#include "run.h"

#include <iostream>
#include <algorithm>
#include <random>

using namespace std;

RunData::RunData(BanditAlgorithm &alg, BanditProblem &prob, bool do_shuffle) {
  static default_random_engine gen;

  alg.setup(prob.n, prob.K);
  regret = 0.0;
  T = vector<uint64_t>(prob.K, 0);
  vector<int> perturb;
  for (int i=0;i!=prob.K;++i) {
    perturb.push_back(i);
  }

  if (do_shuffle) {
    shuffle(perturb.begin(), perturb.end(), gen);
  }

  for (unsigned int t = 0;t!=prob.n;++t) {
    int I_t = alg.get_arm();
    int R_t = prob.sample(perturb[I_t]);
    alg.give_reward(R_t);

    T[I_t]+=1;
    regret+=prob.gap(perturb[I_t]);
  }
}


