function mse = validation_function(thetas, w, X, f, y0)
% mse = validation_function(thetas, w, X, f, y0)
%  A function that will *not* be used directly
%  Rather, use it to create an anonymous function of (thetas, w)
%
% Inputs: 
%  - thetas, D x K matrix of estimated parameters
%  - w, K x 1 vector of estimated weights
%  - X, p x n design matrix X
%  - f, function handle of the form f(x,theta): specifies kernel family
%  - y0, n x 1 vector of 'ground truth' signal, either the true signal or one fitted from an independent set
% 
% Outputs:
%  - mse, mean prediction error
%
% Example usage:
%  theta_space = .5 .* (fullfact([5 5])-3)'; % grid on [-1,1]^2
%  delta = .5;
%  thetas = sample_parameters(theta_space,delta,10); % will sample points from [-1.25,1.25]^2
%  w = rand(10,1);
%  f = @(x,theta) exp(-norm(x-theta)^2); % gaussian kernel
%  X = randn(2,10);
%  X_val = randn(2,10);
%  noise_type = 'gaussian'; noise=0.1; % specifies gaussian noise N(0, 0.01)
%  [y,y0] = generate_signal(X, thetas, w, f, noise_type, noise);
%  [y_val,y0_val] = generate_signal(X, thetas, w, f, noise_type, noise);
%
%  % create function handle
%  vfunc = @(thetas, w) validation_function(thetas, w, X_val, f, y_val);
%
%  % fit an NNLS
%  regtype = 'L1'; lambda = 0.1;
%  [thetas_n, w_n, yh_n, psse_n, sse_n] = nnls_fit(y,X,theta_space,f,regtype,lambda);
%
%  % compute the prediction error
%  mse_n = vfunc(thetas_n, w_n);

n = size(X,2);
F = predictor_matrix(X, thetas, f, 'none', 0);
yh = F * w;
mse = norm(y0-yh)^2./n;

end