function msbm_gui_draw(handles)

    H = handles.settings.H;
    W = handles.settings.W;

    output          = zeros(H*W, 3);
    brush           = handles.brush;
    mask            = handles.mask;
    ground          = handles.ground;
    pv              = handles.pv;
    
    % the masked parts of the image
    pv_output = reshape(shape_for_display_color(pv, H, W), [], 3);
    output(mask, :) = pv_output(mask, :);
    
    % the unmasked parts of the image
    ground_output = reshape(shape_for_display_color(ground, H, W), [], 3);
    output(~mask,:) = ground_output(~mask, :);
    
    % the brush
    if any(brush)
        
        switch handles.brush_type
            
            case 'white'
                colors = generate_colors(handles.dataset.L);
                output(brush, :) = repmat_fast(colors(handles.brush_white_index+1, :), sum(brush));
                
            case 'black'
                colors = generate_colors(handles.dataset.L);
                output(brush, :) = repmat_fast(colors(1, :), sum(brush));
                
            case 'cut'
               output(brush, 1) = 36/255; 
               output(brush, 2) = 144/255;
               output(brush, 3) = 184/255;
               
            case 'uncut'
               output(brush, :) = 0.6;
               
        end
        
    end
    
    % display
    imagesc(reshape(output, H, W, 3));
    axis image;
    axis off;
    
    % flush
    drawnow;

end