function [idx,C] = fast_kmeans(X,k)

% initialize clusters
m = size(X,2);
n = size(X,1);
C = X(:,ceil(rand(1,k)*m)) + 1e-3*randn(n,k);

% run until convergence
idx0 = ones(1,m);
idx = zeros(1,m);
while(norm(idx0 - idx) > 0.1)
  idx0 = idx;
  D = sqdist(C,X);
  [d,idx] = min(D,[],1);
  for i=1:k, C(:,i) = mean(X(:,idx==i),2); end
end

% remove clusters with no entries
for i=1:k, if (sum(idx == i) == 0), C(:,i) = Inf; end; end
C(:,sum(C) == Inf) = [];
D = sqdist(C,X);
[d,idx] = min(D,[],1);
  