function [f,g,d] = dual_kl_obj2(y, F, p0, b0)


% optimize distribution
k = sqrt(size(F,2))/2;
p = numel(y) ./ (2*k);
y0 = reshape(y, 2*k, p);

c = -F*vec(y0*y0');
d = optimize_kl(p0, c, b0);

f = sum(p0.*log(d)) - c'*d;
g = vec(2*reshape(F'*d, 2*k, 2*k)*y0);

