 /*---------------------------------------------------
 * File:    node.h
 * purpose: header file for the node struct
 * author:  ahollowa@uci.edu
 * date:    12/11/2009
 *-------------------------------------------------*/

#ifndef _NODE_H_
#define _NODE_H_


struct node{
  int id;             // Unique id
  int equiv_class;    // Equivalence class
  int k_capacity;     // Capacity of the feasible, perm and edge_cnts arrays
  int D;              // D is actually the second dimension of the edge_cnts matrices
  int W;              // W is actually the dimension of the cp and lp vectors

  // Stick-Breaking Prior
  int *feasible;     // Id's of feasible nodes
  int *perm;         // The permutation of the feasible nodes
  int num_feasible;  // The number of feasible nodes

  int *cp;    // 1-by-W; no. times word w is generated by this node
  int ztot;   // Total no. words assigned to this node (cp summed over W dimension)
  int keep_cp_fixed;
  
  int *etot_k;         // Total number of times feasible node k is chosen. 
  int *etot_k_agg;     // Total number of times a node greater than feasible node k is chosen

};

/* Allocate memory for node data structures */
struct node *allocate_node();

/* Deallocate node memory */
void deallocate_node(struct node *n);

/* Allocate vector if node structs */
struct node *nodevec(int size);

#endif
