/*---------------------------------------------------
 * File:    node.c
 * purpose: Routines for node structure
 * author:  ahollowa@uci.edu
 * date:    12/11/2009
 *-------------------------------------------------*/

#include "mylib.h"
#include "node.h"
#include "alloc.h"

/* Allocate vector if node structs */
struct node *nodevec(int size){
	struct node *tmp = calloc(size, sizeof(struct node));
	assert(tmp);
	return(tmp);
}

struct node *allocate_node(){
	struct node *n = malloc(sizeof(struct node));
	assert(n);
	return(n);
}

/* Deallocate node memory */
void deallocate_node(struct node *n){
  free(n->feasible);
  free(n->perm);
  free(n->etot_k);
  free(n->etot_k_agg);
  free(n->cp);
  return;
}
