/*---------------------------------------------------
 * file:    checksum.h
 * purpose: header file for checksum.c
 * author:  ahollowa@uci.edu
 * date:    1/14/09
 *-------------------------------------------------*/

#ifndef _CHECKSUM_H_
#define _CHECKSUM_H_


/* Compute log-likelihood of assignments */
double * log_likelihood(Graph *graph, int **p, int *path_lengths, int *l, int *d, int *w, int *Nd, int *sum_levels, double *pi_d, int ntot, int D, int L, int W, double alpha, double beta, double eta, double a, double b, int * docconcept);

double * log_likelihood_poisson(Graph *graph, int **p, int *path_lengths, int *l, int *d, int *w, int *Nd, int *sum_levels, double *pi_d, int ntot, int D, int L, int W, double alpha, double beta, double eta, double a, double b, int *docconcept, int *factorial);


/* Checksum for dwl matrix */
int checksum_dwl(int ***dwl, int **dl, int D, int W, int L);

/* Checksum for etot_k vector */
int checksum_etot_k_agg(Graph *graph);

/* Checksum edge_cnts_agg matrix */
int checksum_edge_cnts_agg(Graph *graph);

#endif
