/*---------------------------------------------------
 * file:    alloc.h
 * purpose: header file for alloc.c
 * author:  ahollowa@uci.edu
 * date:    12/14/09
 *-------------------------------------------------*/

#ifndef _ALLOC_H_
#define _ALLOC_H_

/* Four-dimensional integer matrix - note free'ing the memory requires iterating through the first dimension */
int ****i4d( int s1, int s2, int s3, int s4);

/* Three-dimensional integer matrix */
int ***i3d( int s1, int s2, int s3);


/* Integer matrix */
int **imat(int nr, int nc);

/* Double matrix */  
double **dmat(int nr, int nc);

/* Integer vector */
int *ivec(int n);

/* Double vector */
double *dvec(int n);

/* Resize two-dimensional matrix of integers*/
int ** resize_two_dim_i(int old_rows, int new_rows, int cols, int **matrix );

/* Resize a one-dimensional integer array */
int *resize_one_dim_i(int old_size, int new_size, int *array);

/* Resize a one-dimensional double array */
double *resize_one_dim_d(int old_size, int new_size, double *array);

#endif
