/*---------------------------------------------------
 * File:    alloc.c
 * purpose: Allocation routines
 * author:  ahollowa@uci.edu
 * date:    12/14/09
 *-------------------------------------------------*/

#include "mylib.h"
#include "alloc.h"


/* Three-dimensional integer matrix */
int ***i3d( int s1, int s2, int s3){
  int ***x = (int ***)calloc(s1,sizeof(int**)); 
  int **y =  (int **) calloc(s1*s2, sizeof(int *));
  int *tmp = (int *)  calloc(s1*s2*s3, sizeof(int));
  int r = 0;

  assert(x);
  assert(y);
  assert(tmp);

  for( r=0; r < s2*s1; r++){
    y[r] = tmp+s3*r;
  }

  for( r=0; r < s1; r++){
    x[r] = y + s2*r;
  }

  return x;
}


/* Integer matrix */
int **imat(int nr, int nc) //
{
  int ntot = nr*nc;
  int *tmp = (int*) calloc(ntot,sizeof(int));
  int **x  = (int**)calloc(nr,sizeof(int*));
  int r;
  assert(tmp);
  assert(x);
  for (r = 0; r < nr; r++) x[r] = tmp + nc*r;
  return x;
}

  
/* Double matrix */  
double **dmat(int nr, int nc) //
{
  int ntot = nr*nc;
  double *tmp = (double*) calloc(ntot,sizeof(double));
  double **x  = (double**)calloc(nr,sizeof(double*));
  int r;
  assert(tmp);
  assert(x);
  for (r = 0; r < nr; r++)	{
		x[r] = tmp + nc*r;
	}
  return x;
}


/* Integer vector */
int *ivec(int n) //
{
  int *x = (int*)calloc(n,sizeof(int));
  assert(x);
  return x;
}


/* Double vector */
double *dvec(int n) //
{
  double *x = (double*)calloc(n,sizeof(double));
  assert(x);
  return x;
}


/* Resize two-dimensional array of integers*/
int ** resize_two_dim_i(int old_rows, int new_rows, int cols, int **matrix ){
  int i;
  int *ptr;

  ptr = matrix[0];
  ptr = (int *)realloc(ptr, new_rows*cols*sizeof(int));
  assert(ptr);
  for(i=old_rows*cols; i < new_rows*cols; i++){ ptr[i] = 0;}
  
  free(matrix);
  matrix = (int **)calloc(new_rows, sizeof(int*));
  assert(matrix);
  
  for(i=0; i < new_rows; i++){
    matrix[i] = ptr + cols*i;
  }

  return(matrix);
}


/* Resize a one-dimensional integer array */
int *resize_one_dim_i(int old_size, int new_size, int *array){
	int i;
	
	array = (int *)realloc(array, new_size*sizeof(int));
	assert(array);
	for(i=old_size; i<new_size; i++){ array[i] = 0; }
	return(array);
}

/* Resize a one-dimensional double array */
double *resize_one_dim_d(int old_size, int new_size, double *array){
	int i;
	
	array = (double *)realloc(array, new_size*sizeof(double));
	assert(array);
	for(i=old_size; i<new_size;i++){ array[i] = 0.0; }
	return(array);
	
}



