import random

def read_file(file):
    lines = open(file, 'r').readlines()
    lines = [line.strip() for line in lines]
    return lines


def write_file(lines, file):
    with open(file, 'w') as f:
        for line in lines:
            f.write(line + '\n')


atrain = read_file('data/wordprobs/atr-train.tsv')
aval = read_file('data/wordprobs/atr-validation.tsv')

ntrain = read_file('data/navprobs/nav/atr-train.tsv')
nval = read_file('data/navprobs/nav/atr-validation.tsv')

ctrain = read_file('data/objcontprobs/nounlistdesiquintans/atr-train.tsv')
cval = read_file('data/objcontprobs/nounlistdesiquintans/atr-validation.tsv')

naval = nval + aval
acval = aval + cval
cnval = cval + nval
acnval = aval + cval + nval
random.shuffle(naval)
random.shuffle(acval)
random.shuffle(cnval)
random.shuffle(acnval)

natrain = ntrain + atrain
actrain = atrain + ctrain
cntrain = ctrain + ntrain
acntrain = atrain + ctrain + ntrain
random.shuffle(natrain)
random.shuffle(actrain)
random.shuffle(cntrain)
random.shuffle(acntrain)


write_file(naval,    'data/namix/atr-validation.tsv')
write_file(acval,    'data/acmix/atr-validation.tsv')
write_file(cnval,    'data/cnmix/atr-validation.tsv')
write_file(acnval,   'data/acnmix/atr-validation.tsv')
                              
write_file(natrain,  'data/namix/atr-train.tsv')
write_file(actrain,  'data/acmix/atr-train.tsv')
write_file(cntrain,  'data/cnmix/atr-train.tsv')
write_file(acntrain, 'data/acnmix/atr-train.tsv')
