

%% Test: dimension dependence

eta = 0.05; % descent step size
ep = 1; % epsilon
r = 5e-1; % radius of perturbation ball
M = 100; % # of samples

outcome_pgd1 = zeros(3,M);
outcome_ncgd1 = zeros(3,M);

tic
for p = 1:3
    % general parameters
    d = 10^p;
    T1 = 20*p^2+10; 
    T2 = 30*p; 
    eigval1 = hd(ep,d); % type 1 Hessian
    mu = zeros(1,d);
    H1 = diag(eigval1);
    
    % sample
    seed_pgd = randsphere(M,d,r);
    seed_ncgd = randsphere(M,d,r);
   
    for t = 1:M
        % pgd
        x0 = seed_pgd(t,:)';
        xT = gdH(x0,eta,T1,H1);
        outcome_pgd1(p,t) = fH(xT,H1);
        
        %ncgd
        x0 = seed_ncgd(t,:)';
        xT = ncgdH(x0,eta,T2,H1,r);
        outcome_ncgd1(p,t) = fH(xT,H1);
    end
end
tEnd=toc;
fprintf('Test dimension, running time = %d\n',tEnd);

%% plot 
figure(5)
subplot(3,1,1)
binRange = -1.2:0.3:0;
hcx = histcounts(outcome_ncgd1(1,:),[binRange Inf]);
hcy = histcounts(outcome_pgd1(1,:),[binRange Inf]);
b = bar(binRange,[hcx;hcy]);
b(1).FaceColor = [0 .3 .9];
b(2).FaceColor = [.9 .2 .1];
xtips1 = b(1).XEndPoints;
ytips1 = b(1).YEndPoints;
labels1 = string(b(1).YData);
text(xtips1,ytips1,labels1,'HorizontalAlignment','center',...
    'VerticalAlignment','bottom')
xtips2 = b(2).XEndPoints;
ytips2 = b(2).YEndPoints;
labels2 = string(b(2).YData);
text(xtips2,ytips2,labels2,'HorizontalAlignment','center',...
    'VerticalAlignment','bottom')
set(gca,...
    'XDir','reverse',...
        'FontSize',12,'FontName','Times');
xticks([-1.2 -0.9 -0.6 -0.3 0]);
xticklabels({'(-1,-0.9]','(-0.9,-0.6]','(-0.6,0.3]','(-0.3,0]','>0'});
xlabel('Descent value')
ylabel('Frequency')
legend('NCGD','PGD','Location','northwest');
title('dim=10')

subplot(3,1,2)
binRange = -1.2:0.3:0;
hcx = histcounts(outcome_ncgd1(2,:),[binRange Inf]);
hcy = histcounts(outcome_pgd1(2,:),[binRange Inf]);
b = bar(binRange,[hcx;hcy]);
b(1).FaceColor = [0 .3 .9];
b(2).FaceColor = [.9 .2 .1];
xtips1 = b(1).XEndPoints;
ytips1 = b(1).YEndPoints;
labels1 = string(b(1).YData);
text(xtips1,ytips1,labels1,'HorizontalAlignment','center',...
    'VerticalAlignment','bottom')
xtips2 = b(2).XEndPoints;
ytips2 = b(2).YEndPoints;
labels2 = string(b(2).YData);
text(xtips2,ytips2,labels2,'HorizontalAlignment','center',...
    'VerticalAlignment','bottom')
set(gca,...
    'XDir','reverse',...
        'FontSize',12,'FontName','Times');
xticks([-1.2 -0.9 -0.6 -0.3 0]);
xticklabels({'(-1,-0.9]','(-0.9,-0.6]','(-0.6,0.3]','(-0.3,0]','>0'});
xlabel('Descent value')
ylabel('Frequency')
legend('NCGD','PGD','Location','northwest');
title('dim=100')

subplot(3,1,3)
binRange = -1.2:0.3:0;
hcx = histcounts(outcome_ncgd1(3,:),[binRange Inf]);
hcy = histcounts(outcome_pgd1(3,:),[binRange Inf]);
b = bar(binRange,[hcx;hcy]);
b(1).FaceColor = [0 .3 .9];
b(2).FaceColor = [.9 .2 .1];
xtips1 = b(1).XEndPoints;
ytips1 = b(1).YEndPoints;
labels1 = string(b(1).YData);
text(xtips1,ytips1,labels1,'HorizontalAlignment','center',...
    'VerticalAlignment','bottom')
xtips2 = b(2).XEndPoints;
ytips2 = b(2).YEndPoints;
labels2 = string(b(2).YData);
text(xtips2,ytips2,labels2,'HorizontalAlignment','center',...
    'VerticalAlignment','bottom')
set(gca,...
    'XDir','reverse',...
        'FontSize',12,'FontName','Times');
xticks([-1.2 -0.9 -0.6 -0.3 0]);
xticklabels({'(-1,-0.9]','(-0.9,-0.6]','(-0.6,0.3]','(-0.3,0]','>0'});
xlabel('Descent value')
ylabel('Frequency')
legend('NCGD','PGD','Location','northwest');
title('dim=1000')


%%

function eigval = hd(ep,d) % build Hessian diagonal entries, type 1
    eigval = ones(1,d);
    eigval(1) = -ep;
end

function x = gdH(x0,eta,T,H)
for k = 1:T
    x = x0 - eta.*gradH(x0,H);
    x0 = x;
end
end

function x = ncgdH(x0,eta,T,H,r)
for k = 1:T
    x = x0 *r/norm(x0);
    x0 = x;
    x = x0 - eta.*gradH(x0,H);
    x0 = x *r /norm(x);
end
x = 2 * x0/ r;
end

function y = fH(x,H)
y = .5* x' * H * x + x(1)^4/16;
end

function v = gradH(x,H)
v = H * x;
v(1) = v(1)+x(1)^3 / 4;
end
