# Supplementary Material 

In this zip file, you will find 
- **full-paper-including-appendices.pdf**, which is the full version of the submission including both the main paper and appendices to allow hyperlinks to work and ease reviewing, 
- **requirements.txt**, which is the current package list from pip, 
- three separate folders containing experiments data. 

The experiments are organized into three separate folders: 
- **Initialization**, which are Monte Carlo simulations of ResNets without training, 
- **Fully Connected ResNets**, which includes training experiments on MNIST and CIFAR-10 on fully connected ResNet architectures, 
- **Convolutional ResNets**, which includes training experiments on CIFAR-10 using SOTA architectures of ResNet18 and ResNet101 with their corresponding balanced versions. 

The descriptions and instructions on how to use each folder can be found below. 

## Initialization Experiments 

All experiments and plots are contained in **resnet.ipynb**, with figures outputed to "/Figures". The first code block defines all the necessary functions required, including both vanilla and balanced ResNets, and they can be chosen based on parameters. 

All later code blocks are split up into an "experiment block" - where the simulation data are being collected - and a "plotting block" - where the rest of the scripts are for generating the plots based on the simulation data collected in the previous block. 

The parameters of the function *resnet* are as follows: 
- *n*, width of the hidden layers 
- *d*, depth of the hidden layers 
- *S*, the number of Monte Carlo samples 
- *raw_data*, also returns individual samples of log squared norm outputs for the density plots 
- *random_sign*, True chooses the Balanced ResNet architecture, False chooses the vanilla 
- *n_in*, number of input neurons 
- *n_out*, number of output neurons 

## Fully Connected ResNet Experiments 

All experiments and plots are contained in **Resnet Fully Connected.ipynb**, 
with figures outputed to "/Figures", and several .csv files saving the experiment data. 

The second code block chooses all the hyperparameters, in particular 
- *dataset_str*, chooses the dataset either "cifar10" or "mnist"
- *n*, chooses the network hidden layer width 
- *d*, chooses the network hidden layer depth 

## Convolutional ResNet Experiments 

Experiments can be run from either 
- **main.py**
- **CIFAR10.ipynb**
and plots are done in **Plots.ipynb**. 

The main option to be chosen here is 
- *net = PreActResNet18()*
or any other network such as *BalancedPreActResNet18*, *PreActResNet101*, and *BalancedPreActResNet101*. 

The loss and accuracies progress is stored in "/csv". 

The plotting code can be found in **Plots.ipynb**, and figures are in "/Figures". 
