function theta_hat = SP_LP(A, k)

% Authors: Jimit Majmudar, Stephen Vavasis
% This function implements the algorithm in the paper titled "Provable
% Overlapping Community Detection in Weighted Graphs".

% Inputs:
% 1. A: Weighted adjacency matrix of a graph which is normalized such that
% each entry is in [0, 1] and all diagonal entries are set to 1.
% The weights should represent the similarity between the node pairs.
% 2. k: The expected number of communities in the graph.

% Output:
% Function returns an n x k matrix (n is the total number of nodes) with
% each entry in [0, 1] such that the entries in each row sum to 
% approximately one. For each node i, row i represents the fractional 
% memberships of that node in the k communities.

% generate almost pure nodes set
J = zeros(k,1);
R = A;
for i = 1:k
    [~, ind] = max(sum(R.*R));
    J(i) = ind;
    uj = R(:, ind);
    R = R - (uj*(uj'*R)/norm(uj)^2);
end

% solve k LPs
n = size(A, 1);
[Q, ~] = eigs(A, k, 'la');

theta_hat = zeros(n, k);
for i=1:k
    cvx_begin quiet
    variable y(size(Q,2))
    minimize sum(Q*y)
    subject to
    Q(J(i),:)*y==1
    Q*y >= 0
    cvx_end
    theta_hat(:, i) = Q*y/max(Q*y);
end

