// Constants & global variables

const NORMAL_FPS = 14;
const SLOWMO_FPS = 6;

const slider = document.getElementById("slider");
const play_pause = document.getElementById("play-pause-icon");

let ANIM_NAME = "c3BHDER8pQ3Y_86458";
let PLAYING = true;
let playerAnim = undefined;


// Functions

const moveFrame = () => {
    const viewer_svg = document.querySelector(`#viewer > img`);
    const filename = viewer_svg.src;

    let frame_id = filename.replace(/^.*[\\\/]/, '').replace(/\.[^/.]+$/, "");
    frame_id = (parseInt(frame_id) + 1) % 54;

    setFrame(frame_id);
};

const setFrame = (frame_id) => {
    frame_id = parseInt(frame_id);

    const viewer_svg = document.querySelector(`#viewer > img`);
    viewer_svg.src = `interpolations/${ANIM_NAME}/${frame_id}.svg`;
    slider.value = frame_id;
};

const startAnim = (fps = NORMAL_FPS) => {
    clearInterval(playerAnim);
    playerAnim = setInterval(moveFrame, 1000 / fps);
    play_pause.src = "res/pause.svg";
    PLAYING = true;
};

const stopAnim = () => {
    clearInterval(playerAnim);
    play_pause.src = "res/play.svg";
    PLAYING = false;
};


// Events

document.querySelector("#viewer").onmouseout = () => {
    startAnim();
};

document.querySelector("#viewer").onmouseover = () => {
    startAnim(SLOWMO_FPS);
};

[...document.querySelectorAll(".animation")].map(el => {
    el.onclick = () => {
        const anim_name = el.firstElementChild.src.replace(/^.*[\\\/]/, '').split('.').slice(0, -1).join('.');
        ANIM_NAME = anim_name;
        setFrame(0);
        startAnim();
    };
});

slider.oninput = () => {
    stopAnim();
    setFrame(slider.value);
};

play_pause.onclick = () => {
    if (PLAYING) stopAnim();
    else startAnim();
};

document.querySelector(".darkmode-chooser input").onclick = function(){
    document.body.className = this.checked ? "darkmode" : "lightmode";
};

// Main

startAnim();
