import random
from collections import deque


class ReplayMemory(object):
    def __init__(self, max_size=1000):
        """
        can optimize further by using a numpy array and allocating it to zero
        """
        self.max_size = max_size
        self.store = deque()

    def add(self, transition):
        """ insert one sample at a time """
        # self.store[self.current] = transition
        if len(self.store) < self.max_size:
            self.store.append(transition)
        else:
            random_replace_index = random.choice(range(self.max_size))
            self.store[random_replace_index] = transition

    def get_minibatch(self, batch_size=100, offset=0):
        """
        a minibatch of random transitions
        """
        samples = random.sample(self.store, batch_size)
        return samples
