## Manual Installation

### 0. Install `python` >= 3.8.3, Install `pip` >= 20.1.1

### 1. Setup a Virtual Environment
`pip3 install virtualenv`
`python3 -m venv comet`
`source comet/bin/activate`

### 2. Install Packages
`pip install matplotlib pandas pillow tensorflow scikit-learn sexpdata tensorflow`

### 3. Install Solvers
`pip install z3-solver`
Download optimathsat (http://optimathsat.disi.unitn.it/pages/download-js.html) and add it to your environment path. Check installation by running `optimathsat -version`


## Counterexample-guided learning

Run counterexample-guided training for a dataset for one fold using `cd COMET python src/run.py configurations/boston-housing.txt`

## Experiment Results

`cd NEURIPS_EVAL_DATA` to find results associated with Neurips submission. 

## Min-Max Networks and Deep Lattice Networks

`cd baseline` to find code associated with other monotonic methods that we compare against in our paper.

## Note about updates:
For the latest version of the code refer to the repository:
https://github.com/aishwaryaSivaraman/comet



