# Novelty Search in representational space for sample efficient exploration
Code for NeurIPs 2020 submission titled "Novelty Search in representational space for sample efficient exploration".

## Installation
First, install [Python 3.6](https://www.python.org/downloads/release/python-369/).
Create a virtual environment in the project root folder called `venv`
and install requirements in `requirements.txt`. 

In the main project folder, run
```
pip install -e .
```

## Running experiments
All experiments reside in `experiments` folder.

Each experiment folder contains the environment it's running in and the run file with
the `.sh` extension. For Visdom plotting, set `--offline-plotting=True`.

Here are the associations for the experiments in the paper and the run files:
1. 21 x 21 open maze:
 `experiments/maze/run_se.sh` with option `maze_wall=False`.
2. 21 x 21 walled maze:
 `experiments/maze/run_se.sh` with option `maze_wall=True`.
3. Acrobot:
 `experiments/gym/run_control.sh`
4. Multi-step maze:
 `experiments/pycolab/run_maze.sh`.

Check the above scripts for the corresponding python run files.
