import torch
import matplotlib
import matplotlib.pyplot as plt
import numpy as np
import imageio
from proj_io_adapter_io_adapter import *
from cal_constraints import *
from proj_io_adapter_io_adapter import *

DEMO = "rope_long"

def plot_gif(before_project, after_project, arrow, name = '0'):
    def generate_one_frame(data, pred, arrow, xy_max = 2):

        fig, ax = plt.subplots(figsize=(10,10))

        X, Y, U, V = zip(*[arrow])
        ax.quiver(X, Y, U, V, angles='xy', scale_units='xy', scale=1)

        ax.scatter(data[:,0], data[:,1], c = 'y')
        ax.scatter(pred[:,0], pred[:,1], c = 'b')       
        ax.grid()
        ax.set(xlabel='X', ylabel='Y', title='yellow: points before projection; blue: after projection.')
        ax.set_xlim(-xy_max, xy_max)
        ax.set_ylim(-xy_max, xy_max)
        fig.canvas.draw()     
        # fig.show()

        image = np.frombuffer(fig.canvas.tostring_rgb(), dtype='uint8')
        image  = image.reshape(fig.canvas.get_width_height()[::-1] + (3,))


        return image
    
    imageio.mimsave('./gif/' + name + '.gif', [
        generate_one_frame(before_project[i], after_project[i], arrow[i]) 
        for i in range(len(before_project))
        ], fps=10)

def show_one_frame(data, pred, arrow, xy_max = 1):
    X, Y, U, V = zip(*[arrow])
    plt.quiver(X, Y, U, V, angles='xy', scale_units='xy', scale=1)

    plt.scatter(data[:,0], data[:,1], c = 'y')
    plt.scatter(pred[:,0], pred[:,1], c = 'b')       
    plt.grid()
    plt.title('yellow: points before projection; blue: after projection.')
    plt.xlim(-xy_max, xy_max)
    plt.ylim(-xy_max, xy_max)
    plt.show()


class Proj():
    def __init__(self, model_path):
        model_path = 'models/' + model_path
        self.model = torch.load(model_path).cpu()
        # print(self.model.iter)
        # self.model.iter = 1
        # print(self.model.iter)
    def project(self, data):
        d = torch.Tensor(data[None, :, :])
        pred = self.model(d)
        pred = pred[0,:,:]
        return pred.detach().numpy()

def test(te = 0):
    data = np.zeros([20,2])
    dx = 0.1
    timestamp = 0.1

    for i in range(20):
        data[i, 0] = i * dx
        data[i, 1] = 0

    if te == 0 or te==1:
        force0 = np.array([-5, 20]) 
        force1 = np.array([5, 20])         
        g = np.array([0, -2])

    vel = np.array(data)*0
    data_list = [np.array(data)]
    proj_list = [np.array(data)]
    force_list = []
    force_list.append(np.array([
            [data[0,0], data[-1,0], ],
            [data[0,1], data[-1,1], ],
            [0, 0], 
            [0, 0]
            ]))

    pr1 = Proj('rope_8_soft_bend.pt')

    for ite in range(100):
        new_data = np.array(data)
        
        vel[0, :] += force0 * timestamp

        if (ite == 50 and te == 1):
            force1 *= 0
            force0 = np.array([0, 40])    

        vel[-1, :] += force1 * timestamp

        for i in range (0, len(data)):
            vel[i, :] += timestamp * g
            new_data[i, :] = data[i,:] + vel[i,:] * timestamp 

        data_list.append(np.array(new_data))
        force_list.append(np.array([
            [new_data[0,0], new_data[-1,0], ],
            [new_data[0,1], new_data[-1,1], ],
            [force0[0]/20, force1[0]/20], 
            [force0[1]/20, force1[1]/20]
            ]))


        for iter_num in range(0, 20):
            new_data_1 = np.array(new_data)
            new_data_2 = np.array(new_data)
            new_data_3 = np.array(new_data)
            new_data_1[0:8, :] = pr1.project(new_data_1[0:8, :]) 
            new_data_2[6:14, :] = pr1.project(new_data_2[6:14, :]) 
            new_data_3[12:20, :] = pr1.project(new_data_3[12:20, :]) 
            new_data = (new_data_1 + new_data_2 + new_data_3) / 3
            # new_data[0:8, :] = pr1.project(new_data[0:8, :]) 
            # new_data[6:14, :] = pr1.project(new_data[6:14, :]) 
        

        proj_list.append(np.array(new_data))
        
        for i in range (len(data)):
           vel[i,:] =  (new_data[i,:] - data[i,:]) / timestamp # vel[i,:] * 0.5 + 0.5 *
        # print(new_data); print(data); print(vel)
        # show_one_frame(data_list[-1], proj_list[-1], force_list[-1])

        data = (np.array(new_data))
        # aaaaaaaaaaaaaaaaaaaa

    plot_gif(data_list, proj_list, force_list, DEMO+str(te))
    write_viewer(proj_list, output_dir = "output_" + DEMO)
    run(proj_list, [0,1,1,0,0], None, DEMO)
    cal_mse(proj_list, 7, DEMO)

        
if __name__ == '__main__':
    # test(0)
    test(1)