import numpy as np
from sklearn import metrics
import matplotlib.pyplot as plt
from itertools import permutations
import time
from tqdm import tqdm
import seaborn as sns
import scipy
# Figure in main text
# plt.figure(figsize=(4, 8))
plt.style.use('default')
# example data
fig, ax = plt.subplots(figsize=(6, 4))
color = sns.color_palette("husl", 2)
lw = 1.5

error_s = np.ones(shape=6)-np.load('empirical_2.npy')
error_cgz = np.ones(shape=6)-np.load('empirical_cgz_2.npy')
# x = np.array([100, 300, 1000, 2000, 5000, 10000, 50000])
x = np.array([1,2,3,4,5,6])
plt.plot(x,error_s, marker='*', label='Sketching(2-poly decay)', color=color[0])
plt.plot(x,error_cgz, linestyle='--', marker='*', label='CGZ(2-poly decay)', color=color[1])

error_s = np.ones(shape=6)-np.load('empirical_4.npy')
error_cgz = np.ones(shape=6)-np.load('empirical_cgz_4.npy')
# x = np.array([100, 300, 1000, 2000, 5000, 10000, 50000])
x = np.array([1,2,3,4,5,6])
plt.plot(x,error_s, linestyle='-', marker='o', label='Sketching(4-poly decay)', color=color[0])
plt.plot(x,error_cgz, linestyle='--', marker='o', label='CGZ(4-poly decay)', color=color[1])

plt.xlabel('Dimension $p$')
plt.ylabel('Type II error rate')

plt.xticks(np.array([1,2,3,4,5,6]), np.array([100, 300, 1000, 2000, 5000, 10000]))
plt.legend(loc="best")
# plt.ylim([0, 1])
plt.savefig('plot5.pdf')
plt.show()