#!/bin/bash

# Parameters
#SBATCH --constraint=XXX
#SBATCH --cpus-per-task=XXX
#SBATCH --error=XXX
#SBATCH --gres=gpu:XXX
#SBATCH --job-name=XXX
#SBATCH --mem=XXX
#SBATCH --nodes=XXX
#SBATCH --ntasks-per-node=XXX
#SBATCH --open-mode=XXX
#SBATCH --output=XXX
#SBATCH --partition=XXX
#SBATCH --signal=XXX
#SBATCH --time=XXX
#SBATCH --mail-user=XXX
#SBATCH --mail-type=END,FAIL,REQUEUE,BEGIN

source activate lab_vid


export MASTER_ADDR=${SLURM_NODELIST:0:9}${SLURM_NODELIST:10:4}
export MASTER_PORT=19500

# debugging flags (optional)
export NCCL_DEBUG=INFO
export PYTHONFAULTHANDLER=1

# set the network interface
export NCCL_SOCKET_IFNAME=^docker0,lo
echo $SLURMD_NODENAME $SLURM_JOB_ID $CUDA_VISIBLE_DEVICES

SAV_FOLDER="XXX"
mkdir -p ${SAV_FOLDER}

if [ -z "$1" ]
then
	RUN_ID='vggsound_ckpt'
else
	RUN_ID=$1
fi


if [ -z "$2" ]
then
	PRETRAINED='False'
else
	PRETRAINED=$2
fi

if [ -z "$3" ]
then
	MIL_NCE='False'
else
	MIL_NCE=$3
fi

if [ -z "$4" ]
then
	DPC='False'
else
	DPC=$4
fi

if [ -z "$5" ]
then
	XDC='False'
else
	XDC=$5
fi

if [ -z "$6" ]
then
	DATASET='vggsound'
else
	DATASET=$6
fi

if [ -z "$7" ]
then
	MODE='val'
else
	MODE=$7
fi

if [ -z "$8" ]
then
	WEIGHTS_PATH='XXX'
else
	WEIGHTS_PATH=$8
fi

if [ -z "$9" ]
then
	CORRUPTION=1
else
	CORRUPTION=$9
fi

# command
python3 cluster_fit.py --output-dir ${SAV_FOLDER} \
--run-id ${RUN_ID} \
--weights-path ${WEIGHTS_PATH} \
--pretrained ${PRETRAINED} \
--mil-nce ${MIL_NCE} \
--dpc ${DPC} \
--xdc ${XDC} \
--dataset ${DATASET} \
--mode ${MODE} \
--corruption ${CORRUPTION} \
