import torch
import numpy as np
from torch.autograd import Variable
from sklearn.linear_model import LogisticRegression
from sklearn.linear_model import LogisticRegressionCV


class PropModel():
    def __init__(self, Cs=None, random_state=None):
        if Cs is None:
            Cs = np.arange(0.05,1.5,0.05)
        self.Cs = Cs
        self.C = None
        if np.isscalar(Cs):
            self.model = LogisticRegression(C=Cs)
            self.C = Cs
        else: #C is list
            self.model = LogisticRegressionCV(Cs=Cs, cv=5, scoring='neg_log_loss',
                                            random_state=random_state)

    def fit(self, x, xp):
        n = x.shape[0]
        x_in_out = np.concatenate([x, xp])
        y_in_out = np.concatenate([-np.ones(n), np.ones(n)])
        self.model.fit(x_in_out, y_in_out)
        if self.C is None:
            self.C = self.model.C_
        # vprint(verbose,"h fit", self.model.score(x_in_out, y_in_out))

    # def tune():

    def predict(self, x, clip=None):
        w = np.exp(self.model.decision_function(x))
        if clip is not None:
            w = np.maximum(w,clip[0])
            w = np.minimum(w,clip[1])
        return w

    def score(self, x, xp):
        # n = x.shape[0]
        # x_in_out = np.concatenate([x, xp])
        # y_in_out = np.concatenate([-np.ones(n), np.ones(n)])
        # return self.model.score(x_in_out, y_in_out)
        p0 = self.model.predict_log_proba(x)
        p1 = self.model.predict_log_proba(xp)
        return -0.5*(np.mean(p1[:,1])+np.mean(p0[:,0]))
        

    def diagnostics(self, w):
        n_eff = (np.sum(w) ** 2) / (np.sum(w ** 2)) #effective sample size
        w_sum = np.sum(w) #effective sample size
        return n_eff, w_sum
