GeneratePopulation <- function(network, modelParameters, gammaSeq = 1, deltaSeq = 1, betaSeq = 1, outputPath){
  populationPathList <- list()
  for (delta in deltaSeq){
    for (beta in betaSeq){
      cat("Generating population data for delta =", delta, "and beta =", beta, "\n")
      # get data for all treatment conditions
      modelParametersWithTreatment <- list()
      feedback <- list()
      response <- list()
      for (r in 1:length(gammaSeq)){
        GetBoostFactors <- function(producer, consumer){
          return(Treatment(producer, consumer, modelParameters$edgeStrength, gamma = gammaSeq[r]))
        }
        modelParametersWithTreatment[[r]] <- GetTreatmentLevelExposure(modelParameters, GetBoostFactors)
        modelParametersWithTreatment[[r]] <- modelParametersWithTreatment[[r]] %>% 
          mutate(treatment = factor(rep(paste0("T(", gammaSeq[r], ")"), nrow(modelParametersWithTreatment[[r]])), 
                                    levels = treatmentLevels))
        
        # get data with noise
        populationData <- GenerateData(modelParametersWithTreatment[[r]], delta = delta, beta = beta, feedbackNoise = feedbackNoise, responseNoise = responseNoise)
        feedback[[r]] <- populationData$feedback
        response[[r]] <- populationData$response 
      }
      
      modelParametersWithTreatment <- do.call("rbind", modelParametersWithTreatment)
      feedback <- do.call("rbind", feedback) 
      response <- do.call("rbind", response)
      
      fileName <- paste0(outputPath, "population_delta=", delta, "_beta=", beta, ".Rdata")
      save(delta, beta, modelParametersWithTreatment, feedback, response, file = fileName)
      populationPathList <- c(populationPathList, fileName)
    }
  }
  return(populationPathList)
}