# Copyright 2020 The Weakly-Supervised Control Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import gym
from multiworld.envs.mujoco.sawyer_xyz.sawyer_door_hook import SawyerDoorHookEnv
from multiworld.envs.mujoco.sawyer_xyz.sawyer_pick_and_place import SawyerPickAndPlaceEnv
from multiworld.envs.mujoco.sawyer_xyz.sawyer_push_nips import SawyerPushAndReachXYEnv, SawyerPushAndReachXYEasyEnv
from multiworld.envs.mujoco import cameras


def get_camera_fn(env_id: str):
    if 'SawyerPush' in env_id:
        return cameras.sawyer_init_camera_zoomed_in
    elif 'SawyerPick' in env_id:
        return cameras.sawyer_pick_and_place_camera
    elif 'SawyerDoor' in env_id:
        return cameras.sawyer_door_env_camera_v0
    else:
        raise NotImplementedError(env_id)
