import numpy as np

import scipy.io.wavfile as wav

import time
import os
os.environ['CUDA_VISIBLE_DEVICES'] = ''
import sys

def main():

    lookup = {}
    for line in open("do2.sh"):
        line = line.split()
        if len(line) > 8:
            lookup[line[8].split("/")[1]] = line[6]

    adaptive = []
    for i, f in enumerate(sorted(os.listdir("adaptive"), key=lambda x: int(x.split("_")[1].split(".")[0]))):
        _, w = wav.read("adaptive/"+f)
        _, ww = wav.read(lookup[f])
        #print(np.max(np.abs(w-ww)))
        adaptive.append(np.max(np.abs(w-ww)))

    lookup = {}
    for line in open("do.sh"):
        line = line.split()
        if len(line) > 8:
            lookup[line[7].split("/")[1]] = line[5]

    other = []            
    for f in os.listdir("final"):
        #print("FOR", f)
        _,w = wav.read("final/"+f)
        otherf = lookup[f.split("_")[0]+"_"]
        _,ww = wav.read(otherf[:-1]+f.split("_")[1])
        other.append(np.max(np.abs(w-ww)))
        
        
    print(np.median(other))
    print(np.median(adaptive))
    
        

main()
