(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    850562,      18492]
NotebookOptionsPosition[    841852,      18343]
NotebookOutlinePosition[    842256,      18359]
CellTagsIndexPosition[    842213,      18356]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"FileNames", "[", 
   RowBox[{
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<*.csv\>\""}], "]"}], "//",
   "TableForm"}]], "Input",
 CellChangeTimes->{{3.798522636339246*^9, 3.798522653835173*^9}},
 CellLabel->
  "In[942]:=",ExpressionUUID->"1bebf07d-44fd-4c9c-ae33-e9b8942be1b5"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {"\<\"C:\\\\Users\\\\Johannes\\\\Dropbox\\\\University\\\\Research\\\\\
Neural Networks\\\\qrnn\\\\fiddle\\\\experiment-2-elman-letter-topology-\
incomplete.csv\"\>"},
     {"\<\"C:\\\\Users\\\\Johannes\\\\Dropbox\\\\University\\\\Research\\\\\
Neural Networks\\\\qrnn\\\\fiddle\\\\experiment-2-elman-xor-initialization-\
incomplete.csv\"\>"},
     {"\<\"C:\\\\Users\\\\Johannes\\\\Dropbox\\\\University\\\\Research\\\\\
Neural Networks\\\\qrnn\\\\fiddle\\\\experiment-5-dna-pool-fawcett.csv\"\>"},
     {"\<\"C:\\\\Users\\\\Johannes\\\\Dropbox\\\\University\\\\Research\\\\\
Neural Networks\\\\qrnn\\\\fiddle\\\\experiment-5-dna-pool-incomplete.csv\"\>\
"},
     {"\<\"C:\\\\Users\\\\Johannes\\\\Dropbox\\\\University\\\\Research\\\\\
Neural Networks\\\\qrnn\\\\fiddle\\\\hparams_table_experiment1-A.csv\"\>"},
     {"\<\"C:\\\\Users\\\\Johannes\\\\Dropbox\\\\University\\\\Research\\\\\
Neural Networks\\\\qrnn\\\\fiddle\\\\hparams_table_experiment1-B.csv\"\>"},
     {"\<\"C:\\\\Users\\\\Johannes\\\\Dropbox\\\\University\\\\Research\\\\\
Neural Networks\\\\qrnn\\\\fiddle\\\\hparams_table_experiment1-C.csv\"\>"},
     {"\<\"C:\\\\Users\\\\Johannes\\\\Dropbox\\\\University\\\\Research\\\\\
Neural Networks\\\\qrnn\\\\fiddle\\\\long-lstm.csv\"\>"},
     {"\<\"C:\\\\Users\\\\Johannes\\\\Dropbox\\\\University\\\\Research\\\\\
Neural Networks\\\\qrnn\\\\fiddle\\\\long-rnn.csv\"\>"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.798522645719096*^9, 3.7985226541211653`*^9}, 
   3.7986016928865056`*^9, 3.798621273001585*^9, 3.798694625665142*^9, 
   3.798695623614453*^9, 3.798695694204646*^9, 3.7989659869031568`*^9, 
   3.8003565176524487`*^9, 3.800356674901699*^9},
 CellLabel->
  "Out[942]//TableForm=",ExpressionUUID->"6eed8e3d-acc8-49bf-a762-\
5ecb17ae2ff5"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"Clear", "[", "extract", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"extract", "[", 
   RowBox[{"data_Dataset", ",", "keys_List", ",", "value_String", ",", 
    RowBox[{"collatorF_", ":", "MeanAround"}]}], "]"}], ":=", 
  RowBox[{"With", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"slots", "=", 
      RowBox[{"Slot", "/@", "keys"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"collatorF", "/@", 
      RowBox[{"data", "[", 
       RowBox[{"GroupBy", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"slots", "&"}], ")"}], "\[Rule]", 
         RowBox[{"Key", "[", "value", "]"}]}], "]"}], "]"}]}], "//", 
     "Normal"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"extract", "[", 
   RowBox[{"data_Dataset", ",", "keys_List", ",", "values_List", ",", 
    RowBox[{"collatorF_", ":", "MeanAround"}]}], "]"}], ":=", 
  RowBox[{"With", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"slots", "=", 
      RowBox[{"Slot", "/@", "keys"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"collatorF", "/@", 
      RowBox[{"data", "[", 
       RowBox[{"GroupBy", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"slots", "&"}], ")"}], "\[Rule]", 
         RowBox[{"Function", "[", 
          RowBox[{"sth", ",", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"sth", "[", "v", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"v", ",", "values"}], "}"}]}], "]"}]}], "]"}]}], "]"}], 
       "]"}]}], "//", "Normal"}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7985231707196493`*^9, 3.798523194889165*^9}, {
  3.798523242588745*^9, 3.7985232932190504`*^9}, {3.7985233246734333`*^9, 
  3.798523398858343*^9}, {3.7985234564800577`*^9, 3.7985235388188705`*^9}, {
  3.798523569198598*^9, 3.798523577968424*^9}, {3.7985237471081104`*^9, 
  3.798523756428337*^9}, {3.7985248243070393`*^9, 3.7985248327374353`*^9}, {
  3.798524944697818*^9, 3.7985249486071243`*^9}, {3.7986020902293463`*^9, 
  3.798602090679822*^9}, {3.798602255634948*^9, 3.7986022754676404`*^9}, {
  3.8003570293448625`*^9, 3.8003570417321167`*^9}, {3.8003571205556*^9, 
  3.800357123519542*^9}, {3.800357154114772*^9, 3.8003571908595777`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"34a1b5c4-4943-4a49-ad91-2199f154a9c1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"textStyle", "=", 
   RowBox[{"Directive", "[", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"FontName", "\[Rule]", "\"\<Times New Roman\>\""}], ",", 
      RowBox[{"FontSize", "\[Rule]", "14"}]}], "}"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7985261103356194`*^9, 3.7985261482060575`*^9}, {
  3.798526198195509*^9, 3.7985261990258036`*^9}, {3.798526479045656*^9, 
  3.7985264823055873`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"a5952001-c3e6-4912-803e-e2277c8e1b3b"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "boxWhisker", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"boxWhisker", "[", 
   RowBox[{"data_", ",", 
    RowBox[{"{", 
     RowBox[{"key_String", ",", "label_String"}], "}"}], ",", 
    RowBox[{"roundF_", ":", "Identity"}], ",", 
    RowBox[{"extra_", ":", "\"\<Outliers\>\""}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"dd", "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ListQ", "[", "data", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"extract", "[", 
              RowBox[{"#", ",", 
               RowBox[{"{", "key", "}"}], ",", "\"\<hparams/epoch\>\"", ",", 
               "Identity"}], "]"}], "//", 
             RowBox[{"KeyValueMap", "[", 
              RowBox[{"Function", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"kkey", ",", "value"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"roundF", "@", 
                   RowBox[{"First", "@", "kkey"}]}], ",", "value"}], "}"}]}], 
               "]"}], "]"}]}], "//", 
            RowBox[{"SortBy", "[", "First", "]"}]}], ")"}], "&"}], "/@", 
         "data"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"extract", "[", 
           RowBox[{"data", ",", 
            RowBox[{"{", "key", "}"}], ",", "\"\<hparams/epoch\>\"", ",", 
            "Identity"}], "]"}], "//", 
          RowBox[{"KeyValueMap", "[", 
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"kkey", ",", "value"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"roundF", "@", 
                RowBox[{"First", "@", "kkey"}]}], ",", "value"}], "}"}]}], 
            "]"}], "]"}]}], "//", 
         RowBox[{"SortBy", "[", "First", "]"}]}]}], "\[IndentingNewLine]", 
       "]"}]}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"foo", "=", "dd"}], ";", "\[IndentingNewLine]", 
     RowBox[{"BoxWhiskerChart", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ListQ", "[", "data", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"PadRight", "[", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", 
                  RowBox[{"All", ",", "2"}], "]"}], "]"}], ",", "20", ",", 
                RowBox[{"{", 
                 RowBox[{"{", "}"}], "}"}]}], "]"}], "&"}], "/@", "dd"}], 
            ")"}], "\[Transpose]"}], "//.", 
          RowBox[{
           RowBox[{"{", "}"}], "\[Rule]", "Nothing"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Last", "/@", "dd"}]}], "\[IndentingNewLine]", "]"}], ",", 
       "\[IndentingNewLine]", "extra", ",", "\[IndentingNewLine]", 
       RowBox[{"PlotTheme", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Detailed\>\"", ",", "\"\<Scientific\>\""}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"GridLines", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"None", ",", "Automatic"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ChartLabels", "\[Rule]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ListQ", "[", "data", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Union", "@@", 
             RowBox[{"Map", "[", 
              RowBox[{"First", ",", "dd", ",", 
               RowBox[{"{", "2", "}"}]}], "]"}]}], ",", "None"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"First", "/@", "dd"}]}], "\[IndentingNewLine]", "]"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"BaseStyle", "\[Rule]", "textStyle"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"label", ",", "\"\<training steps\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"BarSpacing", "\[Rule]", "2"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ImageSize", "\[Rule]", "220"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"All", ",", "Automatic"}], "}"}]}]}], "\[IndentingNewLine]", 
      "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7985254746869974`*^9, 3.798525641626482*^9}, {
   3.7985256718065104`*^9, 3.798525673536557*^9}, {3.798525720286182*^9, 
   3.7985257413065805`*^9}, {3.798525775396347*^9, 3.7985260700583696`*^9}, {
   3.7985261016159782`*^9, 3.7985261085800753`*^9}, {3.798526138656251*^9, 
   3.7985262291467314`*^9}, {3.798526264186302*^9, 3.798526529805251*^9}, {
   3.7985265625151777`*^9, 3.798526570955183*^9}, {3.79852660735843*^9, 
   3.7985266326954517`*^9}, {3.798526695397745*^9, 3.798526698452014*^9}, {
   3.7985267341818686`*^9, 3.7985269346355467`*^9}, {3.7985269802454567`*^9, 
   3.798526993475368*^9}, {3.7985271145947466`*^9, 3.7985271241348777`*^9}, {
   3.7985271602647467`*^9, 3.7985271609248075`*^9}, {3.7985272857745976`*^9, 
   3.7985272896649604`*^9}, {3.7986020422721753`*^9, 
   3.7986020667349854`*^9}, {3.798621367432814*^9, 3.7986213703876767`*^9}, {
   3.7986947136155605`*^9, 3.7986947144955463`*^9}, {3.798695615003428*^9, 
   3.7986956210991163`*^9}, {3.7986956887480927`*^9, 
   3.7986956911713967`*^9}, {3.798743107485897*^9, 3.798743113040634*^9}, 
   3.7990519129078393`*^9, {3.8002701910920963`*^9, 3.8002702596009803`*^9}, {
   3.8002706210076857`*^9, 3.8002706638123646`*^9}, {3.8002707170533905`*^9, 
   3.800270733120961*^9}, {3.8002708620979757`*^9, 3.8002709148877707`*^9}, {
   3.8002709454940596`*^9, 3.8002709498670044`*^9}, {3.8002709983988237`*^9, 
   3.8002710128813972`*^9}, {3.8002710443978357`*^9, 3.800271056346221*^9}, {
   3.8002785029821014`*^9, 3.800278508650078*^9}, {3.8002787692383127`*^9, 
   3.800278775546745*^9}, {3.8003328025087876`*^9, 3.8003328417750316`*^9}, {
   3.800332947462842*^9, 3.8003330394449387`*^9}, {3.8003330805392876`*^9, 
   3.800333244396784*^9}, {3.800333276592147*^9, 3.8003332784104004`*^9}, {
   3.8003333456207886`*^9, 3.8003333764443836`*^9}, {3.800333778856947*^9, 
   3.80033378854711*^9}, {3.800333824336342*^9, 3.8003338492019863`*^9}, {
   3.8003340728620973`*^9, 3.800334092100218*^9}, {3.8003342006358576`*^9, 
   3.8003342137354345`*^9}, {3.8003342686433764`*^9, 3.800334309090065*^9}, {
   3.8003343480945396`*^9, 3.8003343530568438`*^9}, {3.800334400787421*^9, 
   3.8003344733308697`*^9}, {3.800334504371937*^9, 3.8003345241656647`*^9}, {
   3.8003346414152684`*^9, 3.8003346437641153`*^9}, {3.8003351384544373`*^9, 
   3.8003352235767016`*^9}, {3.8003352787262487`*^9, 3.800335284550111*^9}, {
   3.800335615290229*^9, 3.800335680627637*^9}, 3.8003357636432395`*^9, {
   3.800335810345155*^9, 3.800335812335781*^9}, {3.8003425285719433`*^9, 
   3.8003425415412984`*^9}, {3.8003440160132246`*^9, 3.800344029597074*^9}, {
   3.8003593756040726`*^9, 3.800359382977618*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"88c76715-c297-41fb-bdfd-f8bd5d69d457"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "plotGrid", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"ImagePadding", "\[Rule]", "40"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"plotGrid", "[", 
   RowBox[{"l_List", ",", "w_", ",", "h_", ",", 
    RowBox[{"opts", ":", 
     RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"nx", ",", "ny", ",", 
      RowBox[{"sidePadding", "=", 
       RowBox[{"OptionValue", "[", 
        RowBox[{"plotGrid", ",", "ImagePadding"}], "]"}]}], ",", 
      RowBox[{"topPadding", "=", "0"}], ",", "widths", ",", "heights", ",", 
      "dimensions", ",", "positions", ",", 
      RowBox[{"frameOptions", "=", 
       RowBox[{"FilterRules", "[", 
        RowBox[{
         RowBox[{"{", "opts", "}"}], ",", 
         RowBox[{"FilterRules", "[", 
          RowBox[{
           RowBox[{"Options", "[", "Graphics", "]"}], ",", 
           RowBox[{"Except", "[", 
            RowBox[{"{", 
             RowBox[{"ImagePadding", ",", "Frame", ",", "FrameTicks"}], "}"}],
             "]"}]}], "]"}]}], "]"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ny", ",", "nx"}], "}"}], "=", 
      RowBox[{"Dimensions", "[", "l", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"widths", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"w", "-", 
          RowBox[{"2", " ", "sidePadding"}]}], ")"}], "/", "nx"}], " ", 
       RowBox[{"Table", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", "nx", "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"widths", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"widths", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "+", "sidePadding"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"widths", "[", 
       RowBox[{"[", 
        RowBox[{"-", "1"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"widths", "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}], "+", "sidePadding"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"heights", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"h", "-", 
          RowBox[{"2", " ", "sidePadding"}]}], ")"}], "/", "ny"}], " ", 
       RowBox[{"Table", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", "ny", "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"heights", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"heights", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "+", "sidePadding"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"heights", "[", 
       RowBox[{"[", 
        RowBox[{"-", "1"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"heights", "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}], "+", "sidePadding"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"positions", "=", 
      RowBox[{"Transpose", "@", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Tuples", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Prepend", "[", 
             RowBox[{
              RowBox[{"Accumulate", "[", 
               RowBox[{"Most", "[", "#", "]"}], "]"}], ",", "0"}], "]"}], 
            "&"}], "/@", 
           RowBox[{"{", 
            RowBox[{"widths", ",", "heights"}], "}"}]}], "]"}], ",", "ny"}], 
        "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Inset", "[", 
          RowBox[{
           RowBox[{"Show", "[", 
            RowBox[{
             RowBox[{"l", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"ny", "-", "j", "+", "1"}], ",", "i"}], "]"}], "]"}], 
             ",", 
             RowBox[{"ImagePadding", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"i", "\[Equal]", "1"}], ",", "sidePadding", ",", 
                    "0"}], "]"}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"i", "\[Equal]", "nx"}], ",", "sidePadding", ",", 
                    "0"}], "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"j", "\[Equal]", "1"}], ",", "sidePadding", ",", 
                    "0"}], "]"}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"j", "\[Equal]", "ny"}], ",", "sidePadding", ",", 
                    "topPadding"}], "]"}]}], "}"}]}], "}"}]}], ",", 
             RowBox[{"AspectRatio", "\[Rule]", "Full"}]}], "]"}], ",", 
           RowBox[{"positions", "[", 
            RowBox[{"[", 
             RowBox[{"j", ",", "i"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"Left", ",", "Bottom"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"widths", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"heights", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "nx"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "1", ",", "ny"}], "}"}]}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "w"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "h"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"w", ",", "h"}], "}"}]}], ",", 
       RowBox[{"Evaluate", "@", 
        RowBox[{"Apply", "[", 
         RowBox[{"Sequence", ",", "frameOptions"}], "]"}]}]}], "]"}]}]}], 
   "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.800342752290838*^9, 3.800342752290838*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"1d30137a-8376-4735-9f7b-b686665dc1fb"],

Cell[CellGroupData[{

Cell["Parameter Initialization", "Chapter",
 CellChangeTimes->{{3.798694809492828*^9, 3.7986948135265417`*^9}, {
  3.79896603229385*^9, 
  3.798966035618266*^9}},ExpressionUUID->"80af1e3b-59ee-462a-8818-\
1d3b28f085c8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
      "\"\<experiment-2-elman-xor-initialization-incomplete.csv\>\""}], ",", 
     "\"\<Dataset\>\"", ",", 
     RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7985225183948517`*^9, 3.798522555972459*^9}, {
   3.7985226044192114`*^9, 3.798522630820962*^9}, {3.798522716299359*^9, 
   3.7985227673889236`*^9}, {3.79852282529937*^9, 3.7985228274893456`*^9}, {
   3.7986017034165735`*^9, 3.7986017113666725`*^9}, {3.798702437775674*^9, 
   3.7987024394355035`*^9}, {3.798702599088843*^9, 3.7987027333705606`*^9}, 
   3.7987205061351004`*^9},
 CellLabel->
  "In[1182]:=",ExpressionUUID->"237db7e5-9a29-48fd-a5a7-cb2b7f399004"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "all", " ", "entries", " ", "finished", " ", "with", " ", "low", " ", 
    "score", " ", "or", " ", "were", " ", "cut", " ", "off"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Length", "[", "data", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", 
    RowBox[{"data", "[", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", "\"\<hparams/epoch\>\"", "]"}], "\[GreaterEqual]", 
         "999."}], "\[Or]", 
        RowBox[{
         RowBox[{"#", "[", "\"\<hparams/validate_best\>\"", "]"}], "<", 
         ".001"}]}], "&"}], "]"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.798720514466533*^9, 3.7987205472194633`*^9}},
 CellLabel->
  "In[1183]:=",ExpressionUUID->"229eadfd-11f8-4308-a69b-230e0b3b3043"],

Cell[BoxData["1643"], "Output",
 CellChangeTimes->{{3.7987205105117807`*^9, 3.7987205148675337`*^9}, 
   3.7987205477585907`*^9, {3.798738109661625*^9, 3.798738133739605*^9}, 
   3.7987430437256107`*^9, 3.7987752432501173`*^9, 3.7987821004111648`*^9, 
   3.7987821369387264`*^9, 3.798794173384326*^9, 3.798807086729404*^9, 
   3.7988125232594705`*^9, 3.7988227937379093`*^9, 3.798828030581459*^9, 
   3.7988606129184527`*^9, 3.8002785517223625`*^9, 3.800278782532971*^9, 
   3.8003330451418495`*^9, 3.8003352887967997`*^9, 3.800342518710802*^9, 
   3.8003593939887714`*^9},
 CellLabel->
  "Out[1183]=",ExpressionUUID->"39f232ef-5184-46d9-b1a0-7492628b7b11"],

Cell[BoxData["1643"], "Output",
 CellChangeTimes->{{3.7987205105117807`*^9, 3.7987205148675337`*^9}, 
   3.7987205477585907`*^9, {3.798738109661625*^9, 3.798738133739605*^9}, 
   3.7987430437256107`*^9, 3.7987752432501173`*^9, 3.7987821004111648`*^9, 
   3.7987821369387264`*^9, 3.798794173384326*^9, 3.798807086729404*^9, 
   3.7988125232594705`*^9, 3.7988227937379093`*^9, 3.798828030581459*^9, 
   3.7988606129184527`*^9, 3.8002785517223625`*^9, 3.800278782532971*^9, 
   3.8003330451418495`*^9, 3.8003352887967997`*^9, 3.800342518710802*^9, 
   3.8003593939887714`*^9},
 CellLabel->
  "Out[1184]=",ExpressionUUID->"7f7c8498-19a9-494b-ab41-464c3842afc4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"all", " ", "entries", " ", "are", " ", "unique"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"data", "[", 
     RowBox[{"GroupBy", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Slot", "[", "\"\<initial_bias\>\"", "]"}], ",", 
          RowBox[{"Slot", "[", "\"\<initial_bias_spread\>\"", "]"}], ",", 
          RowBox[{"Slot", "[", "\"\<initial_weights_spread\>\"", "]"}], ",", 
          RowBox[{"Slot", "[", "\"\<initial_unitaries_spread\>\"", "]"}], ",", 
          RowBox[{"Slot", "[", "\"\<seed\>\"", "]"}]}], "}"}], "&"}], 
       "\[Rule]", 
       RowBox[{"Key", "[", "\"\<hparams/epoch\>\"", "]"}]}], "]"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Length", "/@", "%"}], "//", "Max"}]}]}]], "Input",
 CellChangeTimes->{{3.798720519900634*^9, 3.798720531060187*^9}},
 CellLabel->
  "In[1185]:=",ExpressionUUID->"1a6aa707-5378-4d5b-90cc-659178d0b859"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{{3.7985225385591173`*^9, 3.79852258517916*^9}, 
   3.79852262208912*^9, 3.798522663755971*^9, {3.798522745129121*^9, 
   3.798522768084078*^9}, 3.7985228281320963`*^9, {3.798601704639109*^9, 
   3.798601712711507*^9}, 3.7986018248700743`*^9, 3.798621273271626*^9, 
   3.798694625934705*^9, 3.798695624062343*^9, 3.7986956955371585`*^9, 
   3.7987024400127134`*^9, 3.7987024912210445`*^9, 3.798702603442913*^9, {
   3.798702637222145*^9, 3.79870273479097*^9}, 3.7987044398205366`*^9, 
   3.798705288242174*^9, {3.798720344276144*^9, 3.798720373631121*^9}, 
   3.798720456137677*^9, {3.7987204913970227`*^9, 3.7987205163201895`*^9}, 
   3.798720549486605*^9, 3.7987381357393265`*^9, 3.7987430448675127`*^9, 
   3.7987752449922647`*^9, 3.798782079130305*^9, 3.7987821382066526`*^9, 
   3.798794174503295*^9, 3.7988070880044727`*^9, 3.798812524117013*^9, 
   3.79882279503822*^9, 3.7988280318285155`*^9, 3.798860613813577*^9, 
   3.8002785525463686`*^9, 3.800333046164606*^9, 3.8003352894479246`*^9, 
   3.8003425206501856`*^9, 3.800342899270006*^9, 3.8003593946118946`*^9},
 CellLabel->
  "Out[1186]=",ExpressionUUID->"8c8a6e85-62c9-43a6-8314-35b242666246"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"row1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"boxWhisker", "[", 
     RowBox[{"data", ",", "#", ",", 
      RowBox[{
       RowBox[{"Round", "[", 
        RowBox[{"#", ",", ".01"}], "]"}], "&"}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<initial_bias\>\"", ",", "\"\<bias \[Mu]\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<initial_bias_spread\>\"", ",", "\"\<bias \[Sigma]\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<initial_weights_spread\>\"", ",", "\"\<weights \[Sigma]\>\""}], 
      "}"}], ",", 
     RowBox[{"{", " ", 
      RowBox[{
      "\"\<initial_unitaries_spread\>\"", ",", "\"\<unitaries \[Sigma]\>\""}],
       "}"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.7985263242259197`*^9, 3.798526329506007*^9}, {
  3.798526546465567*^9, 3.798526558545287*^9}, {3.7986019986124864`*^9, 
  3.7986020288227854`*^9}, {3.798602340950798*^9, 3.7986023420972104`*^9}, {
  3.798695225494727*^9, 3.7986952341182394`*^9}, {3.8002785693373804`*^9, 
  3.8002786177221127`*^9}, {3.8002787366595554`*^9, 3.800278738545706*^9}, {
  3.8002787912343836`*^9, 3.8002788045742097`*^9}, {3.800342546795653*^9, 
  3.80034256068921*^9}, {3.8003427609720325`*^9, 3.8003428687258024`*^9}},
 CellLabel->
  "In[1187]:=",ExpressionUUID->"86993b25-7f74-4b10-847d-09709745ea47"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {Opacity[0], 
      PointBox[{{0.33333333333333326`, 65.55}, {4.666666666666666, 
       1043.45}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8333333333333333, 999.}, {1.1666666666666665`, 
             999.}, {1.1666666666666665`, 475.}, {0.8333333333333333, 
             475.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{1.1666666666666665`, 870.}, {0.8333333333333333, 
              870.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{0.9999999999999999, 475.}, {0.9999999999999999, 
              140.}}, {{0.9999999999999999, 999.}, {0.9999999999999999, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.0833333333333333`, 140.}, {0.9166666666666665, 
              140.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{1.833333333333333, 999.}, {2.1666666666666665`, 
             999.}, {2.1666666666666665`, 410.}, {1.833333333333333, 
             410.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{2.1666666666666665`, 805.}, {1.833333333333333, 
              805.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.9999999999999998`, 410.}, {1.9999999999999998`, 
              160.}}, {{1.9999999999999998`, 999.}, {1.9999999999999998`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{2.083333333333333, 160.}, {1.9166666666666665`, 
              160.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{2.833333333333333, 999.}, {3.1666666666666665`, 
             999.}, {3.1666666666666665`, 260.}, {2.833333333333333, 
             260.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{3.166666666666667, 480.}, {2.833333333333333, 
              480.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3., 260.}, {3., 110.}}, {{3., 999.}, {3., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.0833333333333335`, 110.}, {2.9166666666666665`, 
              110.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
             999.}, {4.166666666666666, 720.}, {3.833333333333333, 
             720.}}], {}, {{InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3.9999999999999996, 280.}], 
              InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3.9999999999999996, 210.}], 
              InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3.9999999999999996, 210.}], 
              InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3.9999999999999996, 210.}], 
              InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3.9999999999999996, 210.}], 
              InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3.9999999999999996, 170.}], 
              InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3.9999999999999996, 160.}], 
              InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3.9999999999999996, 280.}], 
              InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3.9999999999999996, 270.}], 
              InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3.9999999999999996, 250.}], 
              InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                
                FontColor->GrayLevel[
                 0]], {3.9999999999999996, 290.}]}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{4.166666666666666, 999.}, {3.833333333333333, 
              999.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.9999999999999996`, 720.}, {3.9999999999999996`, 
              310.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{4.083333333333333, 310.}, {3.916666666666666, 
              310.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
              999.}}}]}, {}}],
          
          Antialiasing->
           False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}}, \
{}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.6666666666666666, 65.55},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"training steps\"", TraditionalForm], None}, {
       FormBox["\"bias \[Mu]\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.9999999999999999, 
         FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox["0.79`", TraditionalForm], 0}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox["1.57`", TraditionalForm], 0}, {3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox["3.14`", TraditionalForm], 0}, {0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        4.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
        0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        4.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->220,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{0.9999999999999999, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       0.9999999999999999, 
        FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       1.9999999999999998`, 
        FormBox["0.79`", TraditionalForm], 0}, {3., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
        FormBox["1.57`", TraditionalForm], 0}, {3.9999999999999996`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       3.9999999999999996`, 
        FormBox["3.14`", TraditionalForm], 0}, {0.8333333333333333, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
       4.166666666666666, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], 
      PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
       1043.45}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8333333333333333, 999.}, {1.1666666666666665`, 
             999.}, {1.1666666666666665`, 260.}, {0.8333333333333333, 
             260.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{1.1666666666666665`, 520.}, {0.8333333333333333, 
              520.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{0.9999999999999999, 260.}, {0.9999999999999999, 
              120.}}, {{0.9999999999999999, 999.}, {0.9999999999999999, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.0833333333333333`, 120.}, {0.9166666666666665, 
              120.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{1.833333333333333, 999.}, {2.1666666666666665`, 
             999.}, {2.1666666666666665`, 290.}, {1.833333333333333, 
             290.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{2.1666666666666665`, 585.}, {1.833333333333333, 
              585.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.9999999999999998`, 290.}, {1.9999999999999998`, 
              130.}}, {{1.9999999999999998`, 999.}, {1.9999999999999998`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{2.083333333333333, 130.}, {1.9166666666666665`, 
              130.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{2.833333333333333, 999.}, {3.1666666666666665`, 
             999.}, {3.1666666666666665`, 330.}, {2.833333333333333, 
             330.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{3.166666666666667, 570.}, {2.833333333333333, 
              570.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3., 330.}, {3., 130.}}, {{3., 999.}, {3., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
              130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
             999.}, {4.166666666666666, 470.}, {3.833333333333333, 
             470.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{4.166666666666666, 830.}, {3.833333333333333, 
              830.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.9999999999999996`, 470.}, {3.9999999999999996`, 
              110.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{4.083333333333333, 110.}, {3.916666666666666, 
              110.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
             999.}, {5.166666666666666, 500.}, {4.833333333333333, 
             500.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{5.166666666666666, 830.}, {4.833333333333334, 
              830.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{5., 500.}, {5., 170.}}, {{5., 999.}, {5., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{5.083333333333333, 170.}, {4.916666666666667, 
              170.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
              999.}}}]}, {}}],
          
          Antialiasing->
           False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.6166666666666666, 65.55},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"training steps\"", TraditionalForm], None}, {
       FormBox["\"bias \[Sigma]\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.9999999999999999, 
         FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox["0.01`", TraditionalForm], 0}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox["1.`", TraditionalForm], 0}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
        0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->220,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{0.9999999999999999, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       0.9999999999999999, 
        FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       1.9999999999999998`, 
        FormBox["0.01`", TraditionalForm], 0}, {3., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
        FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       3.9999999999999996`, 
        FormBox["1.`", TraditionalForm], 0}, {5., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
        FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
       5.166666666666666, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], 
      PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
       1043.45}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8333333333333333, 999.}, {1.1666666666666665`, 
             999.}, {1.1666666666666665`, 270.}, {0.8333333333333333, 
             270.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{1.1666666666666665`, 560.}, {0.8333333333333333, 560.}}
              ]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{0.9999999999999999, 270.}, {0.9999999999999999, 
              120.}}, {{0.9999999999999999, 999.}, {0.9999999999999999, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.0833333333333333`, 120.}, {0.9166666666666665, 
              120.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{1.833333333333333, 999.}, {2.1666666666666665`, 
             999.}, {2.1666666666666665`, 290.}, {1.833333333333333, 
             290.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{2.1666666666666665`, 630.}, {1.833333333333333, 
              630.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.9999999999999998`, 290.}, {1.9999999999999998`, 
              120.}}, {{1.9999999999999998`, 999.}, {1.9999999999999998`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{2.083333333333333, 120.}, {1.9166666666666665`, 
              120.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{2.833333333333333, 999.}, {3.1666666666666665`, 
             999.}, {3.1666666666666665`, 320.}, {2.833333333333333, 
             320.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{3.166666666666667, 650.}, {2.833333333333333, 
              650.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3., 320.}, {3., 130.}}, {{3., 999.}, {3., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
              130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
             999.}, {4.166666666666666, 410.}, {3.833333333333333, 
             410.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{4.166666666666666, 710.}, {3.833333333333333, 
              710.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.9999999999999996`, 410.}, {3.9999999999999996`, 
              110.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{4.083333333333333, 110.}, {3.916666666666666, 
              110.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
             999.}, {5.166666666666666, 470.}, {4.833333333333333, 
             470.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{5.166666666666666, 830.}, {4.833333333333334, 
              830.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{5., 470.}, {5., 150.}}, {{5., 999.}, {5., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{5.083333333333333, 150.}, {4.916666666666667, 
              150.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
              999.}}}]}, {}}],
          
          Antialiasing->
           False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.6166666666666666, 65.55},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"training steps\"", TraditionalForm], None}, {
       FormBox["\"weights \[Sigma]\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.9999999999999999, 
         FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox["0.01`", TraditionalForm], 0}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox["1.`", TraditionalForm], 0}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
        0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->220,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{0.9999999999999999, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       0.9999999999999999, 
        FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       1.9999999999999998`, 
        FormBox["0.01`", TraditionalForm], 0}, {3., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
        FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       3.9999999999999996`, 
        FormBox["1.`", TraditionalForm], 0}, {5., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
        FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
       5.166666666666666, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], 
      PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
       1043.45}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8333333333333333, 999.}, {1.1666666666666665`, 
             999.}, {1.1666666666666665`, 310.}, {0.8333333333333333, 
             310.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{1.1666666666666665`, 490.}, {0.8333333333333333, 
              490.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{0.9999999999999999, 310.}, {0.9999999999999999, 
              110.}}, {{0.9999999999999999, 999.}, {0.9999999999999999, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.0833333333333333`, 110.}, {0.9166666666666665, 
              110.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{1.833333333333333, 999.}, {2.1666666666666665`, 
             999.}, {2.1666666666666665`, 310.}, {1.833333333333333, 
             310.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{2.1666666666666665`, 530.}, {1.833333333333333, 
              530.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.9999999999999998`, 310.}, {1.9999999999999998`, 
              120.}}, {{1.9999999999999998`, 999.}, {1.9999999999999998`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{2.083333333333333, 120.}, {1.9166666666666665`, 
              120.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{2.833333333333333, 999.}, {3.1666666666666665`, 
             999.}, {3.1666666666666665`, 310.}, {2.833333333333333, 
             310.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{3.166666666666667, 540.}, {2.833333333333333, 
              540.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3., 310.}, {3., 130.}}, {{3., 999.}, {3., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
              130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
             999.}, {4.166666666666666, 512.5}, {3.833333333333333, 
             512.5}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{4.166666666666666, 999.}, {3.833333333333333, 
              999.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.9999999999999996`, 512.5}, {3.9999999999999996`, 
              120.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{4.083333333333333, 120.}, {3.916666666666666, 
              120.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
             999.}, {5.166666666666666, 550.}, {4.833333333333333, 
             550.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{5.166666666666666, 999.}, {4.833333333333334, 
              999.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{5., 550.}, {5., 120.}}, {{5., 999.}, {5., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{5.083333333333333, 120.}, {4.916666666666667, 
              120.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
              999.}}}]}, {}}],
          
          Antialiasing->
           False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.6166666666666666, 65.55},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"training steps\"", TraditionalForm], None}, {
       FormBox["\"unitaries \[Sigma]\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.9999999999999999, 
         FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox["0.01`", TraditionalForm], 0}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox["1.`", TraditionalForm], 0}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
        0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->220,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{0.9999999999999999, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       0.9999999999999999, 
        FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       1.9999999999999998`, 
        FormBox["0.01`", TraditionalForm], 0}, {3., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
        FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       3.9999999999999996`, 
        FormBox["1.`", TraditionalForm], 0}, {5., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
        FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
       5.166666666666666, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
      Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.798526329955846*^9, 3.7985263364253817`*^9}, {
   3.7985263776955166`*^9, 3.7985265737456093`*^9}, {3.798526623252246*^9, 
   3.798526634020524*^9}, 3.7985267010753374`*^9, 3.798526793385289*^9, {
   3.798526823998711*^9, 3.798526936349416*^9}, {3.7985269865048075`*^9, 
   3.798526998235042*^9}, {3.7985271178549366`*^9, 3.7985271277950068`*^9}, 
   3.7985271625750012`*^9, 3.7985272928344946`*^9, {3.7986020301025066`*^9, 
   3.7986020946491985`*^9}, 3.798602342258427*^9, 3.798621273992502*^9, 
   3.7986213724765854`*^9, 3.798694626920807*^9, 3.7986947174368086`*^9, {
   3.7986952074317102`*^9, 3.798695235645974*^9}, 3.798695625883403*^9, 
   3.798695696357278*^9, 3.7987149282405987`*^9, 3.7987205605073614`*^9, 
   3.7987381383491964`*^9, 3.79874304654582*^9, 3.7987431189659023`*^9, 
   3.798775246510453*^9, 3.798782139294606*^9, 3.798794175847601*^9, 
   3.798807089317549*^9, 3.798812525162505*^9, 3.7988227964007015`*^9, 
   3.798828032928832*^9, 3.798860614925553*^9, 3.800278553712556*^9, 
   3.8002786193970003`*^9, {3.800278765643586*^9, 3.8002788060979166`*^9}, 
   3.8003330469288054`*^9, {3.800333087096918*^9, 3.800333098965626*^9}, 
   3.8003331307678614`*^9, {3.8003331714849005`*^9, 3.800333197491321*^9}, 
   3.8003332490812397`*^9, 3.8003352908842487`*^9, {3.8003425223688283`*^9, 
   3.8003425613231106`*^9}, {3.8003427682083416`*^9, 
   3.8003428698283405`*^9}, {3.8003440217518983`*^9, 3.800344032310873*^9}, 
   3.800359395426138*^9},
 CellLabel->
  "Out[1187]=",ExpressionUUID->"47d14d88-7586-4b52-ad0f-64cb2e6aa962"]
}, Open  ]],

Cell["The initial bias should equal pi/2", "Text",
 CellChangeTimes->{{3.7986947646251507`*^9, 3.798694766410556*^9}, {
  3.7986951522422943`*^9, 3.798695166473759*^9}, {3.798794240013877*^9, 
  3.7987942737438374`*^9}, {3.79879431693826*^9, 3.798794318337623*^9}, {
  3.7988606518050613`*^9, 
  3.798860651974058*^9}},ExpressionUUID->"14239afb-061b-400c-bc85-\
0d24677af46c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"row2", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"boxWhisker", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"data", "[", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"##", "[", "\"\<initial_bias\>\"", "]"}], "\[Equal]", 
          "1.5708"}], "&"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "#", 
      ",", 
      RowBox[{
       RowBox[{"Round", "[", 
        RowBox[{"#", ",", ".01"}], "]"}], "&"}]}], "\[IndentingNewLine]", 
     "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<initial_bias\>\"", ",", "\"\<bias \[Mu]\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<initial_bias_spread\>\"", ",", "\"\<bias \[Sigma]\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<initial_weights_spread\>\"", ",", "\"\<weights \[Sigma]\>\""}], 
      "}"}], ",", 
     RowBox[{"{", " ", 
      RowBox[{
      "\"\<initial_unitaries_spread\>\"", ",", "\"\<unitaries \[Sigma]\>\""}],
       "}"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.7986952513622856`*^9, 3.7986953557530203`*^9}, {
   3.7986954223810177`*^9, 3.7986954246580677`*^9}, {3.79879422546714*^9, 
   3.79879423522358*^9}, {3.7987942772659216`*^9, 3.798794286016699*^9}, {
   3.798794322031794*^9, 3.798794325292053*^9}, 3.798794359566829*^9, {
   3.800342875887021*^9, 3.8003428888232346`*^9}, {3.8003429196386003`*^9, 
   3.8003429517054863`*^9}},
 CellLabel->
  "In[1188]:=",ExpressionUUID->"71821e41-da72-4f46-a04e-f2ccc606ffd6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {Opacity[0], 
      PointBox[{{-0.16666666666666696`, 65.55}, {2.166666666666667, 
       1043.45}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8333333333333333, 999.}, {1.1666666666666665`, 
             999.}, {1.1666666666666665`, 260.}, {0.8333333333333333, 
             260.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{1.1666666666666665`, 480.}, {0.8333333333333333, 
              480.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{0.9999999999999999, 260.}, {0.9999999999999999, 
              110.}}, {{0.9999999999999999, 999.}, {0.9999999999999999, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.0833333333333333`, 110.}, {0.9166666666666665, 
              110.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
              999.}}}]}, {}}],
          Antialiasing->False]]}}, {}, {}}, {{{{{}, {}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.8166666666666667, 65.55},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"training steps\"", TraditionalForm], None}, {
       FormBox["\"bias \[Mu]\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.9999999999999999, 
         FormBox["1.57`", TraditionalForm], 0}, {0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        1.1666666666666665`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
        0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        1.1666666666666665`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->220,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{0.9999999999999999, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       0.9999999999999999, 
        FormBox["1.57`", TraditionalForm], 0}, {0.8333333333333333, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
       1.1666666666666665`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], 
      PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
       1043.45}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8333333333333333, 552.5}, {1.1666666666666665`, 
             552.5}, {1.1666666666666665`, 200.}, {0.8333333333333333, 
             200.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{1.1666666666666665`, 310.}, {0.8333333333333333, 
              310.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{0.9999999999999999, 200.}, {0.9999999999999999, 
              120.}}, {{0.9999999999999999, 552.5}, {0.9999999999999999, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.0833333333333333`, 120.}, {0.9166666666666665, 
              120.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{1.833333333333333, 655.}, {2.1666666666666665`, 
             655.}, {2.1666666666666665`, 220.}, {1.833333333333333, 
             220.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{2.1666666666666665`, 320.}, {1.833333333333333, 
              320.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.9999999999999998`, 220.}, {1.9999999999999998`, 
              130.}}, {{1.9999999999999998`, 655.}, {1.9999999999999998`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{2.083333333333333, 130.}, {1.9166666666666665`, 
              130.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{2.833333333333333, 600.}, {3.1666666666666665`, 
             600.}, {3.1666666666666665`, 210.}, {2.833333333333333, 
             210.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{3.166666666666667, 350.}, {2.833333333333333, 
              350.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3., 210.}, {3., 130.}}, {{3., 600.}, {3., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
              130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
             999.}, {4.166666666666666, 510.}, {3.833333333333333, 
             510.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{4.166666666666666, 785.}, {3.833333333333333, 
              785.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.9999999999999996`, 510.}, {3.9999999999999996`, 
              110.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{4.083333333333333, 110.}, {3.916666666666666, 
              110.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
             999.}, {5.166666666666666, 470.}, {4.833333333333333, 
             470.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{5.166666666666666, 980.}, {4.833333333333334, 
              980.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{5., 470.}, {5., 180.}}, {{5., 999.}, {5., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{5.083333333333333, 180.}, {4.916666666666667, 
              180.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
              999.}}}]}, {}}],
          
          Antialiasing->
           False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.6166666666666666, 65.55},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"training steps\"", TraditionalForm], None}, {
       FormBox["\"bias \[Sigma]\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.9999999999999999, 
         FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox["0.01`", TraditionalForm], 0}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox["1.`", TraditionalForm], 0}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
        0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->220,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{0.9999999999999999, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       0.9999999999999999, 
        FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       1.9999999999999998`, 
        FormBox["0.01`", TraditionalForm], 0}, {3., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
        FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       3.9999999999999996`, 
        FormBox["1.`", TraditionalForm], 0}, {5., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
        FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
       5.166666666666666, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], 
      PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
       1043.45}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8333333333333333, 592.5}, {1.1666666666666665`, 
             592.5}, {1.1666666666666665`, 190.}, {0.8333333333333333, 
             190.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{1.1666666666666665`, 300.}, {0.8333333333333333, 
              300.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{0.9999999999999999, 190.}, {0.9999999999999999, 
              120.}}, {{0.9999999999999999, 592.5}, {0.9999999999999999, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.0833333333333333`, 120.}, {0.9166666666666665, 
              120.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{1.833333333333333, 660.}, {2.1666666666666665`, 
             660.}, {2.1666666666666665`, 210.}, {1.833333333333333, 
             210.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{2.1666666666666665`, 310.}, {1.833333333333333, 
              310.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.9999999999999998`, 210.}, {1.9999999999999998`, 
              120.}}, {{1.9999999999999998`, 660.}, {1.9999999999999998`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{2.083333333333333, 120.}, {1.9166666666666665`, 
              120.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{2.833333333333333, 715.}, {3.1666666666666665`, 
             715.}, {3.1666666666666665`, 290.}, {2.833333333333333, 
             290.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{3.166666666666667, 445.}, {2.833333333333333, 
              445.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3., 290.}, {3., 130.}}, {{3., 715.}, {3., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
              130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
             999.}, {4.166666666666666, 470.}, {3.833333333333333, 
             470.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{4.166666666666666, 810.}, {3.833333333333333, 
              810.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.9999999999999996`, 470.}, {3.9999999999999996`, 
              110.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{4.083333333333333, 110.}, {3.916666666666666, 
              110.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
             999.}, {5.166666666666666, 442.5}, {4.833333333333333, 
             442.5}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{5.166666666666666, 730.}, {4.833333333333334, 
              730.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{5., 442.5}, {5., 150.}}, {{5., 999.}, {5., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{5.083333333333333, 150.}, {4.916666666666667, 
              150.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
              999.}}}]}, {}}],
          
          Antialiasing->
           False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.6166666666666666, 65.55},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"training steps\"", TraditionalForm], None}, {
       FormBox["\"weights \[Sigma]\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.9999999999999999, 
         FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox["0.01`", TraditionalForm], 0}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox["1.`", TraditionalForm], 0}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
        0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->220,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{0.9999999999999999, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       0.9999999999999999, 
        FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       1.9999999999999998`, 
        FormBox["0.01`", TraditionalForm], 0}, {3., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
        FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       3.9999999999999996`, 
        FormBox["1.`", TraditionalForm], 0}, {5., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
        FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
       5.166666666666666, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], 
      PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
       1043.45}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8333333333333333, 605.}, {1.1666666666666665`, 
             605.}, {1.1666666666666665`, 240.}, {0.8333333333333333, 
             240.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{1.1666666666666665`, 400.}, {0.8333333333333333, 
              400.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{0.9999999999999999, 240.}, {0.9999999999999999, 
              110.}}, {{0.9999999999999999, 605.}, {0.9999999999999999, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.0833333333333333`, 110.}, {0.9166666666666665, 
              110.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{1.833333333333333, 690.}, {2.1666666666666665`, 
             690.}, {2.1666666666666665`, 240.}, {1.833333333333333, 
             240.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{2.1666666666666665`, 410.}, {1.833333333333333, 
              410.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.9999999999999998`, 240.}, {1.9999999999999998`, 
              120.}}, {{1.9999999999999998`, 690.}, {1.9999999999999998`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{2.083333333333333, 120.}, {1.9166666666666665`, 
              120.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{2.833333333333333, 710.}, {3.1666666666666665`, 
             710.}, {3.1666666666666665`, 230.}, {2.833333333333333, 
             230.}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{3.166666666666667, 425.}, {2.833333333333333, 
              425.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3., 230.}, {3., 130.}}, {{3., 710.}, {3., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
              130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
             999.}, {4.166666666666666, 307.5}, {3.833333333333333, 
             307.5}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{4.166666666666666, 710.}, {3.833333333333333, 
              710.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.9999999999999996`, 307.5}, {3.9999999999999996`, 
              120.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
              999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{4.083333333333333, 120.}, {3.916666666666666, 
              120.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
              999.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
             999.}, {5.166666666666666, 322.5}, {4.833333333333333, 
             322.5}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{5.166666666666666, 710.}, {4.833333333333334, 
              710.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{5., 322.5}, {5., 120.}}, {{5., 999.}, {5., 999.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{5.083333333333333, 120.}, {4.916666666666667, 
              120.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
              999.}}}]}, {}}],
          
          Antialiasing->
           False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.6166666666666666, 65.55},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"training steps\"", TraditionalForm], None}, {
       FormBox["\"unitaries \[Sigma]\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.9999999999999999, 
         FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox["0.01`", TraditionalForm], 0}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox["1.`", TraditionalForm], 0}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
        0.9999999999999999, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        1.9999999999999998`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        3.9999999999999996`, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
        0.8333333333333333, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
        5.166666666666666, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->220,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{0.9999999999999999, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       0.9999999999999999, 
        FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       1.9999999999999998`, 
        FormBox["0.01`", TraditionalForm], 0}, {3., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
        FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
       3.9999999999999996`, 
        FormBox["1.`", TraditionalForm], 0}, {5., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
        FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
       5.166666666666666, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
      Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.798695318053473*^9, 3.7986953563245344`*^9}, 
   3.798695425676052*^9, 3.798695626406744*^9, 3.7986956967099266`*^9, 
   3.798738157165413*^9, 3.7987430775735884`*^9, 3.7987431284890304`*^9, 
   3.79877526396227*^9, 3.7987822164167013`*^9, 3.798794201736285*^9, 
   3.7987942361540384`*^9, 3.798794286750107*^9, 3.798794325893385*^9, {
   3.798794366465334*^9, 3.7987943729210625`*^9}, 3.7988070947012477`*^9, 
   3.7988125315878415`*^9, 3.7988227999258385`*^9, 3.7988280386541357`*^9, 
   3.798860619414014*^9, {3.8003428905837145`*^9, 3.800342921403486*^9}, 
   3.8003429527707973`*^9, 3.8003440363411694`*^9, 3.8003593976852903`*^9},
 CellLabel->
  "Out[1188]=",ExpressionUUID->"730c41a4-b0a5-48b0-a320-21ea8295cc84"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"plotGrid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"row1", ",", "row2"}], "}"}], ",", "600", ",", "250", ",", 
    RowBox[{"ImagePadding", "\[Rule]", "50"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8003429579428687`*^9, 3.8003429722264576`*^9}, {
   3.800343110918943*^9, 3.800343142682178*^9}, {3.8003440440291204`*^9, 
   3.800344052955351*^9}, 3.8003593688222585`*^9, 3.8003594056456137`*^9},
 CellLabel->
  "In[1190]:=",ExpressionUUID->"3352cda1-787d-4b84-bd08-f33f839bcb7b"],

Cell[BoxData[
 GraphicsBox[{{InsetBox[
     GraphicsBox[{
       {Opacity[0], 
        PointBox[{{-0.16666666666666696`, 65.55}, {2.166666666666667, 
         1043.45}}]}, 
       {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
        {RGBColor[0.9, 0.36, 0.054], 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{0.8333333333333333, 999.}, {1.1666666666666665`, 
               999.}, {1.1666666666666665`, 260.}, {0.8333333333333333, 
               260.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{1.1666666666666665`, 480.}, {0.8333333333333333, 
                480.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{0.9999999999999999, 260.}, {0.9999999999999999, 
                110.}}, {{0.9999999999999999, 999.}, {0.9999999999999999, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.0833333333333333`, 110.}, {0.9166666666666665, 
                110.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
                999.}}}]}, {}}],
            Antialiasing->False]]}}, {}, {}}, {{{{{}, {}}, {}}, {}}, {}}, {}},
      AspectRatio->Full,
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0.8166666666666667, 65.55},
      BaseStyle->Directive[{
         GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
      DisplayFunction->Identity,
      Frame->True,
      FrameLabel->{{
         FormBox["\"training steps\"", TraditionalForm], None}, {
         FormBox["\"bias \[Mu]\"", TraditionalForm], None}},
      FrameStyle->GrayLevel[0],
      FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.9999999999999999, 
           FormBox["1.57`", TraditionalForm], 0}, {0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          1.1666666666666665`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
          0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          1.1666666666666665`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
      GridLines->{None, Automatic},
      GridLinesStyle->Directive[
        GrayLevel[0.4, 0.5], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{1, 2}]],
      ImagePadding->{{50, 0}, {50, 0}},
      ImageSize->220,
      LabelStyle->{FontFamily -> "Times"},
      PlotRange->{All, Automatic},
      PlotRangePadding->{{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{{{0.9999999999999999, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         0.9999999999999999, 
          FormBox["1.57`", TraditionalForm], 0}, {0.8333333333333333, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
         1.1666666666666665`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
        Automatic}], {0, 0}, {Left, Bottom}, {175, 125}], InsetBox[
     GraphicsBox[{
       {Opacity[0], 
        PointBox[{{0.33333333333333326`, 65.55}, {4.666666666666666, 
         1043.45}}]}, 
       {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
        {RGBColor[0.9, 0.36, 0.054], 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{0.8333333333333333, 999.}, {1.1666666666666665`, 
               999.}, {1.1666666666666665`, 475.}, {0.8333333333333333, 
               475.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{1.1666666666666665`, 870.}, {0.8333333333333333, 
                870.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{0.9999999999999999, 475.}, {0.9999999999999999, 
                140.}}, {{0.9999999999999999, 999.}, {0.9999999999999999, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.0833333333333333`, 140.}, {0.9166666666666665, 
                140.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{1.833333333333333, 999.}, {2.1666666666666665`, 
               999.}, {2.1666666666666665`, 410.}, {1.833333333333333, 
               410.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{2.1666666666666665`, 805.}, {1.833333333333333, 
                805.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.9999999999999998`, 410.}, {1.9999999999999998`, 
                160.}}, {{1.9999999999999998`, 999.}, {1.9999999999999998`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{2.083333333333333, 160.}, {1.9166666666666665`, 
                160.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{2.833333333333333, 999.}, {3.1666666666666665`, 
               999.}, {3.1666666666666665`, 260.}, {2.833333333333333, 
               260.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{3.166666666666667, 480.}, {2.833333333333333, 
                480.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3., 260.}, {3., 110.}}, {{3., 999.}, {3., 999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.0833333333333335`, 110.}, {2.9166666666666665`, 
                110.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
               999.}, {4.166666666666666, 720.}, {3.833333333333333, 
               720.}}], {}, {{InsetBox[
                 StyleBox["\<\"\[FilledSmallCircle]\"\>",
                  StripOnInput->False,
                  LineColor->GrayLevel[0],
                  FrontFaceColor->GrayLevel[0],
                  BackFaceColor->GrayLevel[0],
                  GraphicsColor->GrayLevel[0],
                  FontSize->10,
                  FontColor->GrayLevel[0]], {3.9999999999999996, 280.}], 
                InsetBox[
                 StyleBox["\<\"\[FilledSmallCircle]\"\>",
                  StripOnInput->False,
                  LineColor->GrayLevel[0],
                  FrontFaceColor->GrayLevel[0],
                  BackFaceColor->GrayLevel[0],
                  GraphicsColor->GrayLevel[0],
                  FontSize->10,
                  FontColor->GrayLevel[0]], {3.9999999999999996, 210.}], 
                InsetBox[
                 StyleBox["\<\"\[FilledSmallCircle]\"\>",
                  StripOnInput->False,
                  LineColor->GrayLevel[0],
                  FrontFaceColor->GrayLevel[0],
                  BackFaceColor->GrayLevel[0],
                  GraphicsColor->GrayLevel[0],
                  FontSize->10,
                  FontColor->GrayLevel[0]], {3.9999999999999996, 210.}], 
                InsetBox[
                 StyleBox["\<\"\[FilledSmallCircle]\"\>",
                  StripOnInput->False,
                  LineColor->GrayLevel[0],
                  FrontFaceColor->GrayLevel[0],
                  BackFaceColor->GrayLevel[0],
                  GraphicsColor->GrayLevel[0],
                  FontSize->10,
                  FontColor->GrayLevel[0]], {3.9999999999999996, 210.}], 
                InsetBox[
                 StyleBox["\<\"\[FilledSmallCircle]\"\>",
                  StripOnInput->False,
                  LineColor->GrayLevel[0],
                  FrontFaceColor->GrayLevel[0],
                  BackFaceColor->GrayLevel[0],
                  GraphicsColor->GrayLevel[0],
                  FontSize->10,
                  FontColor->GrayLevel[0]], {3.9999999999999996, 210.}], 
                InsetBox[
                 StyleBox["\<\"\[FilledSmallCircle]\"\>",
                  StripOnInput->False,
                  LineColor->GrayLevel[0],
                  FrontFaceColor->GrayLevel[0],
                  BackFaceColor->GrayLevel[0],
                  GraphicsColor->GrayLevel[0],
                  FontSize->10,
                  FontColor->GrayLevel[0]], {3.9999999999999996, 170.}], 
                InsetBox[
                 StyleBox["\<\"\[FilledSmallCircle]\"\>",
                  StripOnInput->False,
                  LineColor->GrayLevel[0],
                  FrontFaceColor->GrayLevel[0],
                  BackFaceColor->GrayLevel[0],
                  GraphicsColor->GrayLevel[0],
                  FontSize->10,
                  FontColor->GrayLevel[0]], {3.9999999999999996, 160.}], 
                InsetBox[
                 StyleBox["\<\"\[FilledSmallCircle]\"\>",
                  StripOnInput->False,
                  LineColor->GrayLevel[0],
                  FrontFaceColor->GrayLevel[0],
                  BackFaceColor->GrayLevel[0],
                  GraphicsColor->GrayLevel[0],
                  FontSize->10,
                  FontColor->GrayLevel[0]], {3.9999999999999996, 280.}], 
                InsetBox[
                 StyleBox["\<\"\[FilledSmallCircle]\"\>",
                  StripOnInput->False,
                  LineColor->GrayLevel[0],
                  FrontFaceColor->GrayLevel[0],
                  BackFaceColor->GrayLevel[0],
                  GraphicsColor->GrayLevel[0],
                  FontSize->10,
                  FontColor->GrayLevel[0]], {3.9999999999999996, 270.}], 
                InsetBox[
                 StyleBox["\<\"\[FilledSmallCircle]\"\>",
                  StripOnInput->False,
                  LineColor->GrayLevel[0],
                  FrontFaceColor->GrayLevel[0],
                  BackFaceColor->GrayLevel[0],
                  GraphicsColor->GrayLevel[0],
                  FontSize->10,
                  FontColor->GrayLevel[0]], {3.9999999999999996, 250.}], 
                InsetBox[
                 StyleBox["\<\"\[FilledSmallCircle]\"\>",
                  StripOnInput->False,
                  LineColor->GrayLevel[0],
                  FrontFaceColor->GrayLevel[0],
                  BackFaceColor->GrayLevel[0],
                  GraphicsColor->GrayLevel[0],
                  FontSize->10,
                  
                  FontColor->GrayLevel[
                   0]], {3.9999999999999996, 290.}]}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{4.166666666666666, 999.}, {3.833333333333333, 
                999.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.9999999999999996`, 720.}, {3.9999999999999996`, 
                310.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{4.083333333333333, 310.}, {3.916666666666666, 
                310.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
                999.}}}]}, {}}],
            
            Antialiasing->
             False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}}, \
{}}, {}}, {}}, {}},
      AspectRatio->Full,
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0.6666666666666666, 65.55},
      BaseStyle->Directive[{
         GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
      DisplayFunction->Identity,
      Frame->True,
      FrameLabel->{{
         FormBox["\"training steps\"", TraditionalForm], None}, {
         FormBox["\"bias \[Mu]\"", TraditionalForm], None}},
      FrameStyle->GrayLevel[0],
      FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.9999999999999999, 
           FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox["0.79`", TraditionalForm], 0}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox["1.57`", TraditionalForm], 0}, {3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox["3.14`", TraditionalForm], 0}, {0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          4.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
          0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          4.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
      GridLines->{None, Automatic},
      GridLinesStyle->Directive[
        GrayLevel[0.4, 0.5], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{1, 2}]],
      ImagePadding->{{50, 0}, {0, 50}},
      ImageSize->220,
      LabelStyle->{FontFamily -> "Times"},
      PlotRange->{All, Automatic},
      PlotRangePadding->{{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{{{0.9999999999999999, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         0.9999999999999999, 
          FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         1.9999999999999998`, 
          FormBox["0.79`", TraditionalForm], 0}, {3., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
          FormBox["1.57`", TraditionalForm], 0}, {3.9999999999999996`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         3.9999999999999996`, 
          FormBox["3.14`", TraditionalForm], 0}, {0.8333333333333333, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
         4.166666666666666, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
        Automatic}], {0, 125}, {Left, Bottom}, {175, 125}]}, {InsetBox[
     GraphicsBox[{
       {Opacity[0], 
        PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
         1043.45}}]}, 
       {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
        {RGBColor[0.9, 0.36, 0.054], 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{0.8333333333333333, 552.5}, {1.1666666666666665`, 
               552.5}, {1.1666666666666665`, 200.}, {0.8333333333333333, 
               200.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{1.1666666666666665`, 310.}, {0.8333333333333333, 
                310.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{0.9999999999999999, 200.}, {0.9999999999999999, 
                120.}}, {{0.9999999999999999, 552.5}, {0.9999999999999999, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.0833333333333333`, 120.}, {0.9166666666666665, 
                120.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{1.833333333333333, 655.}, {2.1666666666666665`, 
               655.}, {2.1666666666666665`, 220.}, {1.833333333333333, 
               220.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{2.1666666666666665`, 320.}, {1.833333333333333, 
                320.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.9999999999999998`, 220.}, {1.9999999999999998`, 
                130.}}, {{1.9999999999999998`, 655.}, {1.9999999999999998`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{2.083333333333333, 130.}, {1.9166666666666665`, 
                130.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{2.833333333333333, 600.}, {3.1666666666666665`, 
               600.}, {3.1666666666666665`, 210.}, {2.833333333333333, 
               210.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{3.166666666666667, 350.}, {2.833333333333333, 
                350.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3., 210.}, {3., 130.}}, {{3., 600.}, {3., 999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
                130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
               999.}, {4.166666666666666, 510.}, {3.833333333333333, 
               510.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{4.166666666666666, 785.}, {3.833333333333333, 
                785.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.9999999999999996`, 510.}, {3.9999999999999996`, 
                110.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{4.083333333333333, 110.}, {3.916666666666666, 
                110.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
               999.}, {5.166666666666666, 470.}, {4.833333333333333, 
               470.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{5.166666666666666, 980.}, {4.833333333333334, 
                980.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{5., 470.}, {5., 180.}}, {{5., 999.}, {5., 999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{5.083333333333333, 180.}, {4.916666666666667, 
                180.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
                999.}}}]}, {}}],
            
            Antialiasing->
             False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
      AspectRatio->Full,
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0.6166666666666666, 65.55},
      BaseStyle->Directive[{
         GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
      DisplayFunction->Identity,
      Frame->True,
      FrameLabel->{{
         FormBox["\"training steps\"", TraditionalForm], None}, {
         FormBox["\"bias \[Sigma]\"", TraditionalForm], None}},
      FrameStyle->GrayLevel[0],
      FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.9999999999999999, 
           FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox["0.01`", TraditionalForm], 0}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox["1.`", TraditionalForm], 0}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
          0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
      GridLines->{None, Automatic},
      GridLinesStyle->Directive[
        GrayLevel[0.4, 0.5], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{1, 2}]],
      ImagePadding->{{0, 0}, {50, 0}},
      ImageSize->220,
      LabelStyle->{FontFamily -> "Times"},
      PlotRange->{All, Automatic},
      PlotRangePadding->{{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{{{0.9999999999999999, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         0.9999999999999999, 
          FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         1.9999999999999998`, 
          FormBox["0.01`", TraditionalForm], 0}, {3., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
          FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         3.9999999999999996`, 
          FormBox["1.`", TraditionalForm], 0}, {5., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
          FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
         5.166666666666666, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
        Automatic}], {175, 0}, {Left, Bottom}, {125, 125}], InsetBox[
     GraphicsBox[{
       {Opacity[0], 
        PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
         1043.45}}]}, 
       {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
        {RGBColor[0.9, 0.36, 0.054], 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{0.8333333333333333, 999.}, {1.1666666666666665`, 
               999.}, {1.1666666666666665`, 260.}, {0.8333333333333333, 
               260.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{1.1666666666666665`, 520.}, {0.8333333333333333, 
                520.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{0.9999999999999999, 260.}, {0.9999999999999999, 
                120.}}, {{0.9999999999999999, 999.}, {0.9999999999999999, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.0833333333333333`, 120.}, {0.9166666666666665, 
                120.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{1.833333333333333, 999.}, {2.1666666666666665`, 
               999.}, {2.1666666666666665`, 290.}, {1.833333333333333, 
               290.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{2.1666666666666665`, 585.}, {1.833333333333333, 
                585.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.9999999999999998`, 290.}, {1.9999999999999998`, 
                130.}}, {{1.9999999999999998`, 999.}, {1.9999999999999998`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{2.083333333333333, 130.}, {1.9166666666666665`, 
                130.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{2.833333333333333, 999.}, {3.1666666666666665`, 
               999.}, {3.1666666666666665`, 330.}, {2.833333333333333, 
               330.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{3.166666666666667, 570.}, {2.833333333333333, 
                570.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3., 330.}, {3., 130.}}, {{3., 999.}, {3., 999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
                130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
               999.}, {4.166666666666666, 470.}, {3.833333333333333, 
               470.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{4.166666666666666, 830.}, {3.833333333333333, 
                830.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.9999999999999996`, 470.}, {3.9999999999999996`, 
                110.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{4.083333333333333, 110.}, {3.916666666666666, 
                110.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
               999.}, {5.166666666666666, 500.}, {4.833333333333333, 
               500.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{5.166666666666666, 830.}, {4.833333333333334, 
                830.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{5., 500.}, {5., 170.}}, {{5., 999.}, {5., 999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{5.083333333333333, 170.}, {4.916666666666667, 
                170.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
                999.}}}]}, {}}],
            
            Antialiasing->
             False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
      AspectRatio->Full,
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0.6166666666666666, 65.55},
      BaseStyle->Directive[{
         GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
      DisplayFunction->Identity,
      Frame->True,
      FrameLabel->{{
         FormBox["\"training steps\"", TraditionalForm], None}, {
         FormBox["\"bias \[Sigma]\"", TraditionalForm], None}},
      FrameStyle->GrayLevel[0],
      FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.9999999999999999, 
           FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox["0.01`", TraditionalForm], 0}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox["1.`", TraditionalForm], 0}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
          0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
      GridLines->{None, Automatic},
      GridLinesStyle->Directive[
        GrayLevel[0.4, 0.5], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{1, 2}]],
      ImagePadding->{{0, 0}, {0, 50}},
      ImageSize->220,
      LabelStyle->{FontFamily -> "Times"},
      PlotRange->{All, Automatic},
      PlotRangePadding->{{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{{{0.9999999999999999, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         0.9999999999999999, 
          FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         1.9999999999999998`, 
          FormBox["0.01`", TraditionalForm], 0}, {3., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
          FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         3.9999999999999996`, 
          FormBox["1.`", TraditionalForm], 0}, {5., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
          FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
         5.166666666666666, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
        Automatic}], {175, 125}, {Left, Bottom}, {125, 125}]}, {InsetBox[
     GraphicsBox[{
       {Opacity[0], 
        PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
         1043.45}}]}, 
       {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
        {RGBColor[0.9, 0.36, 0.054], 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{0.8333333333333333, 592.5}, {1.1666666666666665`, 
               592.5}, {1.1666666666666665`, 190.}, {0.8333333333333333, 
               190.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{1.1666666666666665`, 300.}, {0.8333333333333333, 
                300.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{0.9999999999999999, 190.}, {0.9999999999999999, 
                120.}}, {{0.9999999999999999, 592.5}, {0.9999999999999999, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.0833333333333333`, 120.}, {0.9166666666666665, 
                120.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{1.833333333333333, 660.}, {2.1666666666666665`, 
               660.}, {2.1666666666666665`, 210.}, {1.833333333333333, 
               210.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{2.1666666666666665`, 310.}, {1.833333333333333, 
                310.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.9999999999999998`, 210.}, {1.9999999999999998`, 
                120.}}, {{1.9999999999999998`, 660.}, {1.9999999999999998`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{2.083333333333333, 120.}, {1.9166666666666665`, 
                120.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{2.833333333333333, 715.}, {3.1666666666666665`, 
               715.}, {3.1666666666666665`, 290.}, {2.833333333333333, 
               290.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{3.166666666666667, 445.}, {2.833333333333333, 
                445.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3., 290.}, {3., 130.}}, {{3., 715.}, {3., 999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
                130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
               999.}, {4.166666666666666, 470.}, {3.833333333333333, 
               470.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{4.166666666666666, 810.}, {3.833333333333333, 
                810.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.9999999999999996`, 470.}, {3.9999999999999996`, 
                110.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{4.083333333333333, 110.}, {3.916666666666666, 
                110.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
               999.}, {5.166666666666666, 442.5}, {4.833333333333333, 
               442.5}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{5.166666666666666, 730.}, {4.833333333333334, 
                730.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{5., 442.5}, {5., 150.}}, {{5., 999.}, {5., 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{5.083333333333333, 150.}, {4.916666666666667, 
                150.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
                999.}}}]}, {}}],
            
            Antialiasing->
             False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
      AspectRatio->Full,
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0.6166666666666666, 65.55},
      BaseStyle->Directive[{
         GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
      DisplayFunction->Identity,
      Frame->True,
      FrameLabel->{{
         FormBox["\"training steps\"", TraditionalForm], None}, {
         FormBox["\"weights \[Sigma]\"", TraditionalForm], None}},
      FrameStyle->GrayLevel[0],
      FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.9999999999999999, 
           FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox["0.01`", TraditionalForm], 0}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox["1.`", TraditionalForm], 0}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
          0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
      GridLines->{None, Automatic},
      GridLinesStyle->Directive[
        GrayLevel[0.4, 0.5], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{1, 2}]],
      ImagePadding->{{0, 0}, {50, 0}},
      ImageSize->220,
      LabelStyle->{FontFamily -> "Times"},
      PlotRange->{All, Automatic},
      PlotRangePadding->{{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{{{0.9999999999999999, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         0.9999999999999999, 
          FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         1.9999999999999998`, 
          FormBox["0.01`", TraditionalForm], 0}, {3., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
          FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         3.9999999999999996`, 
          FormBox["1.`", TraditionalForm], 0}, {5., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
          FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
         5.166666666666666, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
        Automatic}], {300, 0}, {Left, Bottom}, {125, 125}], InsetBox[
     GraphicsBox[{
       {Opacity[0], 
        PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
         1043.45}}]}, 
       {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
        {RGBColor[0.9, 0.36, 0.054], 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{0.8333333333333333, 999.}, {1.1666666666666665`, 
               999.}, {1.1666666666666665`, 270.}, {0.8333333333333333, 
               270.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{1.1666666666666665`, 560.}, {0.8333333333333333, 
                560.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{0.9999999999999999, 270.}, {0.9999999999999999, 
                120.}}, {{0.9999999999999999, 999.}, {0.9999999999999999, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.0833333333333333`, 120.}, {0.9166666666666665, 
                120.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{1.833333333333333, 999.}, {2.1666666666666665`, 
               999.}, {2.1666666666666665`, 290.}, {1.833333333333333, 
               290.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{2.1666666666666665`, 630.}, {1.833333333333333, 
                630.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.9999999999999998`, 290.}, {1.9999999999999998`, 
                120.}}, {{1.9999999999999998`, 999.}, {1.9999999999999998`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{2.083333333333333, 120.}, {1.9166666666666665`, 
                120.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{2.833333333333333, 999.}, {3.1666666666666665`, 
               999.}, {3.1666666666666665`, 320.}, {2.833333333333333, 
               320.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{3.166666666666667, 650.}, {2.833333333333333, 
                650.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3., 320.}, {3., 130.}}, {{3., 999.}, {3., 999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
                130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
               999.}, {4.166666666666666, 410.}, {3.833333333333333, 
               410.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{4.166666666666666, 710.}, {3.833333333333333, 
                710.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.9999999999999996`, 410.}, {3.9999999999999996`, 
                110.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{4.083333333333333, 110.}, {3.916666666666666, 
                110.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
               999.}, {5.166666666666666, 470.}, {4.833333333333333, 
               470.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{5.166666666666666, 830.}, {4.833333333333334, 
                830.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{5., 470.}, {5., 150.}}, {{5., 999.}, {5., 999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{5.083333333333333, 150.}, {4.916666666666667, 
                150.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
                999.}}}]}, {}}],
            
            Antialiasing->
             False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
      AspectRatio->Full,
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0.6166666666666666, 65.55},
      BaseStyle->Directive[{
         GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
      DisplayFunction->Identity,
      Frame->True,
      FrameLabel->{{
         FormBox["\"training steps\"", TraditionalForm], None}, {
         FormBox["\"weights \[Sigma]\"", TraditionalForm], None}},
      FrameStyle->GrayLevel[0],
      FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.9999999999999999, 
           FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox["0.01`", TraditionalForm], 0}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox["1.`", TraditionalForm], 0}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
          0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
      GridLines->{None, Automatic},
      GridLinesStyle->Directive[
        GrayLevel[0.4, 0.5], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{1, 2}]],
      ImagePadding->{{0, 0}, {0, 50}},
      ImageSize->220,
      LabelStyle->{FontFamily -> "Times"},
      PlotRange->{All, Automatic},
      PlotRangePadding->{{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{{{0.9999999999999999, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         0.9999999999999999, 
          FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         1.9999999999999998`, 
          FormBox["0.01`", TraditionalForm], 0}, {3., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
          FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         3.9999999999999996`, 
          FormBox["1.`", TraditionalForm], 0}, {5., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
          FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
         5.166666666666666, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
        Automatic}], {300, 125}, {Left, Bottom}, {125, 125}]}, {InsetBox[
     GraphicsBox[{
       {Opacity[0], 
        PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
         1043.45}}]}, 
       {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
        {RGBColor[0.9, 0.36, 0.054], 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{0.8333333333333333, 605.}, {1.1666666666666665`, 
               605.}, {1.1666666666666665`, 240.}, {0.8333333333333333, 
               240.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{1.1666666666666665`, 400.}, {0.8333333333333333, 
                400.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{0.9999999999999999, 240.}, {0.9999999999999999, 
                110.}}, {{0.9999999999999999, 605.}, {0.9999999999999999, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.0833333333333333`, 110.}, {0.9166666666666665, 
                110.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{1.833333333333333, 690.}, {2.1666666666666665`, 
               690.}, {2.1666666666666665`, 240.}, {1.833333333333333, 
               240.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{2.1666666666666665`, 410.}, {1.833333333333333, 
                410.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.9999999999999998`, 240.}, {1.9999999999999998`, 
                120.}}, {{1.9999999999999998`, 690.}, {1.9999999999999998`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{2.083333333333333, 120.}, {1.9166666666666665`, 
                120.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{2.833333333333333, 710.}, {3.1666666666666665`, 
               710.}, {3.1666666666666665`, 230.}, {2.833333333333333, 
               230.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{3.166666666666667, 425.}, {2.833333333333333, 
                425.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3., 230.}, {3., 130.}}, {{3., 710.}, {3., 999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
                130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
               999.}, {4.166666666666666, 307.5}, {3.833333333333333, 
               307.5}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{4.166666666666666, 710.}, {3.833333333333333, 
                710.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.9999999999999996`, 307.5}, {3.9999999999999996`, 
                120.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{4.083333333333333, 120.}, {3.916666666666666, 
                120.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
               999.}, {5.166666666666666, 322.5}, {4.833333333333333, 
               322.5}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{5.166666666666666, 710.}, {4.833333333333334, 
                710.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{5., 322.5}, {5., 120.}}, {{5., 999.}, {5., 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{5.083333333333333, 120.}, {4.916666666666667, 
                120.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
                999.}}}]}, {}}],
            
            Antialiasing->
             False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
      AspectRatio->Full,
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0.6166666666666666, 65.55},
      BaseStyle->Directive[{
         GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
      DisplayFunction->Identity,
      Frame->True,
      FrameLabel->{{
         FormBox["\"training steps\"", TraditionalForm], None}, {
         FormBox["\"unitaries \[Sigma]\"", TraditionalForm], None}},
      FrameStyle->GrayLevel[0],
      FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.9999999999999999, 
           FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox["0.01`", TraditionalForm], 0}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox["1.`", TraditionalForm], 0}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
          0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
      GridLines->{None, Automatic},
      GridLinesStyle->Directive[
        GrayLevel[0.4, 0.5], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{1, 2}]],
      ImagePadding->{{0, 50}, {50, 0}},
      ImageSize->220,
      LabelStyle->{FontFamily -> "Times"},
      PlotRange->{All, Automatic},
      PlotRangePadding->{{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{{{0.9999999999999999, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         0.9999999999999999, 
          FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         1.9999999999999998`, 
          FormBox["0.01`", TraditionalForm], 0}, {3., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
          FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         3.9999999999999996`, 
          FormBox["1.`", TraditionalForm], 0}, {5., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
          FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
         5.166666666666666, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
        Automatic}], {425, 0}, {Left, Bottom}, {175, 125}], InsetBox[
     GraphicsBox[{
       {Opacity[0], 
        PointBox[{{0.33333333333333326`, 65.55}, {5.666666666666666, 
         1043.45}}]}, 
       {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
        {RGBColor[0.9, 0.36, 0.054], 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{0.8333333333333333, 999.}, {1.1666666666666665`, 
               999.}, {1.1666666666666665`, 310.}, {0.8333333333333333, 
               310.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{1.1666666666666665`, 490.}, {0.8333333333333333, 
                490.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{0.9999999999999999, 310.}, {0.9999999999999999, 
                110.}}, {{0.9999999999999999, 999.}, {0.9999999999999999, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.0833333333333333`, 110.}, {0.9166666666666665, 
                110.}}, {{1.0833333333333333`, 999.}, {0.9166666666666665, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{1.833333333333333, 999.}, {2.1666666666666665`, 
               999.}, {2.1666666666666665`, 310.}, {1.833333333333333, 
               310.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{2.1666666666666665`, 530.}, {1.833333333333333, 
                530.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{1.9999999999999998`, 310.}, {1.9999999999999998`, 
                120.}}, {{1.9999999999999998`, 999.}, {1.9999999999999998`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{2.083333333333333, 120.}, {1.9166666666666665`, 
                120.}}, {{2.083333333333333, 999.}, {1.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{2.833333333333333, 999.}, {3.1666666666666665`, 
               999.}, {3.1666666666666665`, 310.}, {2.833333333333333, 
               310.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{3.166666666666667, 540.}, {2.833333333333333, 
                540.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3., 310.}, {3., 130.}}, {{3., 999.}, {3., 999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.0833333333333335`, 130.}, {2.9166666666666665`, 
                130.}}, {{3.0833333333333335`, 999.}, {2.9166666666666665`, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{3.833333333333333, 999.}, {4.166666666666666, 
               999.}, {4.166666666666666, 512.5}, {3.833333333333333, 
               512.5}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{4.166666666666666, 999.}, {3.833333333333333, 
                999.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{3.9999999999999996`, 512.5}, {3.9999999999999996`, 
                120.}}, {{3.9999999999999996`, 999.}, {3.9999999999999996`, 
                999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{4.083333333333333, 120.}, {3.916666666666666, 
                120.}}, {{4.083333333333333, 999.}, {3.916666666666666, 
                999.}}}]}, {}}],
            Antialiasing->False]]}, 
         {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
           
           StyleBox[
            GraphicsGroupBox[{
              PolygonBox[{{4.833333333333333, 999.}, {5.166666666666666, 
               999.}, {5.166666666666666, 550.}, {4.833333333333333, 
               550.}}], {}, {{}, {}}, {}, 
              {GrayLevel[1], 
               LineBox[{{5.166666666666666, 999.}, {4.833333333333334, 
                999.}}]}, {}, 
              {GrayLevel[0.5], 
               LineBox[{{{5., 550.}, {5., 120.}}, {{5., 999.}, {5., 999.}}}]}, 
              {GrayLevel[0.5], 
               LineBox[{{{5.083333333333333, 120.}, {4.916666666666667, 
                120.}}, {{5.083333333333333, 999.}, {4.916666666666667, 
                999.}}}]}, {}}],
            
            Antialiasing->
             False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}}, {}}, {}}, {}}, {}},
      AspectRatio->Full,
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0.6166666666666666, 65.55},
      BaseStyle->Directive[{
         GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
      DisplayFunction->Identity,
      Frame->True,
      FrameLabel->{{
         FormBox["\"training steps\"", TraditionalForm], None}, {
         FormBox["\"unitaries \[Sigma]\"", TraditionalForm], None}},
      FrameStyle->GrayLevel[0],
      FrameTicks->{{Automatic, Automatic}, {{{0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.9999999999999999, 
           FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox["0.01`", TraditionalForm], 0}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox["1.`", TraditionalForm], 0}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{
          0.9999999999999999, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          1.9999999999999998`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          3.9999999999999996`, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
          0.8333333333333333, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
          5.166666666666666, 
           FormBox[
            TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
      GridLines->{None, Automatic},
      GridLinesStyle->Directive[
        GrayLevel[0.4, 0.5], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{1, 2}]],
      ImagePadding->{{0, 50}, {0, 50}},
      ImageSize->220,
      LabelStyle->{FontFamily -> "Times"},
      PlotRange->{All, Automatic},
      PlotRangePadding->{{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{{{0.9999999999999999, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         0.9999999999999999, 
          FormBox["0.`", TraditionalForm], 0}, {1.9999999999999998`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         1.9999999999999998`, 
          FormBox["0.01`", TraditionalForm], 0}, {3., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
          FormBox["0.1`", TraditionalForm], 0}, {3.9999999999999996`, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {
         3.9999999999999996`, 
          FormBox["1.`", TraditionalForm], 0}, {5., 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {5., 
          FormBox["10.`", TraditionalForm], 0}, {0.8333333333333333, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {
         5.166666666666666, 
          FormBox[
           TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
        Automatic}], {425, 125}, {Left, Bottom}, {175, 125}]}},
  ImageSize->{600, 250},
  PlotRange->{{0, 600}, {0, 250}}]], "Output",
 CellChangeTimes->{{3.8003429648977547`*^9, 3.8003429727806835`*^9}, {
  3.8003431148656316`*^9, 3.8003431433605957`*^9}, {3.80034403870788*^9, 
  3.800344053688311*^9}, {3.800359369308057*^9, 3.800359406338826*^9}},
 CellLabel->
  "Out[1190]=",ExpressionUUID->"805d514f-f1da-4a08-aa61-16a35f3727a1"]
}, Open  ]],

Cell["All spreads should be mild", "Text",
 CellChangeTimes->{{3.798695447125038*^9, 3.7986954645967846`*^9}, {
  3.7988606593647184`*^9, 
  3.798860665961254*^9}},ExpressionUUID->"2bb82f68-e948-4fbc-b527-\
b1fba39ae245"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"boxWhisker", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", "\"\<initial_bias\>\"", "]"}], "\[Equal]", 
          "1.5708"}], "\[And]", 
         RowBox[{
          RowBox[{"#", "[", "\"\<initial_bias_spread\>\"", "]"}], "<", ".5"}],
          "\[And]", 
         RowBox[{
          RowBox[{"#", "[", "\"\<initial_unitaries_spread\>\"", "]"}], "<", 
          ".5"}], "\[And]", 
         RowBox[{
          RowBox[{"#", "[", "\"\<initial_weights_spread\>\"", "]"}], "<", 
          ".05"}]}], "&"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "#"}], 
    "\[IndentingNewLine]", "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<initial_bias\>\"", ",", "\"\<initial_bias_spread\>\"", ",", 
    "\"\<initial_weights_spread\>\"", ",", " ", 
    "\"\<initial_unitaries_spread\>\""}], "}"}]}]], "Input",
 CellChangeTimes->{{3.798695470927963*^9, 3.798695478193745*^9}, {
   3.798695533820357*^9, 3.7986955341613193`*^9}, {3.798695589183629*^9, 
   3.798695595654914*^9}, {3.7986957518968844`*^9, 3.7986957522533417`*^9}, {
   3.7986957980236444`*^9, 3.7986958012247453`*^9}, 3.798738346945422*^9, {
   3.7987753197956734`*^9, 3.798775340584906*^9}, {3.79879436313968*^9, 
   3.7987943635803647`*^9}, 3.7987943939961615`*^9, {3.7987950873711195`*^9, 
   3.7987950967905045`*^9}, {3.798860674665161*^9, 3.7988607008883147`*^9}},
 CellLabel->
  "In[438]:=",ExpressionUUID->"3b42a380-2516-497b-84e9-d9b40a3be749"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {Opacity[0], PointBox[{{-0.19999999999999996`, 87.5}, {2.2, 802.5}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8, 280.}, {1.2, 280.}, {1.2, 170.}, {0.8, 
             170.}}], {}, {{InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {1., 480.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {1., 520.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {1., 520.}]}, {InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0.5],
                FrontFaceColor->GrayLevel[0.5],
                BackFaceColor->GrayLevel[0.5],
                GraphicsColor->GrayLevel[0.5],
                FontSize->10,
                FontColor->GrayLevel[0.5]], {1., 700.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0.5],
                FrontFaceColor->GrayLevel[0.5],
                BackFaceColor->GrayLevel[0.5],
                GraphicsColor->GrayLevel[0.5],
                FontSize->10,
                FontColor->GrayLevel[0.5]], {1., 770.}]}}, {}, 
            {GrayLevel[1], LineBox[{{1.2, 210.}, {0.8, 210.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1., 170.}, {1., 120.}}, {{1., 280.}, {1., 440.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.1, 120.}, {0.9, 120.}}, {{1.1, 440.}, {0.9, 
              440.}}}]}, {}}],
          Antialiasing->False]]}}, {}, {}}, {{{{{}, {}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.78, 87.5},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"epoch\"", TraditionalForm], None}, {
       FormBox["\"initial_bias\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
         FormBox["1.5708`", TraditionalForm], 0}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->300,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{1., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
        FormBox["1.5708`", TraditionalForm], 0}, {0.8, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], PointBox[{{0.42500000000000004`, 87.5}, {3.575, 802.5}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8, 240.}, {1.2, 240.}, {1.2, 180.}, {0.8, 
             180.}}], {}, {{InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {1., 360.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {1., 370.}]}, {InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0.5],
                FrontFaceColor->GrayLevel[0.5],
                BackFaceColor->GrayLevel[0.5],
                GraphicsColor->GrayLevel[0.5],
                FontSize->10,
                FontColor->GrayLevel[0.5]], {1., 430.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0.5],
                FrontFaceColor->GrayLevel[0.5],
                BackFaceColor->GrayLevel[0.5],
                GraphicsColor->GrayLevel[0.5],
                FontSize->10,
                FontColor->GrayLevel[0.5]], {1., 480.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0.5],
                FrontFaceColor->GrayLevel[0.5],
                BackFaceColor->GrayLevel[0.5],
                GraphicsColor->GrayLevel[0.5],
                FontSize->10,
                FontColor->GrayLevel[0.5]], {1., 520.}]}}, {}, 
            {GrayLevel[1], LineBox[{{1.2, 200.}, {0.8, 200.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1., 180.}, {1., 120.}}, {{1., 240.}, {1., 320.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.1, 120.}, {0.9, 120.}}, {{1.1, 320.}, {0.9, 
              320.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{1.8, 315.}, {2.2, 315.}, {2.2, 175.}, {1.8, 
             175.}}], {}, {InsetBox[
              StyleBox["\<\"\[FilledSmallCircle]\"\>",
               StripOnInput->False,
               LineColor->GrayLevel[0],
               FrontFaceColor->GrayLevel[0],
               BackFaceColor->GrayLevel[0],
               GraphicsColor->GrayLevel[0],
               FontSize->10,
               FontColor->GrayLevel[0]], {2., 700.}], InsetBox[
              StyleBox["\<\"\[FilledSmallCircle]\"\>",
               StripOnInput->False,
               LineColor->GrayLevel[0.5],
               FrontFaceColor->GrayLevel[0.5],
               BackFaceColor->GrayLevel[0.5],
               GraphicsColor->GrayLevel[0.5],
               FontSize->10,
               FontColor->GrayLevel[0.5]], {2., 770.}]}, {}, 
            {GrayLevel[1], 
             LineBox[{{2.2, 240.}, {1.7999999999999998`, 240.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{2., 175.}, {2., 130.}}, {{2., 315.}, {2., 520.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{2.1, 130.}, {1.9, 130.}}, {{2.1, 520.}, {1.9, 
              520.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{2.8000000000000003`, 250.}, {3.2, 250.}, {3.2, 
             160.}, {2.8000000000000003`, 160.}}], {}, {{InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3., 440.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {3., 430.}]}, {}}, {}, 
            {GrayLevel[1], LineBox[{{3.2, 200.}, {2.8, 200.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3., 160.}, {3., 130.}}, {{3., 250.}, {3., 370.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.1, 130.}, {2.9, 130.}}, {{3.1, 370.}, {2.9, 
              370.}}}]}, {}}],
          
          Antialiasing->
           False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}}, {}}, {}}, \
{}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.68, 87.5},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"epoch\"", TraditionalForm], None}, {
       FormBox["\"initial_bias_spread\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
         FormBox["0.`", TraditionalForm], 0}, {2., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {2., 
         FormBox["0.01`", TraditionalForm], 0}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox["0.1`", TraditionalForm], 0}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {3.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {2., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {3.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->300,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{1., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
        FormBox["0.`", TraditionalForm], 0}, {2., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {2., 
        FormBox["0.01`", TraditionalForm], 0}, {3., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
        FormBox["0.1`", TraditionalForm], 0}, {0.8, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {3.2, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], PointBox[{{0.42500000000000004`, 87.5}, {2.575, 802.5}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8, 250.}, {1.2, 250.}, {1.2, 170.}, {0.8, 
             170.}}], {}, {{InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {1., 400.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {1., 440.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {1., 480.}]}, {InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0.5],
                FrontFaceColor->GrayLevel[0.5],
                BackFaceColor->GrayLevel[0.5],
                GraphicsColor->GrayLevel[0.5],
                FontSize->10,
                FontColor->GrayLevel[0.5]], {1., 700.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0.5],
                FrontFaceColor->GrayLevel[0.5],
                BackFaceColor->GrayLevel[0.5],
                GraphicsColor->GrayLevel[0.5],
                FontSize->10,
                FontColor->GrayLevel[0.5]], {1., 770.}]}}, {}, 
            {GrayLevel[1], LineBox[{{1.2, 200.}, {0.8, 200.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1., 170.}, {1., 140.}}, {{1., 250.}, {1., 370.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.1, 140.}, {0.9, 140.}}, {{1.1, 370.}, {0.9, 
              370.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{1.8, 290.}, {2.2, 290.}, {2.2, 180.}, {1.8, 
             180.}}], {}, {{InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {2., 520.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {2., 520.}]}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{2.2, 210.}, {1.7999999999999998`, 210.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{2., 180.}, {2., 120.}}, {{2., 290.}, {2., 430.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{2.1, 120.}, {1.9, 120.}}, {{2.1, 430.}, {1.9, 
              430.}}}]}, {}}],
          
          Antialiasing->
           False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.73, 87.5},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"epoch\"", TraditionalForm], None}, {
       FormBox["\"initial_weights_spread\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
         FormBox["0.`", TraditionalForm], 0}, {2., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {2., 
         FormBox["0.01`", TraditionalForm], 0}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {2.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {2., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {2.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->300,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{1., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
        FormBox["0.`", TraditionalForm], 0}, {2., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {2., 
        FormBox["0.01`", TraditionalForm], 0}, {0.8, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {2.2, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], PointBox[{{0.42500000000000004`, 87.5}, {3.575, 802.5}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8, 300.}, {1.2, 300.}, {1.2, 180.}, {0.8, 
             180.}}], {}, {{}, InsetBox[
              StyleBox["\<\"\[FilledSmallCircle]\"\>",
               StripOnInput->False,
               LineColor->GrayLevel[0.5],
               FrontFaceColor->GrayLevel[0.5],
               BackFaceColor->GrayLevel[0.5],
               GraphicsColor->GrayLevel[0.5],
               FontSize->10,
               FontColor->GrayLevel[0.5]], {1., 770.}]}, {}, 
            {GrayLevel[1], LineBox[{{1.2, 200.}, {0.8, 200.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1., 180.}, {1., 130.}}, {{1., 300.}, {1., 430.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.1, 130.}, {0.9, 130.}}, {{1.1, 430.}, {0.9, 
              430.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{1.8, 260.}, {2.2, 260.}, {2.2, 170.}, {1.8, 
             170.}}], {}, {{InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {2., 430.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {2., 480.}], InsetBox[
               StyleBox["\<\"\[FilledSmallCircle]\"\>",
                StripOnInput->False,
                LineColor->GrayLevel[0],
                FrontFaceColor->GrayLevel[0],
                BackFaceColor->GrayLevel[0],
                GraphicsColor->GrayLevel[0],
                FontSize->10,
                FontColor->GrayLevel[0]], {2., 520.}]}, {}}, {}, 
            {GrayLevel[1], 
             LineBox[{{2.2, 205.}, {1.7999999999999998`, 205.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{2., 170.}, {2., 120.}}, {{2., 260.}, {2., 370.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{2.1, 120.}, {1.9, 120.}}, {{2.1, 370.}, {1.9, 
              370.}}}]}, {}}],
          Antialiasing->False]]}, 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{2.8000000000000003`, 280.}, {3.2, 280.}, {3.2, 
             167.5}, {2.8000000000000003`, 167.5}}], {}, {InsetBox[
              StyleBox["\<\"\[FilledSmallCircle]\"\>",
               StripOnInput->False,
               LineColor->GrayLevel[0],
               FrontFaceColor->GrayLevel[0],
               BackFaceColor->GrayLevel[0],
               GraphicsColor->GrayLevel[0],
               FontSize->10,
               FontColor->GrayLevel[0]], {3., 520.}], InsetBox[
              StyleBox["\<\"\[FilledSmallCircle]\"\>",
               StripOnInput->False,
               LineColor->GrayLevel[0.5],
               FrontFaceColor->GrayLevel[0.5],
               BackFaceColor->GrayLevel[0.5],
               GraphicsColor->GrayLevel[0.5],
               FontSize->10,
               FontColor->GrayLevel[0.5]], {3., 700.}]}, {}, 
            {GrayLevel[1], LineBox[{{3.2, 210.}, {2.8, 210.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{3., 167.5}, {3., 130.}}, {{3., 280.}, {3., 440.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{3.1, 130.}, {2.9, 130.}}, {{3.1, 440.}, {2.9, 
              440.}}}]}, {}}],
          
          Antialiasing->
           False]]}}, {}, {}}, {{{{{{}, {}}, {{}, {}}, {{}, {}}}, {}}, {}}, \
{}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.68, 87.5},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"epoch\"", TraditionalForm], None}, {
       FormBox["\"initial_unitaries_spread\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
         FormBox["0.`", TraditionalForm], 0}, {2., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {2., 
         FormBox["0.01`", TraditionalForm], 0}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox["0.1`", TraditionalForm], 0}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {3.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {2., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {3.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->300,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{1., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
        FormBox["0.`", TraditionalForm], 0}, {2., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {2., 
        FormBox["0.01`", TraditionalForm], 0}, {3., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {3., 
        FormBox["0.1`", TraditionalForm], 0}, {0.8, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {3.2, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
      Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7987943944109445`*^9, {3.7987950922261753`*^9, 3.7987950972393136`*^9}, 
   3.79882280448886*^9, 3.798828069304226*^9, {3.798860689896722*^9, 
   3.798860701551445*^9}},
 CellLabel->
  "Out[438]=",ExpressionUUID->"5eaeecb9-25b9-4542-a285-f6cf34f05975"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"boxWhisker", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", "\"\<initial_bias\>\"", "]"}], "\[Equal]", 
          "1.5708"}], "\[And]", 
         RowBox[{
          RowBox[{"#", "[", "\"\<initial_bias_spread\>\"", "]"}], "\[Equal]", 
          ".1"}], "\[And]", 
         RowBox[{
          RowBox[{"#", "[", "\"\<initial_unitaries_spread\>\"", "]"}], 
          "\[Equal]", ".01"}], "\[And]", 
         RowBox[{
          RowBox[{"#", "[", "\"\<initial_weights_spread\>\"", "]"}], 
          "\[Equal]", ".0"}]}], "&"}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", "#"}], "\[IndentingNewLine]", "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<initial_bias\>\"", ",", "\"\<initial_bias_spread\>\"", ",", 
    "\"\<initial_weights_spread\>\"", ",", " ", 
    "\"\<initial_unitaries_spread\>\""}], "}"}]}]], "Input",
 CellChangeTimes->{{3.798695807812479*^9, 3.798695816258822*^9}, {
   3.798738234746219*^9, 3.7987382363371134`*^9}, 3.7987383583880486`*^9, {
   3.7988125488631907`*^9, 3.798812591991208*^9}, {3.7988128047920856`*^9, 
   3.798812851080761*^9}, {3.7988607716865315`*^9, 3.798860777738302*^9}, {
   3.7988610250984273`*^9, 3.798861030100692*^9}},
 CellLabel->
  "In[445]:=",ExpressionUUID->"4796c954-d7d3-4b20-b31c-a8b86e3c44e4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {Opacity[0], PointBox[{{-0.19999999999999996`, 132.5}, {2.2, 297.5}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8, 207.5}, {1.2, 207.5}, {1.2, 142.5}, {0.8, 
             142.5}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], LineBox[{{1.2, 180.}, {0.8, 180.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1., 142.5}, {1., 140.}}, {{1., 207.5}, {1., 290.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.1, 140.}, {0.9, 140.}}, {{1.1, 290.}, {0.9, 
              290.}}}]}, {}}],
          Antialiasing->False]]}}, {}, {}}, {{{{{}, {}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.78, 132.5},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"epoch\"", TraditionalForm], None}, {
       FormBox["\"initial_bias\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
         FormBox["1.5708`", TraditionalForm], 0}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->300,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{1., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
        FormBox["1.5708`", TraditionalForm], 0}, {0.8, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], PointBox[{{-0.19999999999999996`, 132.5}, {2.2, 297.5}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8, 207.5}, {1.2, 207.5}, {1.2, 142.5}, {0.8, 
             142.5}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], LineBox[{{1.2, 180.}, {0.8, 180.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1., 142.5}, {1., 140.}}, {{1., 207.5}, {1., 290.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.1, 140.}, {0.9, 140.}}, {{1.1, 290.}, {0.9, 
              290.}}}]}, {}}],
          Antialiasing->False]]}}, {}, {}}, {{{{{}, {}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.78, 132.5},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"epoch\"", TraditionalForm], None}, {
       FormBox["\"initial_bias_spread\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
         FormBox["0.1`", TraditionalForm], 0}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->300,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{1., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
        FormBox["0.1`", TraditionalForm], 0}, {0.8, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], PointBox[{{-0.19999999999999996`, 132.5}, {2.2, 297.5}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8, 207.5}, {1.2, 207.5}, {1.2, 142.5}, {0.8, 
             142.5}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], LineBox[{{1.2, 180.}, {0.8, 180.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1., 142.5}, {1., 140.}}, {{1., 207.5}, {1., 290.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.1, 140.}, {0.9, 140.}}, {{1.1, 290.}, {0.9, 
              290.}}}]}, {}}],
          Antialiasing->False]]}}, {}, {}}, {{{{{}, {}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.78, 132.5},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"epoch\"", TraditionalForm], None}, {
       FormBox["\"initial_weights_spread\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
         FormBox["0.`", TraditionalForm], 0}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->300,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{1., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
        FormBox["0.`", TraditionalForm], 0}, {0.8, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, Automatic}],
    ",", 
   GraphicsBox[{
     {Opacity[0], PointBox[{{-0.19999999999999996`, 132.5}, {2.2, 297.5}}]}, 
     {RGBColor[0.9, 0.36, 0.054], CapForm[None], {}, 
      {RGBColor[0.9, 0.36, 0.054], 
       {RGBColor[0.9, 0.36, 0.054], GraphicsGroupBox[
         StyleBox[
          GraphicsGroupBox[{
            PolygonBox[{{0.8, 207.5}, {1.2, 207.5}, {1.2, 142.5}, {0.8, 
             142.5}}], {}, {{}, {}}, {}, 
            {GrayLevel[1], LineBox[{{1.2, 180.}, {0.8, 180.}}]}, {}, 
            {GrayLevel[0.5], 
             LineBox[{{{1., 142.5}, {1., 140.}}, {{1., 207.5}, {1., 290.}}}]}, 
            {GrayLevel[0.5], 
             LineBox[{{{1.1, 140.}, {0.9, 140.}}, {{1.1, 290.}, {0.9, 
              290.}}}]}, {}}],
          Antialiasing->False]]}}, {}, {}}, {{{{{}, {}}, {}}, {}}, {}}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.78, 132.5},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->True,
    FrameLabel->{{
       FormBox["\"epoch\"", TraditionalForm], None}, {
       FormBox["\"initial_unitaries_spread\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {{{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
         FormBox["0.01`", TraditionalForm], 0}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, {{1., 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {0.8, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
         FormBox[
          TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->300,
    LabelStyle->{FontFamily -> "Times"},
    PlotRange->{All, Automatic},
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{{{1., 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0.008, 0}}, {1., 
        FormBox["0.01`", TraditionalForm], 0}, {0.8, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}, {1.2, 
        FormBox[
         TemplateBox[{0}, "Spacer1"], TraditionalForm], {0, 0}}}, 
      Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.798695817337882*^9, 3.7987382366777725`*^9, 3.7987383597328386`*^9, 
   3.798794400646329*^9, {3.7988125520911407`*^9, 3.7988125928100414`*^9}, {
   3.798812816460148*^9, 3.798812851824748*^9}, 3.798822808453054*^9, 
   3.798828096861964*^9, 3.798860778485613*^9, {3.798861026345235*^9, 
   3.7988610306474485`*^9}},
 CellLabel->
  "Out[445]=",ExpressionUUID->"c2d4d115-1578-407a-82ac-4f276277535f"]
}, Open  ]],

Cell["Best combination", "Text",
 CellChangeTimes->{{3.7988126339600706`*^9, 
  3.798812637786745*^9}},ExpressionUUID->"b4f7621e-d6a4-4824-8811-\
ad24dfcb0ee0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"data", "[", 
    RowBox[{"GroupBy", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Slot", "[", "\"\<initial_bias\>\"", "]"}], ",", 
         RowBox[{"Slot", "[", "\"\<initial_bias_spread\>\"", "]"}], ",", 
         RowBox[{"Slot", "[", "\"\<initial_weights_spread\>\"", "]"}], ",", 
         RowBox[{"Slot", "[", "\"\<initial_unitaries_spread\>\"", "]"}]}], 
        "}"}], "&"}], "\[Rule]", 
      RowBox[{"Key", "[", "\"\<hparams/epoch\>\"", "]"}]}], "]"}], "]"}], "//", 
   RowBox[{"SortBy", "[", "Mean", "]"}]}], "//", 
  RowBox[{
   RowBox[{"MeanAround", "/@", "#"}], "&"}]}]], "Input",
 CellChangeTimes->{{3.7988126433734293`*^9, 3.7988126706110396`*^9}, {
  3.7988127608892035`*^9, 3.798812761327719*^9}, {3.7988281335062385`*^9, 
  3.7988281823865232`*^9}},
 CellLabel->
  "In[440]:=",ExpressionUUID->"5a19b9ac-90eb-4b8a-9cee-77dfbbe1f529"],

Cell[BoxData[
 TagBox[
  TagBox[
   DynamicModuleBox[{TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
    Association[
    "InitialData" -> 
     Association[{1.5708, 0., 0., 10.} -> 
       Around[168.57142857142858`, 11.428571428571427`], {1.5708, 0., 0., 0.} -> 
       Around[184.44444444444446`, 2.939723678960656], {1.5708, 0.1, 0., 
        0.01} -> Around[187.14285714285714`, 20.203050891044214`], {0.785398, 
        1., 0.01, 0.} -> Around[195., 35.], {0.785398, 0., 0.1, 0.} -> 
       200., {1.5708, 0.1, 0., 0.} -> 
       Around[200., 11.126972805283735`], {0.785398, 0.1, 0.1, 0.} -> 
       210., {1.5708, 0.1, 0.01, 0.1} -> 
       Around[210., 32.80534218980921], {1.5708, 0., 0., 0.1} -> 
       Around[211.25, 17.872314983156006`], {1.5708, 0.01, 0.01, 1.} -> 
       Around[215., 26.425997300638123`], {1.5708, 0., 0.01, 0.} -> 
       Around[216.66666666666666`, 27.28450923957483], {0., 0.01, 1., 0.} -> 
       Around[220., 70.], {1.5708, 0.01, 0.01, 0.01} -> 
       Around[220., 20.97617696340303], {1.5708, 0.01, 0., 0.01} -> 
       Around[222.5, 25.19566289208181], {1.5708, 0.1, 0.1, 0.1} -> 
       Around[223.33333333333334`, 19.776529298921773`], {1.5708, 1., 1., 0.} -> 
       Around[232., 62.161081071680215`], {1.5708, 0.1, 0., 0.1} -> 
       Around[236., 53.53503525729669], {1.5708, 0.01, 0., 1.} -> 
       Around[238.57142857142858`, 32.90886198699237], {0.785398, 0., 0.1, 
        0.1} -> Around[240., 37.859388972001824`], {1.5708, 0., 0.01, 0.01} -> 
       Around[240., 40.93355048802334], {1.5708, 0.01, 0.01, 10.} -> 
       Around[240., 21.044171232366047`], {3.14159, 0., 1., 0.} -> 
       Around[240., 80.], {1.5708, 0.1, 0.01, 0.01} -> 
       Around[244., 33.25657829663178], {0.785398, 0.1, 0.1, 0.01} -> 
       Around[250., 40.], {0.785398, 1., 0.1, 0.} -> 
       Around[250., 30.], {1.5708, 0., 0., 1.} -> 
       Around[250., 45.94251065967429], {1.5708, 0.1, 0.01, 0.} -> 
       Around[250., 38.047589248453676`], {1.5708, 0., 0., 0.01} -> 
       Around[255.71428571428572`, 43.74477617015397], {1.5708, 0., 0.01, 
        0.1} -> Around[255.71428571428572`, 32.28276429843484], {1.5708, 0., 
        0.1, 0.1} -> 
       Around[258.57142857142856`, 38.32371958713294], {1.5708, 0., 0.01, 
        10.} -> Around[258.75, 37.10205519913957], {1.5708, 0.01, 0.01, 0.} -> 
       Around[258.75, 31.928351709055427`], {1.5708, 0.01, 0., 0.1} -> 
       Around[260., 88.35534316987666], {1.5708, 0.1, 0., 10.} -> 
       Around[261.6666666666667, 38.59332124143302], {0., 1., 0.1, 0.} -> 
       Around[266.6666666666667, 29.627314724385297`], {1.5708, 0.01, 0., 
        10.} -> Around[266.6666666666667, 42.242685099842376`], {1.5708, 0., 
        0.01, 1.} -> 
       Around[268.8888888888889, 24.801682539499684`], {1.5708, 0.01, 0.01, 
        0.1} -> Around[271.25, 40.98943679256192], {0., 0., 1., 0.1} -> 
       Around[275., 75.], {0.785398, 0.01, 0.1, 0.} -> 
       Around[275., 95.], {0., 0., 1., 1.} -> 290., {0.785398, 0., 10., 0.01} -> 
       290., {0.785398, 1., 0.1, 0.1} -> 290., {0.785398, 10., 0., 0.} -> 
       300., {0.785398, 0.01, 0.1, 0.01} -> 
       Around[305., 55.], {3.14159, 0.01, 1., 0.01} -> 
       Around[305., 95.], {1.5708, 0., 0.1, 0.01} -> 
       Around[305.55555555555554`, 31.53970650497168], {3.14159, 0., 10., 
        0.1} -> 310., {1.5708, 0.1, 0.1, 0.} -> 
       Around[324.2857142857143, 45.032112502775], {3.14159, 0.1, 10., 0.} -> 
       Around[325., 45.], {0.785398, 10., 1., 0.} -> 
       Around[326.6666666666667, 81.92137151629673], {1.5708, 0.01, 0.1, 0.1} -> 
       Around[327.14285714285717`, 62.62945776223705], {1.5708, 0.1, 0., 1.} -> 
       Around[335., 61.900457725825156`], {1.5708, 0.1, 0.01, 1.} -> 
       Around[344.2857142857143, 89.38565834834661], {1.5708, 0.01, 0., 0.} -> 
       Around[346.6666666666667, 56.81353516353104], {1.5708, 0.01, 0.1, 0.} -> 
       Around[350., 47.90864322059325], {1.5708, 0.01, 0.1, 0.01} -> 
       Around[351.25, 56.64543544843536], {0.785398, 1., 10., 0.01} -> 
       Around[355., 105.], {3.14159, 0.01, 1., 0.1} -> 
       Around[356.6666666666667, 117.94537341969425`], {0., 1., 10., 0.01} -> 
       360., {0.785398, 0.01, 1., 0.01} -> 
       Around[360., 40.], {1.5708, 10., 10., 0.} -> 
       Around[372., 60.86049621881175], {1.5708, 0., 0.1, 0.} -> 
       Around[375.7142857142857, 44.82012424586712], {0.785398, 0.01, 0.01, 
        0.1} -> Around[380., 68.06859285554046], {0.785398, 1., 0., 0.1} -> 
       Around[385., 15.], {0.785398, 1., 0.1, 0.01} -> 
       Around[385., 135.], {1.5708, 0.01, 0.1, 1.} -> 
       Around[385., 84.55767262643882], {1.5708, 0.1, 0.1, 0.01} -> 
       Around[390., 43.74166587286467], {0.785398, 0., 0.01, 0.1} -> 
       Around[397.5, 132.18516053879372`], {1.5708, 0., 0.1, 1.} -> 
       Around[398.75, 40.72720659636328], {0., 0.01, 1., 0.01} -> 
       Around[400., 66.58328118479393], {3.14159, 0.01, 10., 0.1} -> 
       Around[400., 150.], {1.5708, 0.1, 0.01, 10.} -> 
       Around[403.3333333333333, 65.0469915608025], {0.785398, 0.01, 1., 0.1} -> 
       Around[405., 5.], {0.785398, 0., 0.1, 0.01} -> 
       Around[409.75, 197.69942463244553`], {0.785398, 0.1, 1., 0.} -> 
       410., {3.14159, 0.1, 1., 0.1} -> 410., {3.14159, 0., 10., 0.01} -> 
       Around[413.3333333333333, 73.56025496904638], {0., 1., 0.1, 0.01} -> 
       Around[420., 127.67145334803705`], {0., 1., 1., 0.1} -> 
       Around[420., 125.0333288900737], {0.785398, 10., 0., 1.} -> 
       Around[423.3333333333333, 90.24657580453925], {0., 0.1, 10., 0.1} -> 
       Around[425., 35.], {1.5708, 0.1, 0.1, 1.} -> 
       Around[427.5, 104.51275839181868`], {3.14159, 10., 0.1, 0.1} -> 
       430., {3.14159, 10., 0.01, 0.1} -> 
       Around[435., 265.], {0., 0.1, 0.01, 0.01} -> 
       Around[436.6666666666667, 108.98521816181213`], {1.5708, 0.1, 1., 
        0.01} -> Around[440., 45.53387017741117], {0., 0., 1., 0.01} -> 
       Around[443.3333333333333, 174.86502731472004`], {0., 0.1, 10., 0.01} -> 
       Around[445., 115.], {0.785398, 10., 0., 10.} -> 
       Around[445., 75.], {1.5708, 0.01, 0.1, 10.} -> 
       Around[446., 101.22252713699653`], {0., 0.1, 1., 0.} -> 
       Around[446.6666666666667, 117.8039803138153], {0.785398, 0.01, 0.1, 
        0.1} -> 450., {0.785398, 0.01, 1., 0.} -> 
       Around[450., 160.98654188057668`], {1.5708, 0., 10., 0.} -> 
       Around[450., 66.93991620066745], {0.785398, 0.1, 0., 0.} -> 
       Around[455., 25.], {1.5708, 1., 1., 0.1} -> 
       Around[458.3333333333333, 32.395129949491555`], {0., 0., 10., 0.1} -> 
       460., {0.785398, 0.1, 10., 0.01} -> 
       Around[460., 20.], {3.14159, 0.1, 10., 0.01} -> 
       Around[460., 112.39810200058247`], {0.785398, 0.1, 0.01, 0.1} -> 
       470., {0.785398, 1., 1., 0.} -> 
       Around[470., 150.], {1.5708, 0.01, 1., 0.} -> 
       Around[476.125, 98.93548357750258], {1.5708, 0., 0.1, 10.} -> 
       Around[477.5, 142.5], {0., 10., 0.01, 0.1} -> 
       Around[480., 51.316014394468844`], {0.785398, 1., 10., 0.} -> 
       480., {1.5708, 0.1, 1., 0.1} -> 
       Around[480., 55.52777082985894], {1.5708, 0.01, 1., 0.1} -> 
       Around[482.5, 53.44389581607987], {0.785398, 10., 0., 0.1} -> 
       Around[486.6666666666667, 79.65202096899014], {0., 0.01, 10., 0.01} -> 
       Around[490., 100.16652800877814`], {3.14159, 10., 1., 0.1} -> 
       Around[490., 200.], {3.14159, 10., 10., 0.1} -> 
       490., {0.785398, 0.1, 1., 0.1} -> 
       Around[493.3333333333333, 154.30849332136944`], {0., 10., 0.1, 1.} -> 
       Around[499.6666666666667, 249.93354672347965`], {0., 0.01, 1., 0.1} -> 
       Around[500., 180.], {0., 1., 0.1, 0.1} -> 
       Around[500., 164.26604437111564`], {1.5708, 0.01, 10., 0.1} -> 
       Around[502., 87.54427451295716], {0., 0.1, 1., 0.01} -> 
       Around[504.75, 166.61101154085424`], {3.14159, 0.1, 10., 0.1} -> 
       Around[505., 175.], {1.5708, 0.01, 10., 0.01} -> 
       Around[508.1666666666667, 104.83333333333334`], {1.5708, 0.1, 0.1, 
        10.} -> Around[513.3333333333334, 79.65202096899016], {3.14159, 10., 
        0.01, 0.} -> 
       Around[513.3333333333334, 61.1918658356194], {0.785398, 0.01, 0.01, 
        0.01} -> Around[516.6666666666666, 161.27960537870595`], {0.785398, 
        10., 1., 10.} -> 520., {3.14159, 10., 0.01, 1.} -> 
       520., {1.5708, 0.1, 10., 0.} -> 
       Around[526.6666666666666, 59.59119994689746], {0., 10., 0., 0.01} -> 
       Around[535., 115.], {0., 0.1, 1., 0.1} -> 540., {0., 1., 0., 1.} -> 
       540., {3.14159, 10., 1., 0.01} -> 540., {0., 0.1, 0.1, 0.1} -> 
       Around[544.75, 157.95324994018537`], {0.785398, 1., 0.1, 1.} -> 
       Around[546.6666666666666, 172.85189549952233`], {0.785398, 0., 1., 
        0.1} -> Around[550., 230.], {1.5708, 1., 10., 0.} -> 
       Around[553.8, 176.4126979556744], {3.14159, 10., 0., 0.} -> 
       Around[563.3333333333334, 86.66666666666669], {1.5708, 10., 10., 0.1} -> 
       Around[564.75, 155.89279168710783`], {0.785398, 10., 1., 0.01} -> 
       Around[566.6666666666666, 116.95203195232557`], {0.785398, 0., 1., 
        0.01} -> Around[567.25, 177.71952387587208`], {0.785398, 0., 0.01, 
        0.} -> Around[569.75, 162.41427225873142`], {0., 0., 10., 0.01} -> 
       570., {3.14159, 0., 1., 0.1} -> 
       Around[570., 50.], {0.785398, 1., 0., 0.} -> 
       Around[573., 215.79851714041044`], {0.785398, 0., 1., 0.} -> 
       Around[579.6666666666666, 210.38087154280717`], {1.5708, 10., 10., 
        0.01} -> Around[579.8333333333334, 118.40056775389402`], {3.14159, 
        0.1, 1., 0.01} -> Around[580., 100.], {0.785398, 1., 0.01, 1.} -> 
       Around[583., 213.71086386361677`], {1.5708, 10., 0.1, 10.} -> 
       Around[584., 52.592775169218825`], {1.5708, 0., 10., 0.01} -> 
       Around[584.6666666666666, 136.2951861871056], {1.5708, 1., 1., 0.01} -> 
       Around[587.5, 91.1386306677909], {0., 0.01, 10., 0.1} -> 
       Around[590., 20.], {0.785398, 0., 10., 0.} -> 
       Around[590., 320.], {0.785398, 1., 0.1, 10.} -> 
       Around[594.5, 404.49999999999994`], {0.785398, 10., 1., 0.1} -> 
       Around[599.6666666666666, 215.40685019541772`], {1.5708, 0.1, 10., 
        0.01} -> Around[599.6666666666666, 217.63909983681194`], {1.5708, 
        0.01, 10., 0.} -> 
       Around[599.8333333333334, 100.96217663615971`], {1.5708, 10., 0.01, 
        0.01} -> Around[601., 142.43595051811883`], {0., 10., 0.01, 1.} -> 
       Around[603.3333333333334, 114.64922347946562`], {3.14159, 1., 1., 
        0.01} -> Around[604.5, 394.49999999999994`], {3.14159, 1., 1., 0.1} -> 
       Around[604.5, 394.49999999999994`], {1.5708, 1., 0.01, 0.} -> 
       Around[607.375, 77.06280775630817], {3.14159, 10., 0.1, 0.01} -> 
       610., {0., 0.01, 0.1, 0.1} -> 
       Around[612., 223.8909704893582], {0., 0.01, 1., 10.} -> 
       Around[613., 201.4505729287791], {0.785398, 1., 0., 0.01} -> 
       Around[615., 195.], {1.5708, 0.1, 10., 0.1} -> 
       Around[619.7142857142857, 103.03506437031967`], {3.14159, 0.01, 10., 
        0.01} -> Around[620., 340.], {3.14159, 10., 0.01, 10.} -> 
       620., {0., 0.1, 0.1, 10.} -> 
       Around[623.3333333333334, 84.12952976082643], {0., 1., 10., 0.} -> 
       Around[625., 5.], {0., 0.1, 0., 0.1} -> 
       Around[626.3333333333334, 198.79665769602647`], {1.5708, 10., 1., 
        0.01} -> Around[631.1666666666666, 167.35937712333634`], {1.5708, 10.,
         0., 10.} -> 
       Around[631.8, 146.2779545933016], {1.5708, 0.01, 1., 0.01} -> 
       Around[634., 98.26494797230598], {0., 0.01, 0.01, 0.} -> 
       Around[634.5, 364.49999999999994`], {0., 1., 0., 0.1} -> 
       Around[636.3333333333334, 187.85662381484215`], {0., 10., 1., 0.1} -> 
       Around[636.6666666666666, 166.96639715157596`], {0., 10., 0.1, 0.1} -> 
       Around[639.5, 359.5], {0.785398, 1., 0.01, 0.01} -> 
       Around[639.5, 359.5], {0.785398, 1., 0.01, 0.1} -> 
       Around[639.5, 359.5], {0., 10., 0., 0.1} -> 
       Around[639.6666666666666, 230.463542549455], {1.5708, 0., 1., 0.} -> 
       Around[639.8, 144.20138695588193`], {0.785398, 0.1, 0.1, 0.1} -> 
       640., {0.785398, 1., 1., 0.1} -> 
       Around[644.5, 354.5], {1.5708, 0.1, 1., 0.} -> 
       Around[648.4285714285714, 116.63779040113828`], {0., 10., 0.1, 0.} -> 
       Around[649.6666666666666, 174.88122953720463`], {3.14159, 1., 0., 
        0.01} -> Around[649.6666666666666, 178.6526735813875], {0.785398, 0., 
        0.01, 0.01} -> 
       Around[649.75, 171.63448322913823`], {1.5708, 1., 0., 1.} -> 
       Around[649.8571428571429, 82.30328020178047], {1.5708, 10., 1., 0.} -> 
       Around[651.8, 123.12286546373099`], {0., 10., 0.1, 0.01} -> 
       Around[653., 173.8648900727229], {0.785398, 0.1, 10., 0.} -> 
       Around[654.5, 344.5], {0.785398, 1., 0., 1.} -> 
       Around[654.5, 344.5], {0.785398, 0., 10., 0.1} -> 
       Around[659.5, 339.5], {0.785398, 0.01, 0.1, 1.} -> 
       Around[659.5, 339.5], {0., 0.1, 0.01, 0.1} -> 
       Around[659.6666666666666, 175.8411530646655], {0.785398, 10., 0.1, 1.} -> 
       Around[659.6666666666666, 198.96426256435547`], {1.5708, 1., 10., 0.1} -> 
       Around[659.6666666666666, 117.81925894257601`], {0., 1., 1., 0.} -> 
       Around[660., 200.], {1.5708, 0., 10., 0.1} -> 
       Around[664., 113.14024167251141`], {0., 1., 0.01, 0.1} -> 
       Around[664.5, 195.8658129094168], {0., 0.1, 0., 0.01} -> 
       Around[666.3333333333334, 168.81975924373046`], {0., 0.1, 0.01, 0.} -> 
       Around[673., 165.53650151351314`], {3.14159, 0., 10., 0.} -> 
       Around[674.5, 324.5], {1.5708, 1., 0.01, 0.01} -> 
       Around[675.4285714285714, 88.89208469311784], {0., 1., 0., 0.01} -> 
       Around[685., 185.], {1.5708, 10., 0., 0.1} -> 
       Around[686.3333333333334, 111.63651334178756`], {0., 0.1, 10., 10.} -> 
       Around[686.6666666666666, 113.48029687032803`], {0., 10., 1., 0.01} -> 
       Around[689.6666666666666, 168.31551060764164`], {0.785398, 1., 0., 
        10.} -> Around[696.3333333333334, 159.09151803635265`], {1.5708, 1., 
        0., 0.1} -> 
       Around[698.1428571428571, 120.68049682084164`], {0., 0.01, 10., 0.} -> 
       Around[699.5, 299.5], {0.785398, 0.1, 10., 0.1} -> 
       Around[699.5, 299.5], {3.14159, 10., 0.01, 0.01} -> 
       Around[700., 130.], {0., 0.01, 0.1, 0.} -> 
       Around[702., 182.77627490094733`], {1.5708, 1., 0.1, 0.01} -> 
       Around[703.1666666666666, 92.18474807568647], {0.785398, 0.01, 1., 
        10.} -> Around[704.5, 294.5], {0.785398, 10., 10., 0.01} -> 
       Around[705., 145.], {0.785398, 1., 10., 0.1} -> 
       Around[706.6666666666666, 136.17798810543667`], {0., 1., 10., 0.1} -> 
       Around[709.5, 289.5], {1.5708, 1., 10., 0.01} -> 
       Around[709.6666666666666, 97.02943425121632], {1.5708, 10., 0.1, 0.} -> 
       Around[711., 115.67153825338696`], {1.5708, 1., 0.1, 0.} -> 
       Around[711.5, 88.41332855778401], {0.785398, 0., 0., 10.} -> 
       Around[714.5, 284.5], {0.785398, 0.01, 10., 10.} -> 
       Around[719.6666666666666, 174.08841942466415`], {0., 1., 0.1, 1.} -> 
       Around[723., 193.52605337094369`], {3.14159, 10., 0., 0.1} -> 
       Around[724.5, 274.5], {1.5708, 10., 1., 0.1} -> 
       Around[727.25, 97.35277345818146], {0., 0.01, 0.01, 0.01} -> 
       Around[729.5, 186.0826429305001], {3.14159, 10., 10., 0.} -> 
       Around[729.5, 269.5], {0., 1., 1., 0.01} -> 
       Around[729.6666666666666, 150.1447449777862], {0.785398, 0., 0., 0.1} -> 
       Around[733., 172.4016627916719], {1.5708, 10., 0., 0.} -> 
       Around[734.75, 111.64331223439524`], {3.14159, 0.01, 1., 0.} -> 
       Around[736.3333333333334, 144.64938452839834`], {0., 0.1, 0.1, 0.} -> 
       Around[739.3333333333334, 259.6666666666667], {0., 10., 0.01, 0.01} -> 
       Around[743., 222.39379487746507`], {0., 10., 0., 0.} -> 
       Around[749.5, 249.49999999999997`], {0.785398, 10., 10., 1.} -> 
       Around[749.5, 249.49999999999997`], {1.5708, 1., 0.01, 1.} -> 
       Around[752.2857142857143, 121.14212713167285`], {1.5708, 10., 0.01, 
        0.1} -> Around[756.5714285714286, 121.59669034164052`], {0., 0.1, 0.1,
         0.01} -> Around[759.3333333333334, 239.6666666666667], {1.5708, 1., 
        0., 0.} -> Around[759.5, 109.17287514152346`], {0.785398, 0.01, 10., 
        0.1} -> Around[759.6666666666666, 123.09932755480204`], {3.14159, 0., 
        10., 1.} -> 
       Around[759.6666666666666, 119.80586147782773`], {0., 10., 1., 0.} -> 
       760., {0.785398, 0.1, 0., 0.1} -> 760., {0., 0.01, 0., 0.01} -> 
       Around[762.6666666666666, 236.33333333333337`], {0., 1., 0.01, 1.} -> 
       Around[763., 226.56639939173095`], {0.785398, 10., 0., 0.01} -> 
       Around[764.5, 234.49999999999997`], {0.785398, 0.01, 1., 1.} -> 
       Around[765., 225.], {1.5708, 1., 0., 0.01} -> 
       Around[766.8571428571429, 65.86654204180009], {1.5708, 10., 0.1, 0.1} -> 
       Around[767.8333333333334, 127.86644508149033`], {0., 0., 0.01, 0.01} -> 
       Around[769.3333333333334, 229.6666666666667], {0.785398, 10., 0.1, 
        10.} -> 
       Around[769.3333333333334, 229.6666666666667], {0.785398, 10., 1., 1.} -> 
       Around[769.5, 229.49999999999997`], {3.14159, 10., 10., 10.} -> 
       Around[769.5, 229.49999999999997`], {0., 0.1, 1., 10.} -> 
       Around[769.6666666666666, 138.64863664834374`], {1.5708, 10., 0., 
        0.01} -> Around[770.8571428571429, 114.10718198076682`], {1.5708, 1., 
        0.1, 1.} -> 
       Around[771.1428571428571, 108.44933611323472`], {0., 0., 0.1, 0.01} -> 
       Around[772., 160.04322332836634`], {0., 0.01, 0., 1.} -> 
       Around[772., 160.04322332836634`], {0.785398, 0.01, 0., 10.} -> 
       Around[774.5, 224.49999999999997`], {0.785398, 0.01, 0.01, 10.} -> 
       Around[774.5, 224.49999999999997`], {0., 1., 0., 0.} -> 
       Around[776.3333333333334, 142.8406260293074], {1.5708, 10., 0.01, 1.} -> 
       Around[777.6666666666666, 140.464863142986], {0., 0.01, 0.1, 0.01} -> 
       Around[784.25, 214.75], {3.14159, 10., 0.1, 10.} -> 
       Around[784.5, 214.49999999999997`], {0.785398, 0.1, 0.01, 0.} -> 
       Around[786.3333333333334, 140.85492931066034`], {0.785398, 0.1, 1., 
        10.} -> Around[789.5, 209.49999999999997`], {3.14159, 1., 0., 0.} -> 
       Around[789.5, 209.49999999999997`], {1.5708, 1., 0., 10.} -> 
       Around[789.7142857142857, 90.70641135677504], {0., 1., 1., 10.} -> 
       790., {0., 10., 0.01, 0.} -> 
       Around[792.6666666666666, 206.33333333333337`], {0., 10., 10., 0.01} -> 
       Around[796., 203.00000000000006`], {0., 0., 0.01, 1.} -> 
       Around[806., 193.00000000000003`], {3.14159, 1., 1., 0.} -> 
       Around[809.3333333333334, 189.66666666666669`], {3.14159, 0.1, 0., 
        0.1} -> Around[812.6666666666666, 186.33333333333337`], {1.5708, 10., 
        0.1, 0.01} -> 
       Around[813.125, 100.17189467182327`], {1.5708, 10., 0., 1.} -> 
       Around[816.5714285714286, 108.54905784567488`], {0., 1., 0.01, 0.} -> 
       Around[816.75, 182.24999999999997`], {1.5708, 10., 0.01, 0.} -> 
       Around[819.3333333333334, 116.52772679114236`], {0., 10., 10., 1.} -> 
       Around[819.5, 179.5], {0.785398, 0.1, 0., 1.} -> 
       Around[819.5, 179.5], {0.785398, 1., 10., 10.} -> 
       Around[819.5, 179.5], {3.14159, 1., 10., 1.} -> 
       Around[819.5, 179.5], {1.5708, 1., 0.01, 0.1} -> 
       Around[820.8571428571429, 86.69306243771719], {0.785398, 10., 0.1, 
        0.01} -> Around[824.5, 174.5], {0.785398, 0., 0.01, 1.} -> 
       Around[829.3333333333334, 169.6666666666667], {3.14159, 0.1, 10., 10.} -> 
       830., {0., 0.1, 0.01, 1.} -> 
       Around[834.25, 164.75], {1.5708, 0., 1., 0.1} -> 
       Around[834.75, 98.22200619005906], {0.785398, 0.1, 0.1, 10.} -> 
       Around[836., 163.00000000000003`], {0., 10., 1., 1.} -> 
       Around[839.3333333333334, 159.66666666666669`], {0.785398, 0.01, 0.01, 
        1.} -> Around[839.3333333333334, 159.66666666666669`], {1.5708, 0.01, 
        1., 1.} -> Around[839.5714285714286, 74.45703687453626], {1.5708, 10.,
         10., 10.} -> Around[841.75, 157.25], {0., 10., 10., 0.1} -> 
       Around[842.25, 117.24644628587541`], {0.785398, 0., 1., 1.} -> 
       Around[843., 132.25858510256842`], {0., 0.01, 0.01, 1.} -> 
       Around[844.5, 89.20061658979718], {0.785398, 0.01, 10., 0.01} -> 
       Around[844.5, 154.5], {1.5708, 0., 10., 10.} -> 
       Around[845.6, 70.32254261614834], {0., 0.01, 0., 0.1} -> 
       Around[846., 153.00000000000003`], {0., 0.01, 0.01, 0.1} -> 
       Around[846., 153.00000000000003`], {0., 0.1, 0.01, 10.} -> 
       Around[846., 153.00000000000003`], {0., 0.1, 10., 0.} -> 
       Around[846., 153.00000000000003`], {0., 10., 0.01, 10.} -> 
       Around[846., 153.00000000000003`], {3.14159, 0.1, 0.1, 0.1} -> 
       Around[846., 153.00000000000003`], {0., 1., 0.01, 0.01} -> 
       Around[849.25, 149.75], {0., 0.1, 0., 0.} -> 
       Around[849.3333333333334, 149.66666666666669`], {0., 10., 10., 0.} -> 
       Around[849.5, 124.5662474348489], {1.5708, 0.1, 1., 1.} -> 
       Around[854.25, 97.43693015044579], {0.785398, 10., 0.1, 0.1} -> 
       Around[854.5, 144.5], {0., 0., 0.01, 0.1} -> 
       Around[855., 45.], {0.785398, 0.01, 0.1, 10.} -> 
       Around[856., 143.], {0.785398, 0.1, 1., 1.} -> 
       Around[856., 143.], {0.785398, 0., 0.1, 1.} -> 
       Around[869.25, 129.75], {1.5708, 0., 1., 0.01} -> 
       Around[869.3333333333334, 129.66666666666669`], {1.5708, 0., 1., 1.} -> 
       Around[873.8571428571429, 57.408074996727876`], {1.5708, 0., 10., 1.} -> 
       Around[874.3333333333334, 83.37692193353695], {3.14159, 1., 10., 10.} -> 
       Around[874.5, 124.49999999999999`], {0., 0.01, 0., 10.} -> 
       Around[877., 94.68632425012599], {0., 0.1, 0., 1.} -> 
       Around[879.3333333333334, 119.66666666666667`], {1.5708, 10., 0.01, 
        10.} -> Around[881.4, 72.17104682627237], {0., 0.01, 1., 1.} -> 
       Around[881.75, 117.25], {0., 10., 0., 10.} -> 
       Around[884.5, 114.49999999999999`], {3.14159, 10., 1., 1.} -> 
       Around[884.5, 114.49999999999999`], {3.14159, 0.1, 0.01, 1.} -> 
       Around[889.5, 109.49999999999999`], {3.14159, 0., 1., 0.01} -> 
       890., {0., 0., 10., 10.} -> 
       Around[892.6666666666666, 106.33333333333334`], {0.785398, 0., 0., 1.} -> 
       Around[896., 103.00000000000001`], {1.5708, 1., 10., 10.} -> 
       Around[905., 65.25225776061042], {1.5708, 0.01, 1., 10.} -> 
       Around[906.75, 61.12655198146594], {1.5708, 1., 1., 1.} -> 
       Around[909.1666666666666, 89.83333333333336], {1.5708, 1., 0.1, 0.1} -> 
       Around[909.2, 89.8], {0., 0.1, 1., 1.} -> 
       Around[909.3333333333334, 89.66666666666669], {0.785398, 0.01, 0., 
        0.1} -> Around[909.3333333333334, 89.66666666666669], {1.5708, 0., 1.,
         10.} -> Around[913.4, 55.22915896516984], {0., 1., 0.1, 10.} -> 
       Around[914.5, 84.49999999999999], {0.785398, 10., 10., 0.} -> 
       Around[914.5, 84.49999999999999], {3.14159, 1., 10., 0.01} -> 
       Around[914.5, 84.49999999999999], {0.785398, 0.01, 0., 1.} -> 
       Around[916., 83.00000000000001], {3.14159, 0.1, 0.01, 0.} -> 
       Around[916., 83.00000000000001], {1.5708, 0.01, 10., 1.} -> 
       Around[918.3333333333334, 39.384147967311804`], {1.5708, 0.1, 1., 10.} -> 
       Around[925.2, 73.8], {0., 0.01, 0.01, 10.} -> 
       Around[926., 73.], {0.785398, 0.01, 10., 1.} -> 
       Around[926., 73.], {0.785398, 0.1, 0., 10.} -> 
       Around[926., 73.], {1.5708, 1., 0.1, 10.} -> 
       Around[929.2, 69.8], {1.5708, 1., 10., 1.} -> 
       Around[935., 48.33661729402018], {1.5708, 1., 0.01, 10.} -> 
       Around[935.5, 42.093433488575656`], {1.5708, 10., 1., 10.} -> 
       Around[937.7142857142857, 61.28571428571427], {0., 0., 0.01, 10.} -> 
       Around[939.25, 59.75], {1.5708, 1., 1., 10.} -> 
       Around[941.1666666666666, 35.559730657647634`], {0.785398, 10., 0.01, 
        1.} -> Around[942.6666666666666, 56.33333333333334], {3.14159, 0.01, 
        1., 1.} -> Around[942.6666666666666, 56.33333333333334], {3.14159, 
        0.1, 0.1, 0.} -> 
       Around[942.6666666666666, 56.33333333333334], {1.5708, 0.1, 10., 10.} -> 
       Around[945.2, 53.8], {1.5708, 10., 0.1, 1.} -> 
       Around[954.1666666666666, 44.833333333333336`], {0.785398, 0.1, 0.01, 
        1.} -> Around[959.3333333333334, 39.66666666666668], {3.14159, 1., 
        0.1, 0.01} -> 
       Around[959.3333333333334, 39.66666666666668], {0., 0.1, 10., 1.} -> 
       Around[961.75, 37.25], {0.785398, 0.1, 0.01, 0.01} -> 
       Around[962.6666666666666, 36.333333333333336`], {0.785398, 10., 0.01, 
        0.1} -> Around[962.6666666666666, 36.333333333333336`], {3.14159, 
        0.01, 0.01, 10.} -> Around[964.5, 34.5], {3.14159, 1., 0., 0.1} -> 
       Around[966., 33.00000000000001], {1.5708, 10., 1., 1.} -> 
       Around[974.1666666666666, 24.833333333333336`], {1.5708, 0.01, 10., 
        10.} -> Around[979.2, 19.8], {0., 0., 0.1, 0.1} -> 
       Around[979.3333333333334, 19.666666666666668`], {0., 10., 0., 1.} -> 
       990., {0.785398, 0.01, 0.01, 0.} -> 
       Around[992.6666666666666, 6.333333333333335], {3.14159, 0.1, 0., 0.} -> 
       Around[996., 3.0000000000000004`], {0., 0., 0.1, 1.} -> 
       999., {0., 0., 0.1, 10.} -> 999., {0., 0., 1., 10.} -> 
       999., {0., 0., 10., 1.} -> 999., {0., 0.01, 0., 0.} -> 
       999., {0., 0.01, 0.1, 1.} -> 999., {0., 0.01, 0.1, 10.} -> 
       999., {0., 0.01, 10., 1.} -> 999., {0., 0.01, 10., 10.} -> 
       999., {0., 0.1, 0., 10.} -> 999., {0., 0.1, 0.1, 1.} -> 
       999., {0., 1., 0., 10.} -> 999., {0., 1., 0.01, 10.} -> 
       999., {0., 1., 1., 1.} -> 999., {0., 1., 10., 1.} -> 
       999., {0., 1., 10., 10.} -> 999., {0., 10., 1., 10.} -> 
       999., {0., 10., 10., 10.} -> 999., {0.785398, 0., 0., 0.} -> 
       999., {0.785398, 0., 0., 0.01} -> 999., {0.785398, 0., 0.01, 10.} -> 
       999., {0.785398, 0., 0.1, 10.} -> 999., {0.785398, 0., 1., 10.} -> 
       999., {0.785398, 0., 10., 1.} -> 999., {0.785398, 0., 10., 10.} -> 
       999., {0.785398, 0.01, 0., 0.} -> 999., {0.785398, 0.01, 0., 0.01} -> 
       999., {0.785398, 0.1, 0., 0.01} -> 999., {0.785398, 0.1, 0.01, 10.} -> 
       999., {0.785398, 0.1, 0.1, 1.} -> 999., {0.785398, 0.1, 10., 1.} -> 
       999., {0.785398, 0.1, 10., 10.} -> 999., {0.785398, 1., 0.01, 10.} -> 
       999., {0.785398, 1., 1., 0.01} -> 999., {0.785398, 1., 1., 1.} -> 
       999., {0.785398, 1., 10., 1.} -> 999., {0.785398, 10., 0.01, 0.} -> 
       999., {0.785398, 10., 0.01, 0.01} -> 999., {0.785398, 10., 0.01, 10.} -> 
       999., {0.785398, 10., 0.1, 0.} -> 999., {0.785398, 10., 10., 0.1} -> 
       999., {0.785398, 10., 10., 10.} -> 999., {1.5708, 0.1, 10., 1.} -> 
       999., {1.5708, 10., 10., 1.} -> 999., {3.14159, 0., 0.01, 0.} -> 
       999., {3.14159, 0., 0.01, 0.01} -> 999., {3.14159, 0., 0.01, 0.1} -> 
       999., {3.14159, 0., 0.01, 1.} -> 999., {3.14159, 0., 0.01, 10.} -> 
       999., {3.14159, 0., 0.1, 0.} -> 999., {3.14159, 0., 0.1, 0.01} -> 
       999., {3.14159, 0., 0.1, 0.1} -> 999., {3.14159, 0., 0.1, 1.} -> 
       999., {3.14159, 0., 0.1, 10.} -> 999., {3.14159, 0., 1., 1.} -> 
       999., {3.14159, 0., 1., 10.} -> 999., {3.14159, 0., 10., 10.} -> 
       999., {3.14159, 0.01, 0., 0.} -> 999., {3.14159, 0.01, 0., 0.01} -> 
       999., {3.14159, 0.01, 0., 0.1} -> 999., {3.14159, 0.01, 0., 1.} -> 
       999., {3.14159, 0.01, 0., 10.} -> 999., {3.14159, 0.01, 0.01, 0.01} -> 
       999., {3.14159, 0.01, 0.01, 0.1} -> 999., {3.14159, 0.01, 0.01, 1.} -> 
       999., {3.14159, 0.01, 0.1, 0.} -> 999., {3.14159, 0.01, 0.1, 0.01} -> 
       999., {3.14159, 0.01, 0.1, 0.1} -> 999., {3.14159, 0.01, 0.1, 1.} -> 
       999., {3.14159, 0.01, 0.1, 10.} -> 999., {3.14159, 0.01, 1., 10.} -> 
       999., {3.14159, 0.01, 10., 1.} -> 999., {3.14159, 0.01, 10., 10.} -> 
       999., {3.14159, 0.1, 0., 0.01} -> 999., {3.14159, 0.1, 0., 1.} -> 
       999., {3.14159, 0.1, 0., 10.} -> 999., {3.14159, 0.1, 0.01, 0.01} -> 
       999., {3.14159, 0.1, 0.01, 0.1} -> 999., {3.14159, 0.1, 0.01, 10.} -> 
       999., {3.14159, 0.1, 0.1, 0.01} -> 999., {3.14159, 0.1, 0.1, 1.} -> 
       999., {3.14159, 0.1, 0.1, 10.} -> 999., {3.14159, 0.1, 1., 0.} -> 
       999., {3.14159, 0.1, 1., 1.} -> 999., {3.14159, 0.1, 1., 10.} -> 
       999., {3.14159, 0.1, 10., 1.} -> 999., {3.14159, 1., 0., 10.} -> 
       999., {3.14159, 1., 0.01, 0.} -> 999., {3.14159, 1., 0.01, 0.01} -> 
       999., {3.14159, 1., 0.01, 0.1} -> 999., {3.14159, 1., 0.01, 1.} -> 
       999., {3.14159, 1., 0.01, 10.} -> 999., {3.14159, 1., 0.1, 0.} -> 
       999., {3.14159, 1., 0.1, 0.1} -> 999., {3.14159, 1., 0.1, 1.} -> 
       999., {3.14159, 1., 0.1, 10.} -> 999., {3.14159, 1., 1., 1.} -> 
       999., {3.14159, 1., 1., 10.} -> 999., {3.14159, 10., 0., 0.01} -> 
       999., {3.14159, 10., 0., 1.} -> 999., {3.14159, 10., 0., 10.} -> 
       999., {3.14159, 10., 0.1, 0.} -> 999., {3.14159, 10., 0.1, 1.} -> 
       999., {3.14159, 10., 1., 0.} -> 999., {3.14159, 10., 1., 10.} -> 
       999., {3.14159, 10., 10., 0.01} -> 999., {3.14159, 10., 10., 1.} -> 
       999.], "InitialShape" -> TypeSystem`PackageScope`Limited[
       TypeSystem`PackageScope`ColumnShape[
        TypeSystem`PackageScope`KeyValueShape[
         TypeSystem`PackageScope`UnknownShape[True], 
         TypeSystem`PackageScope`UnknownShape[False]]], 20, 
       DirectedInfinity[1], {}], "InitialType" -> TypeSystem`Assoc[
       TypeSystem`Vector[
        TypeSystem`Atom[Real], 4], TypeSystem`AnyType, 477], "Meta" -> 
     Association["ID" -> 136614521092374], "RowTarget" -> 20, "ColumnTarget" -> 
     10, "Shape" -> TypeSystem`PackageScope`Limited[
       TypeSystem`PackageScope`ColumnShape[
        TypeSystem`PackageScope`KeyValueShape[
         TypeSystem`PackageScope`UnknownShape[True], 
         TypeSystem`PackageScope`UnknownShape[False]]], 20, 
       DirectedInfinity[1], {}], "Type" -> TypeSystem`Assoc[
       TypeSystem`Vector[
        TypeSystem`Atom[Real], 4], TypeSystem`AnyType, 477], "Path" -> {}, 
     "BaseIndices" -> {}, "DisplayedRowCount" -> 20, "DisplayedColumnCount" -> 
     1, "DataRowCount" -> 477, "DataColumnCount" -> 1, "SortPaths" -> {}, 
     "SortDirections" -> {}, "HiddenItemsMap" -> Null, "UpdateType" -> 1], 
    TypeSystem`NestedGrid`PackagePrivate`$outputID$$, 
    TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
    TypeSystem`NestedGrid`PackagePrivate`$vPos$$ = 1, 
    TypeSystem`NestedGrid`PackagePrivate`$hPos$$ = 1, 
    TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
    DynamicModule[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
        Style[
         Grid[{{
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  Style[{1.5708, 0., 0., 10.}, ShowStringCharacters -> False], 
                  Style[
                   
                   Style[{1.5708, 0., 0., 10.}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0., 0., 10.}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0., 0., 10.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"169.", "11."}, "Around"], 
                  Around[168.57142857142858`, 11.428571428571427`]], 
                 FontFamily -> "Source Code Pro", ShowStringCharacters -> 
                 True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0., 0., 10.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  Style[{1.5708, 0., 0., 0.}, ShowStringCharacters -> False], 
                  Style[
                   Style[{1.5708, 0., 0., 0.}, ShowStringCharacters -> False],
                    FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0., 0., 0.}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0., 0., 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"184.4", "2.9"}, "Around"], 
                  Around[184.44444444444446`, 2.939723678960656]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0., 0., 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{1.5708, 0.1, 0., 0.01}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{1.5708, 0.1, 0., 0.01}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0.1, 0., 0.01}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.1, 0., 0.01}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"187.", "20."}, "Around"], 
                  Around[187.14285714285714`, 20.203050891044214`]], 
                 FontFamily -> "Source Code Pro", ShowStringCharacters -> 
                 True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.1, 0., 0.01}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{0.785398, 1., 0.01, 0.}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{0.785398, 1., 0.01, 0.}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{0.785398, 1., 0.01, 0.}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{0.785398, 1., 0.01, 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"195.", "35."}, "Around"], 
                  Around[195., 35.]], FontFamily -> "Source Code Pro", 
                 ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{0.785398, 1., 0.01, 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{0.785398, 0., 0.1, 0.}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{0.785398, 0., 0.1, 0.}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{0.785398, 0., 0.1, 0.}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{0.785398, 0., 0.1, 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["200.0"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{0.785398, 0., 0.1, 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  Style[{1.5708, 0.1, 0., 0.}, ShowStringCharacters -> False], 
                  Style[
                   
                   Style[{1.5708, 0.1, 0., 0.}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0.1, 0., 0.}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.1, 0., 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"200.", "11."}, "Around"], 
                  Around[200., 11.126972805283735`]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.1, 0., 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{0.785398, 0.1, 0.1, 0.}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{0.785398, 0.1, 0.1, 0.}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{0.785398, 0.1, 0.1, 0.}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{0.785398, 0.1, 0.1, 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["210.0"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{0.785398, 0.1, 0.1, 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{1.5708, 0.1, 0.01, 0.1}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{1.5708, 0.1, 0.01, 0.1}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0.1, 0.01, 0.1}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.1, 0.01, 0.1}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"210.", "33."}, "Around"], 
                  Around[210., 32.80534218980921]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.1, 0.01, 0.1}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  Style[{1.5708, 0., 0., 0.1}, ShowStringCharacters -> False], 
                  Style[
                   
                   Style[{1.5708, 0., 0., 0.1}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0., 0., 0.1}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0., 0., 0.1}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"211.", "18."}, "Around"], 
                  Around[211.25, 17.872314983156006`]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0., 0., 0.1}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{1.5708, 0.01, 0.01, 1.}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{1.5708, 0.01, 0.01, 1.}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0.01, 0.01, 1.}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.01, 0.01, 1.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"215.", "26."}, "Around"], 
                  Around[215., 26.425997300638123`]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.01, 0.01, 1.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{1.5708, 0., 0.01, 0.}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{1.5708, 0., 0.01, 0.}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0., 0.01, 0.}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0., 0.01, 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"217.", "27."}, "Around"], 
                  Around[216.66666666666666`, 27.28450923957483]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0., 0.01, 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  Style[{0., 0.01, 1., 0.}, ShowStringCharacters -> False], 
                  Style[
                   Style[{0., 0.01, 1., 0.}, ShowStringCharacters -> False], 
                   FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{0., 0.01, 1., 0.}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{0., 0.01, 1., 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"220.", "70."}, "Around"], 
                  Around[220., 70.]], FontFamily -> "Source Code Pro", 
                 ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{0., 0.01, 1., 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{1.5708, 0.01, 0.01, 0.01}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{1.5708, 0.01, 0.01, 0.01}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0.01, 0.01, 0.01}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.01, 0.01, 0.01}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"220.", "21."}, "Around"], 
                  Around[220., 20.97617696340303]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.01, 0.01, 0.01}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{1.5708, 0.01, 0., 0.01}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{1.5708, 0.01, 0., 0.01}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0.01, 0., 0.01}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.01, 0., 0.01}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"223.", "25."}, "Around"], 
                  Around[222.5, 25.19566289208181]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.01, 0., 0.01}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{1.5708, 0.1, 0.1, 0.1}, ShowStringCharacters -> 
                   False], 
                  Style[
                   Style[{1.5708, 0.1, 0.1, 0.1}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0.1, 0.1, 0.1}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.1, 0.1, 0.1}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"223.", "20."}, "Around"], 
                  Around[223.33333333333334`, 19.776529298921773`]], 
                 FontFamily -> "Source Code Pro", ShowStringCharacters -> 
                 True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.1, 0.1, 0.1}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  Style[{1.5708, 1., 1., 0.}, ShowStringCharacters -> False], 
                  Style[
                   Style[{1.5708, 1., 1., 0.}, ShowStringCharacters -> False],
                    FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 1., 1., 0.}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 1., 1., 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"232.", "62."}, "Around"], 
                  Around[232., 62.161081071680215`]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 1., 1., 0.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{1.5708, 0.1, 0., 0.1}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{1.5708, 0.1, 0., 0.1}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0.1, 0., 0.1}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.1, 0., 0.1}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"236.", "54."}, "Around"], 
                  Around[236., 53.53503525729669]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.1, 0., 0.1}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{1.5708, 0.01, 0., 1.}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{1.5708, 0.01, 0., 1.}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0.01, 0., 1.}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.01, 0., 1.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"239.", "33."}, "Around"], 
                  Around[238.57142857142858`, 32.90886198699237]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0.01, 0., 1.}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{0.785398, 0., 0.1, 0.1}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{0.785398, 0., 0.1, 0.1}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{0.785398, 0., 0.1, 0.1}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{0.785398, 0., 0.1, 0.1}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"240.", "38."}, "Around"], 
                  Around[240., 37.859388972001824`]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{0.785398, 0., 0.1, 0.1}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation[
               EventHandler[
                MouseAppearance[
                 Mouseover[
                  
                  Style[{1.5708, 0., 0.01, 0.01}, ShowStringCharacters -> 
                   False], 
                  Style[
                   
                   Style[{1.5708, 0., 0.01, 0.01}, ShowStringCharacters -> 
                    False], FontColor -> 
                   RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                TypeSystem`NestedGrid`PackagePrivate`updateState[
                 TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                  TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`localHold[
                   TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                   Key[{1.5708, 0., 0.01, 0.01}]}, 4]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0., 0.01, 0.01}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Annotation[
               RawBoxes[
                StyleBox[
                 InterpretationBox[
                  TemplateBox[{"240.", "41."}, "Around"], 
                  Around[240., 40.93355048802334]], FontFamily -> 
                 "Source Code Pro", ShowStringCharacters -> True]], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                 Key[{1.5708, 0., 0.01, 0.01}]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Deploy[
              Pane[
               Row[{
                 Spacer[2], 
                 Style[
                  Row[{
                    Button[
                    MouseAppearance[
                    Mouseover[
                    Graphics[{{
                    EdgeForm[None], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.5372549019607843, 0.5372549019607843, 
                    0.5372549019607843], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}], 
                    Line[{{0, 5}, {8, 5}}]}, {5, 6.5}], 0, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]], 
                    Graphics[{{
                    EdgeForm[
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549]], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}], 
                    Line[{{0, 5}, {8, 5}}]}, {5, 6.5}], 0, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]]], "LinkHand"], 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$ = 
                    Clip[TypeSystem`NestedGrid`PackagePrivate`$vPos$$ - 20 
                    If[True, 477, 1], {1, 477 - -20 + 1}], Appearance -> 
                    None], 
                    Button[
                    MouseAppearance[
                    Mouseover[
                    Graphics[{{
                    EdgeForm[None], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.5372549019607843, 0.5372549019607843, 
                    0.5372549019607843], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}]}, {5, 6.5}], 0, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]], 
                    Graphics[{{
                    EdgeForm[
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549]], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}]}, {5, 6.5}], 0, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]]], "LinkHand"], 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$ = 
                    Clip[TypeSystem`NestedGrid`PackagePrivate`$vPos$$ - 20 
                    If[False, 477, 1], {1, 477 - -20 + 1}], Appearance -> 
                    None], " ", 
                    Style[
                    Mouseover[
                    Row[{"rows ", 1, "\[Dash]", 20, " of ", 
                    Style[
                    477, FontColor -> GrayLevel[0], FontWeight -> "Medium"]}, 
                    BaseStyle -> {
                    FontSize -> 8., FontColor -> 
                    RGBColor[
                    0.5098039215686274, 0.5098039215686274, 
                    0.5098039215686274]}], 
                    Row[{"rows ", 1, "\[Dash]", 20, " of ", 
                    Style[
                    477, FontColor -> GrayLevel[0], FontWeight -> "Medium"]}, 
                    BaseStyle -> {
                    FontSize -> 8., FontColor -> 
                    RGBColor[
                    0.5098039215686274, 0.5098039215686274, 
                    0.5098039215686274]}]], ContextMenu -> {
                    MenuItem["Hide", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]}, 
                    "Rows", 1, {}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show up to 10 Rows", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]}, 
                    "Rows", 10, {}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show up to 30 Rows", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]}, 
                    "Rows", 30, {}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show up to 100 Rows", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]}, 
                    "Rows", 100, {}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show All", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]}, 
                    "Rows", 100000000, {}]], MenuEvaluator -> Automatic]}], 
                    " ", 
                    Button[
                    MouseAppearance[
                    Mouseover[
                    Graphics[{{
                    EdgeForm[None], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.5372549019607843, 0.5372549019607843, 
                    0.5372549019607843], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}]}, {5, 6.5}], 180 Degree, {
                    9, 9}]}, ImageSize -> (1 -> 1), 
                    ImagePadding -> {{0, 1}, {1, 0}}, BaselinePosition -> 
                    Scaled[0.35]], 
                    Graphics[{{
                    EdgeForm[
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549]], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}]}, {5, 6.5}], 180 Degree, {
                    9, 9}]}, ImageSize -> (1 -> 1), 
                    ImagePadding -> {{0, 1}, {1, 0}}, BaselinePosition -> 
                    Scaled[0.35]]], "LinkHand"], 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$ = 
                    Clip[TypeSystem`NestedGrid`PackagePrivate`$vPos$$ + 
                    20 If[False, 477, 1], {1, 477 - 20 + 1}], Appearance -> 
                    None], 
                    Button[
                    MouseAppearance[
                    Mouseover[
                    Graphics[{{
                    EdgeForm[None], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.5372549019607843, 0.5372549019607843, 
                    0.5372549019607843], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}], 
                    Line[{{0, 5}, {8, 5}}]}, {5, 6.5}], 180 Degree, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]], 
                    Graphics[{{
                    EdgeForm[
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549]], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}], 
                    Line[{{0, 5}, {8, 5}}]}, {5, 6.5}], 180 Degree, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]]], "LinkHand"], 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$ = 
                    Clip[TypeSystem`NestedGrid`PackagePrivate`$vPos$$ + 
                    20 If[True, 477, 1], {1, 477 - 20 + 1}], Appearance -> 
                    None]}], ContextMenu -> {}], 
                 Graphics[{
                   RGBColor[
                   0.8196078431372549, 0.8196078431372549, 
                    0.8196078431372549], 
                   Line[{{0, 0}, {0, 19}}]}, ImageSize -> (1 -> 1), 
                  ImagePadding -> {{0, 0}, {0, 0}}, BaselinePosition -> 
                  Scaled[0.35]]}], ImageMargins -> {{0, -1}, {-1, 1}}]], 
             Background -> 
             RGBColor[
              0.9764705882352941, 0.9764705882352941, 0.9764705882352941], 
             Alignment -> {Left, Top}], SpanFromLeft}}, 
          BaseStyle -> {
           ContextMenu -> 
            Dynamic[TypeSystem`NestedGrid`PackagePrivate`$contextMenuTrigger; 
              Which[TypeSystem`NestedGrid`PackagePrivate`$lastOutputID =!= 
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                 TypeSystem`NestedGrid`PackagePrivate`$outputID$$], {}, 
                TypeSystem`NestedGrid`PackagePrivate`$contextMenuTrigger === 
                TypeSystem`NestedGrid`PackagePrivate`$lastContextMenuTrigger, 
                TypeSystem`NestedGrid`PackagePrivate`$lastContextMenu, True, 
                TypeSystem`NestedGrid`PackagePrivate`$lastContextMenuTrigger = 
                 TypeSystem`NestedGrid`PackagePrivate`$contextMenuTrigger; 
                TypeSystem`NestedGrid`PackagePrivate`$lastContextMenu = 
                 Block[{TypeSystem`NestedGrid`PackagePrivate`$globalScrollPos = \
{TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$}}, 
                   
                   With[{TypeSystem`NestedGrid`PackagePrivate`lastPath$ = 
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, 
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ = 
                    TypeSystem`NestedGrid`PackagePrivate`$lastPathType, 
                    TypeSystem`NestedGrid`PackagePrivate`isLeafHeader$ = 
                    TypeSystem`NestedGrid`PackagePrivate`$\
lastPathIsLeafHeader, TypeSystem`NestedGrid`PackagePrivate`allHidden$ = 
                    TypeSystem`NestedGrid`PackagePrivate`allHiddenQ[
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, 
                    TypeSystem`NestedGrid`PackagePrivate`$state$$], 
                    TypeSystem`NestedGrid`PackagePrivate`anyHidden$ = 
                    TypeSystem`NestedGrid`PackagePrivate`anyHiddenQ[
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, 
                    TypeSystem`NestedGrid`PackagePrivate`$state$$], 
                    TypeSystem`NestedGrid`PackagePrivate`sortDirection$ = 
                    TypeSystem`NestedGrid`PackagePrivate`columnSortDirection[
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, 
                    TypeSystem`NestedGrid`PackagePrivate`$state$$[
                    "SortPaths"], 
                    TypeSystem`NestedGrid`PackagePrivate`$state$$[
                    "SortDirections"]], 
                    TypeSystem`NestedGrid`PackagePrivate`haveData$ = Not[
                    FailureQ[
                    TypeSystem`NestedGrid`PackagePrivate`datasetInitialData[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$]]], 
                    TypeSystem`NestedGrid`PackagePrivate`isKeyDummy$ = Not[
                    FreeQ[
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, Keys]]}, 
                    Join[{
                    If[
                    Or[
                    Not[TypeSystem`NestedGrid`PackagePrivate`haveData$], 
                    Not[TypeSystem`NestedGrid`PackagePrivate`anyHidden$], 
                    TypeSystem`NestedGrid`PackagePrivate`isKeyDummy$], 
                    Nothing, 
                    MenuItem[
                    StringJoin["Show ", 
                    Which[
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "Item", "", 
                    TypeSystem`NestedGrid`PackagePrivate`allHidden$, 
                    ToString[
                    ReplaceAll[
                    Last[TypeSystem`NestedGrid`PackagePrivate`lastPath$], Key[
                    Pattern[TypeSystem`NestedGrid`PackagePrivate`x, 
                    Blank[]]] :> TypeSystem`NestedGrid`PackagePrivate`x]], 
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "RowHeader", "Row", 
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "ColumnHeader", "Column", True, ""]], 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`updateHiddenItems[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][
                    TypeSystem`NestedGrid`PackagePrivate`lastPath$, 
                    "remove"]], MenuEvaluator -> Automatic]], 
                    If[
                    Or[
                    Not[TypeSystem`NestedGrid`PackagePrivate`haveData$], 
                    TypeSystem`NestedGrid`PackagePrivate`pathEmptyQ[
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, 
                    TypeSystem`NestedGrid`PackagePrivate`$state$$], 
                    TypeSystem`NestedGrid`PackagePrivate`allHidden$, 
                    TypeSystem`NestedGrid`PackagePrivate`isKeyDummy$], 
                    Nothing, 
                    MenuItem[
                    StringJoin["Hide ", 
                    Which[
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "Item", "", 
                    TypeSystem`NestedGrid`PackagePrivate`allHidden$, 
                    ToString[
                    ReplaceAll[
                    Last[TypeSystem`NestedGrid`PackagePrivate`lastPath$], Key[
                    Pattern[TypeSystem`NestedGrid`PackagePrivate`x, 
                    Blank[]]] :> TypeSystem`NestedGrid`PackagePrivate`x]], 
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "RowHeader", "Row", 
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "ColumnHeader", "Column", True, ""]], 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`updateHiddenItems[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][
                    TypeSystem`NestedGrid`PackagePrivate`lastPath$, "add"]], 
                    MenuEvaluator -> Automatic]], Delimiter}, 
                    If[
                    And[TypeSystem`NestedGrid`PackagePrivate`haveData$, 
                    MatchQ[TypeSystem`NestedGrid`PackagePrivate`lastPathType$, 
                    Alternatives["ColumnHeader", "KeyDummy"]], 
                    TypeSystem`NestedGrid`PackagePrivate`isLeafHeader$, 
                    Not[TypeSystem`NestedGrid`PackagePrivate`allHidden$]], {
                    If[TypeSystem`NestedGrid`PackagePrivate`sortDirection$ =!= 
                    "Ascending", 
                    MenuItem["Sort", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`updateSort[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][
                    TypeSystem`NestedGrid`PackagePrivate`lastPath$, 
                    "Ascending"]], MenuEvaluator -> Automatic], Nothing], 
                    If[
                    TypeSystem`NestedGrid`PackagePrivate`sortDirection$ =!= 
                    "Descending", 
                    MenuItem["Reverse Sort", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`updateSort[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][
                    TypeSystem`NestedGrid`PackagePrivate`lastPath$, 
                    "Descending"]], MenuEvaluator -> Automatic], Nothing], 
                    If[
                    TypeSystem`NestedGrid`PackagePrivate`sortDirection$ =!= 
                    None, 
                    MenuItem["Unsort", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`updateSort[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][
                    TypeSystem`NestedGrid`PackagePrivate`lastPath$, None]], 
                    MenuEvaluator -> Automatic], Nothing], Delimiter}, {}], {
                    MenuItem["Copy Position to Clipboard", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                    MenuEvaluator -> Automatic], 
                    MenuItem["Copy Data to Clipboard", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                    MenuEvaluator -> Automatic], Delimiter, 
                    MenuItem["Paste Position in New Cell", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                    MenuEvaluator -> Automatic], 
                    MenuItem["Paste Data in New Cell", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                    MenuEvaluator -> Automatic]}]]]]], FontFamily -> 
            "Verdana", FontSize -> 12}, Spacings -> {0, 0}, Alignment -> Left,
           Dividers -> All, FrameStyle -> GrayLevel[0.7490196078431373], 
          BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
         LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False, 
         ShowAutoStyles -> False]], 
      TypeSystem`NestedGrid`PackagePrivate`initialQ = True}, 
     Dynamic[
      TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
      TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
         Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
         Module[{
          TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
           TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
           TypeSystem`NestedGrid`PackagePrivate`datasetData[
            TypeSystem`NestedGrid`PackagePrivate`$state$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = If[
             FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpData$], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
             TypeSystem`NestedGrid`PackagePrivate`renderGrid[
             TypeSystem`NestedGrid`PackagePrivate`$state$$, 
              TypeSystem`NestedGrid`PackagePrivate`$path$$, 
              TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
              TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
              TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
              TypeSystem`NestedGrid`PackagePrivate`localHold[
              TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][
             TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
            Not[
             FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
            TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
            TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
       TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
       TypeSystem`NestedGrid`PackagePrivate`$vPos$$; 
       TypeSystem`NestedGrid`PackagePrivate`$hPos$$; If[
         FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
         TypeSystem`SparseGrid[
          TypeSystem`H["(data no longer present)"]], 
         If[GeneralUtilities`$DebugMode, 
          Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
            TypeSystem`NestedGrid`PackagePrivate`formatState[
            TypeSystem`NestedGrid`PackagePrivate`$state$$, 
             TypeSystem`NestedGrid`PackagePrivate`$path$$, 
             TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
             TypeSystem`NestedGrid`PackagePrivate`$hPos$$]}], 
          TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
        TypeSystem`NestedGrid`PackagePrivate`$hPos$$}], 
     DynamicModuleValues :> {}], 
    TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
     TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
      TypeSystem`PackageScope`SubViewPathbar[
      TypeSystem`NestedGrid`PackagePrivate`$path$$, 
       TypeSystem`NestedGrid`PackagePrivate`updateState[
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$path$$, 
        TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
        TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
        TypeSystem`NestedGrid`PackagePrivate`localHold[
        TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]]], 
     TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
    TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Style[
     Framed[
      Dynamic[
       Replace[
       TypeSystem`NestedGrid`PackagePrivate`mouseAnnotation$$, {
        TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
           TypeSystem`NestedGrid`PackagePrivate`localHold[
           TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][Null, 
           Blank[]] -> "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
           TypeSystem`NestedGrid`PackagePrivate`localHold[
           TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][
           Pattern[TypeSystem`NestedGrid`PackagePrivate`path$, 
            Blank[]], 
           Pattern[TypeSystem`NestedGrid`PackagePrivate`pathType$, 
            Blank[]], 
           Pattern[TypeSystem`NestedGrid`PackagePrivate`isLeafHeader$, 
            Blank[]]] :> (
          Increment[TypeSystem`NestedGrid`PackagePrivate`$contextMenuTrigger]; 
          TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
           TypeSystem`NestedGrid`PackagePrivate`path$; 
          TypeSystem`NestedGrid`PackagePrivate`$lastPathType = 
           TypeSystem`NestedGrid`PackagePrivate`pathType$; 
          TypeSystem`NestedGrid`PackagePrivate`$lastPathIsLeafHeader = 
           TypeSystem`NestedGrid`PackagePrivate`isLeafHeader$; 
          TypeSystem`NestedGrid`PackagePrivate`$lastOutputID = 
           TypeSystem`NestedGrid`PackagePrivate`localHold[
            TypeSystem`NestedGrid`PackagePrivate`$outputID$$]; 
          TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
           TypeSystem`NestedGrid`PackagePrivate`path$, 
            TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
         Spacer[10], Blank[] :> Spacer[10]}], 
       TrackedSymbols :> {
        TypeSystem`NestedGrid`PackagePrivate`mouseAnnotation$$}], FrameStyle -> 
      None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> Top, 
      ImageSize -> {Automatic, 15}], FontSize -> 1], 
    TypeSystem`NestedGrid`PackagePrivate`mouseAnnotation$$ = Null}, 
    DynamicWrapperBox[
     DynamicBox[ToBoxes[
       Dataset`DatasetContent[
       1, "Path" -> TypeSystem`NestedGrid`PackagePrivate`$path$$, "Grid" -> 
        TypeSystem`NestedGrid`PackagePrivate`releaseLocalHold[
         TypeSystem`NestedGrid`PackagePrivate`$grid$$], "State" -> 
        TypeSystem`NestedGrid`PackagePrivate`$state$$, "VPos" -> 
        Hold[TypeSystem`NestedGrid`PackagePrivate`$vPos$$], "HPos" -> 
        Hold[TypeSystem`NestedGrid`PackagePrivate`$hPos$$], "TopBar" -> 
        TypeSystem`NestedGrid`PackagePrivate`$topBar$$, "BottomBar" -> 
        TypeSystem`NestedGrid`PackagePrivate`releaseLocalHold[
         TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]], StandardForm],
      ImageSizeCache->{274., {265., 271.}},
      TrackedSymbols:>{
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     TypeSystem`NestedGrid`PackagePrivate`mouseAnnotation$$ = 
     MouseAnnotation[],
     ImageSizeCache->{274., {265., 271.}}],
    BaseStyle->{LineBreakWithin -> False},
    DynamicModuleValues:>{},
    Initialization:>
     Block[{$ContextPath = $ContextPath}, Needs["TypeSystem`"]; 
      Needs["Dataset`"]; 
      TypeSystem`NestedGrid`PackagePrivate`$outputID$$ = CreateUUID[]],
    UnsavedVariables:>{TypeSystem`NestedGrid`PackagePrivate`$outputID$$}],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  Dataset`InterpretDataset[1],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{{3.7988126461210227`*^9, 3.7988126710414147`*^9}, 
   3.798812761853751*^9, 3.7988281066365433`*^9, {3.7988281404709234`*^9, 
   3.798828182788272*^9}, 3.798860806344368*^9},
 CellLabel->
  "Out[440]=",ExpressionUUID->"2c281eac-7684-49a5-9b01-4be4ed5189a9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Topology", "Chapter",
 CellChangeTimes->{{3.798694809492828*^9, 3.7986948135265417`*^9}, {
  3.798966042485071*^9, 
  3.7989660442957363`*^9}},ExpressionUUID->"d7c1f52a-9ffa-47e2-96a1-\
602dfb6b75df"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "listPlot", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"listPlot", "[", 
   RowBox[{"data_List", ",", 
    RowBox[{"{", 
     RowBox[{"key_String", ",", "label_String"}], "}"}], ",", 
    RowBox[{"roundF_", ":", "Identity"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"dd", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"extract", "[", 
            RowBox[{"#", ",", 
             RowBox[{"{", "key", "}"}], ",", "\"\<hparams/epoch\>\"", ",", 
             "MeanAround"}], "]"}], "//", 
           RowBox[{"KeyValueMap", "[", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"kkey", ",", "value"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"roundF", "@", 
                 RowBox[{"First", "@", "kkey"}]}], ",", "value"}], "}"}]}], 
             "]"}], "]"}]}], "//", 
          RowBox[{"SortBy", "[", "First", "]"}]}], ")"}], "&"}], "/@", 
       "data"}]}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"foo", "=", "dd"}], ";", "\[IndentingNewLine]", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{"dd", ",", "\[IndentingNewLine]", 
       RowBox[{"PlotTheme", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Detailed\>\"", ",", "\"\<Scientific\>\""}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"GridLines", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"None", ",", "Automatic"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ScalingFunctions", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"BaseStyle", "\[Rule]", "textStyle"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"label", ",", "\"\<training steps\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ImageSize", "\[Rule]", "300"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"All", ",", "All"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"AspectRatio", "\[Rule]", ".6"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"BaseStyle", "\[Rule]", "textStyle"}]}], "\[IndentingNewLine]",
       "]"}]}]}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.800865743604084*^9, 3.8008657904186172`*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"6b0409ce-318e-44ea-bdc9-1d747ed4bdb3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
      "\"\<experiment-2-elman-letter-topology.csv\>\""}], ",", 
     "\"\<Dataset\>\"", ",", 
     RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.7985225183948517`*^9, 3.798522555972459*^9}, {
   3.7985226044192114`*^9, 3.798522630820962*^9}, {3.798522716299359*^9, 
   3.7985227673889236`*^9}, {3.79852282529937*^9, 3.7985228274893456`*^9}, {
   3.7986017034165735`*^9, 3.7986017113666725`*^9}, {3.798702437775674*^9, 
   3.7987024394355035`*^9}, {3.798702599088843*^9, 3.7987027333705606`*^9}, 
   3.7987205061351004`*^9, {3.7989660516691494`*^9, 3.7989660566293764`*^9}, {
   3.8008655172017293`*^9, 3.8008655173490257`*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"c451b6ed-2d37-4f83-8041-16f7b43dbb26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "all", " ", "entries", " ", "finished", " ", "with", " ", "low", " ", 
    "score", " ", "or", " ", "were", " ", "cut", " ", "off"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Length", "[", "data", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", 
    RowBox[{"data", "[", 
     RowBox[{"Select", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", "\"\<hparams/epoch\>\"", "]"}], "\[GreaterEqual]", 
         "999."}], "\[Or]", 
        RowBox[{
         RowBox[{"#", "[", "\"\<hparams/validate_best\>\"", "]"}], "<", 
         ".01"}]}], "&"}], "]"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.798720514466533*^9, 3.7987205472194633`*^9}, 
   3.798966065911137*^9},
 CellLabel->"In[53]:=",ExpressionUUID->"3dd5c580-ef66-4620-9c89-ffb27de3e00a"],

Cell[BoxData["785"], "Output",
 CellChangeTimes->{{3.7987205105117807`*^9, 3.7987205148675337`*^9}, 
   3.7987205477585907`*^9, {3.798738109661625*^9, 3.798738133739605*^9}, 
   3.7987430437256107`*^9, 3.7987752432501173`*^9, 3.7987821004111648`*^9, 
   3.7987821369387264`*^9, 3.798794173384326*^9, 3.798807086729404*^9, 
   3.7988125232594705`*^9, 3.7988227937379093`*^9, 3.798828030581459*^9, 
   3.7988606129184527`*^9, {3.7989660586359425`*^9, 3.7989660898963127`*^9}, {
   3.7989661443628263`*^9, 3.798966177392365*^9}, 3.7989912311923313`*^9, 
   3.7990518064439387`*^9, 3.799051842285596*^9, 3.7990519037025614`*^9, 
   3.80035641167076*^9, 3.8008655237308083`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"0694bcfc-cf35-4739-9ef0-e309ff14a257"],

Cell[BoxData["785"], "Output",
 CellChangeTimes->{{3.7987205105117807`*^9, 3.7987205148675337`*^9}, 
   3.7987205477585907`*^9, {3.798738109661625*^9, 3.798738133739605*^9}, 
   3.7987430437256107`*^9, 3.7987752432501173`*^9, 3.7987821004111648`*^9, 
   3.7987821369387264`*^9, 3.798794173384326*^9, 3.798807086729404*^9, 
   3.7988125232594705`*^9, 3.7988227937379093`*^9, 3.798828030581459*^9, 
   3.7988606129184527`*^9, {3.7989660586359425`*^9, 3.7989660898963127`*^9}, {
   3.7989661443628263`*^9, 3.798966177392365*^9}, 3.7989912311923313`*^9, 
   3.7990518064439387`*^9, 3.799051842285596*^9, 3.7990519037025614`*^9, 
   3.80035641167076*^9, 3.8008655237308083`*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"db7852cc-ef3c-4727-93e7-4533e0e2fd70"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"all", " ", "entries", " ", "are", " ", "unique"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"data", "[", 
     RowBox[{"GroupBy", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Slot", "[", "\"\<workspace\>\"", "]"}], ",", 
          RowBox[{"Slot", "[", "\"\<stages\>\"", "]"}], ",", 
          RowBox[{"Slot", "[", "\"\<degree\>\"", "]"}], ",", 
          RowBox[{"Slot", "[", "\"\<seed\>\"", "]"}]}], "}"}], "&"}], 
       "\[Rule]", 
       RowBox[{"Key", "[", "\"\<hparams/epoch\>\"", "]"}]}], "]"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Length", "/@", "%"}], "//", "Max"}]}]}]], "Input",
 CellChangeTimes->{{3.798720519900634*^9, 3.798720531060187*^9}, {
  3.7989660998066893`*^9, 3.798966127722357*^9}, {3.7989661824820986`*^9, 
  3.798966186660794*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"8552608d-8fb8-4751-beeb-2c18140467cd"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{{3.7985225385591173`*^9, 3.79852258517916*^9}, 
   3.79852262208912*^9, 3.798522663755971*^9, {3.798522745129121*^9, 
   3.798522768084078*^9}, 3.7985228281320963`*^9, {3.798601704639109*^9, 
   3.798601712711507*^9}, 3.7986018248700743`*^9, 3.798621273271626*^9, 
   3.798694625934705*^9, 3.798695624062343*^9, 3.7986956955371585`*^9, 
   3.7987024400127134`*^9, 3.7987024912210445`*^9, 3.798702603442913*^9, {
   3.798702637222145*^9, 3.79870273479097*^9}, 3.7987044398205366`*^9, 
   3.798705288242174*^9, {3.798720344276144*^9, 3.798720373631121*^9}, 
   3.798720456137677*^9, {3.7987204913970227`*^9, 3.7987205163201895`*^9}, 
   3.798720549486605*^9, 3.7987381357393265`*^9, 3.7987430448675127`*^9, 
   3.7987752449922647`*^9, 3.798782079130305*^9, 3.7987821382066526`*^9, 
   3.798794174503295*^9, 3.7988070880044727`*^9, 3.798812524117013*^9, 
   3.79882279503822*^9, 3.7988280318285155`*^9, 3.798860613813577*^9, {
   3.7989660912714977`*^9, 3.798966186983429*^9}, 3.798991232311823*^9, 
   3.7990518074258175`*^9, 3.7990518430724645`*^9, 3.799051904521674*^9, 
   3.800356412762763*^9, 3.800865524595415*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"11bcaef8-91e0-4114-846f-8274c44e4142"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"listPlot", "[", 
    RowBox[{
     RowBox[{"{", "data", "}"}], ",", "#", ",", "Identity"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<workspace\>\"", ",", "\"\<workspace\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<stages\>\"", ",", "\"\<stages\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<degree\>\"", ",", "\"\<degree\>\""}], "}"}]}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.7985263242259197`*^9, 3.798526329506007*^9}, {
  3.798526546465567*^9, 3.798526558545287*^9}, {3.7986019986124864`*^9, 
  3.7986020288227854`*^9}, {3.798602340950798*^9, 3.7986023420972104`*^9}, {
  3.798695225494727*^9, 3.7986952341182394`*^9}, {3.7989661947116256`*^9, 
  3.7989662028658123`*^9}, {3.8003564243985825`*^9, 3.8003564404322205`*^9}, {
  3.8008655689069476`*^9, 3.800865643610024*^9}, {3.800865798251584*^9, 
  3.800865802313545*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"77312177-6b3e-446e-8ad6-8df114195053"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{3., 940.4420443764315}, {3., 952.5958904109589}}], 
           LineBox[{{3., 952.5958904109589}, {3., 964.7497364454863}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{4., 697.5447960481958}, {4., 730.5909090909091}}], 
           LineBox[{{4., 730.5909090909091}, {4., 763.6370221336224}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{5., 547.9273770713303}, {5., 582.5853658536586}}], 
           LineBox[{{5., 582.5853658536586}, {5., 617.2433546359869}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {LineBox[{{6., 465.137898034875}, {6., 500.136}}], 
           LineBox[{{6., 500.136}, {6., 535.1341019651251}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{7., 522.4307903144924}, {7., 556.6159420289855}}], 
           LineBox[{{7., 556.6159420289855}, {7., 590.8010937434786}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{8., 507.78077096120546`}, {8., 541.4335664335664}}], 
           LineBox[{{8., 541.4335664335664}, {8., 575.0863619059273}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}}, {
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{3., 964.7497364454863}, 
              Offset[{3, 0}, {3., 964.7497364454863}]}, {{3., 
              964.7497364454863}, 
              Offset[{-3, 0}, {3., 964.7497364454863}]}, {{3., 
              940.4420443764315}, Offset[{3, 0}, {3., 940.4420443764315}]}, {{
              3., 940.4420443764315}, 
              Offset[{-3, 0}, {3., 940.4420443764315}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{4., 763.6370221336224}, 
              Offset[{3, 0}, {4., 763.6370221336224}]}, {{4., 
              763.6370221336224}, 
              Offset[{-3, 0}, {4., 763.6370221336224}]}, {{4., 
              697.5447960481958}, Offset[{3, 0}, {4., 697.5447960481958}]}, {{
              4., 697.5447960481958}, 
              Offset[{-3, 0}, {4., 697.5447960481958}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{5., 617.2433546359869}, 
              Offset[{3, 0}, {5., 617.2433546359869}]}, {{5., 
              617.2433546359869}, 
              Offset[{-3, 0}, {5., 617.2433546359869}]}, {{5., 
              547.9273770713303}, Offset[{3, 0}, {5., 547.9273770713303}]}, {{
              5., 547.9273770713303}, 
              Offset[{-3, 0}, {5., 547.9273770713303}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{6., 535.1341019651251}, 
              Offset[{3, 0}, {6., 535.1341019651251}]}, {{6., 
              535.1341019651251}, 
              Offset[{-3, 0}, {6., 535.1341019651251}]}, {{6., 
              465.137898034875}, Offset[{3, 0}, {6., 465.137898034875}]}, {{
              6., 465.137898034875}, 
              Offset[{-3, 0}, {6., 465.137898034875}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{7., 590.8010937434786}, 
              Offset[{3, 0}, {7., 590.8010937434786}]}, {{7., 
              590.8010937434786}, 
              Offset[{-3, 0}, {7., 590.8010937434786}]}, {{7., 
              522.4307903144924}, Offset[{3, 0}, {7., 522.4307903144924}]}, {{
              7., 522.4307903144924}, 
              Offset[{-3, 0}, {7., 522.4307903144924}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{8., 575.0863619059273}, 
              Offset[{3, 0}, {8., 575.0863619059273}]}, {{8., 
              575.0863619059273}, 
              Offset[{-3, 0}, {8., 575.0863619059273}]}, {{8., 
              507.78077096120546`}, 
              Offset[{3, 0}, {8., 507.78077096120546`}]}, {{8., 
              507.78077096120546`}, 
              Offset[{-3, 0}, {8., 507.78077096120546`}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}}}, {{{}, {}, 
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[
         LineBox[{{3., 952.5958904109589}, {4., 730.5909090909091}, {5., 
          582.5853658536586}, {6., 500.136}, {7., 556.6159420289855}, {8., 
          541.4335664335664}}],
         FontSize->14,
         FontName -> "Times New Roman"]}}, 
      {RGBColor[1, 0, 0], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
       CapForm["Butt"], 
       StyleBox[{},
        FontSize->14,
        FontName -> "Times New Roman"]}, {
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, {}}, {
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, {}}}, {{}, {}}},
    AspectRatio->0.6,
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{2.895833333333334, 474.99933942161346`},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->{{True, True}, {True, True}},
    FrameLabel->{{
       FormBox["\"training steps\"", TraditionalForm], None}, {
       FormBox["\"workspace\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->300,
    LabelStyle->{FontFamily -> "Times"},
    Method->{
     "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& )}},
    PlotRange->{{2.895833333333334, 8.}, {474.99933942161346`, 
     952.5958904109589}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{1., 731.3410319185416}, {1., 756.9572192513369}}], 
           LineBox[{{1., 756.9572192513369}, {1., 782.5734065841323}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{2., 508.35603616609455`}, {2., 537.5343915343915}}], 
           LineBox[{{2., 537.5343915343915}, {2., 566.7127469026884}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {LineBox[{{3., 622.264465431752}, {3., 649.2}}], 
           LineBox[{{3., 649.2}, {3., 676.1355345682481}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{4., 617.993948140476}, {4., 645.2254901960785}}], 
           LineBox[{{4., 645.2254901960785}, {4., 672.4570322516809}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}}, {
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{1., 782.5734065841323}, 
              Offset[{3, 0}, {1., 782.5734065841323}]}, {{1., 
              782.5734065841323}, 
              Offset[{-3, 0}, {1., 782.5734065841323}]}, {{1., 
              731.3410319185416}, Offset[{3, 0}, {1., 731.3410319185416}]}, {{
              1., 731.3410319185416}, 
              Offset[{-3, 0}, {1., 731.3410319185416}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{2., 566.7127469026884}, 
              Offset[{3, 0}, {2., 566.7127469026884}]}, {{2., 
              566.7127469026884}, 
              Offset[{-3, 0}, {2., 566.7127469026884}]}, {{2., 
              508.35603616609455`}, 
              Offset[{3, 0}, {2., 508.35603616609455`}]}, {{2., 
              508.35603616609455`}, 
              Offset[{-3, 0}, {2., 508.35603616609455`}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{3., 676.1355345682481}, 
              Offset[{3, 0}, {3., 676.1355345682481}]}, {{3., 
              676.1355345682481}, 
              Offset[{-3, 0}, {3., 676.1355345682481}]}, {{3., 
              622.264465431752}, Offset[{3, 0}, {3., 622.264465431752}]}, {{
              3., 622.264465431752}, 
              Offset[{-3, 0}, {3., 622.264465431752}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{4., 672.4570322516809}, 
              Offset[{3, 0}, {4., 672.4570322516809}]}, {{4., 
              672.4570322516809}, 
              Offset[{-3, 0}, {4., 672.4570322516809}]}, {{4., 
              617.993948140476}, Offset[{3, 0}, {4., 617.993948140476}]}, {{
              4., 617.993948140476}, 
              Offset[{-3, 0}, {4., 617.993948140476}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}}}, {{{}, {}, 
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[
         LineBox[{{1., 756.9572192513369}, {2., 537.5343915343915}, {3., 
          649.2}, {4., 645.2254901960785}}],
         FontSize->14,
         FontName -> "Times New Roman"]}}, 
      {RGBColor[1, 0, 0], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
       CapForm["Butt"], 
       StyleBox[{},
        FontSize->14,
        FontName -> "Times New Roman"]}, {
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, {}}, {
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, {}}}, {{}, {}}},
    AspectRatio->0.6,
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.9375000000000003, 525.3442344390056},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->{{True, True}, {True, True}},
    FrameLabel->{{
       FormBox["\"training steps\"", TraditionalForm], None}, {
       FormBox["\"stages\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->300,
    LabelStyle->{FontFamily -> "Times"},
    Method->{
     "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& )}},
    PlotRange->{{0.9375000000000003, 4.}, {525.3442344390056, 
     756.9572192513369}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{1., 774.9220702489106}, {1., 794.9840425531914}}], 
           LineBox[{{1., 794.9840425531914}, {1., 815.0460148574723}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{2., 529.2735282190106}, {2., 558.0320855614973}}], 
           LineBox[{{2., 558.0320855614973}, {2., 586.790642903984}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{3., 537.3775248991402}, {3., 566.4057971014493}}], 
           LineBox[{{3., 566.4057971014493}, {3., 595.4340693037583}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{{}, {
           LineBox[{{4., 645.6555797728745}, {4., 673.9014778325123}}], 
           LineBox[{{4., 673.9014778325123}, {4., 702.1473758921502}}]}},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}}, {
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{1., 815.0460148574723}, 
              Offset[{3, 0}, {1., 815.0460148574723}]}, {{1., 
              815.0460148574723}, 
              Offset[{-3, 0}, {1., 815.0460148574723}]}, {{1., 
              774.9220702489106}, Offset[{3, 0}, {1., 774.9220702489106}]}, {{
              1., 774.9220702489106}, 
              Offset[{-3, 0}, {1., 774.9220702489106}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{2., 586.790642903984}, 
              Offset[{3, 0}, {2., 586.790642903984}]}, {{2., 
              586.790642903984}, Offset[{-3, 0}, {2., 586.790642903984}]}, {{
              2., 529.2735282190106}, 
              Offset[{3, 0}, {2., 529.2735282190106}]}, {{2., 
              529.2735282190106}, 
              Offset[{-3, 0}, {2., 529.2735282190106}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{3., 595.4340693037583}, 
              Offset[{3, 0}, {3., 595.4340693037583}]}, {{3., 
              595.4340693037583}, 
              Offset[{-3, 0}, {3., 595.4340693037583}]}, {{3., 
              537.3775248991402}, Offset[{3, 0}, {3., 537.3775248991402}]}, {{
              3., 537.3775248991402}, 
              Offset[{-3, 0}, {3., 537.3775248991402}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[1, 0, 0], CapForm["Butt"], 
        StyleBox[{
          GeometricTransformationBox[
           LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
          GeometricTransformationBox[
           LineBox[{{{4., 702.1473758921502}, 
              Offset[{3, 0}, {4., 702.1473758921502}]}, {{4., 
              702.1473758921502}, 
              Offset[{-3, 0}, {4., 702.1473758921502}]}, {{4., 
              645.6555797728745}, Offset[{3, 0}, {4., 645.6555797728745}]}, {{
              4., 645.6555797728745}, 
              Offset[{-3, 0}, {4., 645.6555797728745}]}}], {{{1., 0.}, {0., 
            1.}}, {0., 0.}}]},
         Antialiasing->False,
         FontSize->14,
         FontName -> "Times New Roman"]}}}, {{{}, {}, 
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[
         LineBox[{{1., 794.9840425531914}, {2., 558.0320855614973}, {3., 
          566.4057971014493}, {4., 673.9014778325123}}],
         FontSize->14,
         FontName -> "Times New Roman"]}}, 
      {RGBColor[1, 0, 0], PointSize[
        NCache[
         Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
       CapForm["Butt"], 
       StyleBox[{},
        FontSize->14,
        FontName -> "Times New Roman"]}, {
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, {}}, {
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, {}}}, {{}, {}}},
    AspectRatio->0.6,
    Axes->{False, False},
    AxesLabel->{None, None},
    AxesOrigin->{0.9375000000000003, 544.8680879508477},
    BaseStyle->Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
    DisplayFunction->Identity,
    Frame->{{True, True}, {True, True}},
    FrameLabel->{{
       FormBox["\"training steps\"", TraditionalForm], None}, {
       FormBox["\"degree\"", TraditionalForm], None}},
    FrameStyle->GrayLevel[0],
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, Automatic},
    GridLinesStyle->Directive[
      GrayLevel[0.4, 0.5], 
      AbsoluteThickness[1], 
      AbsoluteDashing[{1, 2}]],
    ImageSize->300,
    LabelStyle->{FontFamily -> "Times"},
    Method->{
     "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Identity[
           Part[#, 1]], 
          Identity[
           Part[#, 2]]}& )}},
    PlotRange->{{0.9375000000000003, 4.}, {544.8680879508477, 
     794.9840425531914}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.798526329955846*^9, 3.7985263364253817`*^9}, {
   3.7985263776955166`*^9, 3.7985265737456093`*^9}, {3.798526623252246*^9, 
   3.798526634020524*^9}, 3.7985267010753374`*^9, 3.798526793385289*^9, {
   3.798526823998711*^9, 3.798526936349416*^9}, {3.7985269865048075`*^9, 
   3.798526998235042*^9}, {3.7985271178549366`*^9, 3.7985271277950068`*^9}, 
   3.7985271625750012`*^9, 3.7985272928344946`*^9, {3.7986020301025066`*^9, 
   3.7986020946491985`*^9}, 3.798602342258427*^9, 3.798621273992502*^9, 
   3.7986213724765854`*^9, 3.798694626920807*^9, 3.7986947174368086`*^9, {
   3.7986952074317102`*^9, 3.798695235645974*^9}, 3.798695625883403*^9, 
   3.798695696357278*^9, 3.7987149282405987`*^9, 3.7987205605073614`*^9, 
   3.7987381383491964`*^9, 3.79874304654582*^9, 3.7987431189659023`*^9, 
   3.798775246510453*^9, 3.798782139294606*^9, 3.798794175847601*^9, 
   3.798807089317549*^9, 3.798812525162505*^9, 3.7988227964007015`*^9, 
   3.798828032928832*^9, 3.798860614925553*^9, {3.798966189039717*^9, 
   3.7989662039174204`*^9}, 3.7989912332674*^9, 3.7990518085504146`*^9, 
   3.7990518447006598`*^9, {3.799051905636301*^9, 3.7990519171103325`*^9}, {
   3.800356414031803*^9, 3.8003564411703405`*^9}, 3.8008655263388324`*^9, {
   3.800865570687722*^9, 3.8008655945877285`*^9}, 3.8008656442056303`*^9, 
   3.8008658032682343`*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"eb6c9b71-04d5-44fb-9582-b8087360b8d0"]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.8002698509905005`*^9},ExpressionUUID->"d3cdd098-e6d7-463e-87da-\
6d7672ec3994"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Long Sequence Convergence Times", "Chapter",
 CellChangeTimes->{{3.8002698593820605`*^9, 
  3.800269864877158*^9}},ExpressionUUID->"f7b601a5-d550-44ef-a839-\
357719b2fe62"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"table", "[", "pairs_", "]"}], ":=", 
   RowBox[{"Grid", "[", 
    RowBox[{"pairs", ",", 
     RowBox[{"Spacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".1"}], "}"}]}], ",", 
     RowBox[{"Alignment", "\[Rule]", "Left"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.800358779412771*^9, 3.800358779412771*^9}, {
  3.800358850632638*^9, 3.8003588787837763`*^9}, {3.80035894476155*^9, 
  3.8003589468967285`*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"ddfce460-5d85-4561-9161-7e239be8322b"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "listCompPlot", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"listCompPlot", "[", 
   RowBox[{"data_List", ",", 
    RowBox[{"{", 
     RowBox[{"key_String", ",", "label_String"}], "}"}], ",", 
    RowBox[{"roundF_", ":", "Identity"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"dd", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"extract", "[", 
            RowBox[{"#", ",", 
             RowBox[{"{", "key", "}"}], ",", "\"\<hparams/epoch\>\"", ",", 
             "MeanAround"}], "]"}], "//", 
           RowBox[{"KeyValueMap", "[", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"kkey", ",", "value"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"roundF", "@", 
                 RowBox[{"First", "@", "kkey"}]}], ",", "value"}], "}"}]}], 
             "]"}], "]"}]}], "//", 
          RowBox[{"SortBy", "[", "First", "]"}]}], ")"}], "&"}], "/@", 
       "data"}]}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"foo", "=", "dd"}], ";", "\[IndentingNewLine]", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{"dd", ",", "\[IndentingNewLine]", 
       RowBox[{"PlotTheme", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Detailed\>\"", ",", "\"\<Scientific\>\""}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"GridLines", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"None", ",", "Automatic"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ScalingFunctions", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Log\>\"", ",", "Identity"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"BaseStyle", "\[Rule]", "textStyle"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"label", ",", "\"\<training steps\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"ImageSize", "\[Rule]", "300"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"All", ",", "All"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"AspectRatio", "\[Rule]", ".6"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "\[Rule]", 
        RowBox[{"Placed", "[", 
         RowBox[{
          RowBox[{"LineLegend", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "\"\<QRNN\>\"", ",", "\"\<RNN\>\"", ",", "\"\<LSTM\>\""}], "}"}],
             ",", 
            RowBox[{"LegendLayout", "\[Rule]", "table"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{".1", ",", ".6"}], "}"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{".1", ",", ".1"}], "}"}]}], "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"BaseStyle", "\[Rule]", "textStyle"}]}], "\[IndentingNewLine]",
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.800336055940254*^9, 3.800336123488772*^9}, {
   3.8003361686223984`*^9, 3.80033621752958*^9}, {3.8003362606073904`*^9, 
   3.800336369710956*^9}, {3.8003364058463583`*^9, 3.8003364068185005`*^9}, 
   3.800339094161579*^9, {3.8003580480328455`*^9, 3.800358066260252*^9}, 
   3.8003585384141316`*^9, {3.8003585859681034`*^9, 3.800358614285634*^9}, {
   3.800358659923829*^9, 3.8003587077691355`*^9}, {3.800358756181316*^9, 
   3.800358845216795*^9}, {3.800358891752094*^9, 3.800358902323271*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"fe8329aa-5aa2-4cf8-b19a-feeecc633457"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"datarnn", "=", 
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
       "\"\<long-rnn.csv\>\""}], ",", "\"\<Dataset\>\"", ",", 
      RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "all", " ", "entries", " ", "finished", " ", "with", " ", "low", " ", 
    "score", " ", "or", " ", "were", " ", "cut", " ", "off"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "datarnn", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "[", 
   RowBox[{"datarnn", "[", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", "\"\<hparams/epoch\>\"", "]"}], "\[GreaterEqual]", 
        "999."}], "\[Or]", 
       RowBox[{
        RowBox[{"#", "[", "\"\<hparams/validate_best\>\"", "]"}], "<", 
        ".0005"}]}], "&"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"all", " ", "entries", " ", "are", " ", "unique"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datarnn", "[", 
   RowBox[{"GroupBy", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Slot", "[", "\"\<sentence_length\>\"", "]"}], ",", 
        RowBox[{"Slot", "[", "\"\<seed\>\"", "]"}]}], "}"}], "&"}], "\[Rule]", 
     RowBox[{"Key", "[", "\"\<hparams/epoch\>\"", "]"}]}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "/@", "%"}], "//", "Max"}]}], "Input",
 CellChangeTimes->{{3.800332467246987*^9, 3.8003324901579504`*^9}, {
  3.800332577471218*^9, 3.8003325831327486`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"ffe8ee01-b591-47f3-bcf3-90404a8f7842"],

Cell[BoxData["132"], "Output",
 CellChangeTimes->{
  3.8003324916565104`*^9, {3.800332573158697*^9, 3.800332583742253*^9}, 
   3.8003580546097937`*^9, 3.8003609032248545`*^9, 3.8008643668830223`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"447057b3-44e4-410f-8d80-579775ce81ba"],

Cell[BoxData["132"], "Output",
 CellChangeTimes->{
  3.8003324916565104`*^9, {3.800332573158697*^9, 3.800332583742253*^9}, 
   3.8003580546097937`*^9, 3.8003609032248545`*^9, 3.8008643668830223`*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"0eaff187-e324-47d6-9cf5-f9dd21083936"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.8003324916565104`*^9, {3.800332573158697*^9, 3.800332583742253*^9}, 
   3.8003580546097937`*^9, 3.8003609032248545`*^9, 3.8008643668911667`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"3643449d-6a06-4e62-8cc0-ab15a7283296"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"datalstm", "=", 
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
       "\"\<long-lstm.csv\>\""}], ",", "\"\<Dataset\>\"", ",", 
      RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "all", " ", "entries", " ", "finished", " ", "with", " ", "low", " ", 
    "score", " ", "or", " ", "were", " ", "cut", " ", "off"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "datalstm", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "[", 
   RowBox[{"datalstm", "[", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", "\"\<hparams/epoch\>\"", "]"}], "\[GreaterEqual]", 
        "999."}], "\[Or]", 
       RowBox[{
        RowBox[{"#", "[", "\"\<hparams/validate_best\>\"", "]"}], "<", 
        ".0005"}]}], "&"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"all", " ", "entries", " ", "are", " ", "unique"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datalstm", "[", 
   RowBox[{"GroupBy", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Slot", "[", "\"\<sentence_length\>\"", "]"}], ",", 
        RowBox[{"Slot", "[", "\"\<seed\>\"", "]"}]}], "}"}], "&"}], "\[Rule]", 
     RowBox[{"Key", "[", "\"\<hparams/epoch\>\"", "]"}]}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "/@", "%"}], "//", "Max"}]}], "Input",
 CellChangeTimes->{{3.8003326015917387`*^9, 3.8003326118449535`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"f28f003f-5be7-4b27-8403-d4b55d94f5d5"],

Cell[BoxData["189"], "Output",
 CellChangeTimes->{3.8003326125784883`*^9, 3.8003580560629225`*^9, 
  3.800360904375895*^9, 3.8008643703313584`*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"0a13e56b-123c-4ed3-905f-67e15e5ff1f7"],

Cell[BoxData["189"], "Output",
 CellChangeTimes->{3.8003326125784883`*^9, 3.8003580560629225`*^9, 
  3.800360904375895*^9, 3.8008643703313584`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"1c69ad36-ab56-4f50-bbe0-e91c90a68013"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.8003326125784883`*^9, 3.8003580560629225`*^9, 
  3.800360904375895*^9, 3.8008643703469462`*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"b44bb3a1-6d12-4f6e-a95d-5744ccedc3ad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
       "\"\<experiment-5-dna-pool.csv\>\""}], ",", "\"\<Dataset\>\"", ",", 
      RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "all", " ", "entries", " ", "finished", " ", "with", " ", "low", " ", 
    "score", " ", "or", " ", "were", " ", "cut", " ", "off"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "data", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "[", 
   RowBox[{"data", "[", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", "\"\<hparams/epoch\>\"", "]"}], "\[GreaterEqual]", 
        "999."}], "\[Or]", 
       RowBox[{
        RowBox[{"#", "[", "\"\<hparams/validate_best\>\"", "]"}], "<", 
        ".0005"}]}], "&"}], "]"}], "]"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"all", " ", "entries", " ", "are", " ", "unique"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "[", 
   RowBox[{"GroupBy", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Slot", "[", "\"\<sentence_length\>\"", "]"}], ",", 
        RowBox[{"Slot", "[", "\"\<seed\>\"", "]"}]}], "}"}], "&"}], "\[Rule]", 
     RowBox[{"Key", "[", "\"\<hparams/epoch\>\"", "]"}]}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Length", "/@", "%"}], "//", "Max"}]}], "Input",
 CellChangeTimes->{{3.800269993613994*^9, 3.800270013298931*^9}, 
   3.800270065102244*^9, {3.8003325885174775`*^9, 3.8003325926441054`*^9}, {
   3.8008643609518833`*^9, 3.8008643611213045`*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"375fd1bb-16e0-4df0-b0b5-fbc5ff659a8f"],

Cell[BoxData["224"], "Output",
 CellChangeTimes->{
  3.800332593327674*^9, 3.8003353010983157`*^9, {3.800335522863962*^9, 
   3.8003355391109447`*^9}, 3.8003390614003487`*^9, 3.8003520787188673`*^9, 
   3.8003580577044735`*^9, 3.800358330960705*^9, 3.8003585444532857`*^9, 
   3.800360905546571*^9, {3.800864372506987*^9, 3.800864399459901*^9}},
 CellLabel->"Out[43]=",ExpressionUUID->"f8239497-2510-4469-bcf4-b4f8ad7bd703"],

Cell[BoxData["224"], "Output",
 CellChangeTimes->{
  3.800332593327674*^9, 3.8003353010983157`*^9, {3.800335522863962*^9, 
   3.8003355391109447`*^9}, 3.8003390614003487`*^9, 3.8003520787188673`*^9, 
   3.8003580577044735`*^9, 3.800358330960705*^9, 3.8003585444532857`*^9, 
   3.800360905546571*^9, {3.800864372506987*^9, 3.800864399459901*^9}},
 CellLabel->"Out[44]=",ExpressionUUID->"6eac3cf5-bb05-4233-9744-9d4a8bca1574"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{
  3.800332593327674*^9, 3.8003353010983157`*^9, {3.800335522863962*^9, 
   3.8003355391109447`*^9}, 3.8003390614003487`*^9, 3.8003520787188673`*^9, 
   3.8003580577044735`*^9, 3.800358330960705*^9, 3.8003585444532857`*^9, 
   3.800360905546571*^9, {3.800864372506987*^9, 3.8008643994755287`*^9}},
 CellLabel->"Out[46]=",ExpressionUUID->"c8d628f6-9b7d-47dc-a662-7b6d4d6e9a94"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"listCompPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"dd", "[", 
        RowBox[{"Select", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", "\"\<hparams/epoch\>\"", "]"}], "<", "999"}], 
          "&"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"dd", ",", 
         RowBox[{"{", 
          RowBox[{"data", ",", "datarnn", ",", "datalstm"}], "}"}]}], "}"}]}],
       "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"\"\<sentence_length\>\"", ",", "\"\<sequence length\>\""}], 
      "}"}], ",", "Round"}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.8002700975465746`*^9, 3.8002701090569725`*^9}, {
   3.800270267948163*^9, 3.8002702689697247`*^9}, {3.800270671028119*^9, 
   3.800270676129759*^9}, {3.800271062477919*^9, 3.800271097774658*^9}, {
   3.8002786557465916`*^9, 3.800278706240055*^9}, {3.800278817629488*^9, 
   3.8002788189692326`*^9}, {3.800332623975378*^9, 3.80033264790017*^9}, {
   3.800332685859146*^9, 3.800332705769139*^9}, {3.800333420524959*^9, 
   3.800333467385023*^9}, {3.8003335259633465`*^9, 3.800333567547366*^9}, {
   3.80033379820912*^9, 3.800333801377308*^9}, {3.8003343250853205`*^9, 
   3.8003343264533453`*^9}, {3.800335652609748*^9, 3.800335655358219*^9}, 
   3.800335782136942*^9, {3.800336109570383*^9, 3.8003361461124263`*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"25af6f1b-9549-4f95-bffc-6597800777f7"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{{
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{1.6094379124341003`, 86.73490473597198}, {
             1.6094379124341003`, 94.}}], 
            LineBox[{{1.6094379124341003`, 94.}, {1.6094379124341003`, 
             101.26509526402802`}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{2.302585092994046, 168.8876759035629}, {
             2.302585092994046, 209.6}}], 
            LineBox[{{2.302585092994046, 209.6}, {2.302585092994046, 
             250.3123240964371}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{2.995732273553991, 223.7313725936539}, {
             2.995732273553991, 266.8}}], 
            LineBox[{{2.995732273553991, 266.8}, {2.995732273553991, 
             309.86862740634615`}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{3.912023005428146, 245.66301296139065`}, {
             3.912023005428146, 280.3448275862069}}], 
            LineBox[{{3.912023005428146, 280.3448275862069}, {
             3.912023005428146, 315.0266422110232}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{4.605170185988092, 247.00657438674614`}, {
             4.605170185988092, 282.17391304347825`}}], 
            LineBox[{{4.605170185988092, 282.17391304347825`}, {
             4.605170185988092, 317.34125170021036`}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{5.298317366548036, 272.73970891124475`}, {
             5.298317366548036, 315.45454545454544`}}], 
            LineBox[{{5.298317366548036, 315.45454545454544`}, {
             5.298317366548036, 358.16938199784613`}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{6.214608098422191, 307.4191832580118}, {
             6.214608098422191, 343.7037037037037}}], 
            LineBox[{{6.214608098422191, 343.7037037037037}, {
             6.214608098422191, 379.9882241493956}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}}, {
        {RGBColor[0, 1, 0], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{1.6094379124341003`, 47.42752046463044}, {
             1.6094379124341003`, 48.63333333333333}}], 
            LineBox[{{1.6094379124341003`, 48.63333333333333}, {
             1.6094379124341003`, 49.839146202036225`}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 1, 0], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{2.302585092994046, 341.7428351890147}, {
             2.302585092994046, 355.6333333333333}}], 
            LineBox[{{2.302585092994046, 355.6333333333333}, {
             2.302585092994046, 369.5238314776519}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}}, {
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{1.6094379124341003`, 41.46566579667624}, {
             1.6094379124341003`, 43.53333333333333}}], 
            LineBox[{{1.6094379124341003`, 43.53333333333333}, {
             1.6094379124341003`, 45.60100086999042}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{2.302585092994046, 182.37383567556475`}, {
             2.302585092994046, 198.}}], 
            LineBox[{{2.302585092994046, 198.}, {2.302585092994046, 
             213.62616432443525`}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{2.995732273553991, 373.30522922363417`}, {
             2.995732273553991, 401.8666666666667}}], 
            LineBox[{{2.995732273553991, 401.8666666666667}, {
             2.995732273553991, 430.4281041096992}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{3.912023005428146, 477.35826474902024`}, {
             3.912023005428146, 514.75}}], 
            LineBox[{{3.912023005428146, 514.75}, {3.912023005428146, 
             552.1417352509798}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{4.605170185988092, 596.7386039731318}, {
             4.605170185988092, 649.7777777777778}}], 
            LineBox[{{4.605170185988092, 649.7777777777778}, {
             4.605170185988092, 702.8169515824238}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{5.298317366548036, 613.1510541672346}, {
             5.298317366548036, 660.3076923076923}}], 
            LineBox[{{5.298317366548036, 660.3076923076923}, {
             5.298317366548036, 707.4643304481499}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{6.907755278982137, 664.}, {6.907755278982137, 696.}}], 
            LineBox[{{6.907755278982137, 696.}, {6.907755278982137, 728.}}]}},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}}}, {{
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{1.6094379124341003`, 101.26509526402802`}, 
               Offset[{3, 0}, {1.6094379124341003`, 101.26509526402802`}]}, {{
               1.6094379124341003`, 101.26509526402802`}, 
               Offset[{-3, 0}, {1.6094379124341003`, 
                101.26509526402802`}]}, {{1.6094379124341003`, 
               86.73490473597198}, 
               Offset[{3, 0}, {1.6094379124341003`, 86.73490473597198}]}, {{
               1.6094379124341003`, 86.73490473597198}, 
               Offset[{-3, 0}, {1.6094379124341003`, 
                86.73490473597198}]}}], {{{1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{2.302585092994046, 250.3123240964371}, 
               Offset[{3, 0}, {2.302585092994046, 250.3123240964371}]}, {{
               2.302585092994046, 250.3123240964371}, 
               Offset[{-3, 0}, {2.302585092994046, 250.3123240964371}]}, {{
               2.302585092994046, 168.8876759035629}, 
               Offset[{3, 0}, {2.302585092994046, 168.8876759035629}]}, {{
               2.302585092994046, 168.8876759035629}, 
               Offset[{-3, 0}, {2.302585092994046, 168.8876759035629}]}}], {{{
             1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{2.995732273553991, 309.86862740634615`}, 
               Offset[{3, 0}, {2.995732273553991, 309.86862740634615`}]}, {{
               2.995732273553991, 309.86862740634615`}, 
               Offset[{-3, 0}, {2.995732273553991, 309.86862740634615`}]}, {{
               2.995732273553991, 223.7313725936539}, 
               Offset[{3, 0}, {2.995732273553991, 223.7313725936539}]}, {{
               2.995732273553991, 223.7313725936539}, 
               Offset[{-3, 0}, {2.995732273553991, 223.7313725936539}]}}], {{{
             1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{3.912023005428146, 315.0266422110232}, 
               Offset[{3, 0}, {3.912023005428146, 315.0266422110232}]}, {{
               3.912023005428146, 315.0266422110232}, 
               Offset[{-3, 0}, {3.912023005428146, 315.0266422110232}]}, {{
               3.912023005428146, 245.66301296139065`}, 
               Offset[{3, 0}, {3.912023005428146, 245.66301296139065`}]}, {{
               3.912023005428146, 245.66301296139065`}, 
               Offset[{-3, 0}, {3.912023005428146, 
                245.66301296139065`}]}}], {{{1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{4.605170185988092, 317.34125170021036`}, 
               Offset[{3, 0}, {4.605170185988092, 317.34125170021036`}]}, {{
               4.605170185988092, 317.34125170021036`}, 
               Offset[{-3, 0}, {4.605170185988092, 317.34125170021036`}]}, {{
               4.605170185988092, 247.00657438674614`}, 
               Offset[{3, 0}, {4.605170185988092, 247.00657438674614`}]}, {{
               4.605170185988092, 247.00657438674614`}, 
               Offset[{-3, 0}, {4.605170185988092, 
                247.00657438674614`}]}}], {{{1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{5.298317366548036, 358.16938199784613`}, 
               Offset[{3, 0}, {5.298317366548036, 358.16938199784613`}]}, {{
               5.298317366548036, 358.16938199784613`}, 
               Offset[{-3, 0}, {5.298317366548036, 358.16938199784613`}]}, {{
               5.298317366548036, 272.73970891124475`}, 
               Offset[{3, 0}, {5.298317366548036, 272.73970891124475`}]}, {{
               5.298317366548036, 272.73970891124475`}, 
               Offset[{-3, 0}, {5.298317366548036, 
                272.73970891124475`}]}}], {{{1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[1, 0, 0], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{6.214608098422191, 379.9882241493956}, 
               Offset[{3, 0}, {6.214608098422191, 379.9882241493956}]}, {{
               6.214608098422191, 379.9882241493956}, 
               Offset[{-3, 0}, {6.214608098422191, 379.9882241493956}]}, {{
               6.214608098422191, 307.4191832580118}, 
               Offset[{3, 0}, {6.214608098422191, 307.4191832580118}]}, {{
               6.214608098422191, 307.4191832580118}, 
               Offset[{-3, 0}, {6.214608098422191, 307.4191832580118}]}}], {{{
             1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}}, {
        {RGBColor[0, 1, 0], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{1.6094379124341003`, 49.839146202036225`}, 
               Offset[{3, 0}, {1.6094379124341003`, 49.839146202036225`}]}, {{
               1.6094379124341003`, 49.839146202036225`}, 
               Offset[{-3, 0}, {1.6094379124341003`, 
                49.839146202036225`}]}, {{1.6094379124341003`, 
               47.42752046463044}, 
               Offset[{3, 0}, {1.6094379124341003`, 47.42752046463044}]}, {{
               1.6094379124341003`, 47.42752046463044}, 
               Offset[{-3, 0}, {1.6094379124341003`, 
                47.42752046463044}]}}], {{{1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 1, 0], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{2.302585092994046, 369.5238314776519}, 
               Offset[{3, 0}, {2.302585092994046, 369.5238314776519}]}, {{
               2.302585092994046, 369.5238314776519}, 
               Offset[{-3, 0}, {2.302585092994046, 369.5238314776519}]}, {{
               2.302585092994046, 341.7428351890147}, 
               Offset[{3, 0}, {2.302585092994046, 341.7428351890147}]}, {{
               2.302585092994046, 341.7428351890147}, 
               Offset[{-3, 0}, {2.302585092994046, 341.7428351890147}]}}], {{{
             1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}}, {
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{1.6094379124341003`, 45.60100086999042}, 
               Offset[{3, 0}, {1.6094379124341003`, 45.60100086999042}]}, {{
               1.6094379124341003`, 45.60100086999042}, 
               Offset[{-3, 0}, {1.6094379124341003`, 45.60100086999042}]}, {{
               1.6094379124341003`, 41.46566579667624}, 
               Offset[{3, 0}, {1.6094379124341003`, 41.46566579667624}]}, {{
               1.6094379124341003`, 41.46566579667624}, 
               Offset[{-3, 0}, {1.6094379124341003`, 
                41.46566579667624}]}}], {{{1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{2.302585092994046, 213.62616432443525`}, 
               Offset[{3, 0}, {2.302585092994046, 213.62616432443525`}]}, {{
               2.302585092994046, 213.62616432443525`}, 
               Offset[{-3, 0}, {2.302585092994046, 213.62616432443525`}]}, {{
               2.302585092994046, 182.37383567556475`}, 
               Offset[{3, 0}, {2.302585092994046, 182.37383567556475`}]}, {{
               2.302585092994046, 182.37383567556475`}, 
               Offset[{-3, 0}, {2.302585092994046, 
                182.37383567556475`}]}}], {{{1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{2.995732273553991, 430.4281041096992}, 
               Offset[{3, 0}, {2.995732273553991, 430.4281041096992}]}, {{
               2.995732273553991, 430.4281041096992}, 
               Offset[{-3, 0}, {2.995732273553991, 430.4281041096992}]}, {{
               2.995732273553991, 373.30522922363417`}, 
               Offset[{3, 0}, {2.995732273553991, 373.30522922363417`}]}, {{
               2.995732273553991, 373.30522922363417`}, 
               Offset[{-3, 0}, {2.995732273553991, 
                373.30522922363417`}]}}], {{{1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{3.912023005428146, 552.1417352509798}, 
               Offset[{3, 0}, {3.912023005428146, 552.1417352509798}]}, {{
               3.912023005428146, 552.1417352509798}, 
               Offset[{-3, 0}, {3.912023005428146, 552.1417352509798}]}, {{
               3.912023005428146, 477.35826474902024`}, 
               Offset[{3, 0}, {3.912023005428146, 477.35826474902024`}]}, {{
               3.912023005428146, 477.35826474902024`}, 
               Offset[{-3, 0}, {3.912023005428146, 
                477.35826474902024`}]}}], {{{1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{4.605170185988092, 702.8169515824238}, 
               Offset[{3, 0}, {4.605170185988092, 702.8169515824238}]}, {{
               4.605170185988092, 702.8169515824238}, 
               Offset[{-3, 0}, {4.605170185988092, 702.8169515824238}]}, {{
               4.605170185988092, 596.7386039731318}, 
               Offset[{3, 0}, {4.605170185988092, 596.7386039731318}]}, {{
               4.605170185988092, 596.7386039731318}, 
               Offset[{-3, 0}, {4.605170185988092, 596.7386039731318}]}}], {{{
             1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{5.298317366548036, 707.4643304481499}, 
               Offset[{3, 0}, {5.298317366548036, 707.4643304481499}]}, {{
               5.298317366548036, 707.4643304481499}, 
               Offset[{-3, 0}, {5.298317366548036, 707.4643304481499}]}, {{
               5.298317366548036, 613.1510541672346}, 
               Offset[{3, 0}, {5.298317366548036, 613.1510541672346}]}, {{
               5.298317366548036, 613.1510541672346}, 
               Offset[{-3, 0}, {5.298317366548036, 613.1510541672346}]}}], {{{
             1., 0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}, 
        {RGBColor[0, 0, 1], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{6.907755278982137, 728.}, 
               Offset[{3, 0}, {6.907755278982137, 728.}]}, {{
               6.907755278982137, 728.}, 
               Offset[{-3, 0}, {6.907755278982137, 728.}]}, {{
               6.907755278982137, 664.}, 
               Offset[{3, 0}, {6.907755278982137, 664.}]}, {{
               6.907755278982137, 664.}, 
               Offset[{-3, 0}, {6.907755278982137, 664.}]}}], {{{1., 0.}, {0.,
              1.}}, {0., 0.}}]},
          Antialiasing->False,
          FontSize->14,
          FontName -> "Times New Roman"]}}}}, {{{}, {}, 
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[
         LineBox[{{1.6094379124341003`, 94.}, {2.302585092994046, 209.6}, {
          2.995732273553991, 266.8}, {3.912023005428146, 280.3448275862069}, {
          4.605170185988092, 282.17391304347825`}, {5.298317366548036, 
          315.45454545454544`}, {6.214608098422191, 343.7037037037037}}],
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[0, 1, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[
         LineBox[{{1.6094379124341003`, 48.63333333333333}, {
          2.302585092994046, 355.6333333333333}}],
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[0, 0, 1], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[
         LineBox[{{1.6094379124341003`, 43.53333333333333}, {
          2.302585092994046, 198.}, {2.995732273553991, 401.8666666666667}, {
          3.912023005428146, 514.75}, {4.605170185988092, 
          649.7777777777778}, {5.298317366548036, 660.3076923076923}, {
          6.214608098422191, 929.}, {6.907755278982137, 696.}}],
         FontSize->14,
         FontName -> "Times New Roman"]}}, {
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[0, 1, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[0, 0, 1], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}}, {
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[0, 1, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[0, 0, 1], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[0, 1, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> "Times New Roman"]}, 
       {RGBColor[0, 0, 1], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        CapForm["Butt"], 
        StyleBox[{},
         FontSize->14,
         FontName -> 
         "Times New Roman"]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, 
    InsetBox[
     TemplateBox[{"\"QRNN\"", "\"RNN\"", "\"LSTM\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               GraphicsBox[{{
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6], FontName -> "Times New Roman", 
                   FontSize -> 14, 
                   RGBColor[1, 0, 0]], {
                   LineBox[{{0, 10}, {20, 10}}]}}, {
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6], FontName -> "Times New Roman", 
                   FontSize -> 14, 
                   RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                ImageSize -> {20, 10}, PlotRangePadding -> None, ImagePadding -> 
                Automatic, 
                BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
               GraphicsBox[{{
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6], FontName -> "Times New Roman", 
                   FontSize -> 14, 
                   RGBColor[0, 1, 0]], {
                   LineBox[{{0, 10}, {20, 10}}]}}, {
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6], FontName -> "Times New Roman", 
                   FontSize -> 14, 
                   RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                ImageSize -> {20, 10}, PlotRangePadding -> None, ImagePadding -> 
                Automatic, 
                BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
               GraphicsBox[{{
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6], FontName -> "Times New Roman", 
                   FontSize -> 14, 
                   RGBColor[0, 0, 1]], {
                   LineBox[{{0, 10}, {20, 10}}]}}, {
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6], FontName -> "Times New Roman", 
                   FontSize -> 14, 
                   RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                ImageSize -> {20, 10}, PlotRangePadding -> None, ImagePadding -> 
                Automatic, 
                BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> False,
              GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Times"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                   RowBox[{"CapForm", "[", "\"Butt\"", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"FontName", "\[Rule]", "\"Times New Roman\""}], 
                   ",", 
                   RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                   RowBox[{"CapForm", "[", "\"Butt\"", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"FontName", "\[Rule]", "\"Times New Roman\""}], 
                   ",", 
                   RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["7", "360"], "]"}], ",", 
                   RowBox[{"CapForm", "[", "\"Butt\"", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"FontName", "\[Rule]", "\"Times New Roman\""}], 
                   ",", 
                   RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"FontFamily", "\[Rule]", "\"Times\""}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "table"}]}], "]"}]& )], 
     Scaled[{0.1, 0.6}], ImageScaled[{0.1, 0.1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->0.6,
   Axes->{False, False},
   AxesLabel->{None, None},
   AxesOrigin->{1.4990563006310162`, 0},
   BaseStyle->Directive[{
      GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"training steps\"", TraditionalForm], None}, {
      FormBox["\"sequence length\"", TraditionalForm], None}},
   FrameStyle->GrayLevel[0],
   FrameTicks->FrontEndValueCache[{{Automatic, Automatic}, {Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
       Charting`ScaledFrameTicks[{Log, Exp}]}}, {{
      Automatic, Automatic}, {{{1.6094379124341003`, 
         FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
         FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
         FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
         FormBox["100", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
         FormBox["500", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
         FormBox["1000", TraditionalForm], {0.01, 0.}}, {1.791759469228055, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.4011973816621555`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.6888794541139363`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.0943445622221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.248495242049359, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.382026634673881, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.499809670330265, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.298317366548036, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.703782474656201, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.991464547107982, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.396929655216146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.551080335043404, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.684611727667927, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.802394763324311, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        7.600902459542082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.006367567650246, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.294049640102028, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.517193191416238, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.612503371220562, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.699514748210191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.779557455883728, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}}, {{1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        2.302585092994046, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        4.605170185988092, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        6.214608098422191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        6.907755278982137, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.4011973816621555`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.6888794541139363`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.0943445622221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.248495242049359, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.382026634673881, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.499809670330265, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.298317366548036, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.703782474656201, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        5.991464547107982, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.396929655216146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.551080335043404, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.684611727667927, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        6.802394763324311, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        7.600902459542082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.006367567650246, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.294049640102028, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.517193191416238, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.612503371220562, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.699514748210191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        8.779557455883728, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
   GridLines->{None, Automatic},
   GridLinesStyle->Directive[
     GrayLevel[0.4, 0.5], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{1, 2}]],
   ImageSize->300,
   LabelStyle->{FontFamily -> "Times"},
   Method->{
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         Exp[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Exp[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& )}},
   PlotRange->{{1.4990563006310162`, 6.907755278982137}, {0, 929.}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.05]}},
   Ticks->{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{{{{Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], {}, {
           
           Line[{{1.6094379124341003`, 86.73490473597198}, {
            1.6094379124341003`, 94.}}], 
           
           Line[{{1.6094379124341003`, 94.}, {1.6094379124341003`, 
            101.26509526402802`}}]}}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], {}, {
           
           Line[{{2.302585092994046, 168.8876759035629}, {2.302585092994046, 
            209.6}}], 
           
           Line[{{2.302585092994046, 209.6}, {2.302585092994046, 
            250.3123240964371}}]}}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], {}, {
           
           Line[{{2.995732273553991, 223.7313725936539}, {2.995732273553991, 
            266.8}}], 
           
           Line[{{2.995732273553991, 266.8}, {2.995732273553991, 
            309.86862740634615`}}]}}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], {}, {
           
           Line[{{3.912023005428146, 245.66301296139065`}, {3.912023005428146,
             280.3448275862069}}], 
           
           Line[{{3.912023005428146, 280.3448275862069}, {3.912023005428146, 
            315.0266422110232}}]}}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], {}, {
           
           Line[{{4.605170185988092, 247.00657438674614`}, {4.605170185988092,
             282.17391304347825`}}], 
           
           Line[{{4.605170185988092, 282.17391304347825`}, {4.605170185988092,
             317.34125170021036`}}]}}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], {}, {
           
           Line[{{5.298317366548036, 272.73970891124475`}, {5.298317366548036,
             315.45454545454544`}}], 
           
           Line[{{5.298317366548036, 315.45454545454544`}, {5.298317366548036,
             358.16938199784613`}}]}}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], {}, {
           
           Line[{{6.214608098422191, 307.4191832580118}, {6.214608098422191, 
            343.7037037037037}}], 
           
           Line[{{6.214608098422191, 343.7037037037037}, {6.214608098422191, 
            379.9882241493956}}]}}}, {{Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 1, 0]], {}, {
           
           Line[{{1.6094379124341003`, 47.42752046463044}, {
            1.6094379124341003`, 48.63333333333333}}], 
           
           Line[{{1.6094379124341003`, 48.63333333333333}, {
            1.6094379124341003`, 49.839146202036225`}}]}}, {
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 1, 0]], {}, {
           
           Line[{{2.302585092994046, 341.7428351890147}, {2.302585092994046, 
            355.6333333333333}}], 
           
           Line[{{2.302585092994046, 355.6333333333333}, {2.302585092994046, 
            369.5238314776519}}]}}}, {{Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], {}, {
           
           Line[{{1.6094379124341003`, 41.46566579667624}, {
            1.6094379124341003`, 43.53333333333333}}], 
           
           Line[{{1.6094379124341003`, 43.53333333333333}, {
            1.6094379124341003`, 45.60100086999042}}]}}, {
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], {}, {
           
           Line[{{2.302585092994046, 182.37383567556475`}, {2.302585092994046,
             198.}}], 
           
           Line[{{2.302585092994046, 198.}, {2.302585092994046, 
            213.62616432443525`}}]}}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], {}, {
           Line[{{2.995732273553991, 373.30522922363417`}, {2.995732273553991,
             401.8666666666667}}], 
           
           Line[{{2.995732273553991, 401.8666666666667}, {2.995732273553991, 
            430.4281041096992}}]}}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], {}, {
           
           Line[{{3.912023005428146, 477.35826474902024`}, {3.912023005428146,
             514.75}}], 
           
           Line[{{3.912023005428146, 514.75}, {3.912023005428146, 
            552.1417352509798}}]}}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], {}, {
           
           Line[{{4.605170185988092, 596.7386039731318}, {4.605170185988092, 
            649.7777777777778}}], 
           
           Line[{{4.605170185988092, 649.7777777777778}, {4.605170185988092, 
            702.8169515824238}}]}}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], {}, {
           
           Line[{{5.298317366548036, 613.1510541672346}, {5.298317366548036, 
            660.3076923076923}}], 
           
           Line[{{5.298317366548036, 660.3076923076923}, {5.298317366548036, 
            707.4643304481499}}]}}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], {}, {
           Line[{{6.907755278982137, 664.}, {6.907755278982137, 696.}}], 
           
           Line[{{6.907755278982137, 696.}, {6.907755278982137, 
            728.}}]}}}}, {{{Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], 
          Rotate[
           Line[{}], 0., {1.6094379124341003`, 94.}], 
          Rotate[
           Line[{{{1.6094379124341003`, 101.26509526402802`}, 
              Offset[{3, 0}, {1.6094379124341003`, 101.26509526402802`}]}, {{
              1.6094379124341003`, 101.26509526402802`}, 
              Offset[{-3, 0}, {1.6094379124341003`, 101.26509526402802`}]}, {{
              1.6094379124341003`, 86.73490473597198}, 
              Offset[{3, 0}, {1.6094379124341003`, 86.73490473597198}]}, {{
              1.6094379124341003`, 86.73490473597198}, 
              Offset[{-3, 0}, {1.6094379124341003`, 86.73490473597198}]}}], 
           0., {1.6094379124341003`, 94.}]}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], 
          Rotate[
           Line[{}], 0., {2.302585092994046, 209.6}], 
          Rotate[
           Line[{{{2.302585092994046, 250.3123240964371}, 
              Offset[{3, 0}, {2.302585092994046, 250.3123240964371}]}, {{
              2.302585092994046, 250.3123240964371}, 
              Offset[{-3, 0}, {2.302585092994046, 250.3123240964371}]}, {{
              2.302585092994046, 168.8876759035629}, 
              Offset[{3, 0}, {2.302585092994046, 168.8876759035629}]}, {{
              2.302585092994046, 168.8876759035629}, 
              Offset[{-3, 0}, {2.302585092994046, 168.8876759035629}]}}], 
           0., {2.302585092994046, 209.6}]}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], 
          Rotate[
           Line[{}], 0., {2.995732273553991, 266.8}], 
          Rotate[
           Line[{{{2.995732273553991, 309.86862740634615`}, 
              Offset[{3, 0}, {2.995732273553991, 309.86862740634615`}]}, {{
              2.995732273553991, 309.86862740634615`}, 
              Offset[{-3, 0}, {2.995732273553991, 309.86862740634615`}]}, {{
              2.995732273553991, 223.7313725936539}, 
              Offset[{3, 0}, {2.995732273553991, 223.7313725936539}]}, {{
              2.995732273553991, 223.7313725936539}, 
              Offset[{-3, 0}, {2.995732273553991, 223.7313725936539}]}}], 
           0., {2.995732273553991, 266.8}]}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], 
          Rotate[
           Line[{}], 0., {3.912023005428146, 280.3448275862069}], 
          Rotate[
           Line[{{{3.912023005428146, 315.0266422110232}, 
              Offset[{3, 0}, {3.912023005428146, 315.0266422110232}]}, {{
              3.912023005428146, 315.0266422110232}, 
              Offset[{-3, 0}, {3.912023005428146, 315.0266422110232}]}, {{
              3.912023005428146, 245.66301296139065`}, 
              Offset[{3, 0}, {3.912023005428146, 245.66301296139065`}]}, {{
              3.912023005428146, 245.66301296139065`}, 
              Offset[{-3, 0}, {3.912023005428146, 245.66301296139065`}]}}], 
           0., {3.912023005428146, 280.3448275862069}]}, {
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], 
          Rotate[
           Line[{}], 0., {4.605170185988092, 282.17391304347825`}], 
          Rotate[
           Line[{{{4.605170185988092, 317.34125170021036`}, 
              Offset[{3, 0}, {4.605170185988092, 317.34125170021036`}]}, {{
              4.605170185988092, 317.34125170021036`}, 
              Offset[{-3, 0}, {4.605170185988092, 317.34125170021036`}]}, {{
              4.605170185988092, 247.00657438674614`}, 
              Offset[{3, 0}, {4.605170185988092, 247.00657438674614`}]}, {{
              4.605170185988092, 247.00657438674614`}, 
              Offset[{-3, 0}, {4.605170185988092, 247.00657438674614`}]}}], 
           0., {4.605170185988092, 282.17391304347825`}]}, {
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], 
          Rotate[
           Line[{}], 0., {5.298317366548036, 315.45454545454544`}], 
          Rotate[
           Line[{{{5.298317366548036, 358.16938199784613`}, 
              Offset[{3, 0}, {5.298317366548036, 358.16938199784613`}]}, {{
              5.298317366548036, 358.16938199784613`}, 
              Offset[{-3, 0}, {5.298317366548036, 358.16938199784613`}]}, {{
              5.298317366548036, 272.73970891124475`}, 
              Offset[{3, 0}, {5.298317366548036, 272.73970891124475`}]}, {{
              5.298317366548036, 272.73970891124475`}, 
              Offset[{-3, 0}, {5.298317366548036, 272.73970891124475`}]}}], 
           0., {5.298317366548036, 315.45454545454544`}]}, {
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[1, 0, 0]], 
          Rotate[
           Line[{}], 0., {6.214608098422191, 343.7037037037037}], 
          Rotate[
           Line[{{{6.214608098422191, 379.9882241493956}, 
              Offset[{3, 0}, {6.214608098422191, 379.9882241493956}]}, {{
              6.214608098422191, 379.9882241493956}, 
              Offset[{-3, 0}, {6.214608098422191, 379.9882241493956}]}, {{
              6.214608098422191, 307.4191832580118}, 
              Offset[{3, 0}, {6.214608098422191, 307.4191832580118}]}, {{
              6.214608098422191, 307.4191832580118}, 
              Offset[{-3, 0}, {6.214608098422191, 307.4191832580118}]}}], 
           0., {6.214608098422191, 343.7037037037037}]}}, {{
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 1, 0]], 
          Rotate[
           Line[{}], 0., {1.6094379124341003`, 48.63333333333333}], 
          Rotate[
           Line[{{{1.6094379124341003`, 49.839146202036225`}, 
              Offset[{3, 0}, {1.6094379124341003`, 49.839146202036225`}]}, {{
              1.6094379124341003`, 49.839146202036225`}, 
              Offset[{-3, 0}, {1.6094379124341003`, 49.839146202036225`}]}, {{
              1.6094379124341003`, 47.42752046463044}, 
              Offset[{3, 0}, {1.6094379124341003`, 47.42752046463044}]}, {{
              1.6094379124341003`, 47.42752046463044}, 
              Offset[{-3, 0}, {1.6094379124341003`, 47.42752046463044}]}}], 
           0., {1.6094379124341003`, 48.63333333333333}]}, {
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 1, 0]], 
          Rotate[
           Line[{}], 0., {2.302585092994046, 355.6333333333333}], 
          Rotate[
           Line[{{{2.302585092994046, 369.5238314776519}, 
              Offset[{3, 0}, {2.302585092994046, 369.5238314776519}]}, {{
              2.302585092994046, 369.5238314776519}, 
              Offset[{-3, 0}, {2.302585092994046, 369.5238314776519}]}, {{
              2.302585092994046, 341.7428351890147}, 
              Offset[{3, 0}, {2.302585092994046, 341.7428351890147}]}, {{
              2.302585092994046, 341.7428351890147}, 
              Offset[{-3, 0}, {2.302585092994046, 341.7428351890147}]}}], 
           0., {2.302585092994046, 355.6333333333333}]}}, {{
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], 
          Rotate[
           Line[{}], 0., {1.6094379124341003`, 43.53333333333333}], 
          Rotate[
           Line[{{{1.6094379124341003`, 45.60100086999042}, 
              Offset[{3, 0}, {1.6094379124341003`, 45.60100086999042}]}, {{
              1.6094379124341003`, 45.60100086999042}, 
              Offset[{-3, 0}, {1.6094379124341003`, 45.60100086999042}]}, {{
              1.6094379124341003`, 41.46566579667624}, 
              Offset[{3, 0}, {1.6094379124341003`, 41.46566579667624}]}, {{
              1.6094379124341003`, 41.46566579667624}, 
              Offset[{-3, 0}, {1.6094379124341003`, 41.46566579667624}]}}], 
           0., {1.6094379124341003`, 43.53333333333333}]}, {
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], 
          Rotate[
           Line[{}], 0., {2.302585092994046, 198.}], 
          Rotate[
           Line[{{{2.302585092994046, 213.62616432443525`}, 
              Offset[{3, 0}, {2.302585092994046, 213.62616432443525`}]}, {{
              2.302585092994046, 213.62616432443525`}, 
              Offset[{-3, 0}, {2.302585092994046, 213.62616432443525`}]}, {{
              2.302585092994046, 182.37383567556475`}, 
              Offset[{3, 0}, {2.302585092994046, 182.37383567556475`}]}, {{
              2.302585092994046, 182.37383567556475`}, 
              Offset[{-3, 0}, {2.302585092994046, 182.37383567556475`}]}}], 
           0., {2.302585092994046, 198.}]}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], 
          Rotate[
           Line[{}], 0., {2.995732273553991, 401.8666666666667}], 
          Rotate[
           Line[{{{2.995732273553991, 430.4281041096992}, 
              Offset[{3, 0}, {2.995732273553991, 430.4281041096992}]}, {{
              2.995732273553991, 430.4281041096992}, 
              Offset[{-3, 0}, {2.995732273553991, 430.4281041096992}]}, {{
              2.995732273553991, 373.30522922363417`}, 
              Offset[{3, 0}, {2.995732273553991, 373.30522922363417`}]}, {{
              2.995732273553991, 373.30522922363417`}, 
              Offset[{-3, 0}, {2.995732273553991, 373.30522922363417`}]}}], 
           0., {2.995732273553991, 401.8666666666667}]}, {
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], 
          Rotate[
           Line[{}], 0., {3.912023005428146, 514.75}], 
          Rotate[
           Line[{{{3.912023005428146, 552.1417352509798}, 
              Offset[{3, 0}, {3.912023005428146, 552.1417352509798}]}, {{
              3.912023005428146, 552.1417352509798}, 
              Offset[{-3, 0}, {3.912023005428146, 552.1417352509798}]}, {{
              3.912023005428146, 477.35826474902024`}, 
              Offset[{3, 0}, {3.912023005428146, 477.35826474902024`}]}, {{
              3.912023005428146, 477.35826474902024`}, 
              Offset[{-3, 0}, {3.912023005428146, 477.35826474902024`}]}}], 
           0., {3.912023005428146, 514.75}]}, {Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], 
          Rotate[
           Line[{}], 0., {4.605170185988092, 649.7777777777778}], 
          Rotate[
           Line[{{{4.605170185988092, 702.8169515824238}, 
              Offset[{3, 0}, {4.605170185988092, 702.8169515824238}]}, {{
              4.605170185988092, 702.8169515824238}, 
              Offset[{-3, 0}, {4.605170185988092, 702.8169515824238}]}, {{
              4.605170185988092, 596.7386039731318}, 
              Offset[{3, 0}, {4.605170185988092, 596.7386039731318}]}, {{
              4.605170185988092, 596.7386039731318}, 
              Offset[{-3, 0}, {4.605170185988092, 596.7386039731318}]}}], 
           0., {4.605170185988092, 649.7777777777778}]}, {
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], 
          Rotate[
           Line[{}], 0., {5.298317366548036, 660.3076923076923}], 
          Rotate[
           Line[{{{5.298317366548036, 707.4643304481499}, 
              Offset[{3, 0}, {5.298317366548036, 707.4643304481499}]}, {{
              5.298317366548036, 707.4643304481499}, 
              Offset[{-3, 0}, {5.298317366548036, 707.4643304481499}]}, {{
              5.298317366548036, 613.1510541672346}, 
              Offset[{3, 0}, {5.298317366548036, 613.1510541672346}]}, {{
              5.298317366548036, 613.1510541672346}, 
              Offset[{-3, 0}, {5.298317366548036, 613.1510541672346}]}}], 
           0., {5.298317366548036, 660.3076923076923}]}, {
         Antialiasing -> False, 
          Directive[
           CapForm["Butt"], FontName -> "Times New Roman", FontSize -> 14, 
           RGBColor[0, 0, 1]], 
          Rotate[
           Line[{}], 0., {6.907755278982137, 696.}], 
          Rotate[
           Line[{{{6.907755278982137, 728.}, 
              Offset[{3, 0}, {6.907755278982137, 728.}]}, {{6.907755278982137,
               728.}, 
              Offset[{-3, 0}, {6.907755278982137, 728.}]}, {{
              6.907755278982137, 664.}, 
              Offset[{3, 0}, {6.907755278982137, 664.}]}, {{6.907755278982137,
               664.}, 
              Offset[{-3, 0}, {6.907755278982137, 664.}]}}], 0., {
           6.907755278982137, 696.}]}}}}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[1, 0, 0]], 
         Line[{{1.6094379124341003`, 94.}, {2.302585092994046, 209.6}, {
          2.995732273553991, 266.8}, {3.912023005428146, 280.3448275862069}, {
          4.605170185988092, 282.17391304347825`}, {5.298317366548036, 
          315.45454545454544`}, {6.214608098422191, 343.7037037037037}}]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[0, 1, 0]], 
         Line[{{1.6094379124341003`, 48.63333333333333}, {2.302585092994046, 
          355.6333333333333}}]}, {
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[0, 0, 1]], 
         Line[{{1.6094379124341003`, 43.53333333333333}, {2.302585092994046, 
          198.}, {2.995732273553991, 401.8666666666667}, {3.912023005428146, 
          514.75}, {4.605170185988092, 649.7777777777778}, {5.298317366548036,
           660.3076923076923}, {6.214608098422191, 929.}, {6.907755278982137, 
          696.}}]}}, {{
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[1, 0, 0]]}, {
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[0, 1, 0]]}, {
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[0, 0, 1]]}}, {{
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[1, 0, 0]]}, {
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[0, 1, 0]]}, {
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[0, 0, 1]]}, {}, {}, {}, {}, {}, {}, {}}, {{
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[1, 0, 0]]}, {
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[0, 1, 0]]}, {
         Directive[
          PointSize[
           Rational[7, 360]], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
          14, 
          RGBColor[0, 0, 1]]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {}}}, {
     DisplayFunction -> Identity, DisplayFunction -> Identity, AspectRatio -> 
      0.6, Axes -> {False, False}, AxesLabel -> {None, None}, 
      AxesOrigin -> {1.4990563006310162`, 0}, BaseStyle -> Directive[{
         GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}], 
      DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"training steps", None}, {"sequence length", None}}, 
      FrameStyle -> GrayLevel[0], 
      FrameTicks -> {{Automatic, Automatic}, {Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
         Charting`ScaledFrameTicks[{Log, Exp}]}}, 
      GridLines -> {None, Automatic}, GridLinesStyle -> Directive[
        GrayLevel[0.4, 0.5], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{1, 2}]], ImageSize -> 300, 
      LabelStyle -> {FontFamily -> "Times"}, 
      Method -> {
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Exp[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Exp[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{1.4990563006310162`, 6.907755278982137}, {0, 929.}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.05]}}, Ticks -> {Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         PointSize[
          Rational[7, 360]], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
         14, 
         RGBColor[1, 0, 0]], 
        Directive[
         PointSize[
          Rational[7, 360]], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
         14, 
         RGBColor[0, 1, 0]], 
        Directive[
         PointSize[
          Rational[7, 360]], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6], FontName -> "Times New Roman", FontSize -> 
         14, 
         RGBColor[0, 0, 1]]}, {"QRNN", "RNN", "LSTM"}, 
       LegendMarkers -> {{False, Automatic}, {False, Automatic}, {
         False, Automatic}}, Joined -> {True, True, True}, 
       LabelStyle -> {FontFamily -> "Times"}, 
       LegendLayout -> $CellContext`table]], {
      Scaled[{0.1, 0.6}], {0.1, 0.1}}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.8002701094659166`*^9, {3.8002702153813295`*^9, 3.8002702321913652`*^9}, {
   3.8002702653925257`*^9, 3.800270269685508*^9}, 3.8002706350215597`*^9, 
   3.8002706767582026`*^9, {3.800270724925682*^9, 3.800270738039222*^9}, 
   3.8002708267156835`*^9, 3.8002708689099913`*^9, 3.800270919657358*^9, 
   3.8002709548216515`*^9, 3.8002710172636075`*^9, {3.8002710643293705`*^9, 
   3.80027109806019*^9}, 3.8002736950004463`*^9, 3.800278428044199*^9, 
   3.8002785142484584`*^9, {3.8002786685587535`*^9, 3.8002787112417555`*^9}, {
   3.800278813490038*^9, 3.800278819408271*^9}, 3.8002866089631014`*^9, 
   3.800300986293192*^9, {3.8003326417734375`*^9, 3.8003326482856064`*^9}, 
   3.8003327070936513`*^9, 3.8003330312225776`*^9, {3.800333258767476*^9, 
   3.8003332836736145`*^9}, {3.8003335497985744`*^9, 3.80033356790991*^9}, {
   3.8003337944482946`*^9, 3.8003338016771393`*^9}, {3.8003338348022757`*^9, 
   3.8003338546780977`*^9}, {3.80033407962211*^9, 3.8003340995885844`*^9}, 
   3.800334220453085*^9, {3.8003342834507113`*^9, 3.8003343267926407`*^9}, 
   3.8003343594879465`*^9, 3.8003344788020806`*^9, {3.800334509253855*^9, 
   3.8003345298963723`*^9}, 3.8003346489781485`*^9, 3.8003351955507965`*^9, 
   3.800335233721481*^9, {3.8003352974946933`*^9, 3.8003353018770914`*^9}, 
   3.8003355417733707`*^9, {3.8003356210892115`*^9, 3.800335684756571*^9}, {
   3.800335769589236*^9, 3.800335782411031*^9}, 3.8003358195208087`*^9, {
   3.800336110526966*^9, 3.800336220121481*^9}, 3.8003362643109236`*^9, {
   3.80033629594271*^9, 3.8003364142827625`*^9}, 3.800339063335169*^9, 
   3.800339097083478*^9, 3.8003520802164435`*^9, {3.8003580600569773`*^9, 
   3.800358068513706*^9}, 3.800358332136561*^9, {3.800358541532712*^9, 
   3.8003585460589867`*^9}, 3.8003586033200407`*^9, {3.8003586818907833`*^9, 
   3.800358711079549*^9}, 3.800358760236229*^9, {3.800358790849402*^9, 
   3.80035886878301*^9}, {3.8003589049729185`*^9, 3.8003589103561745`*^9}, 
   3.8003589489259043`*^9, 3.800360906795876*^9, 3.8008644025133376`*^9, 
   3.8008644380506268`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"cf20af14-322c-4f8a-88ea-a18a5d7f23ff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Optimizer", "Chapter",
 CellChangeTimes->{{3.8003566792140703`*^9, 
  3.800356684005611*^9}},ExpressionUUID->"70610b5e-b48f-4328-ac14-\
cd5d84de655a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataA", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
      "\"\<hparams_table_experiment1-A.csv\>\""}], ",", "\"\<Dataset\>\"", 
     ",", 
     RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataB", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
      "\"\<hparams_table_experiment1-B.csv\>\""}], ",", "\"\<Dataset\>\"", 
     ",", 
     RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataC", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
      "\"\<hparams_table_experiment1-C.csv\>\""}], ",", "\"\<Dataset\>\"", 
     ",", 
     RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8003567046096373`*^9, 3.800356709457397*^9}, 
   3.8003569554844832`*^9, 3.8003572694803553`*^9, {3.80035748828996*^9, 
   3.800357495552675*^9}, {3.8003575363693013`*^9, 3.800357546404068*^9}},
 CellLabel->
  "In[1162]:=",ExpressionUUID->"a8cdf916-15ca-4579-b8f5-5428bf17dfaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dataP", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"dataA", ",", "dataB", ",", "dataC"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.800356984590308*^9, 3.8003569857324595`*^9}, {
   3.800357551360344*^9, 3.800357558208337*^9}, {3.800357605426214*^9, 
   3.8003576547722692`*^9}, {3.8003576955470023`*^9, 3.800357745306599*^9}, 
   3.800358987598373*^9},
 CellLabel->
  "In[1165]:=",ExpressionUUID->"4bfaf213-b67a-401e-8d93-898259f89ba3"],

Cell[BoxData[
 TagBox[
  TagBox[
   DynamicModuleBox[{TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
    Association["InitialData" -> {
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 5., "hparams/validate_best" -> 
        0.35838788747787476`, "hparams/cer_best" -> 0.3684210479259491], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 1., "hparams/validate_best" -> 
        0.0004636049270629883, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 2., "hparams/validate_best" -> 
        0.0003135204315185547, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 10., "hparams/validate_best" -> 
        0.44370734691619873`, "hparams/cer_best" -> 0.3947368562221527], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.5, "hparams/validate_best" -> 
        0.06615287065505981, "hparams/cer_best" -> 0.02631578966975212], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.2, "hparams/validate_best" -> 
        0.23344850540161133`, "hparams/cer_best" -> 0.2368421107530594], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.1, "hparams/validate_best" -> 
        0.2129662036895752, "hparams/cer_best" -> 0.21052631735801697`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.05, "hparams/validate_best" -> 
        0.27811193466186523`, "hparams/cer_best" -> 0.2631579041481018], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.02, "hparams/validate_best" -> 
        0.2988194227218628, "hparams/cer_best" -> 0.28947368264198303`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.002, 
        "hparams/validate_best" -> 0.4771192669868469, "hparams/cer_best" -> 
        0.44736841320991516`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.005, 
        "hparams/validate_best" -> 0.46659886837005615`, "hparams/cer_best" -> 
        0.4736842215061188], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.01, "hparams/validate_best" -> 
        0.32821738719940186`, "hparams/cer_best" -> 0.31578946113586426`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.0002, 
        "hparams/validate_best" -> 0.5559812188148499, "hparams/cer_best" -> 
        0.5526315569877625], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.001, 
        "hparams/validate_best" -> 0.4868994355201721, "hparams/cer_best" -> 
        0.42105263471603394`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.0005, 
        "hparams/validate_best" -> 0.505466639995575, "hparams/cer_best" -> 
        0.4736842215061188], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.0001, 
        "hparams/validate_best" -> 0.5934625864028931, "hparams/cer_best" -> 
        0.5526315569877625], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.00005, 
        "hparams/validate_best" -> 0.6843966841697693, "hparams/cer_best" -> 
        0.6315789222717285], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.00002, 
        "hparams/validate_best" -> 0.7176473736763, "hparams/cer_best" -> 
        0.7631579041481018], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.00001, 
        "hparams/validate_best" -> 0.7285641431808472, "hparams/cer_best" -> 
        0.7105262875556946], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 5., 
        "hparams/validate_best" -> 0.33544957637786865`, "hparams/cer_best" -> 
        0.34210526943206787`], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 1., 
        "hparams/validate_best" -> 0.3301984667778015, "hparams/cer_best" -> 
        0.31578946113586426`], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.2, 
        "hparams/validate_best" -> 0.0007100105285644531, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 2., 
        "hparams/validate_best" -> 0.44154173135757446`, "hparams/cer_best" -> 
        0.5263158082962036], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 10., 
        "hparams/validate_best" -> 0.4019968509674072, "hparams/cer_best" -> 
        0.4736842215061188], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.5, 
        "hparams/validate_best" -> 0.00005900859832763672, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.1, 
        "hparams/validate_best" -> 0.0000966191291809082, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.05, 
        "hparams/validate_best" -> 0.00032889842987060547`, 
        "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.02, 
        "hparams/validate_best" -> 0.047122955322265625`, "hparams/cer_best" -> 
        0.02631578966975212], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.01, 
        "hparams/validate_best" -> 0.026366710662841797`, "hparams/cer_best" -> 
        0.02631578966975212], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.002, 
        "hparams/validate_best" -> 0.026998579502105713`, "hparams/cer_best" -> 
        0.02631578966975212], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.005, 
        "hparams/validate_best" -> 0.0004609227180480957, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.001, 
        "hparams/validate_best" -> 0.03139293193817139, "hparams/cer_best" -> 
        0.02631578966975212], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.0005, 
        "hparams/validate_best" -> 0.1360480785369873, "hparams/cer_best" -> 
        0.1315789520740509], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.0002, 
        "hparams/validate_best" -> 0.3319500684738159, "hparams/cer_best" -> 
        0.31578946113586426`], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.00005, 
        "hparams/validate_best" -> 0.5302981734275818, "hparams/cer_best" -> 
        0.4736842215061188], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.00002, 
        "hparams/validate_best" -> 0.6561363339424133, "hparams/cer_best" -> 
        0.5789473652839661], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.0001, 
        "hparams/validate_best" -> 0.4138845205307007, "hparams/cer_best" -> 
        0.3684210479259491], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.00001, 
        "hparams/validate_best" -> 0.7015594840049744, "hparams/cer_best" -> 
        0.6578947305679321], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 10., "hparams/validate_best" -> 
        0.37605810165405273`, "hparams/cer_best" -> 0.42105263471603394`], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 5., "hparams/validate_best" -> 
        0.45173370838165283`, "hparams/cer_best" -> 0.44736841320991516`], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 2., "hparams/validate_best" -> 
        0.30686336755752563`, "hparams/cer_best" -> 0.18421052396297455`], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 1., "hparams/validate_best" -> 
        0.018461167812347412`, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.5, "hparams/validate_best" -> 
        0.0006042122840881348, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.2, "hparams/validate_best" -> 
        0.00020569562911987305`, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.1, "hparams/validate_best" -> 
        0.0001061558723449707, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.05, 
        "hparams/validate_best" -> 0.00021076202392578125`, 
        "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.02, 
        "hparams/validate_best" -> 0.0009015798568725586, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.01, 
        "hparams/validate_best" -> 0.02742105722427368, "hparams/cer_best" -> 
        0.02631578966975212], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.005, 
        "hparams/validate_best" -> 0.036813318729400635`, "hparams/cer_best" -> 
        0.02631578966975212], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.002, 
        "hparams/validate_best" -> 0.03327864408493042, "hparams/cer_best" -> 
        0.02631578966975212], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.001, 
        "hparams/validate_best" -> 0.13520896434783936`, "hparams/cer_best" -> 
        0.1315789520740509], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.0005, 
        "hparams/validate_best" -> 0.16276639699935913`, "hparams/cer_best" -> 
        0.1315789520740509], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.0002, 
        "hparams/validate_best" -> 0.36274850368499756`, "hparams/cer_best" -> 
        0.31578946113586426`], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.0001, 
        "hparams/validate_best" -> 0.4793527126312256, "hparams/cer_best" -> 
        0.44736841320991516`], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.00005, 
        "hparams/validate_best" -> 0.5518456101417542, "hparams/cer_best" -> 
        0.5263158082962036], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.00002, 
        "hparams/validate_best" -> 0.6695111393928528, "hparams/cer_best" -> 
        0.6315789222717285], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.00001, 
        "hparams/validate_best" -> 0.7070858478546143, "hparams/cer_best" -> 
        0.7105262875556946], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 10., "hparams/validate_best" -> 
        0.6293835639953613, "hparams/cer_best" -> 0.6052631735801697], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 5., "hparams/validate_best" -> 
        0.44244247674942017`, "hparams/cer_best" -> 0.42105263471603394`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 2., "hparams/validate_best" -> 
        0.28242504596710205`, "hparams/cer_best" -> 0.28947368264198303`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.5, "hparams/validate_best" -> 
        0.5810741782188416, "hparams/cer_best" -> 0.6052631735801697], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.2, "hparams/validate_best" -> 
        0.5805003643035889, "hparams/cer_best" -> 0.6052631735801697], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.02, "hparams/validate_best" -> 
        0.7945024371147156, "hparams/cer_best" -> 0.7894737124443054], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.005, 
        "hparams/validate_best" -> 0.8141453266143799, "hparams/cer_best" -> 
        0.8157894611358643], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.01, "hparams/validate_best" -> 
        0.8087209463119507, "hparams/cer_best" -> 0.8157894611358643], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.00002, 
        "hparams/validate_best" -> 0.8344482183456421, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.0002, 
        "hparams/validate_best" -> 0.834784209728241, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 5., 
        "hparams/validate_best" -> 0.5215714573860168, "hparams/cer_best" -> 
        0.5263158082962036], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.00001, 
        "hparams/validate_best" -> 0.8344292640686035, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 10., 
        "hparams/validate_best" -> 0.4746641516685486, "hparams/cer_best" -> 
        0.4736842215061188], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 2., 
        "hparams/validate_best" -> 0.5697699189186096, "hparams/cer_best" -> 
        0.5789473652839661], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 1., 
        "hparams/validate_best" -> 0.3345615267753601, "hparams/cer_best" -> 
        0.34210526943206787`], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.5, 
        "hparams/validate_best" -> 0.0017167925834655762`, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.001, 
        "hparams/validate_best" -> 0.8291847109794617, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.2, 
        "hparams/validate_best" -> 0.09906738996505737, "hparams/cer_best" -> 
        0.10526315867900848`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.1, "hparams/validate_best" -> 
        0.6484790444374084, "hparams/cer_best" -> 0.6578947305679321], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.002, 
        "hparams/validate_best" -> 0.8345987796783447, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.05, "hparams/validate_best" -> 
        0.7447186708450317, "hparams/cer_best" -> 0.7631579041481018], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 1., "hparams/validate_best" -> 
        0.001121819019317627, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.0001, 
        "hparams/validate_best" -> 0.8346111178398132, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.00005, 
        "hparams/validate_best" -> 0.8345140218734741, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.0005, 
        "hparams/validate_best" -> 0.8348957300186157, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.1, 
        "hparams/validate_best" -> 0.00021791458129882812`, 
        "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.05, 
        "hparams/validate_best" -> 0.00023216009140014648`, 
        "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.02, 
        "hparams/validate_best" -> 0.00015717744827270508`, 
        "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.01, 
        "hparams/validate_best" -> 0.10646235942840576`, "hparams/cer_best" -> 
        0.10526315867900848`], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.005, 
        "hparams/validate_best" -> 0.4766218066215515, "hparams/cer_best" -> 
        0.5], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.002, 
        "hparams/validate_best" -> 0.497312068939209, "hparams/cer_best" -> 
        0.5], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.001, 
        "hparams/validate_best" -> 0.6094695329666138, "hparams/cer_best" -> 
        0.6315789222717285], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.0005, 
        "hparams/validate_best" -> 0.6087127923965454, "hparams/cer_best" -> 
        0.6315789222717285], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.0002, 
        "hparams/validate_best" -> 0.6201549172401428, "hparams/cer_best" -> 
        0.6315789222717285], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.0001, 
        "hparams/validate_best" -> 0.6880305409431458, "hparams/cer_best" -> 
        0.6842105388641357], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.00005, 
        "hparams/validate_best" -> 0.8308834433555603, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.00002, 
        "hparams/validate_best" -> 0.8357657194137573, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.00001, 
        "hparams/validate_best" -> 0.8342432975769043, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 10., "hparams/validate_best" -> 
        0.46917325258255005`, "hparams/cer_best" -> 0.42105263471603394`], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 5., "hparams/validate_best" -> 
        0.4213396906852722, "hparams/cer_best" -> 0.44736841320991516`], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 2., "hparams/validate_best" -> 
        0.5640290975570679, "hparams/cer_best" -> 0.5789473652839661], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 1., "hparams/validate_best" -> 
        0.10687839984893799`, "hparams/cer_best" -> 0.1315789520740509], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.5, "hparams/validate_best" -> 
        0.001000046730041504, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.2, "hparams/validate_best" -> 
        0.0001290440559387207, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.1, "hparams/validate_best" -> 
        0.00044721364974975586`, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.05, 
        "hparams/validate_best" -> 0.0010342001914978027`, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.02, 
        "hparams/validate_best" -> 0.15217489004135132`, "hparams/cer_best" -> 
        0.15789473056793213`], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.01, 
        "hparams/validate_best" -> 0.4774254560470581, "hparams/cer_best" -> 
        0.5], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.005, 
        "hparams/validate_best" -> 0.005885064601898193, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.002, 
        "hparams/validate_best" -> 0.4889744520187378, "hparams/cer_best" -> 
        0.5], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.001, 
        "hparams/validate_best" -> 0.6073241829872131, "hparams/cer_best" -> 
        0.6315789222717285], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.0005, 
        "hparams/validate_best" -> 0.6123048067092896, "hparams/cer_best" -> 
        0.6315789222717285], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.0002, 
        "hparams/validate_best" -> 0.6296093463897705, "hparams/cer_best" -> 
        0.6315789222717285], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.0001, 
        "hparams/validate_best" -> 0.7000554203987122, "hparams/cer_best" -> 
        0.6842105388641357], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.00005, 
        "hparams/validate_best" -> 0.8371926546096802, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.00002, 
        "hparams/validate_best" -> 0.834351122379303, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.00001, 
        "hparams/validate_best" -> 0.8335968255996704, "hparams/cer_best" -> 
        0.8421052694320679], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 10., "hparams/validate_best" -> 
        0.5606086254119873, "hparams/cer_best" -> 0.5], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 2., "hparams/validate_best" -> 
        0.00013184547424316406`, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.5, "hparams/validate_best" -> 
        0.0004837512969970703, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 1., "hparams/validate_best" -> 
        0.0004419088363647461, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.05, "hparams/validate_best" -> 
        0.00372922420501709, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 5., "hparams/validate_best" -> 
        0.5071831941604614, "hparams/cer_best" -> 0.5263158082962036], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.005, 
        "hparams/validate_best" -> 0.13508981466293335`, "hparams/cer_best" -> 
        0.1315789520740509], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.1, "hparams/validate_best" -> 
        0.0011677742004394531`, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.002, 
        "hparams/validate_best" -> 0.16330569982528687`, "hparams/cer_best" -> 
        0.18421052396297455`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.001, 
        "hparams/validate_best" -> 0.37255293130874634`, "hparams/cer_best" -> 
        0.31578946113586426`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.01, "hparams/validate_best" -> 
        0.0600583553314209, "hparams/cer_best" -> 0.05263157933950424], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.02, "hparams/validate_best" -> 
        0.02902120351791382, "hparams/cer_best" -> 0.02631578966975212], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.00005, 
        "hparams/validate_best" -> 0.55452561378479, "hparams/cer_best" -> 
        0.5526315569877625], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.0005, 
        "hparams/validate_best" -> 0.45475929975509644`, "hparams/cer_best" -> 
        0.44736841320991516`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.2, "hparams/validate_best" -> 
        0.0012406110763549805`, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.0002, 
        "hparams/validate_best" -> 0.46443837881088257`, "hparams/cer_best" -> 
        0.44736841320991516`], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.0001, 
        "hparams/validate_best" -> 0.5274598598480225, "hparams/cer_best" -> 
        0.4736842215061188], 
       Association[
       "optimizer" -> "sgd", "learning_rate" -> 0.00002, 
        "hparams/validate_best" -> 0.6136759519577026, "hparams/cer_best" -> 
        0.5526315569877625], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 10., 
        "hparams/validate_best" -> 0.6345036029815674, "hparams/cer_best" -> 
        0.7105262875556946], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 2., 
        "hparams/validate_best" -> 0.4722258448600769, "hparams/cer_best" -> 
        0.5], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 1., 
        "hparams/validate_best" -> 0.5394635796546936, "hparams/cer_best" -> 
        0.5263158082962036], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.5, 
        "hparams/validate_best" -> 0.36936575174331665`, "hparams/cer_best" -> 
        0.42105263471603394`], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 5., 
        "hparams/validate_best" -> 0.46163731813430786`, "hparams/cer_best" -> 
        0.4736842215061188], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.2, 
        "hparams/validate_best" -> 0.00014513731002807617`, 
        "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.1, 
        "hparams/validate_best" -> 0.00018614530563354492`, 
        "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.05, 
        "hparams/validate_best" -> 0.00008755922317504883, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.02, 
        "hparams/validate_best" -> 0.0000336766242980957, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.01, 
        "hparams/validate_best" -> 0.000011801719665527344`, 
        "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.002, 
        "hparams/validate_best" -> 0.00020235776901245117`, 
        "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.005, 
        "hparams/validate_best" -> 0.000044405460357666016`, 
        "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.001, 
        "hparams/validate_best" -> 0.0006769895553588867, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.0005, 
        "hparams/validate_best" -> 0.024120092391967773`, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.0002, 
        "hparams/validate_best" -> 0.04504185914993286, "hparams/cer_best" -> 
        0.02631578966975212], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.0001, 
        "hparams/validate_best" -> 0.14051812887191772`, "hparams/cer_best" -> 
        0.1315789520740509], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.00005, 
        "hparams/validate_best" -> 0.23763394355773926`, "hparams/cer_best" -> 
        0.18421052396297455`], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.00002, 
        "hparams/validate_best" -> 0.41353893280029297`, "hparams/cer_best" -> 
        0.3684210479259491], 
       Association[
       "optimizer" -> "rmsprop", "learning_rate" -> 0.00001, 
        "hparams/validate_best" -> 0.48448389768600464`, "hparams/cer_best" -> 
        0.4736842215061188], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 10., "hparams/validate_best" -> 
        0.5560092329978943, "hparams/cer_best" -> 0.6578947305679321], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 5., "hparams/validate_best" -> 
        0.4796062111854553, "hparams/cer_best" -> 0.5263158082962036], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 2., "hparams/validate_best" -> 
        0.6299775242805481, "hparams/cer_best" -> 0.6052631735801697], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 1., "hparams/validate_best" -> 
        0.41197288036346436`, "hparams/cer_best" -> 0.5526315569877625], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.5, "hparams/validate_best" -> 
        0.004891693592071533, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.2, "hparams/validate_best" -> 
        0.0003662109375, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.1, "hparams/validate_best" -> 
        0.000055909156799316406`, "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.05, 
        "hparams/validate_best" -> 0.0001627802848815918, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.02, 
        "hparams/validate_best" -> 0.00005733966827392578, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.01, 
        "hparams/validate_best" -> 0.00010102987289428711`, 
        "hparams/cer_best" -> 0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.005, 
        "hparams/validate_best" -> 0.0001881122589111328, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.002, 
        "hparams/validate_best" -> 0.001383662223815918, "hparams/cer_best" -> 
        0.], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.001, 
        "hparams/validate_best" -> 0.024991869926452637`, "hparams/cer_best" -> 
        0.02631578966975212], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.0005, 
        "hparams/validate_best" -> 0.032344937324523926`, "hparams/cer_best" -> 
        0.02631578966975212], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.0002, 
        "hparams/validate_best" -> 0.13488125801086426`, "hparams/cer_best" -> 
        0.1315789520740509], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.0001, 
        "hparams/validate_best" -> 0.15483897924423218`, "hparams/cer_best" -> 
        0.1315789520740509], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.00005, 
        "hparams/validate_best" -> 0.32087230682373047`, "hparams/cer_best" -> 
        0.31578946113586426`], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.00002, 
        "hparams/validate_best" -> 0.4598618149757385, "hparams/cer_best" -> 
        0.42105263471603394`], 
       Association[
       "optimizer" -> "adam", "learning_rate" -> 0.00001, 
        "hparams/validate_best" -> 0.4919767379760742, "hparams/cer_best" -> 
        0.4736842215061188]}, "InitialShape" -> 
     TypeSystem`PackageScope`HeaderShape[
       Association[{All, "optimizer"} -> 1, {All, "learning_rate"} -> 
        1, {All, "hparams/validate_best"} -> 1, {All, "hparams/cer_best"} -> 
        1], 
       TypeSystem`PackageScope`Limited[
        TypeSystem`PackageScope`ColumnShape[
         TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`RowShape[
           Association[
           "optimizer" -> TypeSystem`PackageScope`AtomShape[63.], 
            "learning_rate" -> TypeSystem`PackageScope`AtomShape[60], 
            "hparams/validate_best" -> TypeSystem`PackageScope`AtomShape[60], 
            "hparams/cer_best" -> TypeSystem`PackageScope`AtomShape[60]]], 
          DirectedInfinity[1], 4, {All}]], 20, 
        DirectedInfinity[1], {}]], "InitialType" -> TypeSystem`Vector[
       TypeSystem`Struct[{
        "optimizer", "learning_rate", "hparams/validate_best", 
         "hparams/cer_best"}, {
         TypeSystem`Atom[
          TypeSystem`Enumeration["adam", "rmsprop", "sgd"]], 
         TypeSystem`Atom[Real], 
         TypeSystem`Atom[Real], 
         TypeSystem`Atom[Real]}], 170], "Meta" -> 
     Association["ID" -> 76102728357212], "RowTarget" -> 20, "ColumnTarget" -> 
     10, "Shape" -> TypeSystem`PackageScope`HeaderShape[
       Association[{All, "optimizer"} -> 1, {All, "learning_rate"} -> 
        1, {All, "hparams/validate_best"} -> 1, {All, "hparams/cer_best"} -> 
        1], 
       TypeSystem`PackageScope`Limited[
        TypeSystem`PackageScope`ColumnShape[
         TypeSystem`PackageScope`Limited[
          TypeSystem`PackageScope`RowShape[
           Association[
           "optimizer" -> TypeSystem`PackageScope`AtomShape[63.], 
            "learning_rate" -> TypeSystem`PackageScope`AtomShape[60], 
            "hparams/validate_best" -> TypeSystem`PackageScope`AtomShape[60], 
            "hparams/cer_best" -> TypeSystem`PackageScope`AtomShape[60]]], 
          DirectedInfinity[1], 4, {All}]], 20, 
        DirectedInfinity[1], {}]], "Type" -> TypeSystem`Vector[
       TypeSystem`Struct[{
        "optimizer", "learning_rate", "hparams/validate_best", 
         "hparams/cer_best"}, {
         TypeSystem`Atom[
          TypeSystem`Enumeration["adam", "rmsprop", "sgd"]], 
         TypeSystem`Atom[Real], 
         TypeSystem`Atom[Real], 
         TypeSystem`Atom[Real]}], 170], "Path" -> {}, "BaseIndices" -> {}, 
     "DisplayedRowCount" -> 20, "DisplayedColumnCount" -> 4, "DataRowCount" -> 
     170, "DataColumnCount" -> 4, "SortPaths" -> {}, "SortDirections" -> {}, 
     "HiddenItemsMap" -> Null, "UpdateType" -> 1], 
    TypeSystem`NestedGrid`PackagePrivate`$outputID$$, 
    TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
    TypeSystem`NestedGrid`PackagePrivate`$vPos$$ = 1, 
    TypeSystem`NestedGrid`PackagePrivate`$hPos$$ = 1, 
    TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
    DynamicModule[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
        Style[
         Grid[{{
            Item[
             Pane[
              Row[{
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover["optimizer", 
                    Style[
                    "optimizer", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                    All, "optimizer"}, 1]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                  TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                  All, "optimizer"}, "ColumnHeader", True], "Mouse"], " ", 
                ""}], ImageSize -> {{1, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Row[{
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover["learning_rate", 
                    Style[
                    "learning_rate", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                    All, "learning_rate"}, 1]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                  TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                  All, "learning_rate"}, "ColumnHeader", True], "Mouse"], " ",
                 ""}], ImageSize -> {{1, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Row[{
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover["hparams/validate_best", 
                    Style[
                    "hparams/validate_best", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                    All, "hparams/validate_best"}, 1]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                  TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                  All, "hparams/validate_best"}, "ColumnHeader", True], 
                 "Mouse"], " ", ""}], ImageSize -> {{1, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}], 
            Item[
             Pane[
              Row[{
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover["hparams/cer_best", 
                    Style[
                    "hparams/cer_best", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][{
                    All, "hparams/cer_best"}, 1]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  TypeSystem`NestedGrid`PackagePrivate`localHold[
                  TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{
                  All, "hparams/cer_best"}, "ColumnHeader", True], "Mouse"], 
                " ", ""}], ImageSize -> {{1, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], Background -> 
             GrayLevel[0.95], Alignment -> {Left, Baseline}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{1, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["5.0"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{1, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.358388"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{1, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.368421"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{1, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{2, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["1.0"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{2, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.000463605"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{2, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.0"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{2, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{3, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["2.0"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{3, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.00031352"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{3, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.0"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{3, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{4, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["10.0"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{4, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.443707"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{4, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.394737"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{4, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{5, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.5"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{5, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.0661529"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{5, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.0263158"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{5, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{6, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.2"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{6, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.233449"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{6, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.236842"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{6, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{7, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.1"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{7, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.212966"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{7, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.210526"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{7, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{8, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.05"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{8, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.278112"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{8, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.263158"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{8, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{9, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.02"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{9, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.298819"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{9, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.289474"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{9, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{10, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.002"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{10, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.477119"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{10, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.447368"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{10, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{11, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.005"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{11, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.466599"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{11, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.473684"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{11, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{12, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.01"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{12, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.328217"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{12, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.315789"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{12, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{13, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.0002"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{13, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.555981"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{13, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.552632"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{13, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{14, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.001"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{14, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.486899"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{14, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.421053"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{14, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{15, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.0005"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{15, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.505467"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{15, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.473684"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{15, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{16, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.0001"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{16, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.593463"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{16, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.552632"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{16, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{17, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.00005"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{17, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.684397"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{17, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.631579"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{17, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{18, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.00002"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{18, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.717647"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{18, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.763158"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{18, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["sgd", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{19, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.00001"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{19, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.728564"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{19, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.710526"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{19, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Pane[
              Annotation["rmsprop", 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{20, 
                 Key["optimizer"]}, "Item", False], "Mouse"], 
              ImageSize -> {{63., Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["5.0"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{20, 
                 Key["learning_rate"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.33545"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{20, 
                 Key["hparams/validate_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}], 
            Item[
             Pane[
              Annotation[
               RawBoxes["0.342105"], 
               TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][{20, 
                 Key["hparams/cer_best"]}, "Item", False], "Mouse"], 
              ImageSize -> {{60, Full}, Automatic}, 
              ImageMargins -> {{5, 3}, {4, 5}}], 
             ItemSize -> {Full, Automatic}]}, {
            Item[
             Deploy[
              Pane[
               Row[{
                 Spacer[2], 
                 Style[
                  Row[{
                    Button[
                    MouseAppearance[
                    Mouseover[
                    Graphics[{{
                    EdgeForm[None], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.5372549019607843, 0.5372549019607843, 
                    0.5372549019607843], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}], 
                    Line[{{0, 5}, {8, 5}}]}, {5, 6.5}], 0, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]], 
                    Graphics[{{
                    EdgeForm[
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549]], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}], 
                    Line[{{0, 5}, {8, 5}}]}, {5, 6.5}], 0, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]]], "LinkHand"], 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$ = 
                    Clip[TypeSystem`NestedGrid`PackagePrivate`$vPos$$ - 20 
                    If[True, 170, 1], {1, 170 - -20 + 1}], Appearance -> 
                    None], 
                    Button[
                    MouseAppearance[
                    Mouseover[
                    Graphics[{{
                    EdgeForm[None], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.5372549019607843, 0.5372549019607843, 
                    0.5372549019607843], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}]}, {5, 6.5}], 0, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]], 
                    Graphics[{{
                    EdgeForm[
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549]], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}]}, {5, 6.5}], 0, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]]], "LinkHand"], 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$ = 
                    Clip[TypeSystem`NestedGrid`PackagePrivate`$vPos$$ - 20 
                    If[False, 170, 1], {1, 170 - -20 + 1}], Appearance -> 
                    None], " ", 
                    Style[
                    Mouseover[
                    Row[{"rows ", 1, "\[Dash]", 20, " of ", 
                    Style[
                    170, FontColor -> GrayLevel[0], FontWeight -> "Medium"]}, 
                    BaseStyle -> {
                    FontSize -> 8., FontColor -> 
                    RGBColor[
                    0.5098039215686274, 0.5098039215686274, 
                    0.5098039215686274]}], 
                    Row[{"rows ", 1, "\[Dash]", 20, " of ", 
                    Style[
                    170, FontColor -> GrayLevel[0], FontWeight -> "Medium"]}, 
                    BaseStyle -> {
                    FontSize -> 8., FontColor -> 
                    RGBColor[
                    0.5098039215686274, 0.5098039215686274, 
                    0.5098039215686274]}]], ContextMenu -> {
                    MenuItem["Hide", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]}, 
                    "Rows", 1, {}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show up to 10 Rows", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]}, 
                    "Rows", 10, {}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show up to 30 Rows", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]}, 
                    "Rows", 30, {}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show up to 100 Rows", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]}, 
                    "Rows", 100, {}]], MenuEvaluator -> Automatic], 
                    MenuItem["Show All", 
                    KernelExecute[
                    
                    TypeSystem`NestedGrid`PackagePrivate`adjustLimits[{
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]}, 
                    "Rows", 100000000, {}]], MenuEvaluator -> Automatic]}], 
                    " ", 
                    Button[
                    MouseAppearance[
                    Mouseover[
                    Graphics[{{
                    EdgeForm[None], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.5372549019607843, 0.5372549019607843, 
                    0.5372549019607843], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}]}, {5, 6.5}], 180 Degree, {
                    9, 9}]}, ImageSize -> (1 -> 1), 
                    ImagePadding -> {{0, 1}, {1, 0}}, BaselinePosition -> 
                    Scaled[0.35]], 
                    Graphics[{{
                    EdgeForm[
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549]], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}]}, {5, 6.5}], 180 Degree, {
                    9, 9}]}, ImageSize -> (1 -> 1), 
                    ImagePadding -> {{0, 1}, {1, 0}}, BaselinePosition -> 
                    Scaled[0.35]]], "LinkHand"], 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$ = 
                    Clip[TypeSystem`NestedGrid`PackagePrivate`$vPos$$ + 
                    20 If[False, 170, 1], {1, 170 - 20 + 1}], Appearance -> 
                    None], 
                    Button[
                    MouseAppearance[
                    Mouseover[
                    Graphics[{{
                    EdgeForm[None], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.5372549019607843, 0.5372549019607843, 
                    0.5372549019607843], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}], 
                    Line[{{0, 5}, {8, 5}}]}, {5, 6.5}], 180 Degree, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]], 
                    Graphics[{{
                    EdgeForm[
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549]], 
                    FaceForm[None], 
                    Rectangle[{0, 0}, {18, 18}, RoundingRadius -> 2]}, 
                    Rotate[
                    Translate[{
                    CapForm[Round], 
                    RGBColor[
                    0.27450980392156865`, 0.5411764705882353, 
                    0.796078431372549], 
                    Line[{{0, 0}, {4, 5}, {8, 0}}], 
                    Line[{{0, 5}, {8, 5}}]}, {5, 6.5}], 180 Degree, {9, 9}]}, 
                    ImageSize -> (1 -> 1), ImagePadding -> {{0, 1}, {1, 0}}, 
                    BaselinePosition -> Scaled[0.35]]], "LinkHand"], 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$ = 
                    Clip[TypeSystem`NestedGrid`PackagePrivate`$vPos$$ + 
                    20 If[True, 170, 1], {1, 170 - 20 + 1}], Appearance -> 
                    None]}], ContextMenu -> {}], 
                 Graphics[{
                   RGBColor[
                   0.8196078431372549, 0.8196078431372549, 
                    0.8196078431372549], 
                   Line[{{0, 0}, {0, 19}}]}, ImageSize -> (1 -> 1), 
                  ImagePadding -> {{0, 0}, {0, 0}}, BaselinePosition -> 
                  Scaled[0.35]]}], ImageMargins -> {{0, -1}, {-1, 1}}]], 
             Background -> 
             RGBColor[
              0.9764705882352941, 0.9764705882352941, 0.9764705882352941], 
             Alignment -> {Left, Top}], SpanFromLeft, SpanFromLeft, 
            SpanFromLeft}}, 
          BaseStyle -> {
           ContextMenu -> 
            Dynamic[TypeSystem`NestedGrid`PackagePrivate`$contextMenuTrigger; 
              Which[TypeSystem`NestedGrid`PackagePrivate`$lastOutputID =!= 
                TypeSystem`NestedGrid`PackagePrivate`localHold[
                 TypeSystem`NestedGrid`PackagePrivate`$outputID$$], {}, 
                TypeSystem`NestedGrid`PackagePrivate`$contextMenuTrigger === 
                TypeSystem`NestedGrid`PackagePrivate`$lastContextMenuTrigger, 
                TypeSystem`NestedGrid`PackagePrivate`$lastContextMenu, True, 
                TypeSystem`NestedGrid`PackagePrivate`$lastContextMenuTrigger = 
                 TypeSystem`NestedGrid`PackagePrivate`$contextMenuTrigger; 
                TypeSystem`NestedGrid`PackagePrivate`$lastContextMenu = 
                 Block[{TypeSystem`NestedGrid`PackagePrivate`$globalScrollPos = \
{TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$}}, 
                   
                   With[{TypeSystem`NestedGrid`PackagePrivate`lastPath$ = 
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, 
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ = 
                    TypeSystem`NestedGrid`PackagePrivate`$lastPathType, 
                    TypeSystem`NestedGrid`PackagePrivate`isLeafHeader$ = 
                    
                    TypeSystem`NestedGrid`PackagePrivate`$\
lastPathIsLeafHeader, TypeSystem`NestedGrid`PackagePrivate`allHidden$ = 
                    TypeSystem`NestedGrid`PackagePrivate`allHiddenQ[
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, 
                    TypeSystem`NestedGrid`PackagePrivate`$state$$], 
                    TypeSystem`NestedGrid`PackagePrivate`anyHidden$ = 
                    TypeSystem`NestedGrid`PackagePrivate`anyHiddenQ[
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, 
                    TypeSystem`NestedGrid`PackagePrivate`$state$$], 
                    TypeSystem`NestedGrid`PackagePrivate`sortDirection$ = 
                    TypeSystem`NestedGrid`PackagePrivate`columnSortDirection[
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, 
                    TypeSystem`NestedGrid`PackagePrivate`$state$$[
                    "SortPaths"], 
                    TypeSystem`NestedGrid`PackagePrivate`$state$$[
                    "SortDirections"]], 
                    TypeSystem`NestedGrid`PackagePrivate`haveData$ = Not[
                    FailureQ[
                    TypeSystem`NestedGrid`PackagePrivate`datasetInitialData[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$]]], 
                    TypeSystem`NestedGrid`PackagePrivate`isKeyDummy$ = Not[
                    FreeQ[
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, Keys]]}, 
                    Join[{
                    If[
                    Or[
                    Not[TypeSystem`NestedGrid`PackagePrivate`haveData$], 
                    Not[TypeSystem`NestedGrid`PackagePrivate`anyHidden$], 
                    TypeSystem`NestedGrid`PackagePrivate`isKeyDummy$], 
                    Nothing, 
                    MenuItem[
                    StringJoin["Show ", 
                    Which[
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "Item", "", 
                    TypeSystem`NestedGrid`PackagePrivate`allHidden$, 
                    ToString[
                    ReplaceAll[
                    Last[TypeSystem`NestedGrid`PackagePrivate`lastPath$], Key[
                    Pattern[TypeSystem`NestedGrid`PackagePrivate`x, 
                    Blank[]]] :> TypeSystem`NestedGrid`PackagePrivate`x]], 
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "RowHeader", "Row", 
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "ColumnHeader", "Column", True, ""]], 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`updateHiddenItems[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][
                    TypeSystem`NestedGrid`PackagePrivate`lastPath$, 
                    "remove"]], MenuEvaluator -> Automatic]], 
                    If[
                    Or[
                    Not[TypeSystem`NestedGrid`PackagePrivate`haveData$], 
                    TypeSystem`NestedGrid`PackagePrivate`pathEmptyQ[
                    TypeSystem`NestedGrid`PackagePrivate`$lastPath, 
                    TypeSystem`NestedGrid`PackagePrivate`$state$$], 
                    TypeSystem`NestedGrid`PackagePrivate`allHidden$, 
                    TypeSystem`NestedGrid`PackagePrivate`isKeyDummy$], 
                    Nothing, 
                    MenuItem[
                    StringJoin["Hide ", 
                    Which[
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "Item", "", 
                    TypeSystem`NestedGrid`PackagePrivate`allHidden$, 
                    ToString[
                    ReplaceAll[
                    Last[TypeSystem`NestedGrid`PackagePrivate`lastPath$], Key[
                    Pattern[TypeSystem`NestedGrid`PackagePrivate`x, 
                    Blank[]]] :> TypeSystem`NestedGrid`PackagePrivate`x]], 
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "RowHeader", "Row", 
                    TypeSystem`NestedGrid`PackagePrivate`lastPathType$ == 
                    "ColumnHeader", "Column", True, ""]], 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`updateHiddenItems[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]][
                    TypeSystem`NestedGrid`PackagePrivate`lastPath$, "add"]], 
                    MenuEvaluator -> Automatic]], Delimiter}, 
                    If[
                    And[TypeSystem`NestedGrid`PackagePrivate`haveData$, 
                    MatchQ[TypeSystem`NestedGrid`PackagePrivate`lastPathType$, 
                    Alternatives["ColumnHeader", "KeyDummy"]], 
                    TypeSystem`NestedGrid`PackagePrivate`isLeafHeader$, 
                    Not[TypeSystem`NestedGrid`PackagePrivate`allHidden$]], {
                    If[
                    TypeSystem`NestedGrid`PackagePrivate`sortDirection$ =!= 
                    "Ascending", 
                    MenuItem["Sort", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`updateSort[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][
                    TypeSystem`NestedGrid`PackagePrivate`lastPath$, 
                    "Ascending"]], MenuEvaluator -> Automatic], Nothing], 
                    If[
                    TypeSystem`NestedGrid`PackagePrivate`sortDirection$ =!= 
                    "Descending", 
                    MenuItem["Reverse Sort", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`updateSort[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][
                    TypeSystem`NestedGrid`PackagePrivate`lastPath$, 
                    "Descending"]], MenuEvaluator -> Automatic], Nothing], 
                    If[
                    TypeSystem`NestedGrid`PackagePrivate`sortDirection$ =!= 
                    None, 
                    MenuItem["Unsort", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`updateSort[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    TypeSystem`NestedGrid`PackagePrivate`localHold[
                    TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][
                    TypeSystem`NestedGrid`PackagePrivate`lastPath$, None]], 
                    MenuEvaluator -> Automatic], Nothing], Delimiter}, {}], {
                    MenuItem["Copy Position to Clipboard", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                    MenuEvaluator -> Automatic], 
                    MenuItem["Copy Data to Clipboard", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                    MenuEvaluator -> Automatic], Delimiter, 
                    MenuItem["Paste Position in New Cell", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                    MenuEvaluator -> Automatic], 
                    MenuItem["Paste Data in New Cell", 
                    KernelExecute[
                    TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                    MenuEvaluator -> Automatic]}]]]]], FontFamily -> 
            "Verdana", FontSize -> 12}, Spacings -> {0, 0}, Alignment -> Left,
           Dividers -> All, FrameStyle -> GrayLevel[0.7490196078431373], 
          BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
         LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False, 
         ShowAutoStyles -> False]], 
      TypeSystem`NestedGrid`PackagePrivate`initialQ = True}, 
     Dynamic[
      TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
      TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
         Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
         Module[{
          TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
           TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
           TypeSystem`NestedGrid`PackagePrivate`datasetData[
            TypeSystem`NestedGrid`PackagePrivate`$state$$]}, 
          TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = If[
             FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpData$], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
             TypeSystem`NestedGrid`PackagePrivate`renderGrid[
             TypeSystem`NestedGrid`PackagePrivate`$state$$, 
              TypeSystem`NestedGrid`PackagePrivate`$path$$, 
              TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
              TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
              TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
              TypeSystem`NestedGrid`PackagePrivate`localHold[
              TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][
             TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
            Not[
             FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
            TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
            TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
       TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
       TypeSystem`NestedGrid`PackagePrivate`$vPos$$; 
       TypeSystem`NestedGrid`PackagePrivate`$hPos$$; If[
         FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
         TypeSystem`SparseGrid[
          TypeSystem`H["(data no longer present)"]], 
         If[GeneralUtilities`$DebugMode, 
          Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
            TypeSystem`NestedGrid`PackagePrivate`formatState[
            TypeSystem`NestedGrid`PackagePrivate`$state$$, 
             TypeSystem`NestedGrid`PackagePrivate`$path$$, 
             TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
             TypeSystem`NestedGrid`PackagePrivate`$hPos$$]}], 
          TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
        TypeSystem`NestedGrid`PackagePrivate`$hPos$$}], 
     DynamicModuleValues :> {}], 
    TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
     TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
      TypeSystem`PackageScope`SubViewPathbar[
      TypeSystem`NestedGrid`PackagePrivate`$path$$, 
       TypeSystem`NestedGrid`PackagePrivate`updateState[
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$path$$, 
        TypeSystem`NestedGrid`PackagePrivate`$vPos$$, 
        TypeSystem`NestedGrid`PackagePrivate`$hPos$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
        TypeSystem`NestedGrid`PackagePrivate`localHold[
        TypeSystem`NestedGrid`PackagePrivate`$outputID$$]]]], 
     TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
    TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Style[
     Framed[
      Dynamic[
       Replace[
       TypeSystem`NestedGrid`PackagePrivate`mouseAnnotation$$, {
        TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
           TypeSystem`NestedGrid`PackagePrivate`localHold[
           TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][Null, 
           Blank[]] -> "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
           TypeSystem`NestedGrid`PackagePrivate`localHold[
           TypeSystem`NestedGrid`PackagePrivate`$outputID$$]][
           Pattern[TypeSystem`NestedGrid`PackagePrivate`path$, 
            Blank[]], 
           Pattern[TypeSystem`NestedGrid`PackagePrivate`pathType$, 
            Blank[]], 
           Pattern[TypeSystem`NestedGrid`PackagePrivate`isLeafHeader$, 
            Blank[]]] :> (
          Increment[TypeSystem`NestedGrid`PackagePrivate`$contextMenuTrigger]; 
          TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
           TypeSystem`NestedGrid`PackagePrivate`path$; 
          TypeSystem`NestedGrid`PackagePrivate`$lastPathType = 
           TypeSystem`NestedGrid`PackagePrivate`pathType$; 
          TypeSystem`NestedGrid`PackagePrivate`$lastPathIsLeafHeader = 
           TypeSystem`NestedGrid`PackagePrivate`isLeafHeader$; 
          TypeSystem`NestedGrid`PackagePrivate`$lastOutputID = 
           TypeSystem`NestedGrid`PackagePrivate`localHold[
            TypeSystem`NestedGrid`PackagePrivate`$outputID$$]; 
          TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
           TypeSystem`NestedGrid`PackagePrivate`path$, 
            TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
         Spacer[10], Blank[] :> Spacer[10]}], 
       TrackedSymbols :> {
        TypeSystem`NestedGrid`PackagePrivate`mouseAnnotation$$}], FrameStyle -> 
      None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> Top, 
      ImageSize -> {Automatic, 15}], FontSize -> 1], 
    TypeSystem`NestedGrid`PackagePrivate`mouseAnnotation$$ = Null}, 
    DynamicWrapperBox[
     DynamicBox[ToBoxes[
       Dataset`DatasetContent[
       1, "Path" -> TypeSystem`NestedGrid`PackagePrivate`$path$$, "Grid" -> 
        TypeSystem`NestedGrid`PackagePrivate`releaseLocalHold[
         TypeSystem`NestedGrid`PackagePrivate`$grid$$], "State" -> 
        TypeSystem`NestedGrid`PackagePrivate`$state$$, "VPos" -> 
        Hold[TypeSystem`NestedGrid`PackagePrivate`$vPos$$], "HPos" -> 
        Hold[TypeSystem`NestedGrid`PackagePrivate`$hPos$$], "TopBar" -> 
        TypeSystem`NestedGrid`PackagePrivate`$topBar$$, "BottomBar" -> 
        TypeSystem`NestedGrid`PackagePrivate`releaseLocalHold[
         TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]], StandardForm],
      ImageSizeCache->{482., {267., 273.}},
      TrackedSymbols:>{
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     TypeSystem`NestedGrid`PackagePrivate`mouseAnnotation$$ = 
     MouseAnnotation[],
     ImageSizeCache->{482., {267., 273.}}],
    BaseStyle->{LineBreakWithin -> False},
    DynamicModuleValues:>{},
    Initialization:>
     Block[{$ContextPath = $ContextPath}, Needs["TypeSystem`"]; 
      Needs["Dataset`"]; 
      TypeSystem`NestedGrid`PackagePrivate`$outputID$$ = CreateUUID[]],
    UnsavedVariables:>{TypeSystem`NestedGrid`PackagePrivate`$outputID$$}],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  Dataset`InterpretDataset[1],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{
  3.8003569858641586`*^9, 3.8003575533364363`*^9, 3.800357638063137*^9, {
   3.8003577035060062`*^9, 3.800357745833694*^9}, 3.8003583928459225`*^9, 
   3.800358987983203*^9},
 CellLabel->
  "Out[1165]=",ExpressionUUID->"a4f3f5f1-c41c-421d-b870-ba2e837866a3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"extract", "[", 
      RowBox[{"dataP", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<optimizer\>\"", ",", "\"\<learning_rate\>\""}], "}"}], 
       ",", "\"\<hparams/validate_best\>\"", ",", "MeanAround"}], "]"}], "//",
      "Normal"}], "//", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"First", "@*", "First"}], "]"}]}], "//", 
   RowBox[{"KeyValueMap", "[", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"k", ",", "v"}], "}"}], ",", 
      RowBox[{"k", "\[Rule]", 
       RowBox[{"Sort", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Association", "[", "v", "]"}], "//", 
         RowBox[{"KeyValueMap", "[", 
          RowBox[{"Function", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"kk", ",", "vv"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Last", "@", "kk"}], ",", "vv"}], "}"}]}], "]"}], 
          "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "]"}], "]"}]}], "//", 
  "Association"}], "\[IndentingNewLine]", 
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotTheme", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Scientific\>\"", ",", "\"\<Detailed\>\""}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"textStyle", ",", "Black"}], "]"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<learning rate\>\"", ",", "\"\<validation loss\>\""}], 
     "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "300"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<SGD\>\"", ",", "\"\<RMSprop\>\"", ",", "\"\<Adam\>\""}],
          "}"}], ",", 
        RowBox[{"LegendLayout", "\[Rule]", "table"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{".1", ",", ".1"}], "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{".1", ",", ".1"}], "}"}]}], "}"}]}], "]"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8003567109062757`*^9, 3.800356940411485*^9}, {
   3.800357048189184*^9, 3.800357053113698*^9}, {3.8003572428820677`*^9, 
   3.8003572618997755`*^9}, {3.800357295344701*^9, 3.800357470599619*^9}, {
   3.800357733545861*^9, 3.800357771661586*^9}, 3.800357950454563*^9, {
   3.8003579961232986`*^9, 3.800358019670159*^9}, {3.800358371485793*^9, 
   3.8003583856425953`*^9}, {3.8003585091556454`*^9, 
   3.8003585216070056`*^9}, {3.8003589766385098`*^9, 
   3.8003590143124666`*^9}, {3.8003590931701026`*^9, 3.80035909716745*^9}},
 CellLabel->
  "In[1173]:=",ExpressionUUID->"9bef51c1-7b11-4234-a1f9-a25bf67b5afe"],

Cell[BoxData[
 RowBox[{"\[LeftAssociation]", 
  RowBox[{
   RowBox[{"\<\"sgd\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.00001`", ",", 
        InterpretationBox[
         TemplateBox[{"0.78", "0.05"},
          "Around"],
         Around[0.7814967036247253, 0.05293256044387817]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.00002`", ",", 
        InterpretationBox[
         TemplateBox[{"0.72", "0.06"},
          "Around"],
         Around[0.721923847993215, 0.06376732333505998]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.00005`", ",", 
        InterpretationBox[
         TemplateBox[{"0.69", "0.08"},
          "Around"],
         Around[0.6911454399426779, 0.08089609888486723]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.0001`", ",", 
        InterpretationBox[
         TemplateBox[{"0.65", "0.09"},
          "Around"],
         Around[0.6518445213635763, 0.09334847181180847]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.0002`", ",", 
        InterpretationBox[
         TemplateBox[{"0.62", "0.11"},
          "Around"],
         Around[0.6184012691179911, 0.11137205758081359`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.0005`", ",", 
        InterpretationBox[
         TemplateBox[{"0.60", "0.12"},
          "Around"],
         Around[0.5983738899230957, 0.11916339513485112`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.001`", ",", 
        InterpretationBox[
         TemplateBox[{"0.56", "0.14"},
          "Around"],
         Around[0.5628790259361267, 0.13718335561228914`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.002`", ",", 
        InterpretationBox[
         TemplateBox[{"0.49", "0.19"},
          "Around"],
         Around[0.49167458216349286`, 0.1939222289687025]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.005`", ",", 
        InterpretationBox[
         TemplateBox[{"0.47", "0.20"},
          "Around"],
         Around[0.4719446698824565, 0.19604466351086752`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.01`", ",", 
        InterpretationBox[
         TemplateBox[{"0.40", "0.22"},
          "Around"],
         Around[0.3989988962809245, 0.21899880920856873`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.02`", ",", 
        InterpretationBox[
         TemplateBox[{"0.37", "0.22"},
          "Around"],
         Around[0.3741143544514974, 0.22415944831402798`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.05`", ",", 
        InterpretationBox[
         TemplateBox[{"0.34", "0.22"},
          "Around"],
         Around[0.3421866099039714, 0.2162910947569693]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.1`", ",", 
        InterpretationBox[
         TemplateBox[{"0.29", "0.19"},
          "Around"],
         Around[0.28753767410914105`, 0.19054627460221815`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.2`", ",", 
        InterpretationBox[
         TemplateBox[{"0.27", "0.17"},
          "Around"],
         Around[0.27172982692718506`, 0.16830979384310674`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.5`", ",", 
        InterpretationBox[
         TemplateBox[{"0.22", "0.18"},
          "Around"],
         Around[0.21590360005696616`, 0.18356676503443703`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.00068", "0.00022"},
          "Around"],
         Around[0.0006757775942484537, 0.00022310863926661435`]]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.09", "0.09"},
          "Around"],
         Around[0.09429013729095459, 0.0940674689578076]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.44", "0.04"},
          "Around"],
         Around[0.43600451946258545`, 0.04307395304671408]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.54", "0.05"},
          "Around"],
         Around[0.5445665121078491, 0.054196944706795]]}], "}"}]}], "}"}]}], 
   ",", 
   RowBox[{"\<\"rmsprop\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.00001`", ",", 
        InterpretationBox[
         TemplateBox[{"0.67", "0.10"},
          "Around"],
         Around[0.6734288930892944, 0.10194182501466147`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.00002`", ",", 
        InterpretationBox[
         TemplateBox[{"0.64", "0.12"},
          "Around"],
         Around[0.6351469953854879, 0.1223373465508059]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.00005`", ",", 
        InterpretationBox[
         TemplateBox[{"0.53", "0.17"},
          "Around"],
         Around[0.5329385201136271, 0.17126146757279068`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.0001`", ",", 
        InterpretationBox[
         TemplateBox[{"0.41", "0.16"},
          "Around"],
         Around[0.4141443967819214, 0.158053272659108]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.0002`", ",", 
        InterpretationBox[
         TemplateBox[{"0.33", "0.17"},
          "Around"],
         Around[0.3323822816212972, 0.16602098010253805`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.0005`", ",", 
        InterpretationBox[
         TemplateBox[{"0.26", "0.18"},
          "Around"],
         Around[0.2562936544418335, 0.179147430084997]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.001`", ",", 
        InterpretationBox[
         TemplateBox[{"0.21", "0.20"},
          "Around"],
         Around[0.213846484820048, 0.19801015499859345`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.002`", ",", 
        InterpretationBox[
         TemplateBox[{"0.17", "0.16"},
          "Around"],
         Around[0.17483766873677573`, 0.16142264758931402`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.005`", ",", 
        InterpretationBox[
         TemplateBox[{"0.16", "0.16"},
          "Around"],
         Around[0.15904237826665243`, 0.1587897597006021]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.01`", ",", 
        InterpretationBox[
         TemplateBox[{"0.044", "0.032"},
          "Around"],
         Around[0.044280290603637695`, 0.03200834562447177]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.02`", ",", 
        InterpretationBox[
         TemplateBox[{"0.016", "0.016"},
          "Around"],
         Around[0.01577126979827881, 0.015675883303231584`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.05`", ",", 
        InterpretationBox[
         TemplateBox[{"0.00022", "0.00007"},
          "Around"],
         Around[0.00021620591481526694`, 0.00007012383091119665]]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.1`", ",", 
        InterpretationBox[
         TemplateBox[{"0.00017", "0.00004"},
          "Around"],
         Around[0.00016689300537109375`, 0.00003631406970293715]]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.2`", ",", 
        InterpretationBox[
         TemplateBox[{"0.033", "0.033"},
          "Around"],
         Around[0.033307512601216636`, 0.032880343031558054`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.5`", ",", 
        InterpretationBox[
         TemplateBox[{"0.12", "0.12"},
          "Around"],
         Around[0.12371385097503662`, 0.12282688267806989`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.40", "0.07"},
          "Around"],
         Around[0.4014078577359517, 0.06903935070912896]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.49", "0.04"},
          "Around"],
         Around[0.49451249837875366`, 0.03865720379219188]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.44", "0.05"},
          "Around"],
         Around[0.43955278396606445`, 0.05485172022393358]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.50", "0.07"},
          "Around"],
         Around[0.5037215352058411, 0.06867337205100808]]}], "}"}]}], "}"}]}],
    ",", 
   RowBox[{"\<\"adam\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.00001`", ",", 
        InterpretationBox[
         TemplateBox[{"0.68", "0.10"},
          "Around"],
         Around[0.677553137143453, 0.09971660981409641]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.00002`", ",", 
        InterpretationBox[
         TemplateBox[{"0.65", "0.11"},
          "Around"],
         Around[0.6545746922492981, 0.10836340623084668`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.00005`", ",", 
        InterpretationBox[
         TemplateBox[{"0.57", "0.15"},
          "Around"],
         Around[0.5699701905250549, 0.1493240890312121]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.0001`", ",", 
        InterpretationBox[
         TemplateBox[{"0.44", "0.16"},
          "Around"],
         Around[0.4447490374247233, 0.1583385641377751]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.0002`", ",", 
        InterpretationBox[
         TemplateBox[{"0.38", "0.14"},
          "Around"],
         Around[0.37574636936187744`, 0.14296349037647968`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.0005`", ",", 
        InterpretationBox[
         TemplateBox[{"0.27", "0.18"},
          "Around"],
         Around[0.2691387136777242, 0.1756650836495787]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.001`", ",", 
        InterpretationBox[
         TemplateBox[{"0.26", "0.18"},
          "Around"],
         Around[0.2558416724205017, 0.17859816945812748`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.002`", ",", 
        InterpretationBox[
         TemplateBox[{"0.17", "0.16"},
          "Around"],
         Around[0.17454558610916138`, 0.1574838153111477]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.005`", ",", 
        InterpretationBox[
         TemplateBox[{"0.014", "0.011"},
          "Around"],
         Around[0.014295498530069986`, 0.011378385743689715`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.01`", ",", 
        InterpretationBox[
         TemplateBox[{"0.17", "0.15"},
          "Around"],
         Around[0.16831584771474203`, 0.15475589212922655`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.02`", ",", 
        InterpretationBox[
         TemplateBox[{"0.05", "0.05"},
          "Around"],
         Around[0.0510446031888326, 0.05056573073577451]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.05`", ",", 
        InterpretationBox[
         TemplateBox[{"0.00047", "0.00028"},
          "Around"],
         Around[0.0004692475001017253, 0.0002828157347444798]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.1`", ",", 
        InterpretationBox[
         TemplateBox[{"0.00020", "0.00012"},
          "Around"],
         Around[0.000203092892964681, 0.00012291920249466007`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.2`", ",", 
        InterpretationBox[
         TemplateBox[{"0.00023", "0.00007"},
          "Around"],
         Around[0.00023365020751953125`, 0.00006987638196010259]]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.5`", ",", 
        InterpretationBox[
         TemplateBox[{"0.0022", "0.0014"},
          "Around"],
         Around[0.0021653175354003906`, 0.0013679688140869136`]]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.18", "0.12"},
          "Around"],
         Around[0.17910414934158325`, 0.11919911373560207`]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.50", "0.10"},
          "Around"],
         Around[0.5002899964650472, 0.09856925539051482]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.451", "0.017"},
          "Around"],
         Around[0.45089320341746014`, 0.0168253448626934]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10.`", ",", 
        InterpretationBox[
         TemplateBox[{"0.47", "0.05"},
          "Around"],
         Around[0.46708019574483234`, 0.0519579576297881]]}], "}"}]}], 
     "}"}]}]}], "\[RightAssociation]"}]], "Output",
 CellChangeTimes->{
  3.8003567121567364`*^9, {3.800356742573969*^9, 3.800356814212043*^9}, {
   3.800356856819106*^9, 3.800356957134989*^9}, 3.800357053469211*^9, {
   3.800357179585494*^9, 3.800357197251003*^9}, {3.8003572435995874`*^9, 
   3.800357298564952*^9}, {3.8003573352607236`*^9, 3.800357498689497*^9}, {
   3.8003577308744793`*^9, 3.8003577506808186`*^9}, 3.8003579514095564`*^9, {
   3.800357996587017*^9, 3.8003580204182696`*^9}, {3.8003583867142243`*^9, 
   3.8003583959006763`*^9}, {3.8003585127880774`*^9, 
   3.8003585219234858`*^9}, {3.8003589813661537`*^9, 3.800359015254609*^9}, 
   3.8003590974672604`*^9},
 CellLabel->
  "Out[1173]=",ExpressionUUID->"a62a2d46-94c3-4972-a24c-a67e9d874ef0"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{{
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-11.512925464970229`, -0.31667960893072905`}, \
{-11.512925464970229`, -0.24654434714008977`}}], 
            LineBox[{{-11.512925464970229`, -0.24654434714008977`}, \
{-11.512925464970229`, -0.18100730392040543`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-10.819778284410283`, -0.4183124965259544}, \
{-10.819778284410283`, -0.3258356193456601}}], 
            LineBox[{{-10.819778284410283`, -0.3258356193456601}, \
{-10.819778284410283`, -0.2411914755590833}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-9.903487552536127, -0.49388764950021086`}, \
{-9.903487552536127, -0.3694049998759599}}], 
            LineBox[{{-9.903487552536127, -0.3694049998759599}, \
{-9.903487552536127, -0.25871692363346177`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-9.210340371976182, -0.5825077338161291}, \
{-9.210340371976182, -0.42794920965887834`}}], 
            LineBox[{{-9.210340371976182, -0.42794920965887834`}, \
{-9.210340371976182, -0.2941120429084297}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-8.517193191416238, -0.6791866606065804}, \
{-8.517193191416238, -0.48061772945037246`}}], 
            LineBox[{{-8.517193191416238, -0.48061772945037246`}, \
{-8.517193191416238, -0.3150213044298385}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-7.600902459542082, -0.7356153317774647}, \
{-7.600902459542082, -0.51353948642373}}], 
            LineBox[{{-7.600902459542082, -0.51353948642373}, \
{-7.600902459542082, -0.33193036746095056`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-6.907755278982137, -0.8540305769212991}, \
{-6.907755278982137, -0.5746905479345001}}], 
            LineBox[{{-6.907755278982137, -0.5746905479345001}, \
{-6.907755278982137, -0.3565858314116347}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-6.214608098422191, -1.2114931675208958`}, \
{-6.214608098422191, -0.7099381996903404}}], 
            LineBox[{{-6.214608098422191, -0.7099381996903404}, \
{-6.214608098422191, -0.3774655629168002}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-5.298317366548036, -1.2877167746650624`}, \
{-5.298317366548036, -0.7508935250932526}}], 
            LineBox[{{-5.298317366548036, -0.7508935250932526}, \
{-5.298317366548036, -0.40348307354704666`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-4.605170185988091, -1.7147979443567338`}, \
{-4.605170185988091, -0.9187966283093214}}], 
            LineBox[{{-4.605170185988091, -0.9187966283093214}, \
{-4.605170185988091, -0.48127053433151157`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-3.912023005428146, -1.8974206558330646`}, \
{-3.912023005428146, -0.9831937677373396}}], 
            LineBox[{{-3.912023005428146, -0.9831937677373396}, \
{-3.912023005428146, -0.5137067656629168}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-2.995732273553991, -2.072302960909439}, \
{-2.995732273553991, -1.0723990477344734`}}], 
            LineBox[{{-2.995732273553991, -1.0723990477344734`}, \
{-2.995732273553991, -0.5825405813038332}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-2.3025850929940455`, -2.3331329692868}, \
{-2.3025850929940455`, -1.2464013869501513`}}], 
            LineBox[{{-2.3025850929940455`, -1.2464013869501513`}, \
{-2.3025850929940455`, -0.7379689369917704}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-1.6094379124341003`, -2.2689565921139163`}, \
{-1.6094379124341003`, -1.3029469896748949`}}], 
            LineBox[{{-1.6094379124341003`, -1.3029469896748949`}, \
{-1.6094379124341003`, -0.8208905089186278}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-0.6931471805599453, -3.4315482953450003`}, \
{-0.6931471805599453, -1.5329232669502515`}}], 
            LineBox[{{-0.6931471805599453, -1.5329232669502515`}, \
{-0.6931471805599453, -0.9176156965237673}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{0., -7.7003494833383614`}, {0., -7.299646538645581}}], 
            LineBox[{{0., -7.299646538645581}, {0., -7.014354079314666}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{0.6931471805599453, -8.409827188930606}, {
             0.6931471805599453, -2.36137868345561}}], 
            LineBox[{{0.6931471805599453, -2.36137868345561}, {
             0.6931471805599453, -1.6694129620716818`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{1.6094379124341003`, -0.9341223585084679}, {
             1.6094379124341003`, -0.8301026699469518}}], 
            LineBox[{{1.6094379124341003`, -0.8301026699469518}, {
             1.6094379124341003`, -0.7358908692912747}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{2.302585092994046, -0.7125959529719993}, {
             2.302585092994046, -0.607765191437652}}], 
            LineBox[{{2.302585092994046, -0.607765191437652}, {
             2.302585092994046, -0.5128886556625628}}]}},
          Antialiasing->False]}}, {
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-11.512925464970229`, -0.5595134240441768}, \
{-11.512925464970229`, -0.39537286689510254`}}], 
            LineBox[{{-11.512925464970229`, -0.39537286689510254`}, \
{-11.512925464970229`, -0.25441401805915015`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-10.819778284410283`, -0.6678505575724258}, \
{-10.819778284410283`, -0.4538988180827986}}], 
            LineBox[{{-10.819778284410283`, -0.4538988180827986}, \
{-10.819778284410283`, -0.27775241252341826`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-9.903487552536127, -1.01700358538523}, \
{-9.903487552536127, -0.6293492083480038}}], 
            LineBox[{{-9.903487552536127, -0.6293492083480038}, \
{-9.903487552536127, -0.35069288974710133`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-9.210340371976182, -1.3622219442342898`}, \
{-9.210340371976182, -0.8815405814706012}}], 
            LineBox[{{-9.210340371976182, -0.8815405814706012}, \
{-9.210340371976182, -0.5582707713540979}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-8.517193191416238, -1.7935933406302205`}, \
{-8.517193191416238, -1.1014695218099693`}}], 
            LineBox[{{-8.517193191416238, -1.1014695218099693`}, \
{-8.517193191416238, -0.6963457671405906}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-7.600902459542082, -2.5620526403616206`}, \
{-7.600902459542082, -1.361431404241532}}], 
            LineBox[{{-7.600902459542082, -1.361431404241532}, \
{-7.600902459542082, -0.8313957742134405}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-6.907755278982137, -4.14544862263419}, \
{-6.907755278982137, -1.5424968820405398`}}], 
            LineBox[{{-6.907755278982137, -1.5424968820405398`}, \
{-6.907755278982137, -0.8870799517905363}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-6.214608098422191, -4.31138021870164}, \
{-6.214608098422191, -1.7438973427708633`}}], 
            LineBox[{{-6.214608098422191, -1.7438973427708633`}, \
{-6.214608098422191, -1.0898696680130389`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-5.298317366548036, -8.283629850945506}, \
{-5.298317366548036, -1.8385845822957643`}}], 
            LineBox[{{-5.298317366548036, -1.8385845822957643`}, \
{-5.298317366548036, -1.1462319036008375`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-4.605170185988091, -4.400439517812046}, \
{-4.605170185988091, -3.11721560829879}}], 
            LineBox[{{-4.605170185988091, -3.11721560829879}, \
{-4.605170185988091, -2.5732312871951146`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-3.912023005428146, -9.257573550880668}, \
{-3.912023005428146, -4.149565361383249}}], 
            
            LineBox[{{-3.912023005428146, -4.149565361383249}, \
{-3.912023005428146, -3.459446821347612}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-2.995732273553991, -8.831341875720527}, \
{-2.995732273553991, -8.439279295060926}}], 
            LineBox[{{-2.995732273553991, -8.439279295060926}, \
{-2.995732273553991, -8.158366454203467}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-2.3025850929940455`, -8.943532643041909}, \
{-2.3025850929940455`, -8.698157637275392}}], 
            LineBox[{{-2.3025850929940455`, -8.698157637275392}, \
{-2.3025850929940455`, -8.501285024588379}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-1.6094379124341003`, -7.758329504928021}, \
{-1.6094379124341003`, -3.401972303800274}}], 
            LineBox[{{-1.6094379124341003`, -3.401972303800274}, \
{-1.6094379124341003`, -2.7152582825240925`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-0.6931471805599453, -7.027701318157354}, \
{-0.6931471805599453, -2.089784033539785}}], 
            LineBox[{{-0.6931471805599453, -2.089784033539785}, \
{-0.6931471805599453, -1.4002280510657286`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{0., -1.1015109646926604`}, {0., -0.9127772669870097}}], 
            LineBox[{{0., -0.9127772669870097}, {0., -0.754071529344224}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{0.6931471805599453, -0.7855798562625901}, {
             0.6931471805599453, -0.7041828534586838}}], 
            LineBox[{{0.6931471805599453, -0.7041828534586838}, {
             0.6931471805599453, -0.6289155149271866}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{1.6094379124341003`, -0.955288704106497}, {
             1.6094379124341003`, -0.8219974690317857}}], 
            LineBox[{{1.6094379124341003`, -0.8219974690317857}, {
             1.6094379124341003`, -0.7044012624634929}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{2.302585092994046, -0.8322985341262805}, {
             2.302585092994046, -0.6857316731126133}}], 
            LineBox[{{2.302585092994046, -0.6857316731126133}, {
             2.302585092994046, -0.5579261285147372}}]}},
          Antialiasing->False]}}, {
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-11.512925464970229`, -0.5484642750018992}, \
{-11.512925464970229`, -0.38926729809579874`}}], 
            LineBox[{{-11.512925464970229`, -0.38926729809579874`}, \
{-11.512925464970229`, -0.2519678241806734}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-10.819778284410283`, -0.6047494073613302}, \
{-10.819778284410283`, -0.4237695790597728}}], 
            LineBox[{{-10.819778284410283`, -0.4237695790597728}, \
{-10.819778284410283`, -0.2705783801105227}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-9.903487552536127, -0.8659634128427317}, \
{-9.903487552536127, -0.562171216845559}}], 
            LineBox[{{-9.903487552536127, -0.562171216845559}, \
{-9.903487552536127, -0.32948471493307213`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-9.210340371976182, -1.250329275824922}, \
{-9.210340371976182, -0.8102451167449465}}], 
            LineBox[{{-9.210340371976182, -0.8102451167449465}, \
{-9.210340371976182, -0.5056928165834714}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-8.517193191416238, -1.4576491097064952`}, \
{-8.517193191416238, -0.9788409127726406}}], 
            LineBox[{{-8.517193191416238, -0.9788409127726406}, \
{-8.517193191416238, -0.656410589248749}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-7.600902459542082, -2.3700759142504793`}, \
{-7.600902459542082, -1.3125283680599498`}}], 
            LineBox[{{-7.600902459542082, -1.3125283680599498`}, \
{-7.600902459542082, -0.8101219989254995}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-6.907755278982137, -2.5607924707881615`}, \
{-6.907755278982137, -1.3631964929396627`}}], 
            LineBox[{{-6.907755278982137, -1.3631964929396627`}, \
{-6.907755278982137, -0.8336977975363261}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-6.214608098422191, -4.070914944062966}, \
{-6.214608098422191, -1.7455693330085607`}}], 
            LineBox[{{-6.214608098422191, -1.7455693330085607`}, \
{-6.214608098422191, -1.1025317554918137`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-5.298317366548036, -5.83716092364682}, \
{-5.298317366548036, -4.247810579379446}}], 
            LineBox[{{-5.298317366548036, -4.247810579379446}, \
{-5.298317366548036, -3.662280979856254}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-4.605170185988091, -4.300634271879715}, \
{-4.605170185988091, -1.781913018732193}}], 
            LineBox[{{-4.605170185988091, -1.781913018732193}, \
{-4.605170185988091, -1.129880875641007}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-3.912023005428146, -7.644076273552012}, \
{-3.912023005428146, -2.9750554561433065`}}], 
            LineBox[{{-3.912023005428146, -2.9750554561433065`}, \
{-3.912023005428146, -2.2866100371536864`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-2.995732273553991, -8.587445255225088}, \
{-2.995732273553991, -7.66438020994557}}], 
            LineBox[{{-2.995732273553991, -7.66438020994557}, \
{-2.995732273553991, -7.1926901486584764`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-2.3025850929940455`, -9.431315145913885}, \
{-2.3025850929940455`, -8.501847082778573}}], 
            LineBox[{{-2.3025850929940455`, -8.501847082778573}, \
{-2.3025850929940455`, -8.028576074649838}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-1.6094379124341003`, -8.717024194433389}, \
{-1.6094379124341003`, -8.36168540065418}}], 
            LineBox[{{-1.6094379124341003`, -8.36168540065418}, \
{-1.6094379124341003`, -8.100041341814123}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{-0.6931471805599453, -7.13421843244189}, \
{-0.6931471805599453, -6.1351882606609}}], 
            LineBox[{{-0.6931471805599453, -6.1351882606609}, \
{-0.6931471805599453, -5.645526863935549}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{0., -2.8149947105163395`}, {0., -1.7197878024474722`}}],
             LineBox[{{0., -1.7197878024474722`}, {
             0., -1.2096446486101495`}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{0.6931471805599453, -0.911998105704811}, {
             0.6931471805599453, -0.6925673557607437}}], 
            LineBox[{{0.6931471805599453, -0.6925673557607437}, {
             0.6931471805599453, -0.5127286803373978}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{1.6094379124341003`, -0.8345544009871018}, {
             1.6094379124341003`, -0.7965247670387181}}], 
            LineBox[{{1.6094379124341003`, -0.7965247670387181}, {
             1.6094379124341003`, -0.7598885565373079}}]}},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{{}, {
            LineBox[{{2.302585092994046, -0.8791822524478724}, {
             2.302585092994046, -0.7612543106926855}}], 
            LineBox[{{2.302585092994046, -0.7612543106926855}, {
             2.302585092994046, -0.6557778852723178}}]}},
          Antialiasing->False]}}}, {{
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-11.512925464970229`, -0.18100730392040543`}, 
               Offset[{3, 
                0}, {-11.512925464970229`, -0.18100730392040543`}]}, \
{{-11.512925464970229`, -0.18100730392040543`}, 
               Offset[{-3, 
                0}, {-11.512925464970229`, -0.18100730392040543`}]}, \
{{-11.512925464970229`, -0.31667960893072905`}, 
               Offset[{3, 
                0}, {-11.512925464970229`, -0.31667960893072905`}]}, \
{{-11.512925464970229`, -0.31667960893072905`}, 
               Offset[{-3, 
                0}, {-11.512925464970229`, -0.31667960893072905`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-10.819778284410283`, -0.2411914755590833}, 
               Offset[{3, 
                0}, {-10.819778284410283`, -0.2411914755590833}]}, \
{{-10.819778284410283`, -0.2411914755590833}, 
               Offset[{-3, 
                0}, {-10.819778284410283`, -0.2411914755590833}]}, \
{{-10.819778284410283`, -0.4183124965259544}, 
               Offset[{3, 
                0}, {-10.819778284410283`, -0.4183124965259544}]}, \
{{-10.819778284410283`, -0.4183124965259544}, 
               Offset[{-3, 
                0}, {-10.819778284410283`, -0.4183124965259544}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-9.903487552536127, -0.25871692363346177`}, 
               Offset[{3, 
                0}, {-9.903487552536127, -0.25871692363346177`}]}, \
{{-9.903487552536127, -0.25871692363346177`}, 
               Offset[{-3, 
                0}, {-9.903487552536127, -0.25871692363346177`}]}, \
{{-9.903487552536127, -0.49388764950021086`}, 
               Offset[{3, 
                0}, {-9.903487552536127, -0.49388764950021086`}]}, \
{{-9.903487552536127, -0.49388764950021086`}, 
               Offset[{-3, 
                0}, {-9.903487552536127, -0.49388764950021086`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-9.210340371976182, -0.2941120429084297}, 
               Offset[{3, 
                0}, {-9.210340371976182, -0.2941120429084297}]}, \
{{-9.210340371976182, -0.2941120429084297}, 
               Offset[{-3, 
                0}, {-9.210340371976182, -0.2941120429084297}]}, \
{{-9.210340371976182, -0.5825077338161291}, 
               Offset[{3, 
                0}, {-9.210340371976182, -0.5825077338161291}]}, \
{{-9.210340371976182, -0.5825077338161291}, 
               Offset[{-3, 
                0}, {-9.210340371976182, -0.5825077338161291}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-8.517193191416238, -0.3150213044298385}, 
               Offset[{3, 
                0}, {-8.517193191416238, -0.3150213044298385}]}, \
{{-8.517193191416238, -0.3150213044298385}, 
               Offset[{-3, 
                0}, {-8.517193191416238, -0.3150213044298385}]}, \
{{-8.517193191416238, -0.6791866606065804}, 
               Offset[{3, 
                0}, {-8.517193191416238, -0.6791866606065804}]}, \
{{-8.517193191416238, -0.6791866606065804}, 
               Offset[{-3, 
                0}, {-8.517193191416238, -0.6791866606065804}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-7.600902459542082, -0.33193036746095056`}, 
               Offset[{3, 
                0}, {-7.600902459542082, -0.33193036746095056`}]}, \
{{-7.600902459542082, -0.33193036746095056`}, 
               Offset[{-3, 
                0}, {-7.600902459542082, -0.33193036746095056`}]}, \
{{-7.600902459542082, -0.7356153317774647}, 
               Offset[{3, 
                0}, {-7.600902459542082, -0.7356153317774647}]}, \
{{-7.600902459542082, -0.7356153317774647}, 
               Offset[{-3, 
                0}, {-7.600902459542082, -0.7356153317774647}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-6.907755278982137, -0.3565858314116347}, 
               Offset[{3, 
                0}, {-6.907755278982137, -0.3565858314116347}]}, \
{{-6.907755278982137, -0.3565858314116347}, 
               Offset[{-3, 
                0}, {-6.907755278982137, -0.3565858314116347}]}, \
{{-6.907755278982137, -0.8540305769212991}, 
               Offset[{3, 
                0}, {-6.907755278982137, -0.8540305769212991}]}, \
{{-6.907755278982137, -0.8540305769212991}, 
               Offset[{-3, 
                0}, {-6.907755278982137, -0.8540305769212991}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-6.214608098422191, -0.3774655629168002}, 
               Offset[{3, 
                0}, {-6.214608098422191, -0.3774655629168002}]}, \
{{-6.214608098422191, -0.3774655629168002}, 
               Offset[{-3, 
                0}, {-6.214608098422191, -0.3774655629168002}]}, \
{{-6.214608098422191, -1.2114931675208958`}, 
               Offset[{3, 
                0}, {-6.214608098422191, -1.2114931675208958`}]}, \
{{-6.214608098422191, -1.2114931675208958`}, 
               Offset[{-3, 
                0}, {-6.214608098422191, -1.2114931675208958`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-5.298317366548036, -0.40348307354704666`}, 
               Offset[{3, 
                0}, {-5.298317366548036, -0.40348307354704666`}]}, \
{{-5.298317366548036, -0.40348307354704666`}, 
               Offset[{-3, 
                0}, {-5.298317366548036, -0.40348307354704666`}]}, \
{{-5.298317366548036, -1.2877167746650624`}, 
               Offset[{3, 
                0}, {-5.298317366548036, -1.2877167746650624`}]}, \
{{-5.298317366548036, -1.2877167746650624`}, 
               Offset[{-3, 
                0}, {-5.298317366548036, -1.2877167746650624`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-4.605170185988091, -0.48127053433151157`}, 
               Offset[{3, 
                0}, {-4.605170185988091, -0.48127053433151157`}]}, \
{{-4.605170185988091, -0.48127053433151157`}, 
               Offset[{-3, 
                0}, {-4.605170185988091, -0.48127053433151157`}]}, \
{{-4.605170185988091, -1.7147979443567338`}, 
               Offset[{3, 
                0}, {-4.605170185988091, -1.7147979443567338`}]}, \
{{-4.605170185988091, -1.7147979443567338`}, 
               Offset[{-3, 
                0}, {-4.605170185988091, -1.7147979443567338`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-3.912023005428146, -0.5137067656629168}, 
               Offset[{3, 
                0}, {-3.912023005428146, -0.5137067656629168}]}, \
{{-3.912023005428146, -0.5137067656629168}, 
               Offset[{-3, 
                0}, {-3.912023005428146, -0.5137067656629168}]}, \
{{-3.912023005428146, -1.8974206558330646`}, 
               Offset[{3, 
                0}, {-3.912023005428146, -1.8974206558330646`}]}, \
{{-3.912023005428146, -1.8974206558330646`}, 
               Offset[{-3, 
                0}, {-3.912023005428146, -1.8974206558330646`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-2.995732273553991, -0.5825405813038332}, 
               Offset[{3, 
                0}, {-2.995732273553991, -0.5825405813038332}]}, \
{{-2.995732273553991, -0.5825405813038332}, 
               Offset[{-3, 
                0}, {-2.995732273553991, -0.5825405813038332}]}, \
{{-2.995732273553991, -2.072302960909439}, 
               Offset[{3, 
                0}, {-2.995732273553991, -2.072302960909439}]}, \
{{-2.995732273553991, -2.072302960909439}, 
               Offset[{-3, 
                0}, {-2.995732273553991, -2.072302960909439}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-2.3025850929940455`, -0.7379689369917704}, 
               Offset[{3, 
                0}, {-2.3025850929940455`, -0.7379689369917704}]}, \
{{-2.3025850929940455`, -0.7379689369917704}, 
               Offset[{-3, 
                0}, {-2.3025850929940455`, -0.7379689369917704}]}, \
{{-2.3025850929940455`, -2.3331329692868}, 
               Offset[{3, 
                0}, {-2.3025850929940455`, -2.3331329692868}]}, \
{{-2.3025850929940455`, -2.3331329692868}, 
               Offset[{-3, 
                0}, {-2.3025850929940455`, -2.3331329692868}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-1.6094379124341003`, -0.8208905089186278}, 
               Offset[{3, 
                0}, {-1.6094379124341003`, -0.8208905089186278}]}, \
{{-1.6094379124341003`, -0.8208905089186278}, 
               Offset[{-3, 
                0}, {-1.6094379124341003`, -0.8208905089186278}]}, \
{{-1.6094379124341003`, -2.2689565921139163`}, 
               Offset[{3, 
                0}, {-1.6094379124341003`, -2.2689565921139163`}]}, \
{{-1.6094379124341003`, -2.2689565921139163`}, 
               Offset[{-3, 
                0}, {-1.6094379124341003`, -2.2689565921139163`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-0.6931471805599453, -0.9176156965237673}, 
               Offset[{3, 
                0}, {-0.6931471805599453, -0.9176156965237673}]}, \
{{-0.6931471805599453, -0.9176156965237673}, 
               Offset[{-3, 
                0}, {-0.6931471805599453, -0.9176156965237673}]}, \
{{-0.6931471805599453, -3.4315482953450003`}, 
               Offset[{3, 
                0}, {-0.6931471805599453, -3.4315482953450003`}]}, \
{{-0.6931471805599453, -3.4315482953450003`}, 
               Offset[{-3, 
                0}, {-0.6931471805599453, -3.4315482953450003`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{0., -7.014354079314666}, 
               Offset[{3, 0}, {0., -7.014354079314666}]}, {{
               0., -7.014354079314666}, 
               Offset[{-3, 0}, {0., -7.014354079314666}]}, {{
               0., -7.7003494833383614`}, 
               Offset[{3, 0}, {0., -7.7003494833383614`}]}, {{
               0., -7.7003494833383614`}, 
               Offset[{-3, 0}, {0., -7.7003494833383614`}]}}], {{{1., 0.}, {
             0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{0.6931471805599453, -1.6694129620716818`}, 
               Offset[{3, 0}, {0.6931471805599453, -1.6694129620716818`}]}, {{
               0.6931471805599453, -1.6694129620716818`}, 
               Offset[{-3, 0}, {
                0.6931471805599453, -1.6694129620716818`}]}, {{
               0.6931471805599453, -8.409827188930606}, 
               Offset[{3, 0}, {0.6931471805599453, -8.409827188930606}]}, {{
               0.6931471805599453, -8.409827188930606}, 
               Offset[{-3, 0}, {
                0.6931471805599453, -8.409827188930606}]}}], {{{1., 0.}, {0., 
             1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{1.6094379124341003`, -0.7358908692912747}, 
               Offset[{3, 0}, {1.6094379124341003`, -0.7358908692912747}]}, {{
               1.6094379124341003`, -0.7358908692912747}, 
               Offset[{-3, 0}, {
                1.6094379124341003`, -0.7358908692912747}]}, {{
               1.6094379124341003`, -0.9341223585084679}, 
               Offset[{3, 0}, {1.6094379124341003`, -0.9341223585084679}]}, {{
               1.6094379124341003`, -0.9341223585084679}, 
               Offset[{-3, 0}, {
                1.6094379124341003`, -0.9341223585084679}]}}], {{{1., 0.}, {
             0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.9, 0.36, 0.054], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{2.302585092994046, -0.5128886556625628}, 
               Offset[{3, 0}, {2.302585092994046, -0.5128886556625628}]}, {{
               2.302585092994046, -0.5128886556625628}, 
               Offset[{-3, 0}, {2.302585092994046, -0.5128886556625628}]}, {{
               2.302585092994046, -0.7125959529719993}, 
               Offset[{3, 0}, {2.302585092994046, -0.7125959529719993}]}, {{
               2.302585092994046, -0.7125959529719993}, 
               Offset[{-3, 0}, {
                2.302585092994046, -0.7125959529719993}]}}], {{{1., 0.}, {0., 
             1.}}, {0., 0.}}]},
          Antialiasing->False]}}, {
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-11.512925464970229`, -0.25441401805915015`}, 
               Offset[{3, 
                0}, {-11.512925464970229`, -0.25441401805915015`}]}, \
{{-11.512925464970229`, -0.25441401805915015`}, 
               Offset[{-3, 
                0}, {-11.512925464970229`, -0.25441401805915015`}]}, \
{{-11.512925464970229`, -0.5595134240441768}, 
               Offset[{3, 
                0}, {-11.512925464970229`, -0.5595134240441768}]}, \
{{-11.512925464970229`, -0.5595134240441768}, 
               Offset[{-3, 
                0}, {-11.512925464970229`, -0.5595134240441768}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-10.819778284410283`, -0.27775241252341826`}, 
               Offset[{3, 
                0}, {-10.819778284410283`, -0.27775241252341826`}]}, \
{{-10.819778284410283`, -0.27775241252341826`}, 
               Offset[{-3, 
                0}, {-10.819778284410283`, -0.27775241252341826`}]}, \
{{-10.819778284410283`, -0.6678505575724258}, 
               Offset[{3, 
                0}, {-10.819778284410283`, -0.6678505575724258}]}, \
{{-10.819778284410283`, -0.6678505575724258}, 
               Offset[{-3, 
                0}, {-10.819778284410283`, -0.6678505575724258}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-9.903487552536127, -0.35069288974710133`}, 
               Offset[{3, 
                0}, {-9.903487552536127, -0.35069288974710133`}]}, \
{{-9.903487552536127, -0.35069288974710133`}, 
               Offset[{-3, 
                0}, {-9.903487552536127, -0.35069288974710133`}]}, \
{{-9.903487552536127, -1.01700358538523}, 
               Offset[{3, 
                0}, {-9.903487552536127, -1.01700358538523}]}, \
{{-9.903487552536127, -1.01700358538523}, 
               Offset[{-3, 
                0}, {-9.903487552536127, -1.01700358538523}]}}], {{{1., 0.}, {
             0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-9.210340371976182, -0.5582707713540979}, 
               Offset[{3, 
                0}, {-9.210340371976182, -0.5582707713540979}]}, \
{{-9.210340371976182, -0.5582707713540979}, 
               Offset[{-3, 
                0}, {-9.210340371976182, -0.5582707713540979}]}, \
{{-9.210340371976182, -1.3622219442342898`}, 
               Offset[{3, 
                0}, {-9.210340371976182, -1.3622219442342898`}]}, \
{{-9.210340371976182, -1.3622219442342898`}, 
               Offset[{-3, 
                0}, {-9.210340371976182, -1.3622219442342898`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-8.517193191416238, -0.6963457671405906}, 
               Offset[{3, 
                0}, {-8.517193191416238, -0.6963457671405906}]}, \
{{-8.517193191416238, -0.6963457671405906}, 
               Offset[{-3, 
                0}, {-8.517193191416238, -0.6963457671405906}]}, \
{{-8.517193191416238, -1.7935933406302205`}, 
               Offset[{3, 
                0}, {-8.517193191416238, -1.7935933406302205`}]}, \
{{-8.517193191416238, -1.7935933406302205`}, 
               Offset[{-3, 
                0}, {-8.517193191416238, -1.7935933406302205`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-7.600902459542082, -0.8313957742134405}, 
               Offset[{3, 
                0}, {-7.600902459542082, -0.8313957742134405}]}, \
{{-7.600902459542082, -0.8313957742134405}, 
               Offset[{-3, 
                0}, {-7.600902459542082, -0.8313957742134405}]}, \
{{-7.600902459542082, -2.5620526403616206`}, 
               Offset[{3, 
                0}, {-7.600902459542082, -2.5620526403616206`}]}, \
{{-7.600902459542082, -2.5620526403616206`}, 
               Offset[{-3, 
                0}, {-7.600902459542082, -2.5620526403616206`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-6.907755278982137, -0.8870799517905363}, 
               Offset[{3, 
                0}, {-6.907755278982137, -0.8870799517905363}]}, \
{{-6.907755278982137, -0.8870799517905363}, 
               Offset[{-3, 
                0}, {-6.907755278982137, -0.8870799517905363}]}, \
{{-6.907755278982137, -4.14544862263419}, 
               Offset[{3, 
                0}, {-6.907755278982137, -4.14544862263419}]}, \
{{-6.907755278982137, -4.14544862263419}, 
               Offset[{-3, 
                0}, {-6.907755278982137, -4.14544862263419}]}}], {{{1., 0.}, {
             0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-6.214608098422191, -1.0898696680130389`}, 
               Offset[{3, 
                0}, {-6.214608098422191, -1.0898696680130389`}]}, \
{{-6.214608098422191, -1.0898696680130389`}, 
               Offset[{-3, 
                0}, {-6.214608098422191, -1.0898696680130389`}]}, \
{{-6.214608098422191, -4.31138021870164}, 
               Offset[{3, 
                0}, {-6.214608098422191, -4.31138021870164}]}, \
{{-6.214608098422191, -4.31138021870164}, 
               Offset[{-3, 
                0}, {-6.214608098422191, -4.31138021870164}]}}], {{{1., 0.}, {
             0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-5.298317366548036, -1.1462319036008375`}, 
               Offset[{3, 
                0}, {-5.298317366548036, -1.1462319036008375`}]}, \
{{-5.298317366548036, -1.1462319036008375`}, 
               Offset[{-3, 
                0}, {-5.298317366548036, -1.1462319036008375`}]}, \
{{-5.298317366548036, -8.283629850945506}, 
               Offset[{3, 
                0}, {-5.298317366548036, -8.283629850945506}]}, \
{{-5.298317366548036, -8.283629850945506}, 
               Offset[{-3, 
                0}, {-5.298317366548036, -8.283629850945506}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-4.605170185988091, -2.5732312871951146`}, 
               Offset[{3, 
                0}, {-4.605170185988091, -2.5732312871951146`}]}, \
{{-4.605170185988091, -2.5732312871951146`}, 
               Offset[{-3, 
                0}, {-4.605170185988091, -2.5732312871951146`}]}, \
{{-4.605170185988091, -4.400439517812046}, 
               Offset[{3, 
                0}, {-4.605170185988091, -4.400439517812046}]}, \
{{-4.605170185988091, -4.400439517812046}, 
               Offset[{-3, 
                0}, {-4.605170185988091, -4.400439517812046}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-3.912023005428146, -3.459446821347612}, 
               Offset[{3, 
                0}, {-3.912023005428146, -3.459446821347612}]}, \
{{-3.912023005428146, -3.459446821347612}, 
               Offset[{-3, 
                0}, {-3.912023005428146, -3.459446821347612}]}, \
{{-3.912023005428146, -9.257573550880668}, 
               Offset[{3, 
                0}, {-3.912023005428146, -9.257573550880668}]}, \
{{-3.912023005428146, -9.257573550880668}, 
               Offset[{-3, 
                0}, {-3.912023005428146, -9.257573550880668}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-2.995732273553991, -8.158366454203467}, 
               Offset[{3, 
                0}, {-2.995732273553991, -8.158366454203467}]}, \
{{-2.995732273553991, -8.158366454203467}, 
               Offset[{-3, 
                0}, {-2.995732273553991, -8.158366454203467}]}, \
{{-2.995732273553991, -8.831341875720527}, 
               Offset[{3, 
                0}, {-2.995732273553991, -8.831341875720527}]}, \
{{-2.995732273553991, -8.831341875720527}, 
               Offset[{-3, 
                0}, {-2.995732273553991, -8.831341875720527}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-2.3025850929940455`, -8.501285024588379}, 
               Offset[{3, 
                0}, {-2.3025850929940455`, -8.501285024588379}]}, \
{{-2.3025850929940455`, -8.501285024588379}, 
               Offset[{-3, 
                0}, {-2.3025850929940455`, -8.501285024588379}]}, \
{{-2.3025850929940455`, -8.943532643041909}, 
               Offset[{3, 
                0}, {-2.3025850929940455`, -8.943532643041909}]}, \
{{-2.3025850929940455`, -8.943532643041909}, 
               Offset[{-3, 
                0}, {-2.3025850929940455`, -8.943532643041909}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-1.6094379124341003`, -2.7152582825240925`}, 
               Offset[{3, 
                0}, {-1.6094379124341003`, -2.7152582825240925`}]}, \
{{-1.6094379124341003`, -2.7152582825240925`}, 
               Offset[{-3, 
                0}, {-1.6094379124341003`, -2.7152582825240925`}]}, \
{{-1.6094379124341003`, -7.758329504928021}, 
               Offset[{3, 
                0}, {-1.6094379124341003`, -7.758329504928021}]}, \
{{-1.6094379124341003`, -7.758329504928021}, 
               Offset[{-3, 
                0}, {-1.6094379124341003`, -7.758329504928021}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-0.6931471805599453, -1.4002280510657286`}, 
               Offset[{3, 
                0}, {-0.6931471805599453, -1.4002280510657286`}]}, \
{{-0.6931471805599453, -1.4002280510657286`}, 
               Offset[{-3, 
                0}, {-0.6931471805599453, -1.4002280510657286`}]}, \
{{-0.6931471805599453, -7.027701318157354}, 
               Offset[{3, 
                0}, {-0.6931471805599453, -7.027701318157354}]}, \
{{-0.6931471805599453, -7.027701318157354}, 
               Offset[{-3, 
                0}, {-0.6931471805599453, -7.027701318157354}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{0., -0.754071529344224}, 
               Offset[{3, 0}, {0., -0.754071529344224}]}, {{
               0., -0.754071529344224}, 
               Offset[{-3, 0}, {0., -0.754071529344224}]}, {{
               0., -1.1015109646926604`}, 
               Offset[{3, 0}, {0., -1.1015109646926604`}]}, {{
               0., -1.1015109646926604`}, 
               Offset[{-3, 0}, {0., -1.1015109646926604`}]}}], {{{1., 0.}, {
             0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{0.6931471805599453, -0.6289155149271866}, 
               Offset[{3, 0}, {0.6931471805599453, -0.6289155149271866}]}, {{
               0.6931471805599453, -0.6289155149271866}, 
               Offset[{-3, 0}, {0.6931471805599453, -0.6289155149271866}]}, {{
               0.6931471805599453, -0.7855798562625901}, 
               Offset[{3, 0}, {0.6931471805599453, -0.7855798562625901}]}, {{
               0.6931471805599453, -0.7855798562625901}, 
               Offset[{-3, 0}, {
                0.6931471805599453, -0.7855798562625901}]}}], {{{1., 0.}, {0.,
              1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{1.6094379124341003`, -0.7044012624634929}, 
               Offset[{3, 0}, {1.6094379124341003`, -0.7044012624634929}]}, {{
               1.6094379124341003`, -0.7044012624634929}, 
               Offset[{-3, 0}, {
                1.6094379124341003`, -0.7044012624634929}]}, {{
               1.6094379124341003`, -0.955288704106497}, 
               Offset[{3, 0}, {1.6094379124341003`, -0.955288704106497}]}, {{
               1.6094379124341003`, -0.955288704106497}, 
               Offset[{-3, 0}, {
                1.6094379124341003`, -0.955288704106497}]}}], {{{1., 0.}, {0.,
              1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.365248, 0.427802, 0.758297], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{2.302585092994046, -0.5579261285147372}, 
               Offset[{3, 0}, {2.302585092994046, -0.5579261285147372}]}, {{
               2.302585092994046, -0.5579261285147372}, 
               Offset[{-3, 0}, {2.302585092994046, -0.5579261285147372}]}, {{
               2.302585092994046, -0.8322985341262805}, 
               Offset[{3, 0}, {2.302585092994046, -0.8322985341262805}]}, {{
               2.302585092994046, -0.8322985341262805}, 
               Offset[{-3, 0}, {
                2.302585092994046, -0.8322985341262805}]}}], {{{1., 0.}, {0., 
             1.}}, {0., 0.}}]},
          Antialiasing->False]}}, {
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-11.512925464970229`, -0.2519678241806734}, 
               Offset[{3, 
                0}, {-11.512925464970229`, -0.2519678241806734}]}, \
{{-11.512925464970229`, -0.2519678241806734}, 
               Offset[{-3, 
                0}, {-11.512925464970229`, -0.2519678241806734}]}, \
{{-11.512925464970229`, -0.5484642750018992}, 
               Offset[{3, 
                0}, {-11.512925464970229`, -0.5484642750018992}]}, \
{{-11.512925464970229`, -0.5484642750018992}, 
               Offset[{-3, 
                0}, {-11.512925464970229`, -0.5484642750018992}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-10.819778284410283`, -0.2705783801105227}, 
               Offset[{3, 
                0}, {-10.819778284410283`, -0.2705783801105227}]}, \
{{-10.819778284410283`, -0.2705783801105227}, 
               Offset[{-3, 
                0}, {-10.819778284410283`, -0.2705783801105227}]}, \
{{-10.819778284410283`, -0.6047494073613302}, 
               Offset[{3, 
                0}, {-10.819778284410283`, -0.6047494073613302}]}, \
{{-10.819778284410283`, -0.6047494073613302}, 
               Offset[{-3, 
                0}, {-10.819778284410283`, -0.6047494073613302}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-9.903487552536127, -0.32948471493307213`}, 
               Offset[{3, 
                0}, {-9.903487552536127, -0.32948471493307213`}]}, \
{{-9.903487552536127, -0.32948471493307213`}, 
               Offset[{-3, 
                0}, {-9.903487552536127, -0.32948471493307213`}]}, \
{{-9.903487552536127, -0.8659634128427317}, 
               Offset[{3, 
                0}, {-9.903487552536127, -0.8659634128427317}]}, \
{{-9.903487552536127, -0.8659634128427317}, 
               Offset[{-3, 
                0}, {-9.903487552536127, -0.8659634128427317}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-9.210340371976182, -0.5056928165834714}, 
               Offset[{3, 
                0}, {-9.210340371976182, -0.5056928165834714}]}, \
{{-9.210340371976182, -0.5056928165834714}, 
               Offset[{-3, 
                0}, {-9.210340371976182, -0.5056928165834714}]}, \
{{-9.210340371976182, -1.250329275824922}, 
               Offset[{3, 
                0}, {-9.210340371976182, -1.250329275824922}]}, \
{{-9.210340371976182, -1.250329275824922}, 
               Offset[{-3, 
                0}, {-9.210340371976182, -1.250329275824922}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-8.517193191416238, -0.656410589248749}, 
               Offset[{3, 
                0}, {-8.517193191416238, -0.656410589248749}]}, \
{{-8.517193191416238, -0.656410589248749}, 
               Offset[{-3, 
                0}, {-8.517193191416238, -0.656410589248749}]}, \
{{-8.517193191416238, -1.4576491097064952`}, 
               Offset[{3, 
                0}, {-8.517193191416238, -1.4576491097064952`}]}, \
{{-8.517193191416238, -1.4576491097064952`}, 
               Offset[{-3, 
                0}, {-8.517193191416238, -1.4576491097064952`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-7.600902459542082, -0.8101219989254995}, 
               Offset[{3, 
                0}, {-7.600902459542082, -0.8101219989254995}]}, \
{{-7.600902459542082, -0.8101219989254995}, 
               Offset[{-3, 
                0}, {-7.600902459542082, -0.8101219989254995}]}, \
{{-7.600902459542082, -2.3700759142504793`}, 
               Offset[{3, 
                0}, {-7.600902459542082, -2.3700759142504793`}]}, \
{{-7.600902459542082, -2.3700759142504793`}, 
               Offset[{-3, 
                0}, {-7.600902459542082, -2.3700759142504793`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-6.907755278982137, -0.8336977975363261}, 
               Offset[{3, 
                0}, {-6.907755278982137, -0.8336977975363261}]}, \
{{-6.907755278982137, -0.8336977975363261}, 
               Offset[{-3, 
                0}, {-6.907755278982137, -0.8336977975363261}]}, \
{{-6.907755278982137, -2.5607924707881615`}, 
               Offset[{3, 
                0}, {-6.907755278982137, -2.5607924707881615`}]}, \
{{-6.907755278982137, -2.5607924707881615`}, 
               Offset[{-3, 
                0}, {-6.907755278982137, -2.5607924707881615`}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-6.214608098422191, -1.1025317554918137`}, 
               Offset[{3, 
                0}, {-6.214608098422191, -1.1025317554918137`}]}, \
{{-6.214608098422191, -1.1025317554918137`}, 
               Offset[{-3, 
                0}, {-6.214608098422191, -1.1025317554918137`}]}, \
{{-6.214608098422191, -4.070914944062966}, 
               Offset[{3, 
                0}, {-6.214608098422191, -4.070914944062966}]}, \
{{-6.214608098422191, -4.070914944062966}, 
               Offset[{-3, 
                0}, {-6.214608098422191, -4.070914944062966}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-5.298317366548036, -3.662280979856254}, 
               Offset[{3, 
                0}, {-5.298317366548036, -3.662280979856254}]}, \
{{-5.298317366548036, -3.662280979856254}, 
               Offset[{-3, 
                0}, {-5.298317366548036, -3.662280979856254}]}, \
{{-5.298317366548036, -5.83716092364682}, 
               Offset[{3, 
                0}, {-5.298317366548036, -5.83716092364682}]}, \
{{-5.298317366548036, -5.83716092364682}, 
               Offset[{-3, 
                0}, {-5.298317366548036, -5.83716092364682}]}}], {{{1., 0.}, {
             0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-4.605170185988091, -1.129880875641007}, 
               Offset[{3, 
                0}, {-4.605170185988091, -1.129880875641007}]}, \
{{-4.605170185988091, -1.129880875641007}, 
               Offset[{-3, 
                0}, {-4.605170185988091, -1.129880875641007}]}, \
{{-4.605170185988091, -4.300634271879715}, 
               Offset[{3, 
                0}, {-4.605170185988091, -4.300634271879715}]}, \
{{-4.605170185988091, -4.300634271879715}, 
               Offset[{-3, 
                0}, {-4.605170185988091, -4.300634271879715}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-3.912023005428146, -2.2866100371536864`}, 
               Offset[{3, 
                0}, {-3.912023005428146, -2.2866100371536864`}]}, \
{{-3.912023005428146, -2.2866100371536864`}, 
               Offset[{-3, 
                0}, {-3.912023005428146, -2.2866100371536864`}]}, \
{{-3.912023005428146, -7.644076273552012}, 
               Offset[{3, 
                0}, {-3.912023005428146, -7.644076273552012}]}, \
{{-3.912023005428146, -7.644076273552012}, 
               Offset[{-3, 
                0}, {-3.912023005428146, -7.644076273552012}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-2.995732273553991, -7.1926901486584764`}, 
               Offset[{3, 
                0}, {-2.995732273553991, -7.1926901486584764`}]}, \
{{-2.995732273553991, -7.1926901486584764`}, 
               Offset[{-3, 
                0}, {-2.995732273553991, -7.1926901486584764`}]}, \
{{-2.995732273553991, -8.587445255225088}, 
               Offset[{3, 
                0}, {-2.995732273553991, -8.587445255225088}]}, \
{{-2.995732273553991, -8.587445255225088}, 
               Offset[{-3, 
                0}, {-2.995732273553991, -8.587445255225088}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-2.3025850929940455`, -8.028576074649838}, 
               Offset[{3, 
                0}, {-2.3025850929940455`, -8.028576074649838}]}, \
{{-2.3025850929940455`, -8.028576074649838}, 
               Offset[{-3, 
                0}, {-2.3025850929940455`, -8.028576074649838}]}, \
{{-2.3025850929940455`, -9.431315145913885}, 
               Offset[{3, 
                0}, {-2.3025850929940455`, -9.431315145913885}]}, \
{{-2.3025850929940455`, -9.431315145913885}, 
               Offset[{-3, 
                0}, {-2.3025850929940455`, -9.431315145913885}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-1.6094379124341003`, -8.100041341814123}, 
               Offset[{3, 
                0}, {-1.6094379124341003`, -8.100041341814123}]}, \
{{-1.6094379124341003`, -8.100041341814123}, 
               Offset[{-3, 
                0}, {-1.6094379124341003`, -8.100041341814123}]}, \
{{-1.6094379124341003`, -8.717024194433389}, 
               Offset[{3, 
                0}, {-1.6094379124341003`, -8.717024194433389}]}, \
{{-1.6094379124341003`, -8.717024194433389}, 
               Offset[{-3, 
                0}, {-1.6094379124341003`, -8.717024194433389}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{-0.6931471805599453, -5.645526863935549}, 
               Offset[{3, 
                0}, {-0.6931471805599453, -5.645526863935549}]}, \
{{-0.6931471805599453, -5.645526863935549}, 
               Offset[{-3, 
                0}, {-0.6931471805599453, -5.645526863935549}]}, \
{{-0.6931471805599453, -7.13421843244189}, 
               Offset[{3, 
                0}, {-0.6931471805599453, -7.13421843244189}]}, \
{{-0.6931471805599453, -7.13421843244189}, 
               Offset[{-3, 
                0}, {-0.6931471805599453, -7.13421843244189}]}}], {{{1., 
             0.}, {0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{0., -1.2096446486101495`}, 
               Offset[{3, 0}, {0., -1.2096446486101495`}]}, {{
               0., -1.2096446486101495`}, 
               Offset[{-3, 0}, {0., -1.2096446486101495`}]}, {{
               0., -2.8149947105163395`}, 
               Offset[{3, 0}, {0., -2.8149947105163395`}]}, {{
               0., -2.8149947105163395`}, 
               Offset[{-3, 0}, {0., -2.8149947105163395`}]}}], {{{1., 0.}, {
             0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{0.6931471805599453, -0.5127286803373978}, 
               Offset[{3, 0}, {0.6931471805599453, -0.5127286803373978}]}, {{
               0.6931471805599453, -0.5127286803373978}, 
               Offset[{-3, 0}, {0.6931471805599453, -0.5127286803373978}]}, {{
               0.6931471805599453, -0.911998105704811}, 
               Offset[{3, 0}, {0.6931471805599453, -0.911998105704811}]}, {{
               0.6931471805599453, -0.911998105704811}, 
               Offset[{-3, 0}, {
                0.6931471805599453, -0.911998105704811}]}}], {{{1., 0.}, {0., 
             1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{1.6094379124341003`, -0.7598885565373079}, 
               Offset[{3, 0}, {1.6094379124341003`, -0.7598885565373079}]}, {{
               1.6094379124341003`, -0.7598885565373079}, 
               Offset[{-3, 0}, {
                1.6094379124341003`, -0.7598885565373079}]}, {{
               1.6094379124341003`, -0.8345544009871018}, 
               Offset[{3, 0}, {1.6094379124341003`, -0.8345544009871018}]}, {{
               1.6094379124341003`, -0.8345544009871018}, 
               Offset[{-3, 0}, {
                1.6094379124341003`, -0.8345544009871018}]}}], {{{1., 0.}, {
             0., 1.}}, {0., 0.}}]},
          Antialiasing->False]}, 
        {RGBColor[0.945109, 0.593901, 0.], CapForm["Butt"], 
         StyleBox[{
           GeometricTransformationBox[
            LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
           GeometricTransformationBox[
            LineBox[{{{2.302585092994046, -0.6557778852723178}, 
               Offset[{3, 0}, {2.302585092994046, -0.6557778852723178}]}, {{
               2.302585092994046, -0.6557778852723178}, 
               Offset[{-3, 0}, {2.302585092994046, -0.6557778852723178}]}, {{
               2.302585092994046, -0.8791822524478724}, 
               Offset[{3, 0}, {2.302585092994046, -0.8791822524478724}]}, {{
               2.302585092994046, -0.8791822524478724}, 
               Offset[{-3, 0}, {
                2.302585092994046, -0.8791822524478724}]}}], {{{1., 0.}, {0., 
             1.}}, {0., 0.}}]},
          Antialiasing->False]}}}}, {{{}, {}, 
       {RGBColor[0.9, 0.36, 0.054], PointSize[0.011000000000000001`], 
        AbsoluteThickness[1.6], CapForm["Butt"], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQHb1qkdY8NvUDITV/Hx7uO79/D9vmXzsXqx4o67Rd
Unvryv4tP5a8nnpO+UBub8y9kCXX94uGbt29MVvpgHT8V5HW5Nv7yzce7T7L
oXjgb1353YJD9/bfc8v/GZQud8B0QU7Mq7wH+xf875/ZtVD6gFHctLy7yY/2
J+3YYHnotsSBEpvdARe2P9sfPGeKdJWh6IGt2xfeDmR/ATVf6EBB/gn9E2lv
96+XXrP9kjf/AUvmQ8eCyt7vn/i4uNrpO/uBzPqU590aH6HqmQ4Y266a4vTx
837j3rffHQ/83N9mEvjx3o0v+99b/vrnpPds/xkn3Z5bbT/2M0DBtLjzXdeM
ZA9A5e1n+11vlHoCNAei377kUnml8YRX+8Ug5jv0P5v953zR4/0AjHKp3w==

         "]]}, 
       {RGBColor[0.365248, 0.427802, 0.758297], PointSize[
        0.011000000000000001`], AbsoluteThickness[1.6], CapForm["Butt"], 
        LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQHb1qkdY8NvUDQpOd/p/0vbl/D9vmXzsXqx5o/HJt
wVqeu/u3/Fjyeuo55QOsJ4o/L1B+sl80dOvujdlKB75kfZg+xfTN/vKNR7vP
cigeeJEX3Thv/sf999zyfwalyx3ozz/vnXPi6/4F//tndi2UPnB8zwtTwXU/
9ift2GB56LbEgV3NOc8Ynv/eHzxninSVoeiB77b7Vl3P+gs1X+jArVML9/B9
4DiwXnrN9kve/Adms9avVJ8pcGDi4+Jqp+/sB8oNbcxfPlA4AFHPdOCy5PdX
JamKB4x73353PPBzf/mhUEdbc+4D7y1//XPSe7b/H8+/DQ+2MxxggALJXcdX
V5i+3Q+Vtz/leaBqVcez/VD99k0xdxad9X21XwxivkOD8e6e5o9P9wMA6lKp
cA==
         "]]}, 
       {RGBColor[0.945109, 0.593901, 0.], PointSize[0.011000000000000001`], 
        AbsoluteThickness[1.6], CapForm["Butt"], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQHb1qkdY8NvUDewLXJR18eWP/HrbNv3YuVj3QXHus
gEv+9v4tP5a8nnpO+cCc0Me1fn8f7hcN3bp7Y7bSgSDLo1rtb1/uL994tPss
h+KBTp5u3VVB7/ffc8v/GZQudyDa5t8+WYav+xf875/ZtVD6wA9NY4Xl57/u
T9qxwfLQbYkD+w8+kr719vf+4DlTpKsMRQ/kq1XwHforcABivtCBNeF7LLc3
/dm/XnrN9kve/Ad+xf+///IM+4GJj4urnb6zH1jhq+4ZvEIOqp7pALPjBclP
DIoHjHvffnc88HO/foPeFb2dCgfeW/7656T3bP+T2Jmn8rokDjBAgYfqTzOH
lt/7ofL2dQteMDdrPtsP1W9fEyLTpFj7cr8YxHyHI8u4GYxiXuwHAJt4oVc=

         "]]}}, {
       {RGBColor[0.9, 0.36, 0.054], PointSize[0.011000000000000001`], 
        AbsoluteThickness[1.6], CapForm["Butt"]}, 
       {RGBColor[0.365248, 0.427802, 0.758297], PointSize[
        0.011000000000000001`], AbsoluteThickness[1.6], CapForm["Butt"]}, 
       {RGBColor[0.945109, 0.593901, 0.], PointSize[0.011000000000000001`], 
        AbsoluteThickness[1.6], CapForm["Butt"]}}, {
       {RGBColor[0.9, 0.36, 0.054], PointSize[0.011000000000000001`], 
        AbsoluteThickness[1.6], CapForm["Butt"]}, 
       {RGBColor[0.365248, 0.427802, 0.758297], PointSize[
        0.011000000000000001`], AbsoluteThickness[1.6], CapForm["Butt"]}, 
       {RGBColor[0.945109, 0.593901, 0.], PointSize[0.011000000000000001`], 
        AbsoluteThickness[1.6], CapForm[
        "Butt"]}, {}, {}, {}, {}, {}, {}, {}}, {
       {RGBColor[0.9, 0.36, 0.054], PointSize[0.011000000000000001`], 
        AbsoluteThickness[1.6], CapForm["Butt"]}, 
       {RGBColor[0.365248, 0.427802, 0.758297], PointSize[
        0.011000000000000001`], AbsoluteThickness[1.6], CapForm["Butt"]}, 
       {RGBColor[0.945109, 0.593901, 0.], PointSize[0.011000000000000001`], 
        AbsoluteThickness[1.6], CapForm[
        "Butt"]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {{}, {}}}}, InsetBox[
     TemplateBox[{"\"SGD\"", "\"RMSprop\"", "\"Adam\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               GraphicsBox[{{
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   RGBColor[0.9, 0.36, 0.054], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6]], {
                   LineBox[{{0, 10}, {20, 10}}]}}, {
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   RGBColor[0.9, 0.36, 0.054], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                ImageSize -> {20, 10}, PlotRangePadding -> None, ImagePadding -> 
                Automatic, 
                BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
               GraphicsBox[{{
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   RGBColor[0.365248, 0.427802, 0.758297], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6]], {
                   LineBox[{{0, 10}, {20, 10}}]}}, {
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   RGBColor[0.365248, 0.427802, 0.758297], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                ImageSize -> {20, 10}, PlotRangePadding -> None, ImagePadding -> 
                Automatic, 
                BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
               GraphicsBox[{{
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   RGBColor[0.945109, 0.593901, 0.], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6]], {
                   LineBox[{{0, 10}, {20, 10}}]}}, {
                  Directive[
                   EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                   PointSize[0.5], 
                   RGBColor[0.945109, 0.593901, 0.], 
                   CapForm["Butt"], 
                   AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                ImageSize -> {20, 10}, PlotRangePadding -> None, ImagePadding -> 
                Automatic, 
                BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> False,
              GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Times"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.9, 0.36, 0.054], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6000000000000001, 0.24, 0.036000000000000004`],
                     FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.9`", ",", "0.36`", ",", "0.054`"}], "]"}], 
                    NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.9, 0.36, 0.054]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.9, 0.36, 0.054], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"CapForm", "[", "\"Butt\"", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.365248, 0.427802, 0.758297], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.2434986666666667, 0.28520133333333336`, 
                    0.5055313333333333], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.365248`", ",", "0.427802`", ",", "0.758297`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.365248, 0.427802, 0.758297]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.365248, 0.427802, 0.758297], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"CapForm", "[", "\"Butt\"", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.945109, 0.593901, 0.], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6300726666666667, 0.395934, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.945109`", ",", "0.593901`", ",", "0.`"}], 
                    "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.945109, 0.593901, 0.]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.945109, 0.593901, 0.], Editable -> False, 
                    Selectable -> False], ",", 
                   RowBox[{"CapForm", "[", "\"Butt\"", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"FontFamily", "\[Rule]", "\"Times\""}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "table"}]}], "]"}]& )], 
     Scaled[{0.1, 0.1}], ImageScaled[{0.1, 0.1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{False, False},
   AxesLabel->{None, None},
   AxesOrigin->{-12.094568053565078`, -10.155204230323175`},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"validation loss\"", TraditionalForm], None}, {
      FormBox["\"learning rate\"", TraditionalForm], None}},
   FrameStyle->Directive[
     Directive[{
       GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}], 
     GrayLevel[0]],
   FrameTicks->FrontEndValueCache[{{
       Charting`ScaledTicks[{Log, Exp}], 
       Charting`ScaledFrameTicks[{Log, Exp}]}, {
       Charting`ScaledTicks[{Log, Exp}], 
       Charting`ScaledFrameTicks[{Log, Exp}]}}, {{{{-9.210340371976182, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
         FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
         0.}}, {-2.3025850929940455`, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
         FormBox["1", TraditionalForm], {0.01, 0.}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.517193191416238, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.111728083308073, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.824046010856292, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.600902459542082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.418580902748128, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.264430222920869, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.1308988302963465`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.013115794639964, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-6.214608098422191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.809142990314028, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.521460917862246, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.298317366548036, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.115995809754082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.961845129926823, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.8283137373023015`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.710530701645918, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.506557897319982, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.2188758248682006`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.8134107167600364`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.659260036932778, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.5257286443082556`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.4079456086518722`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.2039728043259361`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.916290731874155, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.5108256237659907, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.35667494393873245`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.2231435513142097, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.10536051565782628`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.302585092994046, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.70805020110221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}}, {{-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-6.907755278982137, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-4.605170185988091, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-2.3025850929940455`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        0., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.517193191416238, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.111728083308073, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.824046010856292, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.600902459542082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.418580902748128, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.264430222920869, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.1308988302963465`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.013115794639964, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-6.214608098422191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.809142990314028, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.521460917862246, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.298317366548036, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.115995809754082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.961845129926823, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.8283137373023015`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.710530701645918, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.506557897319982, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.2188758248682006`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.8134107167600364`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.659260036932778, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.5257286443082556`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.4079456086518722`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.2039728043259361`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.916290731874155, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.5108256237659907, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.35667494393873245`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.2231435513142097, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.10536051565782628`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.302585092994046, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.70805020110221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}}}, {{{-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm], {0.01, 0.}}, {-6.907755278982137, 
         FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
         0.}}, {-2.3025850929940455`, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
         FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
         FormBox["10", TraditionalForm], {0.01, 0.}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.517193191416238, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.111728083308073, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.824046010856292, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.600902459542082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.418580902748128, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.264430222920869, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.1308988302963465`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.013115794639964, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-6.214608098422191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.809142990314028, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.521460917862246, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.298317366548036, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.115995809754082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.961845129926823, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.8283137373023015`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.710530701645918, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.506557897319982, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.2188758248682006`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.8134107167600364`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.659260036932778, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.5257286443082556`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.4079456086518722`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.2039728043259361`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.916290731874155, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.5108256237659907, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.35667494393873245`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.2231435513142097, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.10536051565782628`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.4011973816621555`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.6888794541139363`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.0943445622221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.248495242049359, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.382026634673881, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.499809670330265, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.605170185988092, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}}, {{-11.512925464970229`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-6.907755278982137, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-4.605170185988091, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-2.3025850929940455`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        0., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {
        2.302585092994046, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
         0.}}, {-13.815510557964274`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-13.122363377404328`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.716898269296165`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.429216196844383`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.206072645530174`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-12.02375108873622, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.86960040890896, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.736069016284437`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-11.618285980628055`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.819778284410283`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.41431317630212, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-10.126631103850338`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.903487552536127, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.721165995742174, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.567015315914915, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.433483923290392, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-9.315700887634009, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.517193191416238, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-8.111728083308073, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.824046010856292, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.600902459542082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.418580902748128, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.264430222920869, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.1308988302963465`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-7.013115794639964, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-6.214608098422191, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.809142990314028, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.521460917862246, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.298317366548036, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-5.115995809754082, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.961845129926823, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.8283137373023015`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-4.710530701645918, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.506557897319982, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-3.2188758248682006`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.8134107167600364`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.659260036932778, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.5257286443082556`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-2.4079456086518722`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-1.2039728043259361`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.916290731874155, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.5108256237659907, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.35667494393873245`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.2231435513142097, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
         0.}}, {-0.10536051565782628`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        0.6931471805599453, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.0986122886681098`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.3862943611198906`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.6094379124341003`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.791759469228055, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        1.9459101490553132`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.0794415416798357`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.1972245773362196`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        2.995732273553991, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.4011973816621555`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.6888794541139363`, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        3.912023005428146, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.0943445622221, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.248495242049359, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.382026634673881, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.499809670330265, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
        4.605170185988092, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}}],
   GridLines->FrontEndValueCache[{
      Charting`ScaledTickValues[{Log, Exp}], 
      Charting`ScaledTickValues[{Log, Exp}]}, {{{-11.512925464970229`, 
        Directive[]}, {-9.210340371976182, 
        Directive[]}, {-6.907755278982137, 
        Directive[]}, {-4.605170185988091, 
        Directive[]}, {-2.3025850929940455`, 
        Directive[]}, {0., 
        Directive[]}, {2.302585092994046, 
        Directive[]}}, {{-9.210340371976182, 
        Directive[]}, {-6.907755278982137, 
        Directive[]}, {-4.605170185988091, 
        Directive[]}, {-2.3025850929940455`, 
        Directive[]}, {0., 
        Directive[]}}}],
   GridLinesStyle->Directive[
     GrayLevel[0.4, 0.5], 
     AbsoluteThickness[1], 
     AbsoluteDashing[{1, 2}]],
   ImageSize->300,
   LabelStyle->{FontFamily -> "Times"},
   Method->{
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         Exp[
          Part[#, 1]], 
         Exp[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Exp[
          Part[#, 1]], 
         Exp[
          Part[#, 2]]}& )}},
   PlotRange->{{-12.094568053565078`, 
    2.302585092994046}, {-10.155204230323175`, -0.18100730392040543`}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.02], 
      Scaled[0.08090169943749476]}},
   Ticks->{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}],
  InterpretTemplate[Legended[
    Graphics[{{{{{Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-11.512925464970229`, -0.31667960893072905`}, \
{-11.512925464970229`, -0.24654434714008977`}}], 
           
           Line[{{-11.512925464970229`, -0.24654434714008977`}, \
{-11.512925464970229`, -0.18100730392040543`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-10.819778284410283`, -0.4183124965259544}, \
{-10.819778284410283`, -0.3258356193456601}}], 
           
           Line[{{-10.819778284410283`, -0.3258356193456601}, \
{-10.819778284410283`, -0.2411914755590833}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-9.903487552536127, -0.49388764950021086`}, \
{-9.903487552536127, -0.3694049998759599}}], 
           
           Line[{{-9.903487552536127, -0.3694049998759599}, \
{-9.903487552536127, -0.25871692363346177`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-9.210340371976182, -0.5825077338161291}, \
{-9.210340371976182, -0.42794920965887834`}}], 
           
           Line[{{-9.210340371976182, -0.42794920965887834`}, \
{-9.210340371976182, -0.2941120429084297}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-8.517193191416238, -0.6791866606065804}, \
{-8.517193191416238, -0.48061772945037246`}}], 
           
           Line[{{-8.517193191416238, -0.48061772945037246`}, \
{-8.517193191416238, -0.3150213044298385}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-7.600902459542082, -0.7356153317774647}, \
{-7.600902459542082, -0.51353948642373}}], 
           
           Line[{{-7.600902459542082, -0.51353948642373}, \
{-7.600902459542082, -0.33193036746095056`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-6.907755278982137, -0.8540305769212991}, \
{-6.907755278982137, -0.5746905479345001}}], 
           
           Line[{{-6.907755278982137, -0.5746905479345001}, \
{-6.907755278982137, -0.3565858314116347}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-6.214608098422191, -1.2114931675208958`}, \
{-6.214608098422191, -0.7099381996903404}}], 
           
           Line[{{-6.214608098422191, -0.7099381996903404}, \
{-6.214608098422191, -0.3774655629168002}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-5.298317366548036, -1.2877167746650624`}, \
{-5.298317366548036, -0.7508935250932526}}], 
           
           Line[{{-5.298317366548036, -0.7508935250932526}, \
{-5.298317366548036, -0.40348307354704666`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-4.605170185988091, -1.7147979443567338`}, \
{-4.605170185988091, -0.9187966283093214}}], 
           
           Line[{{-4.605170185988091, -0.9187966283093214}, \
{-4.605170185988091, -0.48127053433151157`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-3.912023005428146, -1.8974206558330646`}, \
{-3.912023005428146, -0.9831937677373396}}], 
           
           Line[{{-3.912023005428146, -0.9831937677373396}, \
{-3.912023005428146, -0.5137067656629168}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-2.995732273553991, -2.072302960909439}, \
{-2.995732273553991, -1.0723990477344734`}}], 
           
           Line[{{-2.995732273553991, -1.0723990477344734`}, \
{-2.995732273553991, -0.5825405813038332}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-2.3025850929940455`, -2.3331329692868}, \
{-2.3025850929940455`, -1.2464013869501513`}}], 
           
           Line[{{-2.3025850929940455`, -1.2464013869501513`}, \
{-2.3025850929940455`, -0.7379689369917704}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-1.6094379124341003`, -2.2689565921139163`}, \
{-1.6094379124341003`, -1.3029469896748949`}}], 
           
           Line[{{-1.6094379124341003`, -1.3029469896748949`}, \
{-1.6094379124341003`, -0.8208905089186278}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{-0.6931471805599453, -3.4315482953450003`}, \
{-0.6931471805599453, -1.5329232669502515`}}], 
           
           Line[{{-0.6931471805599453, -1.5329232669502515`}, \
{-0.6931471805599453, -0.9176156965237673}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           Line[{{0., -7.7003494833383614`}, {0., -7.299646538645581}}], 
           Line[{{0., -7.299646538645581}, {0., -7.014354079314666}}]}}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{0.6931471805599453, -8.409827188930606}, {
            0.6931471805599453, -2.36137868345561}}], 
           
           Line[{{0.6931471805599453, -2.36137868345561}, {
            0.6931471805599453, -1.6694129620716818`}}]}}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{1.6094379124341003`, -0.9341223585084679}, {
            1.6094379124341003`, -0.8301026699469518}}], 
           
           Line[{{1.6094379124341003`, -0.8301026699469518}, {
            1.6094379124341003`, -0.7358908692912747}}]}}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], {}, {
           
           Line[{{2.302585092994046, -0.7125959529719993}, {
            2.302585092994046, -0.607765191437652}}], 
           
           Line[{{2.302585092994046, -0.607765191437652}, {
            2.302585092994046, -0.5128886556625628}}]}}}, {{
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-11.512925464970229`, -0.5595134240441768}, \
{-11.512925464970229`, -0.39537286689510254`}}], 
           
           Line[{{-11.512925464970229`, -0.39537286689510254`}, \
{-11.512925464970229`, -0.25441401805915015`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-10.819778284410283`, -0.6678505575724258}, \
{-10.819778284410283`, -0.4538988180827986}}], 
           
           Line[{{-10.819778284410283`, -0.4538988180827986}, \
{-10.819778284410283`, -0.27775241252341826`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-9.903487552536127, -1.01700358538523}, \
{-9.903487552536127, -0.6293492083480038}}], 
           
           Line[{{-9.903487552536127, -0.6293492083480038}, \
{-9.903487552536127, -0.35069288974710133`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-9.210340371976182, -1.3622219442342898`}, \
{-9.210340371976182, -0.8815405814706012}}], 
           
           Line[{{-9.210340371976182, -0.8815405814706012}, \
{-9.210340371976182, -0.5582707713540979}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-8.517193191416238, -1.7935933406302205`}, \
{-8.517193191416238, -1.1014695218099693`}}], 
           
           Line[{{-8.517193191416238, -1.1014695218099693`}, \
{-8.517193191416238, -0.6963457671405906}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-7.600902459542082, -2.5620526403616206`}, \
{-7.600902459542082, -1.361431404241532}}], 
           
           Line[{{-7.600902459542082, -1.361431404241532}, \
{-7.600902459542082, -0.8313957742134405}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-6.907755278982137, -4.14544862263419}, \
{-6.907755278982137, -1.5424968820405398`}}], 
           
           Line[{{-6.907755278982137, -1.5424968820405398`}, \
{-6.907755278982137, -0.8870799517905363}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-6.214608098422191, -4.31138021870164}, \
{-6.214608098422191, -1.7438973427708633`}}], 
           
           Line[{{-6.214608098422191, -1.7438973427708633`}, \
{-6.214608098422191, -1.0898696680130389`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-5.298317366548036, -8.283629850945506}, \
{-5.298317366548036, -1.8385845822957643`}}], 
           
           Line[{{-5.298317366548036, -1.8385845822957643`}, \
{-5.298317366548036, -1.1462319036008375`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-4.605170185988091, -4.400439517812046}, \
{-4.605170185988091, -3.11721560829879}}], 
           
           Line[{{-4.605170185988091, -3.11721560829879}, \
{-4.605170185988091, -2.5732312871951146`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-3.912023005428146, -9.257573550880668}, \
{-3.912023005428146, -4.149565361383249}}], 
           
           Line[{{-3.912023005428146, -4.149565361383249}, \
{-3.912023005428146, -3.459446821347612}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-2.995732273553991, -8.831341875720527}, \
{-2.995732273553991, -8.439279295060926}}], 
           
           Line[{{-2.995732273553991, -8.439279295060926}, \
{-2.995732273553991, -8.158366454203467}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-2.3025850929940455`, -8.943532643041909}, \
{-2.3025850929940455`, -8.698157637275392}}], 
           
           Line[{{-2.3025850929940455`, -8.698157637275392}, \
{-2.3025850929940455`, -8.501285024588379}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-1.6094379124341003`, -7.758329504928021}, \
{-1.6094379124341003`, -3.401972303800274}}], 
           
           Line[{{-1.6094379124341003`, -3.401972303800274}, \
{-1.6094379124341003`, -2.7152582825240925`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{-0.6931471805599453, -7.027701318157354}, \
{-0.6931471805599453, -2.089784033539785}}], 
           
           Line[{{-0.6931471805599453, -2.089784033539785}, \
{-0.6931471805599453, -1.4002280510657286`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           Line[{{0., -1.1015109646926604`}, {0., -0.9127772669870097}}], 
           Line[{{0., -0.9127772669870097}, {0., -0.754071529344224}}]}}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           Line[{{0.6931471805599453, -0.7855798562625901}, {
            0.6931471805599453, -0.7041828534586838}}], 
           
           Line[{{0.6931471805599453, -0.7041828534586838}, {
            0.6931471805599453, -0.6289155149271866}}]}}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{1.6094379124341003`, -0.955288704106497}, {
            1.6094379124341003`, -0.8219974690317857}}], 
           
           Line[{{1.6094379124341003`, -0.8219974690317857}, {
            1.6094379124341003`, -0.7044012624634929}}]}}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], {}, {
           
           Line[{{2.302585092994046, -0.8322985341262805}, {
            2.302585092994046, -0.6857316731126133}}], 
           
           Line[{{2.302585092994046, -0.6857316731126133}, {
            2.302585092994046, -0.5579261285147372}}]}}}, {{
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-11.512925464970229`, -0.5484642750018992}, \
{-11.512925464970229`, -0.38926729809579874`}}], 
           
           Line[{{-11.512925464970229`, -0.38926729809579874`}, \
{-11.512925464970229`, -0.2519678241806734}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-10.819778284410283`, -0.6047494073613302}, \
{-10.819778284410283`, -0.4237695790597728}}], 
           
           Line[{{-10.819778284410283`, -0.4237695790597728}, \
{-10.819778284410283`, -0.2705783801105227}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-9.903487552536127, -0.8659634128427317}, \
{-9.903487552536127, -0.562171216845559}}], 
           
           Line[{{-9.903487552536127, -0.562171216845559}, \
{-9.903487552536127, -0.32948471493307213`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-9.210340371976182, -1.250329275824922}, \
{-9.210340371976182, -0.8102451167449465}}], 
           
           Line[{{-9.210340371976182, -0.8102451167449465}, \
{-9.210340371976182, -0.5056928165834714}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-8.517193191416238, -1.4576491097064952`}, \
{-8.517193191416238, -0.9788409127726406}}], 
           
           Line[{{-8.517193191416238, -0.9788409127726406}, \
{-8.517193191416238, -0.656410589248749}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-7.600902459542082, -2.3700759142504793`}, \
{-7.600902459542082, -1.3125283680599498`}}], 
           
           Line[{{-7.600902459542082, -1.3125283680599498`}, \
{-7.600902459542082, -0.8101219989254995}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-6.907755278982137, -2.5607924707881615`}, \
{-6.907755278982137, -1.3631964929396627`}}], 
           
           Line[{{-6.907755278982137, -1.3631964929396627`}, \
{-6.907755278982137, -0.8336977975363261}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-6.214608098422191, -4.070914944062966}, \
{-6.214608098422191, -1.7455693330085607`}}], 
           
           Line[{{-6.214608098422191, -1.7455693330085607`}, \
{-6.214608098422191, -1.1025317554918137`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-5.298317366548036, -5.83716092364682}, \
{-5.298317366548036, -4.247810579379446}}], 
           
           Line[{{-5.298317366548036, -4.247810579379446}, \
{-5.298317366548036, -3.662280979856254}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-4.605170185988091, -4.300634271879715}, \
{-4.605170185988091, -1.781913018732193}}], 
           
           Line[{{-4.605170185988091, -1.781913018732193}, \
{-4.605170185988091, -1.129880875641007}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-3.912023005428146, -7.644076273552012}, \
{-3.912023005428146, -2.9750554561433065`}}], 
           
           Line[{{-3.912023005428146, -2.9750554561433065`}, \
{-3.912023005428146, -2.2866100371536864`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-2.995732273553991, -8.587445255225088}, \
{-2.995732273553991, -7.66438020994557}}], 
           
           Line[{{-2.995732273553991, -7.66438020994557}, \
{-2.995732273553991, -7.1926901486584764`}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-2.3025850929940455`, -9.431315145913885}, \
{-2.3025850929940455`, -8.501847082778573}}], 
           
           Line[{{-2.3025850929940455`, -8.501847082778573}, \
{-2.3025850929940455`, -8.028576074649838}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-1.6094379124341003`, -8.717024194433389}, \
{-1.6094379124341003`, -8.36168540065418}}], 
           
           Line[{{-1.6094379124341003`, -8.36168540065418}, \
{-1.6094379124341003`, -8.100041341814123}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{-0.6931471805599453, -7.13421843244189}, \
{-0.6931471805599453, -6.1351882606609}}], 
           
           Line[{{-0.6931471805599453, -6.1351882606609}, \
{-0.6931471805599453, -5.645526863935549}}]}}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           Line[{{0., -2.8149947105163395`}, {0., -1.7197878024474722`}}], 
           Line[{{0., -1.7197878024474722`}, {0., -1.2096446486101495`}}]}}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{0.6931471805599453, -0.911998105704811}, {
            0.6931471805599453, -0.6925673557607437}}], 
           
           Line[{{0.6931471805599453, -0.6925673557607437}, {
            0.6931471805599453, -0.5127286803373978}}]}}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{1.6094379124341003`, -0.8345544009871018}, {
            1.6094379124341003`, -0.7965247670387181}}], 
           
           Line[{{1.6094379124341003`, -0.7965247670387181}, {
            1.6094379124341003`, -0.7598885565373079}}]}}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], {}, {
           
           Line[{{2.302585092994046, -0.8791822524478724}, {
            2.302585092994046, -0.7612543106926855}}], 
           
           Line[{{2.302585092994046, -0.7612543106926855}, {
            2.302585092994046, -0.6557778852723178}}]}}}}, {{{
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-11.512925464970229`, -0.24654434714008977`}], 
          Rotate[
           Line[{{{-11.512925464970229`, -0.18100730392040543`}, 
              
              Offset[{3, 
               0}, {-11.512925464970229`, -0.18100730392040543`}]}, \
{{-11.512925464970229`, -0.18100730392040543`}, 
              
              Offset[{-3, 
               0}, {-11.512925464970229`, -0.18100730392040543`}]}, \
{{-11.512925464970229`, -0.31667960893072905`}, 
              
              Offset[{3, 
               0}, {-11.512925464970229`, -0.31667960893072905`}]}, \
{{-11.512925464970229`, -0.31667960893072905`}, 
              
              Offset[{-3, 
               0}, {-11.512925464970229`, -0.31667960893072905`}]}}], 
           0., {-11.512925464970229`, -0.24654434714008977`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-10.819778284410283`, -0.3258356193456601}], 
          Rotate[
           Line[{{{-10.819778284410283`, -0.2411914755590833}, 
              
              Offset[{3, 
               0}, {-10.819778284410283`, -0.2411914755590833}]}, \
{{-10.819778284410283`, -0.2411914755590833}, 
              
              Offset[{-3, 
               0}, {-10.819778284410283`, -0.2411914755590833}]}, \
{{-10.819778284410283`, -0.4183124965259544}, 
              
              Offset[{3, 
               0}, {-10.819778284410283`, -0.4183124965259544}]}, \
{{-10.819778284410283`, -0.4183124965259544}, 
              Offset[{-3, 0}, {-10.819778284410283`, -0.4183124965259544}]}}],
            0., {-10.819778284410283`, -0.3258356193456601}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-9.903487552536127, -0.3694049998759599}], 
          Rotate[
           Line[{{{-9.903487552536127, -0.25871692363346177`}, 
              Offset[{3, 
               0}, {-9.903487552536127, -0.25871692363346177`}]}, \
{{-9.903487552536127, -0.25871692363346177`}, 
              
              Offset[{-3, 
               0}, {-9.903487552536127, -0.25871692363346177`}]}, \
{{-9.903487552536127, -0.49388764950021086`}, 
              
              Offset[{3, 
               0}, {-9.903487552536127, -0.49388764950021086`}]}, \
{{-9.903487552536127, -0.49388764950021086`}, 
              Offset[{-3, 0}, {-9.903487552536127, -0.49388764950021086`}]}}],
            0., {-9.903487552536127, -0.3694049998759599}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-9.210340371976182, -0.42794920965887834`}], 
          Rotate[
           Line[{{{-9.210340371976182, -0.2941120429084297}, 
              
              Offset[{3, 
               0}, {-9.210340371976182, -0.2941120429084297}]}, \
{{-9.210340371976182, -0.2941120429084297}, 
              
              Offset[{-3, 
               0}, {-9.210340371976182, -0.2941120429084297}]}, \
{{-9.210340371976182, -0.5825077338161291}, 
              
              Offset[{3, 
               0}, {-9.210340371976182, -0.5825077338161291}]}, \
{{-9.210340371976182, -0.5825077338161291}, 
              Offset[{-3, 0}, {-9.210340371976182, -0.5825077338161291}]}}], 
           0., {-9.210340371976182, -0.42794920965887834`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-8.517193191416238, -0.48061772945037246`}], 
          Rotate[
           Line[{{{-8.517193191416238, -0.3150213044298385}, 
              
              Offset[{3, 
               0}, {-8.517193191416238, -0.3150213044298385}]}, \
{{-8.517193191416238, -0.3150213044298385}, 
              
              Offset[{-3, 
               0}, {-8.517193191416238, -0.3150213044298385}]}, \
{{-8.517193191416238, -0.6791866606065804}, 
              
              Offset[{3, 
               0}, {-8.517193191416238, -0.6791866606065804}]}, \
{{-8.517193191416238, -0.6791866606065804}, 
              Offset[{-3, 0}, {-8.517193191416238, -0.6791866606065804}]}}], 
           0., {-8.517193191416238, -0.48061772945037246`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-7.600902459542082, -0.51353948642373}], 
          Rotate[
           Line[{{{-7.600902459542082, -0.33193036746095056`}, 
              
              Offset[{3, 
               0}, {-7.600902459542082, -0.33193036746095056`}]}, \
{{-7.600902459542082, -0.33193036746095056`}, 
              
              Offset[{-3, 
               0}, {-7.600902459542082, -0.33193036746095056`}]}, \
{{-7.600902459542082, -0.7356153317774647}, 
              
              Offset[{3, 
               0}, {-7.600902459542082, -0.7356153317774647}]}, \
{{-7.600902459542082, -0.7356153317774647}, 
              Offset[{-3, 0}, {-7.600902459542082, -0.7356153317774647}]}}], 
           0., {-7.600902459542082, -0.51353948642373}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-6.907755278982137, -0.5746905479345001}], 
          Rotate[
           Line[{{{-6.907755278982137, -0.3565858314116347}, 
              
              Offset[{3, 
               0}, {-6.907755278982137, -0.3565858314116347}]}, \
{{-6.907755278982137, -0.3565858314116347}, 
              
              Offset[{-3, 
               0}, {-6.907755278982137, -0.3565858314116347}]}, \
{{-6.907755278982137, -0.8540305769212991}, 
              
              Offset[{3, 
               0}, {-6.907755278982137, -0.8540305769212991}]}, \
{{-6.907755278982137, -0.8540305769212991}, 
              Offset[{-3, 0}, {-6.907755278982137, -0.8540305769212991}]}}], 
           0., {-6.907755278982137, -0.5746905479345001}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-6.214608098422191, -0.7099381996903404}], 
          Rotate[
           Line[{{{-6.214608098422191, -0.3774655629168002}, 
              
              Offset[{3, 
               0}, {-6.214608098422191, -0.3774655629168002}]}, \
{{-6.214608098422191, -0.3774655629168002}, 
              
              Offset[{-3, 
               0}, {-6.214608098422191, -0.3774655629168002}]}, \
{{-6.214608098422191, -1.2114931675208958`}, 
              
              Offset[{3, 
               0}, {-6.214608098422191, -1.2114931675208958`}]}, \
{{-6.214608098422191, -1.2114931675208958`}, 
              Offset[{-3, 0}, {-6.214608098422191, -1.2114931675208958`}]}}], 
           0., {-6.214608098422191, -0.7099381996903404}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-5.298317366548036, -0.7508935250932526}], 
          Rotate[
           Line[{{{-5.298317366548036, -0.40348307354704666`}, 
              
              Offset[{3, 
               0}, {-5.298317366548036, -0.40348307354704666`}]}, \
{{-5.298317366548036, -0.40348307354704666`}, 
              
              Offset[{-3, 
               0}, {-5.298317366548036, -0.40348307354704666`}]}, \
{{-5.298317366548036, -1.2877167746650624`}, 
              
              Offset[{3, 
               0}, {-5.298317366548036, -1.2877167746650624`}]}, \
{{-5.298317366548036, -1.2877167746650624`}, 
              Offset[{-3, 0}, {-5.298317366548036, -1.2877167746650624`}]}}], 
           0., {-5.298317366548036, -0.7508935250932526}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-4.605170185988091, -0.9187966283093214}], 
          Rotate[
           Line[{{{-4.605170185988091, -0.48127053433151157`}, 
              
              Offset[{3, 
               0}, {-4.605170185988091, -0.48127053433151157`}]}, \
{{-4.605170185988091, -0.48127053433151157`}, 
              Offset[{-3, 
               0}, {-4.605170185988091, -0.48127053433151157`}]}, \
{{-4.605170185988091, -1.7147979443567338`}, 
              
              Offset[{3, 
               0}, {-4.605170185988091, -1.7147979443567338`}]}, \
{{-4.605170185988091, -1.7147979443567338`}, 
              Offset[{-3, 0}, {-4.605170185988091, -1.7147979443567338`}]}}], 
           0., {-4.605170185988091, -0.9187966283093214}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-3.912023005428146, -0.9831937677373396}], 
          Rotate[
           Line[{{{-3.912023005428146, -0.5137067656629168}, 
              
              Offset[{3, 
               0}, {-3.912023005428146, -0.5137067656629168}]}, \
{{-3.912023005428146, -0.5137067656629168}, 
              
              Offset[{-3, 
               0}, {-3.912023005428146, -0.5137067656629168}]}, \
{{-3.912023005428146, -1.8974206558330646`}, 
              
              Offset[{3, 
               0}, {-3.912023005428146, -1.8974206558330646`}]}, \
{{-3.912023005428146, -1.8974206558330646`}, 
              Offset[{-3, 0}, {-3.912023005428146, -1.8974206558330646`}]}}], 
           0., {-3.912023005428146, -0.9831937677373396}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-2.995732273553991, -1.0723990477344734`}], 
          Rotate[
           Line[{{{-2.995732273553991, -0.5825405813038332}, 
              
              Offset[{3, 
               0}, {-2.995732273553991, -0.5825405813038332}]}, \
{{-2.995732273553991, -0.5825405813038332}, 
              
              Offset[{-3, 
               0}, {-2.995732273553991, -0.5825405813038332}]}, \
{{-2.995732273553991, -2.072302960909439}, 
              
              Offset[{3, 
               0}, {-2.995732273553991, -2.072302960909439}]}, \
{{-2.995732273553991, -2.072302960909439}, 
              Offset[{-3, 0}, {-2.995732273553991, -2.072302960909439}]}}], 
           0., {-2.995732273553991, -1.0723990477344734`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-2.3025850929940455`, -1.2464013869501513`}], 
          Rotate[
           Line[{{{-2.3025850929940455`, -0.7379689369917704}, 
              
              Offset[{3, 
               0}, {-2.3025850929940455`, -0.7379689369917704}]}, \
{{-2.3025850929940455`, -0.7379689369917704}, 
              
              Offset[{-3, 
               0}, {-2.3025850929940455`, -0.7379689369917704}]}, \
{{-2.3025850929940455`, -2.3331329692868}, 
              
              Offset[{3, 
               0}, {-2.3025850929940455`, -2.3331329692868}]}, \
{{-2.3025850929940455`, -2.3331329692868}, 
              Offset[{-3, 0}, {-2.3025850929940455`, -2.3331329692868}]}}], 
           0., {-2.3025850929940455`, -1.2464013869501513`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-1.6094379124341003`, -1.3029469896748949`}], 
          Rotate[
           Line[{{{-1.6094379124341003`, -0.8208905089186278}, 
              
              Offset[{3, 
               0}, {-1.6094379124341003`, -0.8208905089186278}]}, \
{{-1.6094379124341003`, -0.8208905089186278}, 
              
              Offset[{-3, 
               0}, {-1.6094379124341003`, -0.8208905089186278}]}, \
{{-1.6094379124341003`, -2.2689565921139163`}, 
              
              Offset[{3, 
               0}, {-1.6094379124341003`, -2.2689565921139163`}]}, \
{{-1.6094379124341003`, -2.2689565921139163`}, 
              
              Offset[{-3, 
               0}, {-1.6094379124341003`, -2.2689565921139163`}]}}], 
           0., {-1.6094379124341003`, -1.3029469896748949`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-0.6931471805599453, -1.5329232669502515`}], 
          Rotate[
           Line[{{{-0.6931471805599453, -0.9176156965237673}, 
              
              Offset[{3, 
               0}, {-0.6931471805599453, -0.9176156965237673}]}, \
{{-0.6931471805599453, -0.9176156965237673}, 
              
              Offset[{-3, 
               0}, {-0.6931471805599453, -0.9176156965237673}]}, \
{{-0.6931471805599453, -3.4315482953450003`}, 
              
              Offset[{3, 
               0}, {-0.6931471805599453, -3.4315482953450003`}]}, \
{{-0.6931471805599453, -3.4315482953450003`}, 
              Offset[{-3, 0}, {-0.6931471805599453, -3.4315482953450003`}]}}],
            0., {-0.6931471805599453, -1.5329232669502515`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {0., -7.299646538645581}], 
          Rotate[
           Line[{{{0., -7.014354079314666}, 
              Offset[{3, 0}, {0., -7.014354079314666}]}, {{
              0., -7.014354079314666}, 
              Offset[{-3, 0}, {0., -7.014354079314666}]}, {{
              0., -7.7003494833383614`}, 
              Offset[{3, 0}, {0., -7.7003494833383614`}]}, {{
              0., -7.7003494833383614`}, 
              Offset[{-3, 0}, {0., -7.7003494833383614`}]}}], 0., {
           0., -7.299646538645581}]}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {0.6931471805599453, -2.36137868345561}], 
          Rotate[
           Line[{{{0.6931471805599453, -1.6694129620716818`}, 
              Offset[{3, 0}, {0.6931471805599453, -1.6694129620716818`}]}, {{
              0.6931471805599453, -1.6694129620716818`}, 
              Offset[{-3, 0}, {0.6931471805599453, -1.6694129620716818`}]}, {{
              0.6931471805599453, -8.409827188930606}, 
              Offset[{3, 0}, {0.6931471805599453, -8.409827188930606}]}, {{
              0.6931471805599453, -8.409827188930606}, 
              Offset[{-3, 0}, {0.6931471805599453, -8.409827188930606}]}}], 
           0., {0.6931471805599453, -2.36137868345561}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {1.6094379124341003`, -0.8301026699469518}], 
          Rotate[
           Line[{{{1.6094379124341003`, -0.7358908692912747}, 
              Offset[{3, 0}, {1.6094379124341003`, -0.7358908692912747}]}, {{
              1.6094379124341003`, -0.7358908692912747}, 
              Offset[{-3, 0}, {1.6094379124341003`, -0.7358908692912747}]}, {{
              1.6094379124341003`, -0.9341223585084679}, 
              Offset[{3, 0}, {1.6094379124341003`, -0.9341223585084679}]}, {{
              1.6094379124341003`, -0.9341223585084679}, 
              Offset[{-3, 0}, {1.6094379124341003`, -0.9341223585084679}]}}], 
           0., {1.6094379124341003`, -0.8301026699469518}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.9, 0.36, 0.054], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {2.302585092994046, -0.607765191437652}], 
          Rotate[
           Line[{{{2.302585092994046, -0.5128886556625628}, 
              Offset[{3, 0}, {2.302585092994046, -0.5128886556625628}]}, {{
              2.302585092994046, -0.5128886556625628}, 
              Offset[{-3, 0}, {2.302585092994046, -0.5128886556625628}]}, {{
              2.302585092994046, -0.7125959529719993}, 
              Offset[{3, 0}, {2.302585092994046, -0.7125959529719993}]}, {{
              2.302585092994046, -0.7125959529719993}, 
              Offset[{-3, 0}, {2.302585092994046, -0.7125959529719993}]}}], 
           0., {2.302585092994046, -0.607765191437652}]}}, {{
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-11.512925464970229`, -0.39537286689510254`}], 
          Rotate[
           Line[{{{-11.512925464970229`, -0.25441401805915015`}, 
              
              Offset[{3, 
               0}, {-11.512925464970229`, -0.25441401805915015`}]}, \
{{-11.512925464970229`, -0.25441401805915015`}, 
              
              Offset[{-3, 
               0}, {-11.512925464970229`, -0.25441401805915015`}]}, \
{{-11.512925464970229`, -0.5595134240441768}, 
              
              Offset[{3, 
               0}, {-11.512925464970229`, -0.5595134240441768}]}, \
{{-11.512925464970229`, -0.5595134240441768}, 
              Offset[{-3, 0}, {-11.512925464970229`, -0.5595134240441768}]}}],
            0., {-11.512925464970229`, -0.39537286689510254`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-10.819778284410283`, -0.4538988180827986}], 
          Rotate[
           Line[{{{-10.819778284410283`, -0.27775241252341826`}, 
              
              Offset[{3, 
               0}, {-10.819778284410283`, -0.27775241252341826`}]}, \
{{-10.819778284410283`, -0.27775241252341826`}, 
              
              Offset[{-3, 
               0}, {-10.819778284410283`, -0.27775241252341826`}]}, \
{{-10.819778284410283`, -0.6678505575724258}, 
              
              Offset[{3, 
               0}, {-10.819778284410283`, -0.6678505575724258}]}, \
{{-10.819778284410283`, -0.6678505575724258}, 
              Offset[{-3, 0}, {-10.819778284410283`, -0.6678505575724258}]}}],
            0., {-10.819778284410283`, -0.4538988180827986}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-9.903487552536127, -0.6293492083480038}], 
          Rotate[
           Line[{{{-9.903487552536127, -0.35069288974710133`}, 
              
              Offset[{3, 
               0}, {-9.903487552536127, -0.35069288974710133`}]}, \
{{-9.903487552536127, -0.35069288974710133`}, 
              Offset[{-3, 0}, {-9.903487552536127, -0.35069288974710133`}]}, {
             {-9.903487552536127, -1.01700358538523}, 
              
              Offset[{3, 
               0}, {-9.903487552536127, -1.01700358538523}]}, \
{{-9.903487552536127, -1.01700358538523}, 
              Offset[{-3, 0}, {-9.903487552536127, -1.01700358538523}]}}], 
           0., {-9.903487552536127, -0.6293492083480038}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-9.210340371976182, -0.8815405814706012}], 
          Rotate[
           Line[{{{-9.210340371976182, -0.5582707713540979}, 
              
              Offset[{3, 
               0}, {-9.210340371976182, -0.5582707713540979}]}, \
{{-9.210340371976182, -0.5582707713540979}, 
              
              Offset[{-3, 
               0}, {-9.210340371976182, -0.5582707713540979}]}, \
{{-9.210340371976182, -1.3622219442342898`}, 
              
              Offset[{3, 
               0}, {-9.210340371976182, -1.3622219442342898`}]}, \
{{-9.210340371976182, -1.3622219442342898`}, 
              Offset[{-3, 0}, {-9.210340371976182, -1.3622219442342898`}]}}], 
           0., {-9.210340371976182, -0.8815405814706012}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-8.517193191416238, -1.1014695218099693`}], 
          Rotate[
           Line[{{{-8.517193191416238, -0.6963457671405906}, 
              
              Offset[{3, 
               0}, {-8.517193191416238, -0.6963457671405906}]}, \
{{-8.517193191416238, -0.6963457671405906}, 
              
              Offset[{-3, 
               0}, {-8.517193191416238, -0.6963457671405906}]}, \
{{-8.517193191416238, -1.7935933406302205`}, 
              
              Offset[{3, 
               0}, {-8.517193191416238, -1.7935933406302205`}]}, \
{{-8.517193191416238, -1.7935933406302205`}, 
              Offset[{-3, 0}, {-8.517193191416238, -1.7935933406302205`}]}}], 
           0., {-8.517193191416238, -1.1014695218099693`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-7.600902459542082, -1.361431404241532}], 
          Rotate[
           Line[{{{-7.600902459542082, -0.8313957742134405}, 
              
              Offset[{3, 
               0}, {-7.600902459542082, -0.8313957742134405}]}, \
{{-7.600902459542082, -0.8313957742134405}, 
              
              Offset[{-3, 
               0}, {-7.600902459542082, -0.8313957742134405}]}, \
{{-7.600902459542082, -2.5620526403616206`}, 
              
              Offset[{3, 
               0}, {-7.600902459542082, -2.5620526403616206`}]}, \
{{-7.600902459542082, -2.5620526403616206`}, 
              Offset[{-3, 0}, {-7.600902459542082, -2.5620526403616206`}]}}], 
           0., {-7.600902459542082, -1.361431404241532}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-6.907755278982137, -1.5424968820405398`}], 
          Rotate[
           Line[{{{-6.907755278982137, -0.8870799517905363}, 
              
              Offset[{3, 
               0}, {-6.907755278982137, -0.8870799517905363}]}, \
{{-6.907755278982137, -0.8870799517905363}, 
              
              Offset[{-3, 
               0}, {-6.907755278982137, -0.8870799517905363}]}, \
{{-6.907755278982137, -4.14544862263419}, 
              
              Offset[{3, 
               0}, {-6.907755278982137, -4.14544862263419}]}, \
{{-6.907755278982137, -4.14544862263419}, 
              Offset[{-3, 0}, {-6.907755278982137, -4.14544862263419}]}}], 
           0., {-6.907755278982137, -1.5424968820405398`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-6.214608098422191, -1.7438973427708633`}], 
          Rotate[
           Line[{{{-6.214608098422191, -1.0898696680130389`}, 
              Offset[{3, 
               0}, {-6.214608098422191, -1.0898696680130389`}]}, \
{{-6.214608098422191, -1.0898696680130389`}, 
              
              Offset[{-3, 
               0}, {-6.214608098422191, -1.0898696680130389`}]}, \
{{-6.214608098422191, -4.31138021870164}, 
              
              Offset[{3, 
               0}, {-6.214608098422191, -4.31138021870164}]}, \
{{-6.214608098422191, -4.31138021870164}, 
              Offset[{-3, 0}, {-6.214608098422191, -4.31138021870164}]}}], 
           0., {-6.214608098422191, -1.7438973427708633`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-5.298317366548036, -1.8385845822957643`}], 
          Rotate[
           Line[{{{-5.298317366548036, -1.1462319036008375`}, 
              
              Offset[{3, 
               0}, {-5.298317366548036, -1.1462319036008375`}]}, \
{{-5.298317366548036, -1.1462319036008375`}, 
              
              Offset[{-3, 
               0}, {-5.298317366548036, -1.1462319036008375`}]}, \
{{-5.298317366548036, -8.283629850945506}, 
              
              Offset[{3, 
               0}, {-5.298317366548036, -8.283629850945506}]}, \
{{-5.298317366548036, -8.283629850945506}, 
              Offset[{-3, 0}, {-5.298317366548036, -8.283629850945506}]}}], 
           0., {-5.298317366548036, -1.8385845822957643`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-4.605170185988091, -3.11721560829879}], 
          Rotate[
           Line[{{{-4.605170185988091, -2.5732312871951146`}, 
              
              Offset[{3, 
               0}, {-4.605170185988091, -2.5732312871951146`}]}, \
{{-4.605170185988091, -2.5732312871951146`}, 
              
              Offset[{-3, 
               0}, {-4.605170185988091, -2.5732312871951146`}]}, \
{{-4.605170185988091, -4.400439517812046}, 
              
              Offset[{3, 
               0}, {-4.605170185988091, -4.400439517812046}]}, \
{{-4.605170185988091, -4.400439517812046}, 
              Offset[{-3, 0}, {-4.605170185988091, -4.400439517812046}]}}], 
           0., {-4.605170185988091, -3.11721560829879}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-3.912023005428146, -4.149565361383249}], 
          Rotate[
           Line[{{{-3.912023005428146, -3.459446821347612}, 
              
              Offset[{3, 
               0}, {-3.912023005428146, -3.459446821347612}]}, \
{{-3.912023005428146, -3.459446821347612}, 
              
              Offset[{-3, 
               0}, {-3.912023005428146, -3.459446821347612}]}, \
{{-3.912023005428146, -9.257573550880668}, 
              
              Offset[{3, 
               0}, {-3.912023005428146, -9.257573550880668}]}, \
{{-3.912023005428146, -9.257573550880668}, 
              Offset[{-3, 0}, {-3.912023005428146, -9.257573550880668}]}}], 
           0., {-3.912023005428146, -4.149565361383249}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-2.995732273553991, -8.439279295060926}], 
          Rotate[
           Line[{{{-2.995732273553991, -8.158366454203467}, 
              
              Offset[{3, 
               0}, {-2.995732273553991, -8.158366454203467}]}, \
{{-2.995732273553991, -8.158366454203467}, 
              
              Offset[{-3, 
               0}, {-2.995732273553991, -8.158366454203467}]}, \
{{-2.995732273553991, -8.831341875720527}, 
              
              Offset[{3, 
               0}, {-2.995732273553991, -8.831341875720527}]}, \
{{-2.995732273553991, -8.831341875720527}, 
              Offset[{-3, 0}, {-2.995732273553991, -8.831341875720527}]}}], 
           0., {-2.995732273553991, -8.439279295060926}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-2.3025850929940455`, -8.698157637275392}], 
          Rotate[
           Line[{{{-2.3025850929940455`, -8.501285024588379}, 
              
              Offset[{3, 
               0}, {-2.3025850929940455`, -8.501285024588379}]}, \
{{-2.3025850929940455`, -8.501285024588379}, 
              
              Offset[{-3, 
               0}, {-2.3025850929940455`, -8.501285024588379}]}, \
{{-2.3025850929940455`, -8.943532643041909}, 
              
              Offset[{3, 
               0}, {-2.3025850929940455`, -8.943532643041909}]}, \
{{-2.3025850929940455`, -8.943532643041909}, 
              Offset[{-3, 0}, {-2.3025850929940455`, -8.943532643041909}]}}], 
           0., {-2.3025850929940455`, -8.698157637275392}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-1.6094379124341003`, -3.401972303800274}], 
          Rotate[
           Line[{{{-1.6094379124341003`, -2.7152582825240925`}, 
              
              Offset[{3, 
               0}, {-1.6094379124341003`, -2.7152582825240925`}]}, \
{{-1.6094379124341003`, -2.7152582825240925`}, 
              
              Offset[{-3, 
               0}, {-1.6094379124341003`, -2.7152582825240925`}]}, \
{{-1.6094379124341003`, -7.758329504928021}, 
              
              Offset[{3, 
               0}, {-1.6094379124341003`, -7.758329504928021}]}, \
{{-1.6094379124341003`, -7.758329504928021}, 
              Offset[{-3, 0}, {-1.6094379124341003`, -7.758329504928021}]}}], 
           0., {-1.6094379124341003`, -3.401972303800274}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-0.6931471805599453, -2.089784033539785}], 
          Rotate[
           Line[{{{-0.6931471805599453, -1.4002280510657286`}, 
              
              Offset[{3, 
               0}, {-0.6931471805599453, -1.4002280510657286`}]}, \
{{-0.6931471805599453, -1.4002280510657286`}, 
              
              Offset[{-3, 
               0}, {-0.6931471805599453, -1.4002280510657286`}]}, \
{{-0.6931471805599453, -7.027701318157354}, 
              
              Offset[{3, 
               0}, {-0.6931471805599453, -7.027701318157354}]}, \
{{-0.6931471805599453, -7.027701318157354}, 
              Offset[{-3, 0}, {-0.6931471805599453, -7.027701318157354}]}}], 
           0., {-0.6931471805599453, -2.089784033539785}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {0., -0.9127772669870097}], 
          Rotate[
           Line[{{{0., -0.754071529344224}, 
              Offset[{3, 0}, {0., -0.754071529344224}]}, {{
              0., -0.754071529344224}, 
              Offset[{-3, 0}, {0., -0.754071529344224}]}, {{
              0., -1.1015109646926604`}, 
              Offset[{3, 0}, {0., -1.1015109646926604`}]}, {{
              0., -1.1015109646926604`}, 
              Offset[{-3, 0}, {0., -1.1015109646926604`}]}}], 0., {
           0., -0.9127772669870097}]}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {0.6931471805599453, -0.7041828534586838}], 
          Rotate[
           Line[{{{0.6931471805599453, -0.6289155149271866}, 
              Offset[{3, 0}, {0.6931471805599453, -0.6289155149271866}]}, {{
              0.6931471805599453, -0.6289155149271866}, 
              Offset[{-3, 0}, {0.6931471805599453, -0.6289155149271866}]}, {{
              0.6931471805599453, -0.7855798562625901}, 
              Offset[{3, 0}, {0.6931471805599453, -0.7855798562625901}]}, {{
              0.6931471805599453, -0.7855798562625901}, 
              Offset[{-3, 0}, {0.6931471805599453, -0.7855798562625901}]}}], 
           0., {0.6931471805599453, -0.7041828534586838}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {1.6094379124341003`, -0.8219974690317857}], 
          Rotate[
           Line[{{{1.6094379124341003`, -0.7044012624634929}, 
              Offset[{3, 0}, {1.6094379124341003`, -0.7044012624634929}]}, {{
              1.6094379124341003`, -0.7044012624634929}, 
              Offset[{-3, 0}, {1.6094379124341003`, -0.7044012624634929}]}, {{
              1.6094379124341003`, -0.955288704106497}, 
              Offset[{3, 0}, {1.6094379124341003`, -0.955288704106497}]}, {{
              1.6094379124341003`, -0.955288704106497}, 
              Offset[{-3, 0}, {1.6094379124341003`, -0.955288704106497}]}}], 
           0., {1.6094379124341003`, -0.8219974690317857}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.365248, 0.427802, 0.758297], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {2.302585092994046, -0.6857316731126133}], 
          Rotate[
           Line[{{{2.302585092994046, -0.5579261285147372}, 
              Offset[{3, 0}, {2.302585092994046, -0.5579261285147372}]}, {{
              2.302585092994046, -0.5579261285147372}, 
              Offset[{-3, 0}, {2.302585092994046, -0.5579261285147372}]}, {{
              2.302585092994046, -0.8322985341262805}, 
              Offset[{3, 0}, {2.302585092994046, -0.8322985341262805}]}, {{
              2.302585092994046, -0.8322985341262805}, 
              Offset[{-3, 0}, {2.302585092994046, -0.8322985341262805}]}}], 
           0., {2.302585092994046, -0.6857316731126133}]}}, {{
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-11.512925464970229`, -0.38926729809579874`}], 
          Rotate[
           Line[{{{-11.512925464970229`, -0.2519678241806734}, 
              Offset[{3, 
               0}, {-11.512925464970229`, -0.2519678241806734}]}, \
{{-11.512925464970229`, -0.2519678241806734}, 
              
              Offset[{-3, 
               0}, {-11.512925464970229`, -0.2519678241806734}]}, \
{{-11.512925464970229`, -0.5484642750018992}, 
              
              Offset[{3, 
               0}, {-11.512925464970229`, -0.5484642750018992}]}, \
{{-11.512925464970229`, -0.5484642750018992}, 
              Offset[{-3, 0}, {-11.512925464970229`, -0.5484642750018992}]}}],
            0., {-11.512925464970229`, -0.38926729809579874`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-10.819778284410283`, -0.4237695790597728}], 
          Rotate[
           Line[{{{-10.819778284410283`, -0.2705783801105227}, 
              
              Offset[{3, 
               0}, {-10.819778284410283`, -0.2705783801105227}]}, \
{{-10.819778284410283`, -0.2705783801105227}, 
              
              Offset[{-3, 
               0}, {-10.819778284410283`, -0.2705783801105227}]}, \
{{-10.819778284410283`, -0.6047494073613302}, 
              
              Offset[{3, 
               0}, {-10.819778284410283`, -0.6047494073613302}]}, \
{{-10.819778284410283`, -0.6047494073613302}, 
              Offset[{-3, 0}, {-10.819778284410283`, -0.6047494073613302}]}}],
            0., {-10.819778284410283`, -0.4237695790597728}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-9.903487552536127, -0.562171216845559}], 
          Rotate[
           Line[{{{-9.903487552536127, -0.32948471493307213`}, 
              
              Offset[{3, 
               0}, {-9.903487552536127, -0.32948471493307213`}]}, \
{{-9.903487552536127, -0.32948471493307213`}, 
              
              Offset[{-3, 
               0}, {-9.903487552536127, -0.32948471493307213`}]}, \
{{-9.903487552536127, -0.8659634128427317}, 
              Offset[{3, 
               0}, {-9.903487552536127, -0.8659634128427317}]}, \
{{-9.903487552536127, -0.8659634128427317}, 
              Offset[{-3, 0}, {-9.903487552536127, -0.8659634128427317}]}}], 
           0., {-9.903487552536127, -0.562171216845559}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-9.210340371976182, -0.8102451167449465}], 
          Rotate[
           Line[{{{-9.210340371976182, -0.5056928165834714}, 
              
              Offset[{3, 
               0}, {-9.210340371976182, -0.5056928165834714}]}, \
{{-9.210340371976182, -0.5056928165834714}, 
              
              Offset[{-3, 
               0}, {-9.210340371976182, -0.5056928165834714}]}, \
{{-9.210340371976182, -1.250329275824922}, 
              
              Offset[{3, 
               0}, {-9.210340371976182, -1.250329275824922}]}, \
{{-9.210340371976182, -1.250329275824922}, 
              Offset[{-3, 0}, {-9.210340371976182, -1.250329275824922}]}}], 
           0., {-9.210340371976182, -0.8102451167449465}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-8.517193191416238, -0.9788409127726406}], 
          Rotate[
           Line[{{{-8.517193191416238, -0.656410589248749}, 
              
              Offset[{3, 
               0}, {-8.517193191416238, -0.656410589248749}]}, \
{{-8.517193191416238, -0.656410589248749}, 
              
              Offset[{-3, 
               0}, {-8.517193191416238, -0.656410589248749}]}, \
{{-8.517193191416238, -1.4576491097064952`}, 
              
              Offset[{3, 
               0}, {-8.517193191416238, -1.4576491097064952`}]}, \
{{-8.517193191416238, -1.4576491097064952`}, 
              Offset[{-3, 0}, {-8.517193191416238, -1.4576491097064952`}]}}], 
           0., {-8.517193191416238, -0.9788409127726406}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-7.600902459542082, -1.3125283680599498`}], 
          Rotate[
           Line[{{{-7.600902459542082, -0.8101219989254995}, 
              
              Offset[{3, 
               0}, {-7.600902459542082, -0.8101219989254995}]}, \
{{-7.600902459542082, -0.8101219989254995}, 
              
              Offset[{-3, 
               0}, {-7.600902459542082, -0.8101219989254995}]}, \
{{-7.600902459542082, -2.3700759142504793`}, 
              
              Offset[{3, 
               0}, {-7.600902459542082, -2.3700759142504793`}]}, \
{{-7.600902459542082, -2.3700759142504793`}, 
              Offset[{-3, 0}, {-7.600902459542082, -2.3700759142504793`}]}}], 
           0., {-7.600902459542082, -1.3125283680599498`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-6.907755278982137, -1.3631964929396627`}], 
          Rotate[
           Line[{{{-6.907755278982137, -0.8336977975363261}, 
              
              Offset[{3, 
               0}, {-6.907755278982137, -0.8336977975363261}]}, \
{{-6.907755278982137, -0.8336977975363261}, 
              
              Offset[{-3, 
               0}, {-6.907755278982137, -0.8336977975363261}]}, \
{{-6.907755278982137, -2.5607924707881615`}, 
              
              Offset[{3, 
               0}, {-6.907755278982137, -2.5607924707881615`}]}, \
{{-6.907755278982137, -2.5607924707881615`}, 
              Offset[{-3, 0}, {-6.907755278982137, -2.5607924707881615`}]}}], 
           0., {-6.907755278982137, -1.3631964929396627`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-6.214608098422191, -1.7455693330085607`}], 
          Rotate[
           Line[{{{-6.214608098422191, -1.1025317554918137`}, 
              
              Offset[{3, 
               0}, {-6.214608098422191, -1.1025317554918137`}]}, \
{{-6.214608098422191, -1.1025317554918137`}, 
              
              Offset[{-3, 
               0}, {-6.214608098422191, -1.1025317554918137`}]}, \
{{-6.214608098422191, -4.070914944062966}, 
              
              Offset[{3, 
               0}, {-6.214608098422191, -4.070914944062966}]}, \
{{-6.214608098422191, -4.070914944062966}, 
              Offset[{-3, 0}, {-6.214608098422191, -4.070914944062966}]}}], 
           0., {-6.214608098422191, -1.7455693330085607`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-5.298317366548036, -4.247810579379446}], 
          Rotate[
           Line[{{{-5.298317366548036, -3.662280979856254}, 
              
              Offset[{3, 
               0}, {-5.298317366548036, -3.662280979856254}]}, \
{{-5.298317366548036, -3.662280979856254}, 
              
              Offset[{-3, 
               0}, {-5.298317366548036, -3.662280979856254}]}, \
{{-5.298317366548036, -5.83716092364682}, 
              
              Offset[{3, 
               0}, {-5.298317366548036, -5.83716092364682}]}, \
{{-5.298317366548036, -5.83716092364682}, 
              Offset[{-3, 0}, {-5.298317366548036, -5.83716092364682}]}}], 
           0., {-5.298317366548036, -4.247810579379446}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-4.605170185988091, -1.781913018732193}], 
          Rotate[
           Line[{{{-4.605170185988091, -1.129880875641007}, 
              
              Offset[{3, 
               0}, {-4.605170185988091, -1.129880875641007}]}, \
{{-4.605170185988091, -1.129880875641007}, 
              
              Offset[{-3, 
               0}, {-4.605170185988091, -1.129880875641007}]}, \
{{-4.605170185988091, -4.300634271879715}, 
              
              Offset[{3, 
               0}, {-4.605170185988091, -4.300634271879715}]}, \
{{-4.605170185988091, -4.300634271879715}, 
              Offset[{-3, 0}, {-4.605170185988091, -4.300634271879715}]}}], 
           0., {-4.605170185988091, -1.781913018732193}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-3.912023005428146, -2.9750554561433065`}], 
          Rotate[
           Line[{{{-3.912023005428146, -2.2866100371536864`}, 
              
              Offset[{3, 
               0}, {-3.912023005428146, -2.2866100371536864`}]}, \
{{-3.912023005428146, -2.2866100371536864`}, 
              
              Offset[{-3, 
               0}, {-3.912023005428146, -2.2866100371536864`}]}, \
{{-3.912023005428146, -7.644076273552012}, 
              
              Offset[{3, 
               0}, {-3.912023005428146, -7.644076273552012}]}, \
{{-3.912023005428146, -7.644076273552012}, 
              Offset[{-3, 0}, {-3.912023005428146, -7.644076273552012}]}}], 
           0., {-3.912023005428146, -2.9750554561433065`}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-2.995732273553991, -7.66438020994557}], 
          Rotate[
           Line[{{{-2.995732273553991, -7.1926901486584764`}, 
              
              Offset[{3, 
               0}, {-2.995732273553991, -7.1926901486584764`}]}, \
{{-2.995732273553991, -7.1926901486584764`}, 
              
              Offset[{-3, 
               0}, {-2.995732273553991, -7.1926901486584764`}]}, \
{{-2.995732273553991, -8.587445255225088}, 
              
              Offset[{3, 
               0}, {-2.995732273553991, -8.587445255225088}]}, \
{{-2.995732273553991, -8.587445255225088}, 
              Offset[{-3, 0}, {-2.995732273553991, -8.587445255225088}]}}], 
           0., {-2.995732273553991, -7.66438020994557}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-2.3025850929940455`, -8.501847082778573}], 
          Rotate[
           Line[{{{-2.3025850929940455`, -8.028576074649838}, 
              
              Offset[{3, 
               0}, {-2.3025850929940455`, -8.028576074649838}]}, \
{{-2.3025850929940455`, -8.028576074649838}, 
              
              Offset[{-3, 
               0}, {-2.3025850929940455`, -8.028576074649838}]}, \
{{-2.3025850929940455`, -9.431315145913885}, 
              
              Offset[{3, 
               0}, {-2.3025850929940455`, -9.431315145913885}]}, \
{{-2.3025850929940455`, -9.431315145913885}, 
              Offset[{-3, 0}, {-2.3025850929940455`, -9.431315145913885}]}}], 
           0., {-2.3025850929940455`, -8.501847082778573}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-1.6094379124341003`, -8.36168540065418}], 
          Rotate[
           Line[{{{-1.6094379124341003`, -8.100041341814123}, 
              
              Offset[{3, 
               0}, {-1.6094379124341003`, -8.100041341814123}]}, \
{{-1.6094379124341003`, -8.100041341814123}, 
              
              Offset[{-3, 
               0}, {-1.6094379124341003`, -8.100041341814123}]}, \
{{-1.6094379124341003`, -8.717024194433389}, 
              
              Offset[{3, 
               0}, {-1.6094379124341003`, -8.717024194433389}]}, \
{{-1.6094379124341003`, -8.717024194433389}, 
              Offset[{-3, 0}, {-1.6094379124341003`, -8.717024194433389}]}}], 
           0., {-1.6094379124341003`, -8.36168540065418}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {-0.6931471805599453, -6.1351882606609}], 
          Rotate[
           Line[{{{-0.6931471805599453, -5.645526863935549}, 
              
              Offset[{3, 
               0}, {-0.6931471805599453, -5.645526863935549}]}, \
{{-0.6931471805599453, -5.645526863935549}, 
              
              Offset[{-3, 
               0}, {-0.6931471805599453, -5.645526863935549}]}, \
{{-0.6931471805599453, -7.13421843244189}, 
              Offset[{3, 
               0}, {-0.6931471805599453, -7.13421843244189}]}, \
{{-0.6931471805599453, -7.13421843244189}, 
              Offset[{-3, 0}, {-0.6931471805599453, -7.13421843244189}]}}], 
           0., {-0.6931471805599453, -6.1351882606609}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {0., -1.7197878024474722`}], 
          Rotate[
           Line[{{{0., -1.2096446486101495`}, 
              Offset[{3, 0}, {0., -1.2096446486101495`}]}, {{
              0., -1.2096446486101495`}, 
              Offset[{-3, 0}, {0., -1.2096446486101495`}]}, {{
              0., -2.8149947105163395`}, 
              Offset[{3, 0}, {0., -2.8149947105163395`}]}, {{
              0., -2.8149947105163395`}, 
              Offset[{-3, 0}, {0., -2.8149947105163395`}]}}], 0., {
           0., -1.7197878024474722`}]}, {Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {0.6931471805599453, -0.6925673557607437}], 
          Rotate[
           Line[{{{0.6931471805599453, -0.5127286803373978}, 
              Offset[{3, 0}, {0.6931471805599453, -0.5127286803373978}]}, {{
              0.6931471805599453, -0.5127286803373978}, 
              Offset[{-3, 0}, {0.6931471805599453, -0.5127286803373978}]}, {{
              0.6931471805599453, -0.911998105704811}, 
              Offset[{3, 0}, {0.6931471805599453, -0.911998105704811}]}, {{
              0.6931471805599453, -0.911998105704811}, 
              Offset[{-3, 0}, {0.6931471805599453, -0.911998105704811}]}}], 
           0., {0.6931471805599453, -0.6925673557607437}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {1.6094379124341003`, -0.7965247670387181}], 
          Rotate[
           Line[{{{1.6094379124341003`, -0.7598885565373079}, 
              Offset[{3, 0}, {1.6094379124341003`, -0.7598885565373079}]}, {{
              1.6094379124341003`, -0.7598885565373079}, 
              Offset[{-3, 0}, {1.6094379124341003`, -0.7598885565373079}]}, {{
              1.6094379124341003`, -0.8345544009871018}, 
              Offset[{3, 0}, {1.6094379124341003`, -0.8345544009871018}]}, {{
              1.6094379124341003`, -0.8345544009871018}, 
              Offset[{-3, 0}, {1.6094379124341003`, -0.8345544009871018}]}}], 
           0., {1.6094379124341003`, -0.7965247670387181}]}, {
         Antialiasing -> False, 
          Directive[
           RGBColor[0.945109, 0.593901, 0.], 
           CapForm["Butt"]], 
          Rotate[
           Line[{}], 0., {2.302585092994046, -0.7612543106926855}], 
          Rotate[
           Line[{{{2.302585092994046, -0.6557778852723178}, 
              Offset[{3, 0}, {2.302585092994046, -0.6557778852723178}]}, {{
              2.302585092994046, -0.6557778852723178}, 
              Offset[{-3, 0}, {2.302585092994046, -0.6557778852723178}]}, {{
              2.302585092994046, -0.8791822524478724}, 
              Offset[{3, 0}, {2.302585092994046, -0.8791822524478724}]}, {{
              2.302585092994046, -0.8791822524478724}, 
              Offset[{-3, 0}, {2.302585092994046, -0.8791822524478724}]}}], 
           0., {2.302585092994046, -0.7612543106926855}]}}}}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.9, 0.36, 0.054], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6]], 
         Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQHb1qkdY8NvUDITV/Hx7uO79/D9vmXzsXqx4o67Rd
Unvryv4tP5a8nnpO+UBub8y9kCXX94uGbt29MVvpgHT8V5HW5Nv7yzce7T7L
oXjgb1353YJD9/bfc8v/GZQud8B0QU7Mq7wH+xf875/ZtVD6gFHctLy7yY/2
J+3YYHnotsSBEpvdARe2P9sfPGeKdJWh6IGt2xfeDmR/ATVf6EBB/gn9E2lv
96+XXrP9kjf/AUvmQ8eCyt7vn/i4uNrpO/uBzPqU590aH6HqmQ4Y266a4vTx
837j3rffHQ/83N9mEvjx3o0v+99b/vrnpPds/xkn3Z5bbT/2M0DBtLjzXdeM
ZA9A5e1n+11vlHoCNAei377kUnml8YRX+8Ug5jv0P5v953zR4/0AjHKp3w==

          "]]}, {
         Hue[0.9060679774997897, 0.6, 0.6], 
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.365248, 0.427802, 0.758297], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6]], 
         Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQHb1qkdY8NvUDQpOd/p/0vbl/D9vmXzsXqx5o/HJt
wVqeu/u3/Fjyeuo55QOsJ4o/L1B+sl80dOvujdlKB75kfZg+xfTN/vKNR7vP
cigeeJEX3Thv/sf999zyfwalyx3ozz/vnXPi6/4F//tndi2UPnB8zwtTwXU/
9ift2GB56LbEgV3NOc8Ynv/eHzxninSVoeiB77b7Vl3P+gs1X+jArVML9/B9
4DiwXnrN9kve/Adms9avVJ8pcGDi4+Jqp+/sB8oNbcxfPlA4AFHPdOCy5PdX
JamKB4x73353PPBzf/mhUEdbc+4D7y1//XPSe7b/H8+/DQ+2MxxggALJXcdX
V5i+3Q+Vtz/leaBqVcez/VD99k0xdxad9X21XwxivkOD8e6e5o9P9wMA6lKp
cA==
          "]]}, {
         Hue[0.1421359549995791, 0.6, 0.6], 
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.945109, 0.593901, 0.], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6]], 
         Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQHb1qkdY8NvUDewLXJR18eWP/HrbNv3YuVj3QXHus
gEv+9v4tP5a8nnpO+cCc0Me1fn8f7hcN3bp7Y7bSgSDLo1rtb1/uL994tPss
h+KBTp5u3VVB7/ffc8v/GZQudyDa5t8+WYav+xf875/ZtVD6wA9NY4Xl57/u
T9qxwfLQbYkD+w8+kr719vf+4DlTpKsMRQ/kq1XwHforcABivtCBNeF7LLc3
/dm/XnrN9kve/Ad+xf+///IM+4GJj4urnb6zH1jhq+4ZvEIOqp7pALPjBclP
DIoHjHvffnc88HO/foPeFb2dCgfeW/7656T3bP+T2Jmn8rokDjBAgYfqTzOH
lt/7ofL2dQteMDdrPtsP1W9fEyLTpFj7cr8YxHyHI8u4GYxiXuwHAJt4oVc=

          "]]}}, {{
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.9, 0.36, 0.054], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6]]}, {
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.365248, 0.427802, 0.758297], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6]]}, {
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.945109, 0.593901, 0.], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6]]}}, {{
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.9, 0.36, 0.054], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6]]}, {
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.365248, 0.427802, 0.758297], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6]]}, {
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.945109, 0.593901, 0.], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6]]}, {}, {}, {}, {}, {}, {}, {}}, {{
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.9, 0.36, 0.054], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6]]}, {
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.365248, 0.427802, 0.758297], 
          CapForm["Butt"], 
          AbsoluteThickness[1.6]]}, {
         Directive[
          PointSize[0.011000000000000001`], 
          RGBColor[0.945109, 0.593901, 0.], 
          CapForm["Butt"], 
          AbsoluteThickness[
          1.6]]}, {}, {}, {}, {}, {}, {}, {}}}, {{}, {{}, {}}}}, {
     DisplayFunction -> Identity, GridLines -> {
        Charting`ScaledTickValues[{Log, Exp}], 
        Charting`ScaledTickValues[{Log, Exp}]}, DisplayFunction -> Identity, 
      DisplayFunction -> Identity, DisplayFunction -> Identity, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {False, False}, AxesLabel -> {None, None}, 
      AxesOrigin -> {-12.094568053565078`, -10.155204230323175`}, 
      DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"validation loss", None}, {"learning rate", None}}, 
      FrameStyle -> Directive[
        Directive[{
          GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}], 
        GrayLevel[0]], FrameTicks -> {{
         Charting`ScaledTicks[{Log, Exp}], 
         Charting`ScaledFrameTicks[{Log, Exp}]}, {
         Charting`ScaledTicks[{Log, Exp}], 
         Charting`ScaledFrameTicks[{Log, Exp}]}}, 
      GridLines -> {{-11.512925464970229`, -9.210340371976182, \
-6.907755278982137, -4.605170185988091, -2.3025850929940455`, 0., 
        2.302585092994046}, {-9.210340371976182, -6.907755278982137, \
-4.605170185988091, -2.3025850929940455`, 0.}}, GridLinesStyle -> Directive[
        GrayLevel[0.4, 0.5], 
        AbsoluteThickness[1], 
        AbsoluteDashing[{1, 2}]], ImageSize -> 300, 
      LabelStyle -> {FontFamily -> "Times"}, 
      Method -> {
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Exp[
             Part[#, 1]], 
            Exp[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Exp[
             Part[#, 1]], 
            Exp[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{-12.094568053565078`, 
       2.302585092994046}, {-10.155204230323175`, -0.18100730392040543`}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.08090169943749476]}}, Ticks -> {
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledTicks[{Log, Exp}]}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.9, 0.36, 0.054], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.365248, 0.427802, 0.758297], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.945109, 0.593901, 0.], 
         CapForm["Butt"], 
         AbsoluteThickness[1.6]]}, {"SGD", "RMSprop", "Adam"}, 
       LegendMarkers -> {{False, Automatic}, {False, Automatic}, {
         False, Automatic}}, Joined -> {True, True, True}, 
       LabelStyle -> {FontFamily -> "Times"}, 
       LegendLayout -> $CellContext`table]], {
      Scaled[{0.1, 0.1}], {0.1, 0.1}}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.8003567121567364`*^9, {3.800356742573969*^9, 3.800356814212043*^9}, {
   3.800356856819106*^9, 3.800356957134989*^9}, 3.800357053469211*^9, {
   3.800357179585494*^9, 3.800357197251003*^9}, {3.8003572435995874`*^9, 
   3.800357298564952*^9}, {3.8003573352607236`*^9, 3.800357498689497*^9}, {
   3.8003577308744793`*^9, 3.8003577506808186`*^9}, 3.8003579514095564`*^9, {
   3.800357996587017*^9, 3.8003580204182696`*^9}, {3.8003583867142243`*^9, 
   3.8003583959006763`*^9}, {3.8003585127880774`*^9, 
   3.8003585219234858`*^9}, {3.8003589813661537`*^9, 3.800359015254609*^9}, 
   3.8003590978010316`*^9},
 CellLabel->
  "Out[1174]=",ExpressionUUID->"07365a0d-4865-4add-8602-865b1de971a4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Postselection", "Chapter",
 CellChangeTimes->{{3.8008654995981417`*^9, 
  3.800865502856571*^9}},ExpressionUUID->"079cd739-d79f-4eb1-a07e-\
9f89d9cfab83"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "listPlotB", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"listPlotB", "[", "data_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{"data", ",", "\[IndentingNewLine]", 
    RowBox[{"PlotTheme", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Detailed\>\"", ",", "\"\<Scientific\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"GridLines", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ScalingFunctions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Identity", ",", "\"\<Log\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"BaseStyle", "\[Rule]", "textStyle"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<training steps\>\"", ",", "\"\<validation  loss\>\""}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ImageSize", "\[Rule]", "300"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"All", ",", "All"}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"AspectRatio", "\[Rule]", ".6"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", "\[IndentingNewLine]", 
    RowBox[{"BaseStyle", "\[Rule]", "textStyle"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.8008659358454676`*^9, 3.8008660567712097`*^9}, {
  3.8008662399499836`*^9, 3.800866302773817*^9}, {3.8008664079979663`*^9, 
  3.800866410424268*^9}, {3.8008711409012036`*^9, 3.800871142879966*^9}, {
  3.8008711843228636`*^9, 3.8008711925446405`*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"fbf83419-2666-46e6-a6a8-14d9abb7dbe4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataX", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
      "\"\<postsel-simple-seq.csv\>\""}], ",", "\"\<Dataset\>\"", ",", 
     RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataY", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
      "\"\<postsel-mnist.csv\>\""}], ",", "\"\<Dataset\>\"", ",", 
     RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8008658440855827`*^9, 3.8008658720172415`*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"19682929-c7ed-42bc-b0c8-541174b3ec3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Normal", "@", 
      RowBox[{"dataX", "[", 
       RowBox[{"All", ",", "\"\<Step\>\""}], "]"}]}], ",", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "@", 
       RowBox[{"Normal", "@", 
        RowBox[{"dataX", "[", 
         RowBox[{"All", ",", "\"\<Value\>\""}], "]"}]}]}]}]}], "}"}], 
   "\[Transpose]"}], "//", "listPlotB"}]], "Input",
 CellChangeTimes->{{3.8008660694145103`*^9, 3.80086615073213*^9}, {
  3.8008661838708887`*^9, 3.800866228165022*^9}, {3.800866291481224*^9, 
  3.800866292595214*^9}, {3.8008664014480743`*^9, 3.800866401548346*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"fe85de7f-432a-4931-8e51-3895b377c8c2"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
      CapForm["Butt"], 
      StyleBox[LineBox[CompressedData["
1:eJw11nk4lAsbBvBXi5xWWTqp1ESLliOlBS3uhFD2bEXG2NdZHUehkSyJSjmS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        "]],
       FontSize->14,
       FontName -> "Times New Roman"]}}, 
    {RGBColor[0, 0, 1], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     CapForm["Butt"], 
     StyleBox[{},
      FontSize->14,
      FontName -> "Times New Roman"]}, {
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
      CapForm["Butt"], 
      StyleBox[{},
       FontSize->14,
       FontName -> "Times New Roman"]}, {}}, {
     {RGBColor[0, 0, 1], PointSize[
       NCache[
        Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
      CapForm["Butt"], 
      StyleBox[{},
       FontSize->14,
       FontName -> "Times New Roman"]}, {}}}, {{}, {}}},
  AspectRatio->0.6,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, -0.29038267426338255`},
  BaseStyle->Directive[{
     GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"postselection overhead\"", TraditionalForm], None}, {
     FormBox["\"training steps\"", TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{Quiet[
       Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {
     Automatic, Automatic}}, {{{{0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.003065458786462, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.090076835776092, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.170119543449628, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.24422751560335, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.313220387090301, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.3777589082278725`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {1., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {2., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {3., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {4., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {5., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-1., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {
     Automatic, Automatic}}],
  GridLines->{
   None, {0., 1.6094379124341003`, 2.302585092994046, 3.912023005428146, 
    4.605170185988092}},
  GridLinesStyle->Directive[
    GrayLevel[0.4, 0.5], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImageSize->300,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 338.}, {-0.29038267426338255`, 5.288551363150157}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Quiet[
     Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }]], "Output",
 CellChangeTimes->{{3.8008662145477858`*^9, 3.8008663048808637`*^9}, {
  3.8008664021651683`*^9, 3.800866412547304*^9}},
 CellLabel->
  "Out[127]=",ExpressionUUID->"cbb8116d-bd58-4011-af72-6e5ea1621b51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Normal", "@", 
      RowBox[{"dataY", "[", 
       RowBox[{"All", ",", "\"\<Step\>\""}], "]"}]}], ",", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "@", 
       RowBox[{"Normal", "@", 
        RowBox[{"dataY", "[", 
         RowBox[{"All", ",", "\"\<Value\>\""}], "]"}]}]}]}]}], "}"}], 
   "\[Transpose]"}], "//", "listPlotB"}]], "Input",
 CellChangeTimes->{{3.800866254603656*^9, 3.8008662570311003`*^9}, {
  3.8008663107120714`*^9, 3.800866347827855*^9}, {3.800866390166778*^9, 
  3.8008664155880795`*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"987d6450-b031-4dc2-b00c-3da03833b46a"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.006944444444444445], AbsoluteThickness[
      1.6], CapForm["Butt"], 
      StyleBox[LineBox[CompressedData["
1:eJw9W3lYzO/Xzp61JMmSkpCEEEK4EUJRCaEUpVDRvpCapr2mmpqpWQrZs0QI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        "]],
       FontSize->14,
       FontName -> "Times New Roman"]}}, 
    {RGBColor[0, 0, 1], PointSize[0.006944444444444445], AbsoluteThickness[
     1.6], CapForm["Butt"], 
     StyleBox[{},
      FontSize->14,
      FontName -> "Times New Roman"]}, {
     {RGBColor[0, 0, 1], PointSize[0.006944444444444445], AbsoluteThickness[
      1.6], CapForm["Butt"], 
      StyleBox[{},
       FontSize->14,
       FontName -> "Times New Roman"]}, {}}, {
     {RGBColor[0, 0, 1], PointSize[0.006944444444444445], AbsoluteThickness[
      1.6], CapForm["Butt"], 
      StyleBox[{},
       FontSize->14,
       FontName -> "Times New Roman"]}, {}}}, {{}, {}}},
  AspectRatio->0.6,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.1783751740827027},
  BaseStyle->Directive[{
     GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"postselection overhead\"", TraditionalForm], None}, {
     FormBox["\"training steps\"", TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{Quiet[
       Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {
     Automatic, Automatic}}, {{{{1.6094379124341003`, 
        FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
        FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
        FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
        FormBox["100", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
        FormBox["500", TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4011973816621555`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6888794541139363`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.0943445622221, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.248495242049359, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.382026634673881, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.499809670330265, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.703782474656201, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.991464547107982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.396929655216146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.551080335043404, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.684611727667927, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.802394763324311, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.313220387090301, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, {{
       1., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {2., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {3., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {4., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {5., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {6., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       3.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       4.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       5.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       6.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       7., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {
     Automatic, Automatic}}],
  GridLines->{
   None, {1.6094379124341003`, 2.302585092994046, 3.912023005428146, 
    4.605170185988092, 6.214608098422191}},
  GridLinesStyle->Directive[
    GrayLevel[0.4, 0.5], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImageSize->300,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1763.}, {0.1783751740827027, 6.490196159753711}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Quiet[
     Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }]], "Output",
 CellChangeTimes->{{3.8008662577655935`*^9, 3.800866311784396*^9}, 
   3.8008663487684107`*^9, {3.800866391177509*^9, 3.8008664159043794`*^9}},
 CellLabel->
  "Out[128]=",ExpressionUUID->"dccc31f4-f6d6-4e8d-998a-8b02457e131d"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataX", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
      "\"\<val-loss-simple-seq.csv\>\""}], ",", "\"\<Dataset\>\"", ",", 
     RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataY", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
      "\"\<val-loss-mnist.csv\>\""}], ",", "\"\<Dataset\>\"", ",", 
     RowBox[{"\"\<HeaderLines\>\"", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8008658440855827`*^9, 3.8008658720172415`*^9}, {
  3.8008711209791517`*^9, 3.8008711262969546`*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"b8510f37-a297-4ce2-8999-23e04d486d74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Normal", "@", 
      RowBox[{"dataX", "[", 
       RowBox[{"All", ",", "\"\<Step\>\""}], "]"}]}], ",", 
     RowBox[{"Normal", "@", 
      RowBox[{"dataX", "[", 
       RowBox[{"All", ",", "\"\<Value\>\""}], "]"}]}]}], "}"}], 
   "\[Transpose]"}], "//", "listPlotB"}]], "Input",
 CellChangeTimes->{{3.8008660694145103`*^9, 3.80086615073213*^9}, {
   3.8008661838708887`*^9, 3.800866228165022*^9}, {3.800866291481224*^9, 
   3.800866292595214*^9}, {3.8008664014480743`*^9, 3.800866401548346*^9}, 
   3.8008711520132732`*^9},
 CellLabel->
  "In[142]:=",ExpressionUUID->"721e534a-fc14-403b-9f1f-5ab51f88b3f7"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
      CapForm["Butt"], 
      StyleBox[LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAmIQDQPeEZFHL6te2g/hqTj4vnfZwvb7GZRv4tAroKx3
R+YTlG/ncNbo4VTr49+hfBeHifvV5F7EfYHyPR3s4yqeWFXC1Ps5VJv6XyqI
YTwA5jYEOhzKnXQh9iQrhM8Q4uCzil92sTMXVD7MQf3znYD2DbxQ+UiHeWsz
/nyfJwCVj3b4fFfq3Fd/Qah8nAP7hKmvMgyEIHyHBIdkhZh33xOFoeoTHQSk
82RmCYhA+AeSHN7sPZR9ey2Uz5DioF544s5UW1Go/lSHgpNqP3IOQfkNaQ7M
T8qnFduJQfWnO3xS2l7IuBnKZ8h0MGidXZipKA7Vn+Vw62HdnoguKL8h2yGk
zrPx2Dso/0COg9X35RXC/hJQ/XkODAd6pj5dDeU75Ds8uKX+t4BVEsovcBDk
YD0fFwPlPyhw6BfSNHm+EspvKHQw/fkk5QWTFISvUORgs/fXbs1gKP9AkYMJ
9yE5t4VQfkKxQ6ZWPxvbOyifocShLSJ1mr2lNIS/oMRB5L/0uitN0gcAPoWl
TA==
        "]],
       FontSize->14,
       FontName -> "Times New Roman"]}}, 
    {RGBColor[1, 0, 0], PointSize[
      NCache[
       Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
     CapForm["Butt"], 
     StyleBox[{},
      FontSize->14,
      FontName -> "Times New Roman"]}, {
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
      CapForm["Butt"], 
      StyleBox[{},
       FontSize->14,
       FontName -> "Times New Roman"]}, {}}, {
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
      CapForm["Butt"], 
      StyleBox[{},
       FontSize->14,
       FontName -> "Times New Roman"]}, {}}}, {{}, {}}},
  AspectRatio->0.6,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, -7.244109193271685},
  BaseStyle->Directive[{
     GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"validation  loss\"", TraditionalForm], None}, {
     FormBox["\"training steps\"", TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{Quiet[
       Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {
     Automatic, Automatic}}, {{{{-6.907755278982137, 
        FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
          NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
          NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox["1", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.517193191416238, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-8.111728083308073, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.824046010856292, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.600902459542082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.418580902748128, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.264430222920869, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.1308988302963465`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.013115794639964, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.0986122886681098`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.3862943611198906`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.791759469228055, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.9459101490553132`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.0794415416798357`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2.1972245773362196`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}}, {0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-8., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-7., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       1.5, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       2., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {
     Automatic, Automatic}}],
  GridLines->{
   None, {-6.907755278982137, -4.605170185988091, -2.3025850929940455`, 0.}},
  GridLinesStyle->Directive[
    GrayLevel[0.4, 0.5], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImageSize->300,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 330.}, {-7.244109193271685, -0.28355879089702246`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Quiet[
     Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }]], "Output",
 CellChangeTimes->{{3.8008662145477858`*^9, 3.8008663048808637`*^9}, {
  3.8008664021651683`*^9, 3.800866412547304*^9}, {3.8008711470095415`*^9, 
  3.800871158550947*^9}, {3.8008711891876435`*^9, 3.8008711950373793`*^9}},
 CellLabel->
  "Out[142]=",ExpressionUUID->"125fad2a-4815-46c7-8da9-b9742fc2d65a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Normal", "@", 
      RowBox[{"dataY", "[", 
       RowBox[{"All", ",", "\"\<Step\>\""}], "]"}]}], ",", 
     RowBox[{"Normal", "@", 
      RowBox[{"dataY", "[", 
       RowBox[{"All", ",", "\"\<Value\>\""}], "]"}]}]}], "}"}], 
   "\[Transpose]"}], "//", "listPlotB"}]], "Input",
 CellChangeTimes->{{3.800866254603656*^9, 3.8008662570311003`*^9}, {
   3.8008663107120714`*^9, 3.800866347827855*^9}, {3.800866390166778*^9, 
   3.8008664155880795`*^9}, 3.800871153989732*^9},
 CellLabel->
  "In[143]:=",ExpressionUUID->"aa05f269-23e6-4861-ad15-67de3a25e242"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
      CapForm["Butt"], 
      StyleBox[LineBox[CompressedData["
1:eJw9Vgs41PkaHonIJddySi2pTdraKSyx9rxKW60uVESbQrmVs0nuihn3u2EY
M5Sd3YO1bUnUZl0ynbaotC4RJ5Isuy5pUa6r7J5nvv+Z55lnnvf5vu99v+/9
fr//f/TdzxzwWMBisa7//f3fL/PZctmgySz+Za0UrUF+4PzuY9eGCZsgZSbd
WsJh8Gdgz2Q7ZCUPEbbBlZrM/oluJr4b17SucUo0RwnvQ3tT/PlC1TdSzLHH
sccuBr+Z/kHxQwgw48+P1TNxR9TJlPDVtAiznLGvO3JMq3yM4l+ipdLMJn3h
W4ofw63ug8kOw5QPVzxnJ2pvWkf9cNwwadfMXvU9YYk7nkrMB9/yB6n+JOQV
u5b7DxEfPPCGo2abrzRA9Z5wtGJJljfSPBIvBPaVe7b+fz4fxBjcYQ3UMfqn
MOJv/1FUDTPPaew59yq/ij1F9b4oGLtVrWY4TfVfgffLhneL8hn9M7hpEJZe
uILi8EODDP8QV470evyQbzXscu9bxo+zUGH7T3n7Ur96/shf9N8PfM+QvxJ/
VPOW+WjPU73rOTTvi5i8Nz9O+gFYry8bqdFPWByAyn7uA+dopp9ARFiFXuTK
zJB+IOa2bdZNV3xH+kEoUTIK3br9PekHI8NolfuWf1BcEgzlEZt685FZ0g9B
5k8yEZvT5kg/FG0xLBODYKoXh8J+aL1MRwtLItUPw8qN0+9P+BFfTxi02ytP
t9sw/oZDs3Fjd7wl+aF3HqoFLXFj9ydI/zxcit8NNSxbKOVzvQC/686HXoaT
HisCJTqjgxsa50k/Ahq2Ry2G0haQfiTmsjvu3vKjfnoiYRZdqnTkLtWDA3kl
W11RM+nxOGCfKyjX3EX76+GA2/tyuIjxl81F0MXJnucRpMfhYiZ1v+a8UEbK
38RFpaTmRCtITy8K9jd3Tu1cSefHLwofyrWbKM0y+42Cipt77LafKV8tGiYh
vn8mPSJ+1+i//Vtf8SqF/CuNxt0bD5oua5IfrBjs1X26hbuR9mEXA+7Fvv0C
c+pHHIPbQezX0x8QHo1BeXi/h89uWfInFppVa4wPKBPmxaLNrU22VyxPfsVi
c8LbfvVwwuw4fKZ2sO8HJTkp5sRh8vbc4XtG1G9THIqcUrc53FWg+eOx4lRe
oWcI5fvFQ/0b8eq9a2k/knicDbQMWfuNEs2fgBtuU4ZL4gi7JqChbPBVWTjx
lSZgz477EcJ6RZo/EeMGwvhnz1Wk2C4RqXyxF6+K/BIn4oRRWarCC/JrNBHO
T7R8Bv9J8yAJxzOSpw68WELzJyHCQ8uON6pG8yfhUUtnw+460mcn49kd4+AQ
b2WaPxkZb12LFb+geFMyrDWrQwY/p3q9FIR2Sxyz1Qn7pUDbyrz/i1/Vaf4U
7LraVXzQQ5XmT0Xhk3Hzmc00j2sqjFg7Gi+9pPzSVLgYBXVc/pj0WGn4rVO2
+dK/mPnTUD4j1HF/qCHF4jQsvpi6v8qS4qNp0Hr0RrO4gPiQDpesSRjuIX1e
Or7aHnzGUp3ye9Jxwv3OBY8O6l+Hh08aa5ZXL6V88GApPhet7E1xbx4U27ZH
XXclfh4PbuIfH1cpUn4FD6GtBoYJnhTv4WGdV8/M/ZtUr5CBX75dY9z5uyb5
nQGFTy7L/V6uJcVOGfhzwv9k5RHCnAzcumVTUaBM+yvOwNdeeavbGL+bMnBo
YKtohzfFpzPAMdV9fWXJMtpPJp5Wvbd4PkJ+7crE3MKxBFVfyvfLxLPzK7OD
HKh/YSYCYp8ZvzpM/kgysW52e0zAUTqvA5nQ+rSqZncCs08+cGl2T8JVOi/m
fLRYtF/t2kX9ufKxsKmlX0WZ/EjgY0JtDH0XiL+UD8nDtfbcNVTfwccq8eqV
XWpUz8qC2b2Thk4N1K9hFpaK+F4RBjSPXRZ06n2L5MKIPyQLCpE75ctMqV6c
hduJtYMfb6D8+izsPTXv2K9D+aNZ4N23N78YRfw62bC2mrF6kET9IBv/Hjm7
xdaS6r2zkTySfy+zj/h52fAUbHrx0Ir4KrLR9HPM0ll1Zv/Z2FrpEzNtRXwK
Apj+UP65hjL5xxag4XXIkZFm4nMSYG26sWHRJdLjCLBYxr+3rlpbiosFSHYX
Ga+YWirFTQIovRZ09q4ivmkBrGt1jz9ZSvV6OchN7nTLe8rsPwcOJmV9uY2E
/XLQan/j7KyA2X8Okkqna/uqmf3nwEauYv9VF+pvIAeTxQ+HJOOE1YRQUbfI
ap6hec2F2NY98X1JB/G7CmH7ovGnoiFm/0KE/TpuWXeCue9CHF6hb3uaS7hD
iJHhsE2VYPYvgkbXj6sb1On8GYpQqHqntvtTuj92IvznAKsspGWxFIeIoH+h
ffr9Dro/YhHOvPva0ViW+OpFmDuaPmHiRHhUhAVlbjc975K+Ti56lIXftX7J
PD9yIWshG+ezibB3LsZHG3vfmzL3Pxf6bPNQRzW6bxW50LJv9pjpYf4P5KJu
SmVJlw29DxTysOx4QdA+a8LsPDgri1Me/0HvJ6c82Kjc70o6Ki/FnDx4RVwx
s/5wkeQvRAWx8A==
        "]],
       FontSize->14,
       FontName -> "Times New Roman"]}}, 
    {RGBColor[1, 0, 0], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     CapForm["Butt"], 
     StyleBox[{},
      FontSize->14,
      FontName -> "Times New Roman"]}, {
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
      CapForm["Butt"], 
      StyleBox[{},
       FontSize->14,
       FontName -> "Times New Roman"]}, {}}, {
     {RGBColor[1, 0, 0], PointSize[
       NCache[
        Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
      CapForm["Butt"], 
      StyleBox[{},
       FontSize->14,
       FontName -> "Times New Roman"]}, {}}}, {{}, {}}},
  AspectRatio->0.6,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, -6.055854801628978},
  BaseStyle->Directive[{
     GrayLevel[0], FontName -> "Times New Roman", FontSize -> 14}],
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"validation  loss\"", TraditionalForm], None}, {
     FormBox["\"training steps\"", TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->FrontEndValueCache[{{Quiet[
       Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
      Charting`ScaledFrameTicks[{Identity, Identity}]}, {
     Automatic, Automatic}}, {{{{-5.298317366548036, 
        FormBox[
         TagBox[
          InterpretationBox["\"0.005\"", 0.005, AutoDelete -> True], 
          NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
          NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox["\"0.050\"", 0.05, AutoDelete -> True], 
          NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
          NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox["\"0.500\"", 0.5, AutoDelete -> True], 
          NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.4054651081081644, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0.6931471805599453, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-5., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-4., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-3., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-2., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-1., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
        0.}}, {-7., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.8, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.6, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.4, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
       0., 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}}, {
     Automatic, Automatic}}],
  GridLines->{
   None, {-5.298317366548036, -4.605170185988091, -2.995732273553991, \
-2.3025850929940455`, -0.6931471805599453}},
  GridLinesStyle->Directive[
    GrayLevel[0.4, 0.5], 
    AbsoluteThickness[1], 
    AbsoluteDashing[{1, 2}]],
  ImageSize->300,
  LabelStyle->{FontFamily -> "Times"},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1760.}, {-6.055854801628978, -0.547756105920888}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Quiet[
     Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }]], "Output",
 CellChangeTimes->{{3.8008662577655935`*^9, 3.800866311784396*^9}, 
   3.8008663487684107`*^9, {3.800866391177509*^9, 3.8008664159043794`*^9}, {
   3.8008711492567196`*^9, 3.8008711556573744`*^9}, 3.8008711975768967`*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"2820e508-46ac-4e18-8525-1ef60e501e54"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1920, 1037},
WindowMargins->{{Automatic, 1912}, {394, Automatic}},
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (March 18, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"8d59b280-dbd3-40d3-9e3b-c768b26bf8f6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 324, 8, 28, "Input",ExpressionUUID->"1bebf07d-44fd-4c9c-ae33-e9b8942be1b5"],
Cell[907, 32, 2181, 42, 181, "Output",ExpressionUUID->"6eed8e3d-acc8-49bf-a762-5ecb17ae2ff5"]
}, Open  ]],
Cell[3103, 77, 2458, 54, 197, "Input",ExpressionUUID->"34a1b5c4-4943-4a49-ad91-2199f154a9c1",
 InitializationCell->True],
Cell[5564, 133, 558, 12, 44, "Input",ExpressionUUID->"a5952001-c3e6-4912-803e-e2277c8e1b3b",
 InitializationCell->True],
Cell[6125, 147, 7590, 153, 577, "Input",ExpressionUUID->"88c76715-c297-41fb-bdfd-f8bd5d69d457",
 InitializationCell->True],
Cell[13718, 302, 6270, 169, 254, "Input",ExpressionUUID->"1d30137a-8376-4735-9f7b-b686665dc1fb",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[20013, 475, 219, 4, 67, "Chapter",ExpressionUUID->"80af1e3b-59ee-462a-8818-1d3b28f085c8"],
Cell[20235, 481, 833, 18, 28, "Input",ExpressionUUID->"237db7e5-9a29-48fd-a5a7-cb2b7f399004"],
Cell[CellGroupData[{
Cell[21093, 503, 853, 22, 67, "Input",ExpressionUUID->"229eadfd-11f8-4308-a69b-230e0b3b3043"],
Cell[21949, 527, 657, 10, 32, "Output",ExpressionUUID->"39f232ef-5184-46d9-b1a0-7492628b7b11"],
Cell[22609, 539, 657, 10, 32, "Output",ExpressionUUID->"7f7c8498-19a9-494b-ab41-464c3842afc4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23303, 554, 1026, 25, 67, "Input",ExpressionUUID->"1a6aa707-5378-4d5b-90cc-659178d0b859"],
Cell[24332, 581, 1202, 17, 32, "Output",ExpressionUUID->"8c8a6e85-62c9-43a6-8314-35b242666246"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25571, 603, 1379, 32, 28, "Input",ExpressionUUID->"86993b25-7f74-4b10-847d-09709745ea47"],
Cell[26953, 637, 37976, 853, 167, "Output",ExpressionUUID->"47d14d88-7586-4b52-ad0f-64cb2e6aa962"]
}, Open  ]],
Cell[64944, 1493, 376, 6, 34, "Text",ExpressionUUID->"14239afb-061b-400c-bc85-0d24677af46c"],
Cell[CellGroupData[{
Cell[65345, 1503, 1541, 39, 86, "Input",ExpressionUUID->"71821e41-da72-4f46-a04e-f2ccc606ffd6"],
Cell[66889, 1544, 28871, 656, 167, "Output",ExpressionUUID->"730c41a4-b0a5-48b0-a320-21ea8295cc84"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95797, 2205, 549, 11, 48, "Input",ExpressionUUID->"3352cda1-787d-4b84-bd08-f33f839bcb7b"],
Cell[96349, 2218, 68556, 1522, 267, "Output",ExpressionUUID->"805d514f-f1da-4a08-aa61-16a35f3727a1"]
}, Open  ]],
Cell[164920, 3743, 221, 4, 34, "Text",ExpressionUUID->"2bb82f68-e948-4fbc-b527-b1fba39ae245"],
Cell[CellGroupData[{
Cell[165166, 3751, 1588, 35, 86, "Input",ExpressionUUID->"3b42a380-2516-497b-84e9-d9b40a3be749"],
Cell[166757, 3788, 25721, 591, 221, "Output",ExpressionUUID->"5eaeecb9-25b9-4542-a285-f6cf34f05975"]
}, Open  ]],
Cell[CellGroupData[{
Cell[192515, 4384, 1434, 33, 86, "Input",ExpressionUUID->"4796c954-d7d3-4b20-b31c-a8b86e3c44e4"],
Cell[193952, 4419, 11019, 266, 221, "Output",ExpressionUUID->"c2d4d115-1578-407a-82ac-4f276277535f"]
}, Open  ]],
Cell[204986, 4688, 160, 3, 34, "Text",ExpressionUUID->"b4f7621e-d6a4-4824-8811-ad24dfcb0ee0"],
Cell[CellGroupData[{
Cell[205171, 4695, 939, 22, 28, "Input",ExpressionUUID->"5a19b9ac-90eb-4b8a-9cee-77dfbbe1f529"],
Cell[206113, 4719, 110728, 1989, 555, "Output",ExpressionUUID->"2c281eac-7684-49a5-9b01-4be4ed5189a9"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[316890, 6714, 206, 4, 67, "Chapter",ExpressionUUID->"d7c1f52a-9ffa-47e2-96a1-602dfb6b75df"],
Cell[317099, 6720, 3042, 71, 387, "Input",ExpressionUUID->"6b0409ce-318e-44ea-bdc9-1d747ed4bdb3",
 InitializationCell->True],
Cell[320144, 6793, 918, 18, 28, "Input",ExpressionUUID->"c451b6ed-2d37-4f83-8041-16f7b43dbb26"],
Cell[CellGroupData[{
Cell[321087, 6815, 873, 22, 67, "Input",ExpressionUUID->"3dd5c580-ef66-4620-9c89-ffb27de3e00a"],
Cell[321963, 6839, 752, 10, 32, "Output",ExpressionUUID->"0694bcfc-cf35-4739-9ef0-e309ff14a257"],
Cell[322718, 6851, 752, 10, 32, "Output",ExpressionUUID->"db7852cc-ef3c-4727-93e7-4533e0e2fd70"]
}, Open  ]],
Cell[CellGroupData[{
Cell[323507, 6866, 1011, 25, 67, "Input",ExpressionUUID->"8552608d-8fb8-4751-beeb-2c18140467cd"],
Cell[324521, 6893, 1245, 17, 32, "Output",ExpressionUUID->"11bcaef8-91e0-4114-846f-8274c44e4142"]
}, Open  ]],
Cell[CellGroupData[{
Cell[325803, 6915, 1024, 22, 28, "Input",ExpressionUUID->"77312177-6b3e-446e-8ad6-8df114195053"],
Cell[326830, 6939, 23738, 558, 214, "Output",ExpressionUUID->"eb6c9b71-04d5-44fb-9582-b8087360b8d0"]
}, Open  ]],
Cell[350583, 7500, 149, 3, 48, "Input",ExpressionUUID->"d3cdd098-e6d7-463e-87da-6d7672ec3994"]
}, Open  ]],
Cell[CellGroupData[{
Cell[350769, 7508, 178, 3, 67, "Chapter",ExpressionUUID->"f7b601a5-d550-44ef-a839-357719b2fe62"],
Cell[350950, 7513, 589, 14, 44, "Input",ExpressionUUID->"ddfce460-5d85-4561-9161-7e239be8322b",
 InitializationCell->True],
Cell[351542, 7529, 4192, 95, 425, "Input",ExpressionUUID->"fe8329aa-5aa2-4cf8-b19a-feeecc633457",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[355759, 7628, 1801, 47, 143, "Input",ExpressionUUID->"ffe8ee01-b591-47f3-bcf3-90404a8f7842"],
Cell[357563, 7677, 278, 4, 32, "Output",ExpressionUUID->"447057b3-44e4-410f-8d80-579775ce81ba"],
Cell[357844, 7683, 278, 4, 32, "Output",ExpressionUUID->"0eaff187-e324-47d6-9cf5-f9dd21083936"],
Cell[358125, 7689, 276, 4, 32, "Output",ExpressionUUID->"3643449d-6a06-4e62-8cc0-ab15a7283296"]
}, Open  ]],
Cell[CellGroupData[{
Cell[358438, 7698, 1757, 46, 143, "Input",ExpressionUUID->"f28f003f-5be7-4b27-8403-d4b55d94f5d5"],
Cell[360198, 7746, 226, 3, 32, "Output",ExpressionUUID->"0a13e56b-123c-4ed3-905f-67e15e5ff1f7"],
Cell[360427, 7751, 226, 3, 32, "Output",ExpressionUUID->"1c69ad36-ab56-4f50-bbe0-e91c90a68013"],
Cell[360656, 7756, 224, 3, 32, "Output",ExpressionUUID->"b44bb3a1-6d12-4f6e-a95d-5744ccedc3ad"]
}, Open  ]],
Cell[CellGroupData[{
Cell[360917, 7764, 1879, 48, 143, "Input",ExpressionUUID->"375fd1bb-16e0-4df0-b0b5-fbc5ff659a8f"],
Cell[362799, 7814, 424, 6, 32, "Output",ExpressionUUID->"f8239497-2510-4469-bcf4-b4f8ad7bd703"],
Cell[363226, 7822, 424, 6, 32, "Output",ExpressionUUID->"6eac3cf5-bb05-4233-9744-9d4a8bca1574"],
Cell[363653, 7830, 424, 6, 32, "Output",ExpressionUUID->"c8d628f6-9b7d-47dc-a662-7b6d4d6e9a94"]
}, Open  ]],
Cell[CellGroupData[{
Cell[364114, 7841, 1580, 31, 124, "Input",ExpressionUUID->"25af6f1b-9549-4f95-bffc-6597800777f7"],
Cell[365697, 7874, 74708, 1585, 209, "Output",ExpressionUUID->"cf20af14-322c-4f8a-88ea-a18a5d7f23ff"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[440454, 9465, 156, 3, 67, "Chapter",ExpressionUUID->"70610b5e-b48f-4328-ac14-cd5d84de655a"],
Cell[440613, 9470, 1289, 35, 67, "Input",ExpressionUUID->"a8cdf916-15ca-4579-b8f5-5428bf17dfaa"],
Cell[CellGroupData[{
Cell[441927, 9509, 458, 9, 28, "Input",ExpressionUUID->"4bfaf213-b67a-401e-8d93-898259f89ba3"],
Cell[442388, 9520, 112203, 2238, 559, "Output",ExpressionUUID->"a4f3f5f1-c41c-421d-b870-ba2e837866a3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[554628, 11763, 2962, 73, 105, "Input",ExpressionUUID->"9bef51c1-7b11-4234-a1f9-a25bf67b5afe"],
Cell[557593, 11838, 13297, 373, 128, "Output",ExpressionUUID->"a62a2d46-94c3-4972-a24c-a67e9d874ef0"],
Cell[570893, 12213, 199944, 4468, 210, "Output",ExpressionUUID->"07365a0d-4865-4add-8602-865b1de971a4"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[770886, 16687, 160, 3, 67, "Chapter",ExpressionUUID->"079cd739-d79f-4eb1-a07e-9f89d9cfab83"],
Cell[771049, 16692, 1957, 38, 333, "Input",ExpressionUUID->"fbf83419-2666-46e6-a6a8-14d9abb7dbe4"],
Cell[773009, 16732, 773, 20, 48, "Input",ExpressionUUID->"19682929-c7ed-42bc-b0c8-541174b3ec3f"],
Cell[CellGroupData[{
Cell[773807, 16756, 717, 18, 28, "Input",ExpressionUUID->"fe85de7f-432a-4931-8e51-3895b377c8c2"],
Cell[774527, 16776, 15675, 364, 209, "Output",ExpressionUUID->"cbb8116d-bd58-4011-af72-6e5ea1621b51"]
}, Open  ]],
Cell[CellGroupData[{
Cell[790239, 17145, 672, 18, 28, "Input",ExpressionUUID->"987d6450-b031-4dc2-b00c-3da03833b46a"],
Cell[790914, 17165, 23694, 480, 209, "Output",ExpressionUUID->"dccc31f4-f6d6-4e8d-998a-8b02457e131d"]
}, Open  ]],
Cell[814623, 17648, 832, 22, 48, "Input",ExpressionUUID->"b8510f37-a297-4ce2-8999-23e04d486d74"],
Cell[CellGroupData[{
Cell[815480, 17674, 685, 17, 28, "Input",ExpressionUUID->"721e534a-fc14-403b-9f1f-5ab51f88b3f7"],
Cell[816168, 17693, 11345, 287, 208, "Output",ExpressionUUID->"125fad2a-4815-46c7-8da9-b9742fc2d65a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[827550, 17985, 634, 16, 28, "Input",ExpressionUUID->"aa05f269-23e6-4861-ad15-67de3a25e242"],
Cell[828187, 18003, 13637, 336, 202, "Output",ExpressionUUID->"2820e508-46ac-4e18-8525-1ef60e501e54"]
}, Open  ]]
}, Open  ]]
}
]
*)

