import os
import numpy as np
from skimage.transform import resize
from scipy.stats import pearsonr
import mahotas as mh
from PIL import Image
import time
import skimage.exposure

def extract_from_single_cell_crop(antibody, nucleus):
    # extract intensity feature
    integrated_intensity = np.sum(antibody)
    mean_intensity = np.mean(antibody)
    std_intensity = np.std(antibody)
    intensity_features = np.array([integrated_intensity, mean_intensity, std_intensity])

    # extract correlation features
    nucleus_corr = pearsonr(antibody.flatten(), nucleus.flatten())
    correlation_features = np.array([nucleus_corr])

    # extract texture features
    antibody_scaled = np.round(antibody * 255).astype(np.uint8)
    scale1 = mh.features.haralick(antibody_scaled, distance=1)
    scale2 = mh.features.haralick(antibody_scaled, distance=2)
    scale3 = mh.features.haralick(antibody_scaled, distance=4)
    scale4 = mh.features.haralick(antibody_scaled, distance=8)
    scale5 = mh.features.haralick(antibody_scaled, distance=16)
    texture_features = np.hstack((scale1.flatten(), scale2.flatten(), scale3.flatten(), scale4.flatten(), scale5.flatten()))

    return np.hstack((intensity_features.flatten(), correlation_features.flatten(), texture_features.flatten()))

datapath = "./COOS7_images/test3/"
outputfile = "./COOS7_texture_features/test3.txt"

for indir in os.listdir(datapath):
    start_time = time.time()
    for image in os.listdir(datapath + indir):
        if "_protein.tif" in image:
            #print("Evaluating", image)
            name = image.split("_protein")[0]
            antibodyname = datapath + indir + "/" + image
            nucleusname = antibodyname.replace("_protein", "_nucleus")

            antibody = np.array(Image.open(antibodyname))
            nucleus = np.array(Image.open(nucleusname))
            antibody = skimage.exposure.rescale_intensity(antibody, out_range=(0, 1))
            nucleus = skimage.exposure.rescale_intensity(nucleus, out_range=(0, 1))

            antibody = resize(antibody, (64, 64))
            nucleus = resize(nucleus, (64, 64))

            features = extract_from_single_cell_crop(antibody, nucleus)

            output = open(outputfile, "a")
            output.write(indir)
            output.write("\t")
            output.write(name)
            output.write("\t")
            for feat in features:
                output.write(str(feat))
                output.write("\t")
            output.write("\n")
            output.close()
    print ("Finished", indir, "in", time.time() - start_time)

