# Supplementary simulation code for the paper titled: 
# 'Identifying Causal Effects via Context-specific Independence Relations'

# These are the required packages, uncomment and run the following to install them
# install.packages(c("Rcpp", "ggplot2", "scales", "latex2exp", "reshape2"))
library(Rcpp)
library(ggplot2)
library(scales)
library(latex2exp)
library(reshape2)
# Set the directory to the directory containing the sub-directories 'R' and 'src'
dir <- "U:/Desktop/csidosearch"
setwd(dir)
sourceCpp("src/initialize_csisearch.cpp")
sourceCpp("src/initialize_contextsearch.cpp")
source("R/get_derivation.R")
source("R/helpers.R")
source("R/output.R")

# Uncomment and run to reproduce the simulation results from the paper
# n7_1 <- run(nsim = 100, n = 7, seed = 9999)
# n8_1 <- run(nsim = 100, n = 8, seed = 9999)
# n9_1 <- run(nsim = 100, n = 9, seed = 9999)

# Alternatively, load the simulation data
load("data/n7_1.rData")
load("data/n8_1.rData")
load("data/n9_1.rData")

runs <- list(n7_1, n8_1, n9_1)

# Cactus plot
plot_cactus <- cactus(runs)

# Bar plot
plot_bars <- bars(runs)