#ifndef CONTEXTSEARCH_H
#define CONTEXTSEARCH_H

#include <unordered_map>
#include <vector>
#include <string>
#include <queue>
#include <chrono>
#include <stack>
#include <Rcpp.h>
#include "ldag.h"

using namespace std;

struct p {
    int a, b, c, d;
};

struct rindep {
    int xset, yset, zset, u, v;
};

struct output {
    p to, from, rp;
    rindep ri;
    bool valid, enumerate;
};

struct distr {
    int rule_num, index, score, pa1, pa2;
    bool primitive;
    p pp;
};

struct comp_distr {
    bool operator()(distr const * d1, distr const * d2) {
        return d1->score < d2->score;
    }
};

class contextsearch {
public:
    contextsearch(const int& n_, const int& con, const int& intv, const bool& verb);
    Rcpp::List search_init();
    int n, index, lhs, con_vars, intv_vars;
    bool trivial_id, format_do;
    const bool verbose;
    ldag *g;
    vector<string> labels;
    vector<int> z_sets;
    vector<int> rules;
    vector<p> targets;
    unordered_map<string, int> found_targets;
    unordered_map<int, distr> L;
    unordered_map<string, int> ps;
    stack<int> candidates;
    output info;
    vector<double> rule_times;
    virtual void add_distribution(distr& nquery);
    virtual void add_known(const int& a, const int& b);
    virtual distr& next_distribution(const int& i);
    void search();
    void set_target(const int& a, const int& b);
    void set_options();
    void set_labels(const Rcpp::StringVector& lab);
    void set_graph(ldag* g_);
    bool is_primitive(const bool& pa1_primitive, const bool& pa2_primitive, const int& ruleid);
    // void draw(const distr& dist, const bool& recursive, derivation& d);
   //  string derive_formula(distr& dist);
    string dec_to_text(const int& dec, const int& zero, const int& one) const;
    string to_string(const p& pp) const;
    // string rule_name(const int& rule_num) const;
    string make_key(const p& pp) const;
    bool equal_p(const p& p1, const p& p2) const;
    void any_target(const p& pp, const int& ix);
    bool all_targets();
    bool valid_rule(const int& ruleid, const int& a, const int& b, const int& c, const int& d, const bool& primi) const;
    void apply_rule(const int& ruleid, const int& a, const int& b, const int& c, const int& d, const int& z, const int& z_ind);
    void derive_distribution(const distr& iquery, const distr& required, const int& ruleid, int& remaining, bool& found);
    void get_ruleinfo(const int& ruleid, const int& y, const int& x, const int& u, const int& v, const int& z);
    void get_candidate(distr &required, const int& req);
    void enumerate_candidates();
    virtual ~contextsearch();
};

class contextsearch_heuristic: public contextsearch {
public:
    contextsearch_heuristic(const int& n_, const int& con, const int& intv, const bool& verb);
    void add_distribution(distr& nquery);
    void add_known(const int& a, const int& b);
    distr& next_distribution(const int& i);
    ~contextsearch_heuristic();
private:
    int compute_score(const p& pp) const;
    priority_queue<distr*, std::vector<distr*>, comp_distr> Q;
};

#endif	/* CONTEXTSEARCH_H */

