bars <- function(runs, n_start = 7) {
    m <- length(runs)
    nsim <- length(runs[[1]]$res_con[[1]])
    res_mat <- matrix(0, nsim * m, 9)
    n <- numeric(nsim * m)
    eps <- 1e-9
    scale <- 60000
    for (i in 1:m) {
        res_con <- runs[[i]]$res_con[[1]]
        for (j in 1:nsim) {
            ix <- nsim * (i - 1) + j
            inst <- res_con[[j]]$res
            n[ix] <- n_start + (i - 1)
            res_mat[ix,1] <- inst$time/scale
            res_mat[ix,2] <- sum(inst$rule_times[5:8])/scale
            res_mat[ix,3] <- inst$rule_times[1]/scale
            res_mat[ix,4] <- inst$rule_times[2]/scale
            res_mat[ix,5] <- sum(inst$rule_times[3:4])/scale
            res_mat[ix,6] <- sum(inst$rule_times[11:13])/scale
            res_mat[ix,7] <- sum(inst$rule_times[9:10])/scale
            res_mat[ix,8] <- sum(inst$rule_times[14])/scale
            res_mat[ix,9] <- sum(inst$rule_times[15])/scale
        }
    }
    colnames(res_mat) <- c("time", paste("Rule", 1:8))
    df <- as.data.frame(res_mat)
    df$inst <- 1:(m * nsim)
    df$n <- factor(n, labels = paste("n =", n_start:(n_start + m - 1))) 
    df2 <- melt(df[,-1], variable.name = "rule", value.name = "ruletime", id.vars = c("inst", "n"))
    df_ag <- aggregate(ruletime ~ n + rule, data = df2, function(x) c(mean(x), sd(x)/sqrt(length(x))))
    df_summary <- data.frame(n = df_ag$n, rule = df_ag$rule, avg = df_ag[,3][,1], se = df_ag[,3][,2])
    p <- ggplot(df_summary, aes(x = rule, y = avg, fill = n)) +
        geom_bar(stat = "identity", position = position_dodge()) +
        geom_errorbar(aes(ymin = avg - se, ymax = avg + se), width = 0.85, lwd = 1, position = position_dodge(.9)) +
        theme_bw(base_size = 30) + 
        coord_cartesian(clip = "on") + 
        scale_fill_discrete(name = "") +
        scale_color_discrete(guide = FALSE) + 
        theme(
            axis.text = element_text(color = "black"),
            panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
            plot.margin = unit(c(10, 17, 5.5, 5.5), "points"), 
            legend.text = element_text(size = 24),
            legend.key.width = unit(1.5, "cm"),
            legend.position = c(0.10,0.90),
            legend.spacing.y = unit(0, "cm"),
            legend.margin = margin(t = -20, r = 0, b = 0, l = 0),
            axis.title.y = element_text(size = 26, margin = margin(t = 0, r = -20, b = 0, l = 0)),
            axis.title.x = element_text(size = 26, margin = margin(t = -20, r = 0, b = 0, l = 0))
        ) +
        ylab("Average time (min)") + xlab("") +
        scale_y_continuous(breaks = c(0, 5), limits = c(0, 5), expand = c(0,0.01))
    return(p)
}

cactus <- function(runs, n_start = 7) {
    m <- length(runs)
    nsim <- length(runs[[1]]$res_con[[1]])
    res_mat <- matrix(0, 2 * nsim * m, 2)
    cfg <- numeric(2 * nsim * m)
    n <- numeric(2 * nsim * m)
    eps <- 1e-9
    for (i in 1:m) {
        res_con <- runs[[i]]$res_con[[1]]
        res_full <- runs[[i]]$res_full[[1]]
        for (j in 1:nsim) {
            ix <- nsim * (i - 1) + j
            xi <- ix + (nsim * m)
            inst1 <- res_con[[j]]$res
            inst2 <- res_full[[j]]$res
            res_mat[ix,1] <- inst1$time / 60000
            res_mat[xi,1] <- inst2$time / 60000
            cfg[ix] <- "Alg. 1"
            cfg[xi] <- "Full CS"
            n[ix] <- n_start + (i - 1)
            n[xi] <- n_start + (i - 1)
        }
    }
    colnames(res_mat) <- c("time", "logtime")
    df <- as.data.frame(res_mat)
    df$cfg <- as.factor(cfg)
    df$n <- factor(n, labels = paste("n =", n_start:(n_start + m - 1)))
    df1 <- df[order(df$n, df$cfg, df$time), ]
    df1$axis <- rep(1:(nrow(df1)/(2 * m)), (2 * m))
    df1$cfg_n <- interaction(df1$n, df1$cfg, sep = ", ")
    p <- ggplot(df1, aes(x = axis, y = time)) + 
        geom_line(aes(linetype = cfg_n, colour = cfg_n), size = 1.5) + 
        theme_bw(base_size = 30) + 
        scale_colour_manual(name = "", values = rep(c("#F8766D", "#00BA38", "#619CFF"), 2)) +
        scale_linetype_manual(name = "", values = rep(c(1, 2), each = m)) +
        coord_cartesian(clip = "on") + 
        theme(
            axis.text = element_text(color = "black"),
            panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
            plot.margin = unit(c(10, 17, 5.5, 5.5), "points"), 
            legend.text = element_text(size = 24),
            legend.key.width = unit(1.5, "cm"),
            legend.position = c(0.15,0.85),
            legend.spacing.y = unit(0, "cm"),
            legend.margin = margin(t = -20, r = -5, b = 0, l = 0),
            axis.title.y = element_text(size = 26, margin = margin(t = 0, r = -24, b = 0, l = 0)),
            axis.title.x = element_text(size = 26, margin = margin(t = -20, r = 0, b = 0, l = 0))
        ) +
        ylab("Time per instance (min)") + xlab("Sorted instance #") +
        scale_x_continuous(oob = function(x, ...) x, breaks = c(0, 100), limits = c(0, 101), expand = c(0,0)) +
        scale_y_continuous(oob = function(x, ...) x, breaks = c(0, 30), limits = c(-1, 30), expand = c(0,0.01))
    return(p)
}
