import subprocess
import json
names = ['northwest_antelope_valley', 'northeast_antelope_valley', 'lancaster', 'quartz_hill', 'lake_los_angeles', 'northwest_palmdale', 'leona_valley', 'palmdale', 'desert_view_highlands', 'sun_village', 'littlerock', 'acton', 'southeast_antelope_valley']
nvals = [500]
for n in nvals:
    for netnum in range(100):
        all_agents = []
        while len(all_agents) != n:
            all_agents = []
            sizes = []
            for region in names:
                with open('data/synthetic_spa/config_' + region + '.json', 'r') as f:
                    config = json.load(f)
                sizes.append(int(config['totalpop']))
            n_regions = [int(float(sizes[i])/sum(sizes)*n) for i in range(len(names))]
            n_regions[2] += n - sum(n_regions)
            for i,region in enumerate(names):
                n_region = n_regions[i]
                subprocess.call('python generate_agents.py --num ' +str(n_region) + ' --out out.json --config data/synthetic_spa/config_' + region + '.json', shell=True)
                with open('out.json', 'r') as f:
                    agents = json.load(f)
                for a in agents:
                    a['region'] = region
                all_agents.extend(agents)
        print(n, netnum, len(all_agents))
        with open('data/synthetic_spa/agents_' + str(n) + '_' + str(netnum) + '.json', 'w') as f:
            json.dump(all_agents, f)