package coreset;

import java.util.List;

import base.Line;
import base.Point;
import clust.Objective;
import clust.WeightedPoint;
import clust.ZObjective;

public class KMedian1D extends Coreset1D
{
    public KMedian1D(List<WeightedPoint> pointSet, Line line, List<Point> optCenters)
    {
        super(pointSet, line, optCenters);
    }

    @Override
    protected double getThreshold(double eps, int k, double opt)
    {
        return eps * opt / k;
    }

    /*
    @Override
	protected ArrayList<Segment> generateSegment(double start, double end)
	{
    	ArrayList<WeightedDouble> list = WeightedDouble.fracSubList(data.T, start, end);
		ArrayList<Segment> res = new ArrayList<Segment>();
		Segment main = new Segment(data.center, data.direction, data.color);
		int af = (int)Math.floor(start);
		int ac = (int)Math.ceil(start);
		int bf = (int)Math.floor(end);
		int bc = (int)Math.ceil(end);
		for (int i = ac; i < bf; i++)
		{
			main.T.add(data.T.get(i));
		}
		
		if (main.T.size() != 0)
		{
			res.add(main);
		}
		if (af != ac)
		{
			double delta = ac - start;
			Segment head = new Segment(data.center, data.direction, data.color);
			head.T.add(new WeightedDouble(data.T.get(af).data, delta, data.T.get(af).color));
			res.add(head);
		}
		if (bf != bc)
		{
			double delta = end - bf;
			Segment tail = new Segment(data.center, data.direction, data.color);
			tail.T.add(new WeightedDouble(data.T.get(bf).data, delta, data.T.get(bf).color));
			res.add(tail);
		}
		return res;
	}*/

	@Override
	protected double evaluateError(double start, double end) {
		return WeightedPoint.cumulError(WeightedPoint.fracSubList(this.data.toPoints(), start, end), 
				ZObjective.getObjective(1.0));
		// return this.data.cumulError(start, end, ZObjective.getObjective(1.0));
	}

	@Override
	protected Objective getObjective()
	{
		return ZObjective.getObjective(1.0);
	}
}
