"""
Model parameters for interaction prediction model with sequence added.

To update params, do the following...

1) Up the current version number.
2) In _create_params, add the new params behind a version flag.
3) In _attempt_patch, add the appropriate patch behind a version flag.
4) In docstring below, document what the updated params are.

"""
import src.util.versioned_params as vp


class SeqModelParams(vp.VersionedParams):
    """Interaction prediction sequence model params."""

    def _attempt_patch(self, key):
        """Attempt to patch the provided key in params."""
        return False

    @classmethod
    def _create_params(cls, inputs, version):
        """Inititalize and check parameters."""

        params = {
            'version': version,
            'struct_model': inputs['struct_model']
        }
        cls._set_or_default(params, inputs, 'batch_norm', False)
        cls._set_or_default(params, inputs, 'dropout', False)
        cls._set_or_default(params, inputs, 'cons_window_radius', 5)
        cls._set_or_default(params, inputs, 'source',
                            ['pssm', 'psfm', 'struct'])
        return params

    def _get_creation_inputs(self):
        """
        Get arguments used to create the param file from existing params.
        """
        inputs = dict()
        inputs['struct_model'] = self.params['struct_model']
        return inputs

    @classmethod
    def _curr_version(cls):
        """Current version of params."""
        return 1.0


def init_params(args, version=None):
    return SeqModelParams.create(vars(args), version=version)


def load_params(param_json, new_version=None):
    return SeqModelParams.load_updated(param_json, new_version)
