# surfacelets

## Overview

Learns an interaction function between pieces of protein surface.

Accompanies the publication "End-to-End Learning on 3D Protein Structure for Interface Prediction"

## Requirements

You need to have python2.7 and pip accessible to use the basic code.  For the deep learning
code to run on GPUs, you also need access to tensorflow 1.8.0, cuDNN v7, and cuda 9.0 .

## Installation

Clone the repository, and then run `make init` from its root.  As this will install several python packages, you may want to create a new virtualenv or conda environment first!

## Datasets

The training (DIPS) and testing (DB5) datasets are supplied alongside this code.

## Running the code

You can run the code via `python main.py` and associated subcommands.  You can
get a help message by passing the -h flag.

Sample run code to replicate the best structure-only model results in the paper
are also included in `scripts/train.sh` and `scripts/test.sh`.  You will need to
edit the parameters at the top of these files to point to the downloaded and
unpacked dataset directories, as well as define output directories.  This will
take ~48 hours on 1 GPU (the default).

To run a much smaller test run to make sure all the code works, you can use
`scripts/train-small.sh` and `scripts/test-small.sh`.  You will still need to
set the appropriate parameters at the top of the file.

Once those the structure-only model is trained, you can replicate the best
structure+conservation model results with `scripts/seq_train.sh` and
`scripts/seq_test.sh`.  Again, you will need to set the appropriate parameters
at the top of these files.

## Quick reference

Below is a quick description of the relevant commands:

`python main.py config interact model` : configures structure-only model parameters.

`python main.py config interact seqmodel` : configures structure+sequence model parameters.

`python main.py config interact train` : configures training run parameters.

`python main.py config interact test` : configures testing run parameters.

`python main.py interact` : run training.

`python main.py predict` : run testing.
