## Description
This folder contains files used for the experiments in Section7.1.
To run the codes, you will need Python 3 and Tensorflow.

## To Run Codes
### Step1. Train Models

To train logistic regression, run

```
python TrainLogreg.py [target] [seed]
```

where `target` is one of {adult, 20news, mnist}, and `seed` is the random seed.
For example, to train logistic regression for adult with seed=0, run

```
python TrainLogreg.py adult 0
```

To train deep neural networks, run

```
python TrainDNN.py [target] [seed] [gpu_index]
```

where `gpu_index` is the index of GPU used.
For example, to train deep neural networks for adult with seed=0 and gpu_index=2, run

```
python TrainDNN.py adult 0 2
```


### Step2. Compute LIEs

To compute influences for logistic regression, run

```
python EvalResultsLogreg.py [target] [seed]
```

To compute influences for deep neural networks, run

```
python EvalResultsDNN.py [target] [seed] [gpu_index]
```

### Step3. See Results

To see the results, check `ViewResults.ipynb`.
