import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
from matplotlib.ticker import MaxNLocator
from collections import namedtuple
from main_expe7B import list_event_id, list_pb_name

from expes.utils import configure_plt
for event_id in list_event_id:
    dict_dns = np.load("event_id_%i_dns.npy" % event_id).take(0)
    dict_supp = np.load("event_id_%i_supp.npy" % event_id).take(0)
    dict_time = np.load("event_id_%i_time.npy" % event_id).take(0)

fig_dir = "../../../latex/NeurIPS2019/prebuiltimages/"

n_groups = 6


means_men = []
means_women = []

for pb_name in list_pb_name:
    means_women.append(dict_time[pb_name, True])
    try:
        means_men.append(dict_time[pb_name, False])
    except:
        means_men.append(0)

fig, ax = plt.subplots()

index = np.arange(n_groups)
bar_width = 0.35

error_config = {'ecolor': '0.3'}
current_palette = sns.color_palette("colorblind")

rects1 = ax.bar(index, means_men, bar_width,
                color=current_palette[1],
                error_kw=error_config,
                label='Safe stop')

rects2 = ax.bar(index + bar_width, means_women, bar_width,
                color=current_palette[0],
                error_kw=error_config,
                label='Heuristic stop')

ax.set_xlabel('Algorithms')
ax.set_ylabel('Time (s)')
# ax.set_title('Scores by group and gender')
ax.set_xticks(index + bar_width / 2)
ax.set_xticklabels(("CLaR", "SGCL", "$\ell_{2,1}$-MLER", "$\ell_{2,1}$-MLE", "$\ell_{2,1}$-MRCER", "MTL"))
ax.legend(fontsize=15)
plt.grid()
fig.tight_layout()
plt.savefig(fig_dir + "fig_time.pdf")
plt.show()
