from typing import Dict, List, Tuple
from collections import defaultdict
import operator
import numpy as np
from glob import glob
import pandas as pd
from tape.analysis import get_config, get_best_metric


if __name__ == '__main__':
    import matplotlib.pyplot as plt
    import seaborn as sns
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument('directory')
    parser.add_argument('model')
    parser.add_argument('key1')
    args = parser.parse_args()

    directories = glob(f'results/{args.directory}/secondary_structure_{args.model}*')

    assert directories

    key1_values: List[int] = []
    data_values: Dict[int, float] = defaultdict(lambda: 0)

    for directory in directories:
        config = get_config(directory)

        key1 = config[args.model][args.key1]
        accuracy = get_best_metric(directory)

        key1_values.append(key1)
        data_values[key1] = max(data_values[key1], accuracy)

    key1_array = np.sort(np.array(list(set(key1_values))))

    data = np.zeros([key1_array.size])

    for point, val in data_values.items():
        p1 = np.where(key1_array == point)[0][0]
        data[p1] = val

    point, acc = max(data_values.items(), key=operator.itemgetter(1))
    print('Max Accuracy:', acc, f'{args.key1}:', point)

    sns.set()
    plt.plot(key1_array, data, marker='o')
    plt.xlabel(args.key1)
    plt.title('Accuracy on secondary structure prediction gridsearch')

    plt.show()
