from typing import Tuple, List
import subprocess
import numpy as np
import tensorflow.keras.backend as K
from tensorflow.keras import Model


class OneHotModel(Model):

    def __init__(self, n_symbols: int):
        super().__init__()
        self._n_symbols = n_symbols

    def call(self, inputs):
        encoder_output = K.one_hot(inputs['sequence'], self._n_symbols)
        inputs['encoder_output'] = encoder_output
        return inputs

    @property
    def boundaries(self) -> Tuple[List[int], List[int]]:
        nvidia_smi = subprocess.check_output('nvidia-smi')
        memsize = list(filter(lambda word: 'MiB' in word, nvidia_smi.decode().split()))[1]
        memsize = int(memsize[:-3]) // 1000  # number of gigabytes on gpu
        boundaries = [
            (100, 5),
            (200, 5),
            (300, 5),
            (400, 5),
            (600, 5),
            (900, 4),
            (1000, 4),
            (1200, 3),
            (1300, 3),
            (2000, 2),
            (3000, 1)]

        bounds = [b[0] for b in boundaries]
        sizes = [b[1] for b in boundaries]
        sizes.append(0)

        bounds_array = np.array(bounds)
        sizes_array = np.array(sizes)
        sizes_array = sizes_array * memsize / 2

        sizes_array = np.asarray(sizes_array, np.int32)
        sizes_array[sizes_array <= 0] = 1

        return bounds_array, sizes_array
