clear;
addpath('../aux'); %test;
addpath('../figures');
addpath('../results'); %test;

design='HLLT'; %NP, SSG, HLLT
[f,sim,x_vis,f_vis]=get_design(design);

% sample size
N=1000;

% simulate data, split into stage 1 and 2 samples
rng('default');
rho=0.5;
[x,y,z]=sim(f,N,rho);

%% kernel smooth

csvwrite('df_in.csv',[x y z]);
csvwrite('df_vis.csv',x_vis);

% run R script to obtain y_vis
bash_script = fullfile(pwd,'kernelsmoothIV_pred.sh'); 
system(bash_script);
y_vis=csvread('df_out.csv',1,1);

% mse
disp('mse:');
disp(mse(y_vis,f_vis));