clear;

addpath('./aux'); %test;
addpath('./figures');
addpath('./results'); 

alg_options={'KIV','kernel_ridge','sieve','sieve_ridge','deep','kernelsmooth'};
N_sizes=[1000 5000 10000]; %change to 1000 5000 10000
rho_vals=[.9 .75 .5 .25 .1]; %change to .9 .75 .5 .25 .1
n_trials=40; %change to 40

%% CC

rng('default')
design='CC';
[~,~,~,f_vis]=get_design(design);
for a=1:length(alg_options)
    
    alg=alg_options{a};
    dir=strcat('./',alg);
    cd(dir);
    
    for i=1:length(N_sizes)
        N=N_sizes(i);
        
        if not(strcmp(alg,'kernelsmooth') & N>1000) %only N=1000 for kernelsmooth

            results=zeros(n_trials,length(f_vis));
            results_mse=zeros(n_trials,1);

            for j=1:n_trials
                if mod(j,10)==0
                    disp(num2str(j));
                end
                results(j,:)=sim_pred(design,N)'; %sim_pred is specific to alg,design pair
                results_mse(j)=mse(results(j,:)',f_vis);
            end

            % save results
            csvwrite(fullfile('../results',strcat(alg,'_',design,'_',num2str(N),'.csv')),results_mse);
        
        end

    end
    
    cd '..'
end

%% NP

rng('default')
design='NP';
[~,~,~,f_vis]=get_design(design);
for a=1:length(alg_options)
    
    alg=alg_options{a};
    dir=strcat('./',alg);
    cd(dir);
    
    for i=1:length(N_sizes)
        N=N_sizes(i);
        
        if not(strcmp(alg,'kernelsmooth') & N>1000) %only N=1000 for kernelsmooth

            results=zeros(n_trials,length(f_vis));
            results_mse=zeros(n_trials,1);

            for j=1:n_trials
                if mod(j,10)==0
                    disp(num2str(j));
                end
                results(j,:)=sim_pred(design,N)'; %sim_pred is specific to alg,design pair
                results_mse(j)=mse(results(j,:)',f_vis);
            end

            % save results
            csvwrite(fullfile('../results',strcat(alg,'_',design,'_',num2str(N),'.csv')),results_mse);
        
        end

    end
    
    cd '..'
end

%% HLLT

rng('default')
design='HLLT';
[~,~,~,f_vis]=get_design(design);
for a=1:length(alg_options)
    
    alg=alg_options{a};
    dir=strcat('./',alg,'2');
    cd(dir);
    
    for k=1:length(rho_vals)
        rho=rho_vals(k);
        
        for i=1:length(N_sizes)
            N=N_sizes(i);
            
            if not(strcmp(alg,'kernelsmooth') & N>1000) %only N=1000 for kernelsmooth

                results=zeros(n_trials,length(f_vis));
                results_mse=zeros(n_trials,1);

                for j=1:n_trials
                    if mod(j,10)==0
                        disp(num2str(j));
                    end
                    results(j,:)=sim_pred(design,N,rho)'; %sim_pred is specific to alg,design pair
                    results_mse(j)=mse(results(j,:)',f_vis);
                end

                % save results
                csvwrite(fullfile('../results',strcat(alg,'_',design,num2str(100.*rho),'_',num2str(N),'.csv')),results_mse);
            
            end

        end
    end
    
    cd '..'
end