#include "double_vector.h"


/* Copy/Assign function */
void double_vector_copy(double * dst, double * src, size_t size)
{
  size_t i;
 
  for (i=0; i<size; i++){
    dst[i] = src[i];
  }
  
}

/*************************
	calculates q = -p
**************************/
double * double_vector_neg(double *ov, size_t size){
	double * res = (double*)malloc(size*sizeof(double));
	size_t i;
	res[0] = ov[0];
	for(i = 1; i < size; i++){
		res[i] = -ov[i];
	}
	return res;
}

/* ********************************************************************** */
/* III. Comparison function */
/* ********************************************************************** */
int double_vector_compare_coeff(double* ov1, double* ov2, size_t size){
	int res = 0;
	size_t i;
	 
	for(i=2; i<size; i++){
		
    		res = (ov1[i] < ov2[i]? -1 : ov1[i] > ov2[i] ? 1 : 0);
    		if (res) {
			return res;
		}
  	}
	return res;
}

int double_vector_compare(double* ov1, double* ov2, size_t size)
{
  size_t i;
  int res=1;
 

  /* bidirectional/unidirectional ? */
  res = (ov1[0] == ov2[0] ? 0 : (ov1[0]> ov2[0] ? 1 : -1));
  if (res) return res;
  res = (ov1[1] < ov2[1]? -1 : ov1[1] > ov2[1] ? 1 : 0);
 
  if (res) return res;
  /* comparison */
  
  res = double_vector_compare_coeff(ov1, ov2, size);
 
  return res;
}




/* ********************************************************************** */
/* IV. Combine function */
/* ********************************************************************** */

/* vector_combine computes a combination ov3 of ov1 and
   ov2 such that ov3[k]=0.  The first coefficient is never
   considered for computations, except when k==0.
   Assumes ov1[k] and ov2[k] have opposite signs.
    */

void double_vector_combine(double* ov1, double * ov2,
		    double* ov3, size_t k, size_t size, int add)
{
  unsigned short int j;
 
  
  double tmp1 = fabs(ov1[k]);
  double tmp2 = fabs(ov2[k]);
  for (j=1;j<size;j++){
    if (j!=k){
      double tmp3 = tmp2 * ov1[j];
      double tmp4 = tmp1 * ov2[j];
      if(add)
      ov3[j] = tmp3 + tmp4;
      else 
      ov3[j] = tmp3 - tmp4;
    }
  }
  ov3[k] = 0;
}



/* The function tests if the given vector is null. */

int double_vector_is_null_expr(double* ov, size_t size){
	size_t i;
	int res = 1;
	for(i = 2; i < size; i++){
		if(ov[i] != 0){
			res = 0;
			break;
		}
	}
	return res;
}


/********************************
	Dense vector product
*********************************/
double * double_vector_scalar_product(double * ov, double s, size_t size){
	size_t i;
	double * res = (double*)malloc(size*sizeof(double));
	res[0] = ov[0];
	res[1] = ov[1]*s;
	for(i = 2; i < size; i++){
		res[i] = s*ov[i];
	}
	return res;
}



/********************************
	add two vectors, assume both ov1 and ov2 are inequalities
*********************************/
void double_vector_sum(double * ov1, double *ov2, size_t size){
	unsigned short int i;
	ov1[1] = ov1[1] + ov2[1];
	
	for(i = 2; i < size; i++){
		ov1[i] = ov1[i] + ov2[i];
	}
	
}
