import numpy as np
import numpy.random as npr
import matplotlib.pyplot as plt
import pickle


def plot_fig5(fname_nondp, fname_dp):
	dp_results = pickle.load(open(fname_dp, 'rb'))
	nondp_results = pickle.load(open(fname_nondp, 'rb'))

	dp_dpvi_params = dp_results[0]
	dp_dp_mcmc_params = dp_results[1]
	dp_chain = dp_results[2]
	dp_privacy_params = dp_results[3]

	nondp_dpvi_params = nondp_results[0]
	nondp_dp_mcmc_params = nondp_results[1]
	nondp_chain = nondp_results[2]
	nondp_privacy_params = nondp_results[3]

	# Privacy budgets
	from exact_rdp import get_privacy_spent
	dp_eps_delta = get_privacy_spent(dp_dp_mcmc_params['B'], dp_dp_mcmc_params['N'],\
										   dp_dp_mcmc_params['T'], max_alpha = 100)
	dp_eps_delta = np.array(dp_eps_delta) +\
						np.array([dp_dpvi_params['eps'], dp_dpvi_params['delta']])


	# Plot results
	plt.cla()
	plt.scatter(nondp_chain[:,0], nondp_chain[:,1])
	plt.xlim(-1.0, 2.0)
	plt.ylim(-2.1, 2.0)
	plt.title('Samples from target distribution, tempered likelihoods\n'+\
			'Non-DP')
	plt.savefig('NONDP-scatter_plot.pdf',format='pdf')
	plt.close()
	
	plt.cla()
	plt.scatter(dp_chain[:,0], dp_chain[:,1])
	plt.xlim(-1.0, 2.0)
	plt.ylim(-2.1, 2.0)
	plt.title('Samples from target distribution, tempered likelihoods\n'+\
			'({0},{1})-DP'.format(np.round(dp_eps_delta[0],2), dp_eps_delta[1]))
	plt.savefig('DP-scatter_plot.pdf',format='pdf')
	plt.close()

