%Script to quickly run through all the routines
N = 50;


IM1 = imread('nips tree 1.bmp');
A1 = IM1(:,:,1);
IM2 = imread('nips tree 2.bmp');
A2 = IM2(:,:,1);
IM3 = imread('nips tree 3.bmp');
A3 = IM3(:,:,1);

[x1 y1] = find(A1==0);
[x2 y2] = find(A2==0);
[x3 y3] = find(A3==0);


P1 = [x1,y1];
FPS1 = px_fps(P1','vector',N,'n');
P2 = [x2,y2];
FPS2 = px_fps(P2','vector',N,'n');
P3 = [x3,y3];
FPS3 = px_fps(P3','vector',N,'n');

subplot(3,1,1);
scatter(y1,1+max(x1)-x1,'filled')
subplot(3,1,2);
scatter(y2,1+max(x2)-x2,'filled')
subplot(3,1,3);
scatter(y3,1+max(x3)-x3,'filled')

dm1 = L2_distance(P1(FPS1,:)',P1(FPS1,:)');
dm1 = dm1/max(dm1(:));
dm2 = L2_distance(P2(FPS2,:)',P2(FPS2,:)');
dm2 = dm2/max(dm2(:));
dm3 = L2_distance(P3(FPS3,:)',P3(FPS3,:)');
dm3 = dm3/max(dm3(:));

HYP1 = hyperbolicity(dm1);
fprintf(1,'Hyperbolicity of dm1 = %f\n',HYP1);
HYP2 = hyperbolicity(dm2);
fprintf(1,'Hyperbolicity of dm2 = %f\n',HYP2);
HYP3 = hyperbolicity(dm3);
fprintf(1,'Hyperbolicity of dm3 = %f\n',HYP3);

max_dis1 = 0;
max_dis2 = 0;
max_dis3 = 0;

for root=1:N
	tm1 = tree_metric(dm1,root);
	diff1 = dm1-tm1;
	tm2 = tree_metric(dm2,root);
	diff2 = dm2-tm2;
	tm3 = tree_metric(dm3,root);
	diff3 = dm3-tm3;
	max_dis1 = max(max_dis1,max(diff1(:)));
	max_dis2 = max(max_dis2,max(diff2(:)));
	max_dis3 = max(max_dis3,max(diff3(:)));
end
fprintf(1,'Worst case of ||dm1-tm|| = %f\n',max_dis1);
fprintf(1,'Worst case of ||dm2-tm|| = %f\n',max_dis2);
fprintf(1,'Worst case of ||dm3-tm|| = %f\n',max_dis3);


ub1 = inf;
i_opt1 = 2;
ub2 = inf;
i_opt2 = 2;
ub3 = inf;
i_opt3 = 2;

CN1 = CovNum(dm1);
CN2 = CovNum(dm2);
CN3 = CovNum(dm3);

for i=2:(N-1)
	eps1 = CN1(i);
	tmp1 = 12*eps1+HYP1*log2(2*i);
	eps2 = CN2(i);
	tmp2 = 12*eps2+HYP2*log2(2*i);
	eps3 = CN3(i);
	tmp3 = 12*eps3+HYP3*log2(2*i);
	if(tmp1 <= ub1)
		ub1 = tmp1;
		i_opt1 = i;
	end
	if(tmp2 <= ub2)
		ub2 = tmp2;
		i_opt2 = i;
	end
	if(tmp3 <= ub3)
		ub3 = tmp3;
		i_opt3 = i;
	end
end

fprintf(1,'Smallest upper bound is %.3f and occurs for eps=%.3f, N_x(%.3f) = %d \n',ub1,CN1(i_opt1),CN1(i_opt1),i_opt1);
fprintf(1,'Smallest upper bound is %.3f and occurs for eps=%.3f, N_x(%.3f) = %d \n',ub2,CN2(i_opt2),CN2(i_opt2),i_opt2);
fprintf(1,'Smallest upper bound is %.3f and occurs for eps=%.3f, N_x(%.3f) = %d \n',ub3,CN3(i_opt3),CN3(i_opt3),i_opt3);
