% Demo file: choose set of parameters, create an instance of the problem and call the solver

%% Define algorithm options
method = 0; 				%0:GAMP-solver		1:L1-minimizing solver using the cvx package
opt.nb_iter=1000;			%maximum number of iterations
opt.mute = 0;				%0:display current MSE and results 	1:do not display anything
opt.verbose_n=1;			%display current MSE every verbose_n iterations
opt.conv_criterion = 1*10^(-17);	%stop algorithm once the MSE or relative difference goes below conv_criterion
opt.damp_mes = 0.9;			%value of the damping coefficient

%% Define instance options
N = 1000;				%size of the sparse signal
P = 3;					%number of signals used for calibration
opt.P = P;
alpha = 0.5;            %measurement rate
opt.alpha = alpha;
rho = 0.2;              %sparsity
opt.rho = rho;
Delta = 1e-18 ;			%variance of the additive white noise
opt.Delta = Delta;
d = 1;					%mean of the calibration coefficients
opt.d = d;
delta = 0.3;			%variance of the calibration coefficients - must be smaller than 1/3
opt.delta = delta;


%% Create an instance
M = ceil(N*alpha);
zero_entries = ceil((1-rho)*N);
%create measurement matrix
G = normrnd(0, sqrt(1/(N)), M, N);
%create D
D = prior_d(d, delta, M);
D = diag(D);
opt.delta=1.5*delta; %increases stability of the algorithm
%create X
X=[];
for i=1:P
    x = normrnd(0, 1, N,1);
    p = randperm(N, zero_entries); 
    x(p) = zeros(1, zero_entries);
    X = [X x];
end
%create Y
Y = G*X;
Y = Y + normrnd(0,sqrt(Delta),size(Y));
Y = D^(-1)*Y;

%% Call the solver
if method ==0
    [X_guess,D_guess,parameters] = BC(Y,G,opt);
    results.X = X_guess;
    results.D = D_guess;
    results.parameters = parameters;
elseif method ==1
try
    [X_guess, D_guess, parameters] = L1cvx(Y,G,opt)
catch error
    rethrow(error)    
end

    results.X = X_guess;
    results.D = D_guess;
    results.parameters = parameters;
end

%% Display results if mute==0
if ( opt.mute==0 && P>1 )
  D = diag(D);
  mse_x = 1/(N*P)*sum(sum((X - X_guess).^2));
  mse_d = 1/M*sum((D-D_guess).^2);
  mse_corr =  1/(N*P)*sum(sum((X - 1/M*sum(D./D_guess)*X_guess).^2));
  iterations = parameters.iterations;
  if method==0
      solver = 'GAMP';
  elseif method==1
      solver = 'L1';
  end
  line1 = sprintf('%s-solver stopped after %d iterations',solver,iterations);
  line2 = sprintf('MSE achieved on X: %d , MSE achieved on D: %d. MSE_corr achieved: %d. ',mse_x, mse_d,mse_corr);
  disp(line1);
  disp(line2);    
    
  figure(1) ; 
  subplot(2,4,1);surf(X);title('Real signal'); 
  subplot(2,4,2); surf(X_guess); title('Reconstruction');
  subplot(2,4,3); surf((X-X_guess)/sqrt(var(X(:)))); title('Relative difference');
  subplot(2,4,4); surf(X/sqrt(var(X(:)))-X_guess/sqrt(var(X_guess(:)))); title('Corrected relative difference');
  subplot(2,4,5); plot(D);title('Real D'); 
  subplot(2,4,6); plot(D_guess); title('Reconstructed D');
  subplot(2,4,7); plot((D-D_guess)/sqrt(var(D))); title('Relative difference');
  subplot(2,4,8); plot(D/sqrt(var(D))-D_guess/sqrt(var(D_guess))); title('Corrected relative difference');
end






