M = 1000; ci_f = tinv(0.975, M);

% varying # of bases, diffusion chain
ks = 2:10;
for i=1:size(ks,2),
  disp(num2str(ks(i)));
  [err_opt, err_mu, err_d, err_con] = op_lstd(100, ks(i), 1, 20, M, 0, 0, 50);
  diffusion_k_errs(i,:) = [mean(err_opt) mean(err_mu) mean(err_d) mean(err_con)];
  diffusion_k_cis(i,:) = ci_f*[std(err_opt) std(err_mu) std(err_d) std(err_con)]/sqrt(M);
  [h,diffusion_k_p(i)] = ttest(err_con, err_d, 0.05, 'left');
end
plot_errs(ks, diffusion_k_errs, diffusion_k_cis, 'Number of Bases')

% varying # of bases, random chain
ks = 2:10;
for i=1:size(ks,2),
  disp(num2str(ks(i)));
  [err_opt, err_mu, err_d, err_con] = op_lstd(11, ks(i), 0, 100, M, 0, 0, 50);
  rand_k_errs(i,:) = [mean(err_opt) mean(err_mu) mean(err_d) mean(err_con)];
  rand_k_cis(i,:) = ci_f*[std(err_opt) std(err_mu) std(err_d) std(err_con)]/sqrt(M);
  [h,rand_k_p(i)] = ttest(err_con, err_d, 0.05, 'left');
end
plot_errs(ks, rand_k_errs, rand_k_cis, 'Number of Bases')


% varying closeness to stationary distribution, diffusion chain
c_mus = [1 2 5 10 20 50 100 200 500 1000];
for i=1:size(c_mus,2),
  disp(num2str(c_mus(i)));
  [err_opt, err_mu, err_d, err_con] = op_lstd(100, 5, 1, c_mus(i), M, 0, 0, 50);
  diffusion_c_errs(i,:) = [mean(err_opt) mean(err_mu) mean(err_d) mean(err_con)];
  diffusion_c_cis(i,:) = ci_f*[std(err_opt) std(err_mu) std(err_d) std(err_con)]/sqrt(M);
  [h,diffusion_c_p(i)] = ttest(err_con, err_d, 0.05, 'left');
end
plot_errs(c_mus, diffusion_c_errs, diffusion_c_cis, 'Closeness to Stationary Distribution, C_{mu}')
set(gca, 'Xscale', 'log');


% varying closeness to stationary distribution, random chain
c_mus = [1 2 5 10 20 50 100 200 500 1000];
for i=1:size(c_mus,2),
  disp(num2str(c_mus(i)));
  [err_opt, err_mu, err_d, err_con] = op_lstd(11, 8, 0, c_mus(i), M, 0, 0, 50);
  rand_c_errs(i,:) = [mean(err_opt) mean(err_mu) mean(err_d) mean(err_con)];
  rand_c_cis(i,:) = ci_f*[std(err_opt) std(err_mu) std(err_d) std(err_con)]/sqrt(M);
  [h,rand_c_p(i)] = ttest(err_con, err_d, 0.05, 'left');
end
plot_errs(c_mus, rand_c_errs, rand_c_cis, 'Closeness to Stationary Distribution, C_{mu}')
set(gca, 'Xscale', 'log');


% number of samples, diffusion chain
M_samples = [100 200 500 1000 2000 5000 10000];
for i=1:size(M_samples,2),
  disp(num2str(M_samples(i)));
  [err_opt, err_mu, err_d, err_con] = op_lstd(100, 5, 1, 20, M, M_samples(i), 25, 50);
  diffusion_samp_errs(i,:) = [mean(err_opt) mean(err_mu) mean(err_d) mean(err_con)];
  diffusion_samp_cis(i,:) = ci_f*[std(err_opt) std(err_mu) std(err_d) std(err_con)]/sqrt(M);
  [h,diffusion_samp_p(i)] = ttest(err_con, err_d, 0.05, 'left');
end
plot_errs(M_samples, diffusion_samp_errs, diffusion_samp_cis, 'Number of Samples')
set(gca, 'Xscale', 'log');


% number of samples, random chain
M_samples = [100 200 500 1000 2000 5000 10000];
for i=1:size(M_samples,2),
  disp(num2str(M_samples(i)));
  [err_opt, err_mu, err_d, err_con] = op_lstd(11, 7, 0, 100, M, M_samples(i), 100, 50);
  rand_samp_errs(i,:) = [mean(err_opt) mean(err_mu) mean(err_d) mean(err_con)];
  rand_samp_cis(i,:) = ci_f*[std(err_opt) std(err_mu) std(err_d) std(err_con)]/sqrt(M);
  [h,rand_samp_p(i)] = ttest(err_con, err_d, 0.05, 'left');
end
plot_errs(M_samples, rand_samp_errs, rand_samp_cis, 'Number of Samples')
set(gca, 'Xscale', 'log');


% cluster size, diffusion chain
k_clusters = [20 30 40 50 60 70 80 90 100];
for i=1:size(k_clusters,2),
  disp(num2str(k_clusters(i)));
  [err_opt, err_mu, err_d, err_con] = op_lstd(100, 5, 1, 20, M, 2000, k_clusters(i), 50);
  diffusion_clust_errs(i,:) = [mean(err_opt) mean(err_mu) mean(err_d) mean(err_con)];
  diffusion_clust_cis(i,:) = ci_f*[std(err_opt) std(err_mu) std(err_d) std(err_con)]/sqrt(M);
  [h,diffusion_clust_p(i)] = ttest(err_con, err_d, 0.05, 'left');
end
plot_errs(k_clusters, diffusion_clust_errs, diffusion_clust_cis, 'Number of Clusters')


% number of iterations
n_iter = [5 10 15 20 25 30 35 40 45 50];
for i=1:size(n_iter,2),
  disp(num2str(n_iter(i)));
  [err_opt, err_mu, err_d, err_con] = op_lstd(100, 5, 1, 20, M, 0, 0, n_iter(i));
  diffusion_iter_errs(i,:) = [mean(err_opt) mean(err_mu) mean(err_d) mean(err_con)];
  diffusion_iter_cis(i,:) = ci_f*[std(err_opt) std(err_mu) std(err_d) std(err_con)]/sqrt(M);
  [h,diffusion_iter_p(i)] = ttest(err_con, err_d, 0.05, 'left');
end
plot_errs(n_iter, diffusion_iter_errs, diffusion_iter_cis, 'Number of LBFGS Iterations')

