function xn = internalize(E,x)
% INTERNALIZE transforms the state coordinates to an "egocentric"
% translation-invariant, rotation invariant form, discarding one angle
% coordinate in the process.
d     = E.d;

th    = x (3:2+d,:);
rx    = (E.P-0.5*E.L)*cos(th);
ry    = (E.P-0.5*E.L)*sin(th);

c2n   = [rx(E.nose,:); ry(E.nose,:)];

c2n_x = [ cos(th(E.nose,:)); sin(th(E.nose,:))];
c2n_y = [-sin(th(E.nose,:)); cos(th(E.nose,:))];

T     = -x(1:2,:) - c2n;

vth   = x (d+5:end,:);
vx    = -(E.P-0.5*E.L)*(sin(th).*vth);
vy    =  (E.P-0.5*E.L)*(cos(th).*vth);
v2n   = [vx(E.nose,:); vy(E.nose,:)];

Tcn   = [sum(T.*c2n_x); sum(T.*c2n_y)];
Vcn   = [sum((x(3+d:4+d,:)+v2n).*c2n_x); sum((x(3+d:4+d,:)+v2n).*c2n_y)];

xn    = [Tcn; th(2:d,:) - th(1:d-1,:); Vcn; x(d+5:end,:)];

