function [xnew,u,w] = integrate(E,x,origin,sim_dt)
% INTEGRATE performs 4th-order Runge-Kutta integration of the dynamics with
% the current policy.
dt       = sim_dt;

x1       = x;
x_rel    = [x1(1:2)-origin; x1(3:end)];
[u1,w]   = policy(E,x_rel);
k1       = dt*f(E,x1,u1);

x2       = x + 0.5*k1;
x_rel    = [x2(1:2)-origin; x2(3:end)];
u2       = policy(E,x_rel);
k2       = dt*f(E,x2,u2);

x3       = x + 0.5*k2;
x_rel    = [x3(1:2)-origin; x3(3:end)];
u3       = policy(E,x_rel);
k3       = dt*f(E,x3,u3);

x4       = x + k3;
x_rel    = [x4(1:2)-origin; x4(3:end)];
u4       = policy(E,x_rel);
k4       = dt*f(E,x4,u4);

xnew     = x+(k1+k4)/6+(k2+k3)/3;
xnew(E.d+5:end)  = min(E.vmax,max(-E.vmax,xnew(E.d+5:end)));
u        =(u1+u4)/6+(u2+u3)/3;
